/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.f7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dimension.DimensionTree;
import kd.epm.far.business.bcm.dimension.StoredMemberFetch;
import kd.epm.far.business.common.f7.dto.FIDMF7SingleInput;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.util.FormUtils;
import kd.epm.far.formplugin.common.util.TreeEntryEntityUtil;
import kd.epm.far.formplugin.common.util.TreeEntryNewUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SingleMemberF7Plugin
extends AbstractBaseDMFormPlugin
implements RowClickEventListener {
    private static final String CTL_DIMENSIONCOMBO = "dimensioncombo";
    private static final String CTL_SEARCHAP = "searchap";
    private static final String CTL_TREEENTRYENTITY = "treeentryentity";
    private static final String BTNOK = "btnok";
    private static final String ACCOUNT = "Account";
    private String selectFields = "id,id as memberid,name,number,dseq,parent,aggoprt,storageType,modifier.name as modifier,modifyTime,isleaf,level,copyfrom,longnumber,createtime,creator.name as creator ,description,model,dimension ";
    private List<String> entryFields = Arrays.asList("number", "name");

    private FIDMF7SingleInput getFormInputParam() {
        FIDMF7SingleInput input = (FIDMF7SingleInput)DisclosureFormHelper.getFormInputParam((IFormView)this.getView(), FIDMF7SingleInput.class, (Boolean)true);
        return input;
    }

    public String getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(String selectFields) {
        this.selectFields = selectFields;
    }

    @Override
    public void initialize() {
        super.initialize();
        Search search = (Search)this.getControl(CTL_SEARCHAP);
        search.addEnterListener(var1 -> {
            if (var1.getText() != null && !"".equals(var1.getText())) {
                List searchFields = var1.getSearchFields();
                this.searchOper(searchFields);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"MutipleMemberF7Plugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTNOK);
        TreeEntryGrid treeentry = (TreeEntryGrid)this.getControl(CTL_TREEENTRYENTITY);
        treeentry.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FIDMF7SingleInput input = this.getFormInputParam();
        this.setDimensionCombo(input);
        this.buildDimEntryTree(input);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
        this.exitAndReturn(this.getModel());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (BTNOK.equals(key)) {
            this.exitAndReturn(this.getModel());
        }
    }

    private QFilter getOwnerFilters(FIDMF7SingleInput input) {
        String dataset;
        QFilter dimFilter = new QFilter("model", "=", (Object)input.getDmModelId());
        dimFilter.and("dimension", "=", (Object)input.getDimId());
        dimFilter.and("status", "!=", (Object)"A");
        String number = input.getNumber();
        if (ACCOUNT.equals(number) && !StringUtils.isBlank((String)(dataset = input.getDataset()))) {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)input.getDmModelId());
            builder.add("number", "=", (Object)dataset);
            DynamicObject[] dataSetObject = BusinessDataServiceHelper.load((String)"eb_dataset", (String)"id,number", (QFilter[])builder.toArray(), (String)"createdate desc");
            if (dataSetObject != null && dataSetObject.length > 0) {
                DynamicObject dynamicObject = dataSetObject[0];
                Object datasetId = dynamicObject.get("id");
                QFilter qdroot = new QFilter("number", "=", (Object)ACCOUNT);
                QFilter qdataset = new QFilter("dataset", "=", (Object)Long.parseLong(datasetId.toString()));
                dimFilter.and(qdroot.or(qdataset));
            }
        }
        return dimFilter;
    }

    private void setDimensionCombo(FIDMF7SingleInput input) {
        ComboEdit dimensioncombo = (ComboEdit)this.getView().getControl(CTL_DIMENSIONCOMBO);
        List<String[]> dimensionlist = this.getDimensionComData(input.getDmModelId());
        FormUtils.customDynamicEnum(dimensionlist, dimensioncombo);
        this.getModel().setValue(CTL_DIMENSIONCOMBO, (Object)input.getDseq());
    }

    private List<String[]> getDimensionComData(Long modelId) {
        List allDims = new ModelStrategyEx(modelId).getDim().getDimList();
        ArrayList<String[]> listDimension = new ArrayList<String[]>();
        if (allDims != null && allDims.size() > 0) {
            for (DimensionInfo task : allDims) {
                String[] dimensionMap = new String[4];
                dimensionMap[0] = task.getName();
                dimensionMap[1] = String.valueOf(task.getDseq());
                dimensionMap[2] = task.getEntityName();
                listDimension.add(dimensionMap);
            }
        }
        return listDimension;
    }

    private void buildDimEntryTree(FIDMF7SingleInput input) {
        QFilter dimFilter = this.getOwnerFilters(input);
        DynamicObjectCollection members = this.getMember(input.getEntityName(), dimFilter.toArray(), this.selectFields);
        this.getModel().deleteEntryData(CTL_TREEENTRYENTITY);
        StoredMemberFetch fetch = ids -> {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
            return (DynamicObject[])QueryServiceHelper.query((String)input.getEntityName(), (String)this.selectFields, (QFilter[])filters, null).toArray((Object[])new DynamicObject[0]);
        };
        TreeEntryNewUtil.newTreeEntry(this.getModel(), members, this.entryFields, fetch);
        this.getView().updateView(CTL_TREEENTRYENTITY);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(CTL_TREEENTRYENTITY);
        treeEntry.setCollapse(false);
        this.getView().updateView(CTL_TREEENTRYENTITY);
    }

    private DynamicObjectCollection getMember(String menberentityid, QFilter[] filters, String selectMemberFields) {
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)menberentityid, (String)selectMemberFields, (QFilter[])filters, (String)"level,dseq");
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        dynamicObjects.addAll(Arrays.asList(dys));
        return dynamicObjects;
    }

    private void searchOper(List<Map<String, Object>> searchFields) {
        FIDMF7SingleInput input = this.getFormInputParam();
        QFilter dimFilter = this.getOwnerFilters(input);
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        list.add(-1);
        DynamicObjectCollection members = this.getMember(input.getEntityName(), dimFilter.toArray(), this.selectFields);
        DimensionTree searchTree = DimensionTree.createTreeFromDyn((DynamicObject[])((DynamicObject[])members.toArray((Object[])new DynamicObject[0])));
        List<Pair<Long, Long>> findList = this.findIndexListDeep((DimensionTree<String, DynamicObject>)searchTree, searchFields);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(CTL_TREEENTRYENTITY);
        findList.forEach(find -> {
            DynamicObject dynamicObject = collection.stream().filter(c -> ((Long)find.getLeft()).longValue() == c.getLong("id")).findFirst().orElse(null);
            if (dynamicObject != null && StringUtils.isNotEmpty((String)dynamicObject.getString("seq"))) {
                String seq = dynamicObject.getString("seq");
                list.add(Integer.parseInt(seq) - 1);
            }
        });
        list.add(-1);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(CTL_TREEENTRYENTITY);
        if (list.size() > 2) {
            int focusRow = (Integer)list.get(1);
            int[] ids = TreeEntryEntityUtil.focus(this.getModel(), focusRow);
            treeEntry.collapse(0);
            treeEntry.expandOne(ids);
            treeEntry.selectRows(focusRow);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SingleMemberF7Plugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Pair<Long, Long>> findIndexListDeep(DimensionTree<String, DynamicObject> dimensionTreeRoot, List<Map<String, Object>> searchFields) {
        ArrayList<Pair<Long, Long>> findList = new ArrayList<Pair<Long, Long>>(16);
        ArrayList<Pair<Long, Long>> fullMatch = new ArrayList<Pair<Long, Long>>(16);
        this.addThisOneOrNot(dimensionTreeRoot, searchFields, fullMatch, findList);
        this.preOrderTravel(dimensionTreeRoot, searchFields, fullMatch, findList);
        if (fullMatch.size() > 0) {
            findList.addAll(0, fullMatch);
        }
        return findList;
    }

    private void preOrderTravel(DimensionTree<String, DynamicObject> tempTreeNode, List<Map<String, Object>> searchFields, List<Pair<Long, Long>> fullMatch, List<Pair<Long, Long>> findList) {
        if (tempTreeNode.getParent() == null) {
            this.addThisOneOrNot(tempTreeNode, searchFields, fullMatch, findList);
        }
        for (DimensionTree child : tempTreeNode.getChildren()) {
            this.addThisOneOrNot((DimensionTree<String, DynamicObject>)child, searchFields, fullMatch, findList);
        }
        for (DimensionTree child : tempTreeNode.getChildren()) {
            this.preOrderTravel((DimensionTree<String, DynamicObject>)child, searchFields, fullMatch, findList);
        }
    }

    private void addThisOneOrNot(DimensionTree<String, DynamicObject> tempTreeNode, List<Map<String, Object>> searchFields, List<Pair<Long, Long>> fullMatch, List<Pair<Long, Long>> findList) {
        String name = ((DynamicObject)tempTreeNode.getData()).getString("name").toLowerCase();
        String number = ((DynamicObject)tempTreeNode.getData()).getString("number").toLowerCase();
        Long memberId = ((DynamicObject)tempTreeNode.getData()).getLong("id");
        Long parentId = ((DynamicObject)tempTreeNode.getData()).getLong("parent_id");
        for (Map<String, Object> searchField : searchFields) {
            Set<String> texts = ((List)searchField.get("value")).stream().map(text -> text.toLowerCase()).collect(Collectors.toSet());
            List fieldNames = (List)searchField.get("fieldName");
            if (fieldNames.size() == 1) {
                if ("number".equals(fieldNames.get(0))) {
                    if (this.strEqualsTexts(number, texts)) {
                        fullMatch.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                        continue;
                    }
                    if (!this.strContainTexts(number, texts)) continue;
                    findList.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                    continue;
                }
                if (!"name".equals(fieldNames.get(0))) continue;
                if (this.strEqualsTexts(name, texts)) {
                    fullMatch.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                    continue;
                }
                if (!this.strContainTexts(name, texts)) continue;
                findList.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                continue;
            }
            if (fieldNames.size() != 2) continue;
            if (this.strEqualsTexts(number, texts) || this.strEqualsTexts(name, texts)) {
                fullMatch.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
                continue;
            }
            if (!this.strContainTexts(number, texts) && !this.strContainTexts(name, texts)) continue;
            findList.add((Pair<Long, Long>)Pair.of((Object)memberId, (Object)parentId));
        }
    }

    private boolean strEqualsTexts(String str, Set<String> texts) {
        boolean flag = false;
        for (String text : texts) {
            if (!str.toLowerCase(Locale.ENGLISH).equals(text)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean strContainTexts(String str, Set<String> texts) {
        boolean flag = false;
        for (String text : texts) {
            if (!str.toLowerCase(Locale.ENGLISH).contains(text)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    protected void exitAndReturn(IDataModel iDataModel) {
        int row = iDataModel.getEntryCurrentRowIndex(CTL_TREEENTRYENTITY);
        DynamicObject selectedRow = iDataModel.getEntryRowEntity(CTL_TREEENTRYENTITY, row);
        if (selectedRow == null) {
            this.getView().close();
            return;
        }
        this.getView().setReturnData((Object)selectedRow);
        this.getView().returnDataToParent((Object)selectedRow);
        this.getView().close();
    }
}

