/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.helper.ElementHelper;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;

public class DmSingleF7ServiceHelper {
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String RANGE = "range";

    public static void createDimensionPage(AbstractBaseFormPlugin plugin, DynamicPage iPage, String contorlId, Map<String, Set<Long>> templateDimMap) {
        Area area = new Area(contorlId);
        Page page = new Page();
        int index = 1;
        for (Map.Entry<String, Set<Long>> entry : templateDimMap.entrySet()) {
            String dimKey = entry.getKey();
            String[] splitDimKey = dimKey.split("/");
            String dimNumber = splitDimKey[1];
            String dimName = splitDimKey[2];
            String entityName = splitDimKey[3];
            BaseEditElement baseEdit = new BaseEditElement(dimName, dimNumber, entityName);
            ElementHelper.buildF7StyleForPreview((BaseEditElement)baseEdit, (int)index);
            ++index;
            area.addElement((Element)baseEdit);
        }
        page.addArea(area);
        iPage.setPage(plugin.getView(), page);
        page.updatePage(plugin.getView());
    }

    public static BasedataEdit createBaseDataEdit(AbstractBaseFormPlugin plugin, Long dmModelId, String f7Key) {
        Map f7DimMap = (Map)SerializationUtils.fromJsonString((String)plugin.getPageCache().get("dimf7map"), Map.class);
        Long dimId = (Long)f7DimMap.get(f7Key);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(false), (Long)dimId);
        return modelStrategyEx.getDimensionF7().createSingleMemberF7(plugin.getView(), (BeforeF7SelectListener)plugin, dimensionInfo, f7Key, null, false, "");
    }

    public static void createBeforeF7Select(AbstractBaseFormPlugin plugin, BeforeF7SelectEvent beforeF7SelectEvent, Long modelId) {
        Map f7DimMap = (Map)SerializationUtils.fromJsonString((String)plugin.getPageCache().get("dimf7map"), Map.class);
        String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        Long dimId = (Long)f7DimMap.get(dimKey);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension", "=", (Object)dimId);
        ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(qFilter);
        beforeF7SelectEvent.setCustomQFilters(filterList);
    }

    public static void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent, Long modelid, Map<String, Set<Long>> templateDimMap, Map<String, Long> f7DimMap, Object scenario, String dimKey) {
        if ("period".equals(dimKey) && f7DimMap.containsKey("scenario") && scenario == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"AnalysisSingleF7ServiceHelper_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        Long dimId = 0L;
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        for (Map.Entry<String, Set<Long>> templateDim : templateDimMap.entrySet()) {
            String templatMapKey = templateDim.getKey();
            String[] splitDimKey = templatMapKey.split("/");
            String dimNumber = splitDimKey[1];
            dimId = LongUtil.toLong((Object)splitDimKey[0]);
            if (!dimKey.equals(dimNumber)) continue;
            HashSet memberList = new HashSet();
            memberList.addAll(templateDim.getValue());
            if (memberList.size() != 0) {
                qFilter.and(new QFilter("id", "in", memberList));
            }
            qFilter.and(new QFilter("dimension", "=", (Object)dimId));
            break;
        }
        ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(qFilter);
        if (DmDimMemberEntityEnum.BCM_YEAR.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter(NUMBER, "!=", (Object)"LastYear").and(new QFilter(NUMBER, "!=", (Object)"CurrentYear")));
        } else if (DmDimMemberEntityEnum.BCM_PERIOD.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter(NUMBER, "!=", (Object)"LastPeriod").and(new QFilter(NUMBER, "!=", (Object)"CurrentPeriod")));
        }
        List allDims = new ModelStrategyEx(modelid).getDim().getDimList();
        DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)allDims, (Long)dimId);
        if (dimensionInfo != null) {
            BcmPermService bcmPermService = new BcmPermService(modelid, dimId);
            QFilter filter = bcmPermService.getPermQFilter("id");
            filterList.add(filter);
        }
        beforeF7SelectEvent.setCustomQFilters(filterList);
    }
}

