/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.helper;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.epm.far.common.common.enums.StorageTypeEnum;
import kd.epm.far.formplugin.common.imp.ImportOperateType;
import kd.epm.far.formplugin.common.util.SilentJSONUtils;

public class ImportHelper {
    public static final Set<String> NOT_PERMIT_SHARED_TYPES = new HashSet<String>(2);

    private ImportHelper() {
    }

    public static ImportOperateType getImportType(ImportContext ctx) {
        return ImportOperateType.codeOf((String)ctx.getOption().get("importtype"));
    }

    public static boolean isShareType(DynamicObject member) {
        return ImportHelper.isShareType(member.getString("storagetype"));
    }

    public static boolean isShareType(String storageType) {
        return StorageTypeEnum.SHARE.index.equals(storageType);
    }

    @Deprecated
    public static String getParentNumber(Map<String, Object> rowData) {
        if (Objects.isNull(rowData.get("parent")) || StringUtils.isEmpty((CharSequence)rowData.get("parent").toString())) {
            return "";
        }
        return (String)SilentJSONUtils.cast(rowData.get("parent").toString(), LinkedHashMap.class).get("number");
    }

    public static String getNumber(DynamicObject dynamicObject) {
        return dynamicObject.getString("number");
    }

    public static long getBaseDataIdCompatible(DynamicObject dyn, String prop) {
        return Objects.isNull(dyn.get(prop)) ? 0L : (dyn.get(prop) instanceof Long ? dyn.getLong(prop) : dyn.getDynamicObject(prop).getLong("id"));
    }

    public static Object getImportBillProp(ImportBillData billData, String prop) {
        String[] propPathKeys = prop.split("\\.");
        if (propPathKeys.length > 2) {
            throw new IllegalArgumentException("current just support the depth 2. ");
        }
        if (Objects.isNull(billData.getData().get((Object)propPathKeys[0]))) {
            return "";
        }
        Object parentObj = billData.getData().get((Object)propPathKeys[0]);
        if (propPathKeys.length < 2) {
            return parentObj;
        }
        if (!(parentObj instanceof Map)) {
            throw new IllegalArgumentException("invalid prop path, parentObj is " + (parentObj == null ? "null" : parentObj.getClass()));
        }
        Map parentMap = (Map)parentObj;
        if (!parentMap.containsKey(propPathKeys[1])) {
            return "";
        }
        Object secondObj = parentMap.get(propPathKeys[1]);
        return Objects.isNull(secondObj) ? "" : secondObj;
    }

    static {
        NOT_PERMIT_SHARED_TYPES.add(StorageTypeEnum.UNSHARE.index);
    }
}

