/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.imp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.webapi.DefaultOperate;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.formplugin.common.helper.ImportHelper;
import kd.epm.far.formplugin.common.imp.BatchProcessHelper;
import kd.epm.far.formplugin.common.imp.BillResult;
import kd.epm.far.formplugin.common.imp.ImportOperateType;
import kd.epm.far.formplugin.common.util.ImportMsgUtils;

public abstract class AbsCommonImport
extends BatchImportPlugin
implements IImportPlugin {
    private static final Log log = LogFactory.getLog(AbsCommonImport.class);
    protected String entityName;
    protected static final String EXT_ID = "id";
    protected static final String EXT_EXISTING_RECORD = "existingRecordDy";
    private boolean success = false;
    public static final int BATCH_SINGLE = 100;
    public static final int BATCH_THRESHOLD = 200;

    public String getDefaultKeyFields() {
        return EXT_ID;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> onlyNumberShow = new ArrayList<ComboItem>(10);
        for (ComboItem item : super.getOverrideFieldsConfig()) {
            if (!EXT_ID.equals(item.getValue())) continue;
            onlyNumberShow.add(item);
        }
        return onlyNumberShow;
    }

    protected int getBatchImportSize() {
        return 1000;
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.entityName = ctx.getBillFormId();
        return this;
    }

    public AbstractOperateWebApi getSaveWebApi() {
        return new DefaultOperate();
    }

    private List<Optional<String>> validateBatchBills(List<ImportBillData> bills) {
        ArrayList<Optional<String>> billValidateResults = new ArrayList<Optional<String>>(bills.size());
        for (ImportBillData bill : bills) {
            try {
                billValidateResults.add(this.validateBillData(bill));
            }
            catch (Exception e) {
                log.error("Failed to validate bill: " + bill.getData() + " for " + e.getMessage(), (Throwable)e);
                billValidateResults.add(Optional.ofNullable(e.getMessage()));
            }
        }
        return billValidateResults;
    }

    protected abstract Optional<String> validateBillData(ImportBillData var1);

    protected void importData() {
        try {
            super.importData();
        }
        catch (Throwable e) {
            log.error("absCommonImport error", e);
        }
        this.afterImport();
    }

    protected void afterImport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult;
        int batchSize = rowdatas.size();
        long sTick = System.currentTimeMillis();
        try {
            this.beforeValidation(rowdatas);
            List allValidateResults = BatchProcessHelper.batchHandle(rowdatas, 200, 100, this::validateBatchBills, null, BatchProcessHelper.Scene.CPU);
            ArrayList<BillResult> savedBillResults = new ArrayList<BillResult>(16);
            ArrayList<ImportBillData> validatedBillData = new ArrayList<ImportBillData>(16);
            Iterator<ImportBillData> rowDataIter = rowdatas.iterator();
            int index = 0;
            int validIndex = 0;
            while (rowDataIter.hasNext()) {
                ImportBillData data = rowDataIter.next();
                Optional validMsg = (Optional)allValidateResults.get(index);
                if (validMsg.isPresent()) {
                    logger.log(Integer.valueOf(data.getStartIndex()), (String)validMsg.get()).fail();
                    rowDataIter.remove();
                } else {
                    validatedBillData.add(data);
                    BillResult result = new BillResult();
                    result.setIndex(validIndex++);
                    result.setNumber(data.getData().getString("number"));
                    result.setSucess(true);
                    result.setData((Map<String, Object>)data.getData());
                    result.setId(data.getData().get((Object)EXT_ID));
                    savedBillResults.add(result);
                }
                ++index;
            }
            log.info(this.genLogPrefix("validation") + String.format("batchSize: %s, cost time: %s", batchSize, System.currentTimeMillis() - sTick));
            long duTick = System.currentTimeMillis();
            ApiResult apiResult2 = new ApiResult();
            if (!validatedBillData.isEmpty()) {
                Map<Object, String> errResult = this.saveBatch(validatedBillData);
                if (!Objects.equals(errResult.size(), validatedBillData.size())) {
                    this.success = true;
                }
                if (!CollectionUtils.isEmpty(errResult)) {
                    savedBillResults.forEach(t -> {
                        if (Objects.nonNull(errResult.get(t.getId()))) {
                            t.setSucess(false);
                            t.setMessage((String)errResult.get(t.getId()));
                        }
                    });
                    apiResult2.setSuccess(false);
                }
            }
            log.info(this.genLogPrefix("dataUpdated") + String.format("size: %s, cost time: %s", validatedBillData.size(), System.currentTimeMillis() - duTick));
            long puTick = System.currentTimeMillis();
            ArrayList apiResultData = new ArrayList(10);
            savedBillResults.forEach(t -> apiResultData.add(t.toMap()));
            apiResult2.setData(apiResultData);
            log.info(this.genLogPrefix("postUpdated") + String.format("size: %s, cost time: %s", validatedBillData.size(), System.currentTimeMillis() - puTick));
            apiResult = apiResult2;
        }
        catch (Throwable throwable) {
            log.info(this.genLogPrefix("finished") + String.format("cost: %s", System.currentTimeMillis() - sTick));
            throw throwable;
        }
        log.info(this.genLogPrefix("finished") + String.format("cost: %s", System.currentTimeMillis() - sTick));
        return apiResult;
    }

    protected Map<Object, String> saveBatch(List<ImportBillData> billDataList) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        switch (importType) {
            case NEW: {
                return this.saveNew(billDataList);
            }
            case OVERRIDE: {
                return this.saveOverride(billDataList);
            }
            case OVERRIDENEW: {
                return this.saveOverrideNew(billDataList);
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7c7b\u578b\u6709\u8bef\u3002", (String)"AbsCommonImport_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    protected String genLogPrefix(String operationName) {
        return String.format("common_import:: entity: %s, operate: %s, ", this.entityName, operationName);
    }

    private void beforeValidation(List<ImportBillData> rowdatas) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        switch (importType) {
            case NEW: {
                this.updateWithNewId(rowdatas);
                break;
            }
            case OVERRIDE: {
                this.updateWithExistId(rowdatas, false);
                break;
            }
            case OVERRIDENEW: {
                this.updateWithExistId(rowdatas, true);
                break;
            }
        }
    }

    protected void updateWithExistId(List<ImportBillData> rowdatas, boolean addNew) {
        ArrayList newDataList = Lists.newArrayListWithCapacity((int)16);
        for (ImportBillData rowData : rowdatas) {
            Optional<DynamicObject> dbOld = this.getDbOld(rowData);
            if (dbOld.isPresent()) {
                rowData.getData().put(EXT_ID, dbOld.get().get(EXT_ID));
                rowData.getData().put(EXT_EXISTING_RECORD, (Object)dbOld.get());
                continue;
            }
            if (!addNew) continue;
            newDataList.add(rowData);
        }
        if (!CollectionUtils.isEmpty((Collection)newDataList)) {
            this.updateWithNewId(newDataList);
        }
    }

    protected abstract Optional<DynamicObject> getDbOld(ImportBillData var1);

    protected void updateWithNewId(List<ImportBillData> rowdatas) {
        if (CollectionUtils.isEmpty(rowdatas)) {
            return;
        }
        long[] ids = DBServiceHelper.genLongIds((String)this.entityName, (int)rowdatas.size());
        for (int j = 0; j < rowdatas.size(); ++j) {
            rowdatas.get(j).getData().put(EXT_ID, (Object)ids[j]);
        }
    }

    public static String buildExceptionMsg(Exception e, int stackLimit, boolean isSimple) {
        List stackMsgs = Arrays.stream(e.getStackTrace()).filter(ele -> ele.getClassName().startsWith("kd.fi.bcm")).map(ele -> isSimple ? String.format("%s:%s", ele.getFileName(), ele.getLineNumber()) : ele.toString()).collect(Collectors.toList());
        if (stackLimit > 0) {
            stackMsgs = stackMsgs.subList(0, Math.min(stackMsgs.size(), stackLimit));
        }
        return String.format("%s %s[%s] %s", ImportMsgUtils.unexpectedError(), e.getMessage(), RequestContext.get().getTraceId(), String.join((CharSequence)",", stackMsgs));
    }

    protected Map<Object, String> buildErrorMap(List<ImportBillData> billDataList, Exception e, Map<Object, String> errorMap) {
        for (ImportBillData t : billDataList) {
            errorMap.put(t.getData().get((Object)EXT_ID), AbsCommonImport.buildExceptionMsg(e, 2, true));
        }
        return errorMap;
    }

    protected abstract DynamicObject[] buildInsertDynamicObject(List<ImportBillData> var1);

    protected abstract DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> var1);

    protected Map<Object, String> saveNew(List<ImportBillData> billDataList) {
        return this.batchInsert(billDataList, Maps.newHashMapWithExpectedSize((int)16));
    }

    protected Map<Object, String> saveOverrideNew(List<ImportBillData> billDataList) {
        ArrayList needInsert = Lists.newArrayListWithCapacity((int)16);
        ArrayList needUpdate = Lists.newArrayListWithCapacity((int)16);
        for (ImportBillData billData : billDataList) {
            if (Objects.nonNull(billData.getData().get((Object)EXT_EXISTING_RECORD))) {
                needUpdate.add(billData);
                continue;
            }
            needInsert.add(billData);
        }
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)16);
        this.batchUpdate(needUpdate, errorMap);
        this.batchInsert(needInsert, errorMap);
        return errorMap;
    }

    protected Map<Object, String> saveOverride(List<ImportBillData> billDataList) {
        ArrayList needUpdate = Lists.newArrayListWithCapacity((int)16);
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)16);
        for (ImportBillData billData : billDataList) {
            if (Objects.nonNull(billData.getData().get((Object)EXT_EXISTING_RECORD))) {
                needUpdate.add(billData);
                continue;
            }
            errorMap.put(billData.getData().getLong(EXT_ID), ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u8bb0\u5f55\u4e0d\u66f4\u65b0\u3002", (String)"AbsCommonImport_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return this.batchUpdate(needUpdate, errorMap);
    }

    protected Map<Object, String> batchUpdate(List<ImportBillData> billDataList, Map<Object, String> errorMap) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return errorMap;
        }
        try (TXHandle tx = TX.requiresNew((String)"updateBatch");){
            try {
                this.batchUpdateDBOpt(billDataList);
            }
            catch (Exception e) {
                log.error("update_import_submit rollback, error:" + e.getMessage(), (Throwable)e);
                tx.markRollback();
                Map<Object, String> map = this.buildErrorMap(billDataList, e, errorMap);
                if (tx != null) {
                    if (var4_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return map;
            }
        }
        return errorMap;
    }

    protected Map<Object, String> batchInsert(List<ImportBillData> billDataList, Map<Object, String> errorMap) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return errorMap;
        }
        try (TXHandle tx = TX.requiresNew((String)"insertBatch");){
            try {
                this.batchInsertDBOpt(billDataList);
            }
            catch (Exception e) {
                log.error("insert_import_submit rollback, error:" + e.getMessage(), (Throwable)e);
                tx.markRollback();
                Map<Object, String> map = this.buildErrorMap(billDataList, e, errorMap);
                if (tx != null) {
                    if (var4_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return map;
            }
        }
        return errorMap;
    }

    protected void batchInsertDBOpt(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildInsertDynamicObject(billDataList);
        SaveServiceHelper.save((DynamicObject[])dys);
    }

    protected void batchUpdateDBOpt(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildUpdateDynamicObject(billDataList);
        SaveServiceHelper.save((DynamicObject[])dys);
    }

    public static void invokeOperation(String entityName, String pluginPath, CloseCallBack closeCallBack, Object modelId, ApplicationTypeEnum type, IFormView view, String listName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fidm_importstart");
        HashMap parameter = new HashMap();
        ArrayList plugins = new ArrayList();
        LinkedHashMap<String, Object> plugin = new LinkedHashMap<String, Object>();
        plugin.put("Type", 0);
        plugin.put("_Type_", "Plugin");
        plugin.put("ClassName", pluginPath);
        boolean enabled = true;
        plugin.put("Enabled", enabled);
        plugin.put("rowKey", null);
        plugins.add(plugin);
        parameter.put("plugins", plugins);
        showParameter.setCustomParams(parameter);
        showParameter.setCustomParam("BillFormId", (Object)entityName);
        showParameter.setCustomParam("RealPermissionEntityId", (Object)entityName);
        showParameter.setCustomParam("ServiceAppId", (Object)view.getFormShowParameter().getAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)view.getFormShowParameter().getAppId());
        showParameter.setCustomParam("reporttype", (Object)type.getOIndex());
        showParameter.setCustomParam("modelid", modelId);
        showParameter.setCustomParam("ListName", (Object)listName);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }
}

