/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.license;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.fs.util.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.formplugin.common.license.Version;
import kd.epm.far.formplugin.common.license.VersionService;

public class BcmLicenceControl {
    public static final String FIDIMANDFAR_VERSION = "5.0.011.0";
    private static final String PLATFORM_VERSION = "4.0.000.0";
    private static List<String> bcmLic = Arrays.asList("bcm_report_list", "bcm_cslreport_list", "bcm_rptadjustentry_merge", "bcm_rptadjustentry_offset", "bcm_report_search", "bcm_cwpreport_list", "bcm_checkrecordlist", "bcm_rptadjustentry_djust");
    private static List<String> FARLIC = Collections.singletonList("far_myanalysislist");
    private static List<String> SPECIAL_LIC = Collections.singletonList("bcm_isrptschemelist");
    private static Set<String> lowVersionshowPage = new HashSet<String>(Collections.singletonList("fidm_model"));

    public static LicenseCheckResult check(String appId, String formId) {
        if (bcmLic.contains(formId)) {
            String platFormVersion;
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            if (StringUtils.isEmpty((String)appId)) {
                appId = ApplicationTypeEnum.CM.getAppnum();
            }
            if (StringUtils.isNotEmpty((String)(platFormVersion = BcmLicenceControl.getPlatFormVersion())) && platFormVersion.compareToIgnoreCase(PLATFORM_VERSION) > 0) {
                return LicenseServiceHelper.checkByAppAndBizObj((String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)"bcm_report_list", (Long)userId);
            }
            return new LicenseCheckResult(Boolean.valueOf(true), "1");
        }
        if (FARLIC.contains(formId)) {
            return BcmLicenceControl.checkFarAppLicense(appId);
        }
        if (SPECIAL_LIC.contains(formId)) {
            return BcmLicenceControl.checkSpecialLicense();
        }
        return null;
    }

    private static LicenseCheckResult checkSpecialLicense() {
        LicenseCheckResult re = null;
        String productVersion = LicenseServiceHelper.getProductVersion();
        BigDecimal licenseVersion = new BigDecimal(productVersion.trim());
        if (licenseVersion.compareTo(new BigDecimal("1.0")) > 0) {
            re = LicenseServiceHelper.checkPerformGroup((String)"PRO_CMRPA");
        }
        return re;
    }

    private static LicenseCheckResult checkFarAppLicense(String appId) {
        String platFormVersion;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (StringUtils.isEmpty((String)appId)) {
            appId = ApplicationTypeEnum.FAR.getAppnum();
        }
        if (StringUtils.isNotEmpty((String)(platFormVersion = BcmLicenceControl.getPlatFormVersion())) && platFormVersion.compareToIgnoreCase(PLATFORM_VERSION) > 0) {
            return LicenseServiceHelper.checkByAppAndBizObj((String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)"far_analysis_list", (Long)userId);
        }
        return new LicenseCheckResult(Boolean.valueOf(true), "1");
    }

    public static String getPlatFormVersion() {
        List<Version> versions = VersionService.getVersionInfos();
        Version versionInfo = versions.stream().filter(x -> Objects.equals(x.getProductNumber(), "cosmic_bos")).findAny().orElse(null);
        if (null != versionInfo) {
            return versionInfo.getVersion();
        }
        return "";
    }

    public static String checkByVersion(FormShowParameter fs) {
        String platFormVersion = BcmLicenceControl.getPlatFormVersion();
        String msg = BcmLicenceControl.checkFidmAndFar(fs, platFormVersion);
        return msg;
    }

    private static String checkFidmAndFar(FormShowParameter fs, String platFormVersion) {
        if (StringUtils.isNotEmpty((String)platFormVersion) && platFormVersion.compareToIgnoreCase(FIDIMANDFAR_VERSION) >= 0) {
            return null;
        }
        String f = fs.getFormId();
        String msg = BcmLicenceControl.checkFidmAndFar(f);
        if (StringUtils.isEmpty((String)msg)) {
            if (fs instanceof ListShowParameter) {
                String billFormId = ((ListShowParameter)fs).getBillFormId();
                return BcmLicenceControl.checkFidmAndFar(billFormId);
            }
        } else {
            return msg;
        }
        return null;
    }

    private static String checkFidmAndFar(String page) {
        if (StringUtils.isEmpty((String)page)) {
            return null;
        }
        if ((page.startsWith("fidm") || page.startsWith("far")) && !lowVersionshowPage.contains(page)) {
            return String.format(ResManager.loadKDString((String)"\u8bf7\u5347\u7ea7\u5e73\u53f0\u7248\u672c\u5230%s\u53ca\u4ee5\u4e0a\u540e\uff0c\u83b7\u53d6\u8bb8\u53ef\u91cd\u8bd5", (String)"BcmLicenceControl_1", (String)"epm-far-formplugin", (Object[])new Object[0]), FIDIMANDFAR_VERSION);
        }
        return null;
    }
}

