/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.license;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.far.formplugin.common.license.Version;

public class VersionService {
    private static Log logger = LogFactory.getLog(VersionService.class);

    public static List<Version> getVersionInfos() {
        String sql = "select fid, fproductnumber, fversion, fupgradetime from t_bas_industry_version where fproductnumber = 'cosmic_bos' or fproductnumber like 'constellation_%';";
        ArrayList<Version> versions = new ArrayList<Version>();
        try {
            List allVersion = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
                ArrayList<Version> result = new ArrayList<Version>(resultSet.getRow());
                while (resultSet.next()) {
                    Version version = new Version();
                    version.setId(resultSet.getString("fid"));
                    version.setVersion(resultSet.getString("fversion"));
                    version.setProductNumber(resultSet.getString("fproductnumber"));
                    version.setUpgradeTime(resultSet.getDate("fupgradetime"));
                    result.add(version);
                }
                return result;
            });
            for (Version version : allVersion) {
                if (!"cosmic_bos".equals(version.getProductNumber())) continue;
                versions.add(version);
                break;
            }
            allVersion.removeAll(versions);
            allVersion.stream().max(Comparator.comparing(Version::getVersion)).ifPresent(versions::add);
        }
        catch (Exception var5) {
            logger.error("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Throwable)var5);
        }
        return versions;
    }
}

