/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.model;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DiscModelService;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.Permission.UserTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseListPlugin;
import kd.epm.far.formplugin.common.util.ModelUtil;

public class DiscModelGuide
extends AbstractBaseDMListPlugin
implements ClickListener,
IConfirmCallBack {
    private static final String STEP1 = "tabpageap";
    private static final String STEP2 = "tabpageap1";
    private static final String STEP3 = "tabpageap2";
    private static final String NEXT = "btnnext";
    private static final String PRE = "btnprev";
    private static final String MODELFROM = "modelfrom";
    private static final String EXISTMODEL = "existmodel";
    private static final String BCMBILLSTAP = "billlistap1";
    private static final String RPTBILLSTAP = "billlistap2";
    private static final String EASYPAGE = "flexpanelap22";
    private static final String INFOPAGE = "flexpanelap3";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(MODELFROM, EXISTMODEL, NEXT, PRE);
        BillList bcmbillList = (BillList)this.getView().getControl(BCMBILLSTAP);
        bcmbillList.addSetFilterListener(this::setFilter);
        BillList epmbillList = (BillList)this.getView().getControl(RPTBILLSTAP);
        epmbillList.addSetFilterListener(this::setFilter);
        bcmbillList.addPagerClickListener(pagerClickEvent -> this.refreshBillList(BCMBILLSTAP, RPTBILLSTAP));
        epmbillList.addPagerClickListener(pagerClickEvent -> this.refreshBillList(RPTBILLSTAP, BCMBILLSTAP));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"wizardap"});
    }

    private String getCurrentTab() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        return tab.getCurrentTab();
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnnext": {
                this.next();
                this.processNext();
                break;
            }
            case "btnprev": {
                this.previous();
                break;
            }
        }
    }

    private void processNext() {
        switch (this.getCurrentTab()) {
            case "tabpageap": {
                if (!"1".equals(this.getModel().getValue(MODELFROM))) break;
                String modelType = (String)this.getModel().getValue(EXISTMODEL);
                if ("2".equals(modelType)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{RPTBILLSTAP});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{BCMBILLSTAP});
                    this.refreshBillList(RPTBILLSTAP, BCMBILLSTAP);
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{RPTBILLSTAP});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BCMBILLSTAP});
                this.refreshBillList(BCMBILLSTAP, RPTBILLSTAP);
                break;
            }
            case "tabpageap1": {
                BillList billList = this.getActiveBillstap();
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DiscModelGuide_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                DynamicObject sourceobj = BusinessDataServiceHelper.loadSingle((Object)selectedRows.getPrimaryKeyValues()[0], (String)billList.getEntityType().getName(), (String)"id,shownumber,name");
                this.saveDMModel(sourceobj);
                if ("1".equals(this.getModel().getValue(MODELFROM))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{EASYPAGE});
                    this.getView().setVisible(Boolean.TRUE, new String[]{INFOPAGE});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{EASYPAGE});
                this.getView().setVisible(Boolean.FALSE, new String[]{INFOPAGE});
                break;
            }
            case "tabpageap2": {
                break;
            }
        }
    }

    public void saveModel(DynamicObject model, boolean needInitModule) {
        try (TXHandle tx = TX.required();){
            AnalysisOpLogParam logParam = this.getLogParam(model);
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
                this.saveModelAdmin(model.getLong("id"));
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam.buildOpResult(OperationResult.SUCCESS));
            }
            catch (Exception e) {
                tx.markRollback();
                AbstractBaseListPlugin.log.error("create model failed : " + e.getMessage(), (Throwable)e);
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam.buildOpResult(OperationResult.FAILURE));
                throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u4f53\u7cfb\u5931\u8d25\u3002", (String)"DiscModelGuide_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        DiscModelService.createPrepareData((Long)model.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
    }

    private void saveModelAdmin(Long id) {
        RequestContext context = RequestContext.get();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)context.getCurrUserId()).toArray());
        DynamicObject modelPerm = BusinessDataServiceHelper.newDynamicObject((String)"bcm_modelperm");
        modelPerm.set("id", (Object)DBServiceHelper.genGlobalLongId());
        modelPerm.set("fidmmodel", (Object)id);
        modelPerm.set("createtime", (Object)TimeServiceHelper.now());
        modelPerm.set("modifytime", (Object)TimeServiceHelper.now());
        modelPerm.set("creator", (Object)context.getCurrUserId());
        modelPerm.set("modifier", (Object)context.getCurrUserId());
        modelPerm.set("username", user != null ? user.get("name") : context.getUserName());
        String appid = this.getView().getFormShowParameter().getAppId();
        modelPerm.set("app", (Object)appid);
        DynamicObjectCollection permEntrys = modelPerm.getDynamicObjectCollection("modelpermentry");
        DynamicObject permEntryItem = new DynamicObject(permEntrys.getDynamicObjectType());
        permEntryItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
        permEntryItem.set("seq", (Object)1);
        permEntryItem.set("etype", (Object)UserTypeEnum.USER.getName());
        permEntryItem.set("eusers", (Object)context.getCurrUserId());
        permEntrys.add((Object)permEntryItem);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{modelPerm});
    }

    private void refreshBillList(String activebill, String noshowbill) {
        BillList activebillList = (BillList)this.getView().getControl(activebill);
        activebillList.addSetFilterListener(this::setFilter);
        activebillList.getRealCount();
        activebillList.refresh();
        activebillList.clearSelection();
        this.getView().setVisible(Boolean.TRUE, new String[]{activebill});
        this.getView().setVisible(Boolean.FALSE, new String[]{noshowbill});
    }

    private BillList getActiveBillstap() {
        String modelType = (String)this.getModel().getValue(EXISTMODEL);
        if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            return (BillList)this.getView().getControl(RPTBILLSTAP);
        }
        return (BillList)this.getView().getControl(BCMBILLSTAP);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "modelfrom": {
                TabPage tab = (TabPage)this.getControl(STEP2);
                if ("1".equals(newValue)) {
                    tab.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u6709\u6a21\u578b", (String)"DiscModelGuide_3", (String)"epm-far-formplugin", (Object[])new Object[0])));
                    break;
                }
                tab.setText(new LocaleString(ResManager.loadKDString((String)"\u7b80\u6613\u6a21\u578b", (String)"DiscModelGuide_4", (String)"epm-far-formplugin", (Object[])new Object[0])));
                this.getView().setVisible(Boolean.FALSE, new String[]{BCMBILLSTAP});
                this.getView().setVisible(Boolean.TRUE, new String[]{RPTBILLSTAP});
                break;
            }
            case "existmodel": {
                if (DisModelTypeEnum.EB.getType().equals(newValue)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{RPTBILLSTAP});
                    this.getView().setVisible(Boolean.TRUE, new String[]{BCMBILLSTAP});
                    this.refreshBillList(RPTBILLSTAP, BCMBILLSTAP);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{RPTBILLSTAP});
                this.getView().setVisible(Boolean.TRUE, new String[]{BCMBILLSTAP});
                this.refreshBillList(BCMBILLSTAP, RPTBILLSTAP);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        if (DisModelTypeEnum.EB.getType().equals(this.getModel().getValue(EXISTMODEL))) {
            this.changeEBFilter(e);
        } else if (DisModelTypeEnum.RPT.getType().equals(this.getModel().getValue(EXISTMODEL))) {
            this.changeRPTFilter(e);
        } else {
            this.changeCMFilter(e);
        }
    }

    private void saveDMModel(DynamicObject source) {
        String number = source.getString("shownumber");
        ApplicationTypeEnum app = ModelUtil.queryApp(this.getView());
        String apptype = app == ApplicationTypeEnum.FAR ? "2" : "1";
        QFilter qf = new QFilter("number", "=", (Object)number);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"fidm_model", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"fidm_model").getAllFields().keySet()), (QFilter[])qf.toArray());
        if (Objects.isNull(obj)) {
            DynamicObject dmmodel = BusinessDataServiceHelper.newDynamicObject((String)"fidm_model");
            dmmodel.set("id", (Object)source.getLong("id"));
            dmmodel.set("number", (Object)number);
            dmmodel.set("name", (Object)source.getString("name"));
            dmmodel.set("creator", (Object)this.getUserId());
            dmmodel.set("createtime", (Object)TimeServiceHelper.now());
            dmmodel.set("status", (Object)"0");
            if (Objects.equals(app, ApplicationTypeEnum.FAR)) {
                dmmodel.set("status", (Object)"1");
            }
            dmmodel.set("modeltype", this.getModel().getValue(EXISTMODEL));
            if (DisModelTypeEnum.EB.getType().equals(dmmodel.getString("modeltype"))) {
                dmmodel.set("modelsourcetype", (Object)"epm_model");
                dmmodel.set("model", (Object)source.getLong("id"));
            } else {
                dmmodel.set("modelsourcetype", (Object)"bcm_model");
                dmmodel.set("model", (Object)source.getLong("id"));
            }
            dmmodel.set("apptype", (Object)apptype);
            this.saveModel(dmmodel, true);
        } else {
            if (Objects.equals(obj.getString("apptype"), "3") || Objects.equals(apptype, obj.getString("apptype"))) {
                AnalysisOpLogParam logParam = this.getLogParam(obj).buildOpResult(OperationResult.FAILURE);
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u4f53\u7cfb\u5df2\u7ecf\u5b58\u5728\uff0c\u540c\u4e00\u4e2a\u4f53\u7cfb\u53ea\u80fd\u5173\u8054\u751f\u6210\u4e00\u6b21\u3002", (String)"DiscModelGuide_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            obj.set("apptype", (Object)"3");
            this.saveModel(obj, true);
        }
    }

    private void changeCMFilter(SetFilterEvent e) {
        e.getQFilters().add(MemberPermHelper.getModelPermFilter((String)"id", (String)"bcm_modelperm_manager", (ApplicationTypeEnum)ApplicationTypeEnum.CM));
    }

    private void changeRPTFilter(SetFilterEvent e) {
        e.getQFilters().add(MemberPermHelper.getModelPermFilter((String)"id", (String)"bcm_modelperm_manager", (ApplicationTypeEnum)ApplicationTypeEnum.RPT));
        e.getQFilters().add(new QFilter("reporttype", "!=", (Object)ApplicationTypeEnum.CM.index));
    }

    private void changeEBFilter(SetFilterEvent e) {
        e.getQFilters().add(MemberPermHelper.getModelPermFilter((String)"id", (String)"epm_modelperm", (ApplicationTypeEnum)ApplicationTypeEnum.BGMD));
    }

    private void next() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(tab.getItems().size() - 1)).getKey())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5411\u5bfc\u5df2\u5b8c\u6210\uff0c\u662f\u5426\u9000\u51fa\u672c\u9875?", (String)"DiscModelGuide_8", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitGuideCallBack"));
                break;
            }
            if (STEP1.equals(currentTab) && "2".equals(this.getModel().getValue(MODELFROM))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u529f\u80fd\u76ee\u524d\u4e0d\u652f\u6301\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"DiscModelGuide_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
            break;
        }
    }

    private void previous() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            if (currentTab.equals(((Control)tab.getItems().get(0)).getKey())) {
                return;
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            break;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("exitGuideCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.getView().close();
        }
    }

    private AnalysisOpLogParam getLogParam(DynamicObject model) {
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.MODEL).buildOpName(OperationName.CREATE_MODEL).buildFormNumber(this.getView()).buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString("number")});
    }
}

