/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListCardView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.model.DiscModelService;
import kd.epm.far.business.common.perm.FarFunPermissionHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.util.ModelUtil;

public class DiscModelListPlugin
extends AbstractBaseDMListPlugin {
    private static final String BTN_ADDNEW = "btn_addnew";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BILLSTAP = "billlistap";
    private static final String CARDEDIT = "card_edit";
    private static final String CARDDELETE = "card_delete";
    private static final String BTN_DISTRIBUTE = "btn_distribute";
    private static final String PARENTFORMID = "parentFormId";
    private static final Log LOGGER = LogFactory.getLog(DiscModelListPlugin.class);
    private static final Map<String, String> permItemMap = new ImmutableMap.Builder().put((Object)"btn_addnew", (Object)"47156aff000000ac").build();
    private static final List<String> NEED_ADMIN_FORM = Lists.newArrayList((Object[])new String[]{"fidm_user_assignperm", "fidm_user_assignrole", "fidm_roleuserorg", "fidm_roleorguser", "fidm_auth"});
    private static final List<String> CHECK_ITEM_KEY = Lists.newArrayList((Object[])new String[]{"btn_enable", "btn_disable", "btn_delete", "btn_distribute"});
    private static final List<String> CHECK_ADMIN_KEY = Lists.newArrayList((Object[])new String[]{"btn_enable", "btn_disable", "btn_delete", "btn_distribute"});

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(CARDEDIT, CARDDELETE);
        ListCardView list = (ListCardView)this.getView().getControl("cardview");
        list.addClickListener((ClickListener)this);
    }

    public void setFilter(SetFilterEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (Objects.nonNull(parentView) && Objects.equals(parentView.getEntityId(), "far_publishcardcontent")) {
            return;
        }
        List qFilters = e.getQFilters();
        qFilters.add(this.getAppFilter());
        if (this.needAdmin()) {
            String appNumber = this.getView().getFormShowParameter().getAppId();
            qFilters.add(new QFilter("id", "in", (Object)MemberPermHelper.getDisModelAdmin((String)appNumber)));
            return;
        }
        ApplicationTypeEnum app = ModelUtil.queryApp(this.getView());
        HasPermDimObjResult result = ModelUtil.getHasPermModel(app);
        if (result != null) {
            if (result.hasAllDimObjPerm() || MemberPermHelper.isDiscModelSuperAdmin((String)app.appnum)) {
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)result.getHasPermDimObjs()));
        }
    }

    private QFilter getAppFilter() {
        ApplicationTypeEnum app = ModelUtil.queryApp(this.getView());
        if (app == ApplicationTypeEnum.FAR) {
            return new QFilter("apptype", "in", (Object)Lists.newArrayList((Object[])new String[]{"3", "2"}));
        }
        return new QFilter("apptype", "in", (Object)Lists.newArrayList((Object[])new String[]{"3", "1"}));
    }

    private boolean needAdmin() {
        IFormView parentViewNoPlugin = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (Objects.isNull(parentViewNoPlugin)) {
            return false;
        }
        return NEED_ADMIN_FORM.contains(parentViewNoPlugin.getEntityId());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("Modal".equals(this.getView().getFormShowParameter().getOpenStyle().getShowType().toString())) {
            BillList list = (BillList)this.getView().getControl(BILLSTAP);
            list.setDefaultView("gridview");
            return;
        }
        if (LongUtil.isvalidLong((Object)this.getDMModelId())) {
            this.getPageCache().put("dmmodelid", String.valueOf(this.getDMModelId()));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "fidm_modelguide": 
            case "fidm_model": 
            case "btn_distribute": {
                this.refreshBillList();
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)this.getControl(BILLSTAP);
        ListSelectedRowCollection dys = billList.getSelectedRows();
        if (dys.isEmpty()) {
            args.setCancel(true);
            return;
        }
        Long pkId = LongUtil.toLong((Object)dys.get(0).getPrimaryKeyValue());
        String msg = this.modelAdminCheck(pkId);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            args.setCancel(true);
            return;
        }
        super.billListHyperLinkClick(args);
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLSTAP);
        billList.addSetFilterListener(this::setFilter);
        billList.refresh();
        billList.clearSelection();
    }

    private String itemClickCheck(String itemKey, ListSelectedRowCollection dys) {
        String errMsg = this.permCheck(itemKey);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            return errMsg;
        }
        errMsg = this.selectCheck(itemKey, dys);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            return errMsg;
        }
        errMsg = this.adminCheck(itemKey, dys);
        return errMsg;
    }

    private String adminCheck(String itemKey, ListSelectedRowCollection dys) {
        if (!CHECK_ADMIN_KEY.contains(itemKey)) {
            return null;
        }
        Long primaryKeyValue = LongUtil.toLong((Object)dys.get(0).getPrimaryKeyValue());
        return this.modelAdminCheck(primaryKeyValue);
    }

    private String modelAdminCheck(Long pkId) {
        String appNumber = this.getView().getFormShowParameter().getAppId();
        return MemberPermHelper.isDiscModelAdmin((Long)pkId, (String)appNumber) || MemberPermHelper.isDiscModelSuperAdmin((String)appNumber) ? null : ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u8be5\u4f53\u7cfb\u7ba1\u7406\u5458,\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"DiscModelListPlugin_23", (String)"epm-far-formplugin", (Object[])new Object[0]);
    }

    private String permCheck(String itemKey) {
        String permItemId = permItemMap.get(itemKey);
        if (StringUtils.isEmpty((CharSequence)permItemId)) {
            return null;
        }
        if (PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), (String)"fidm_model", (String)permItemId)) {
            return null;
        }
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"DiscModelListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]);
    }

    private String selectCheck(String itemKey, ListSelectedRowCollection dys) {
        if (!CHECK_ITEM_KEY.contains(itemKey)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"DiscModelListPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        if (dys.size() != 1) {
            return ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u4e2d\u4e00\u4e2a\u4f53\u7cfb\u3002", (String)"DiscModelListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        BillList billList;
        ListSelectedRowCollection dys;
        String itemKey = evt.getItemKey();
        String errMsg = this.itemClickCheck(itemKey, dys = (billList = (BillList)this.getControl(BILLSTAP)).getSelectedRows());
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            this.getView().showErrorNotification(errMsg);
            return;
        }
        switch (itemKey) {
            case "btn_addnew": {
                this.openGuidePage();
                break;
            }
            case "btn_enable": 
            case "btn_disable": {
                this.actionEnable(Objects.equals(BTN_ENABLE, itemKey) ? 1 : 0);
                break;
            }
            case "btn_delete": {
                this.actionDelete();
                break;
            }
            case "btn_distribute": {
                ListSelectedRow selectedRow = dys.get(0);
                String billId = selectedRow.getPrimaryKeyValue().toString();
                DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"fidm_model", (String)"model.name", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(billId)).toArray());
                String modelName = dy.getString("model.name");
                QFBuilder modelPermFilter = new QFBuilder();
                modelPermFilter.add(new QFilter("fidmmodel.id", "=", (Object)Long.valueOf(billId)));
                modelPermFilter.add(new QFilter("app", "=", (Object)this.getBizAppId()));
                DynamicObject modelPerm = QueryServiceHelper.queryOne((String)"bcm_modelperm", (String)"id", (QFilter[])modelPermFilter.toArray());
                if (Objects.isNull(modelPerm)) {
                    RequestContext context = RequestContext.get();
                    DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)context.getCurrUserId()).toArray());
                    modelPerm = BusinessDataServiceHelper.newDynamicObject((String)"bcm_modelperm");
                    modelPerm.set("id", (Object)DBServiceHelper.genGlobalLongId());
                    modelPerm.set("fidmmodel", (Object)Long.valueOf(billId));
                    modelPerm.set("createtime", (Object)TimeServiceHelper.now());
                    modelPerm.set("modifytime", (Object)TimeServiceHelper.now());
                    modelPerm.set("creator", (Object)context.getCurrUserId());
                    modelPerm.set("modifier", (Object)context.getCurrUserId());
                    modelPerm.set("username", user != null ? user.get("name") : context.getUserName());
                    String appid = this.getView().getFormShowParameter().getAppId();
                    modelPerm.set("app", (Object)appid);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{modelPerm});
                }
                HashMap<String, String> openParameter = new HashMap<String, String>();
                openParameter.put("formId", "bcm_modelperm");
                openParameter.put("pkId", modelPerm.getString("id"));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
                showParameter.setCustomParam(PARENTFORMID, (Object)this.getBizEntityNumber());
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u7ba1\u7406 - %s", (String)"DiscModelListPlugin_21", (String)"epm-far-formplugin", (Object[])new Object[0]), modelName));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_DISTRIBUTE);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection result = new DynamicObjectCollection();
        String id = this.getPageCache().get("dmmodelid");
        IFormView parentView = this.getView().getParentView();
        Map<Long, String> adminMap = Objects.nonNull(parentView) && Objects.equals(parentView.getEntityId(), "far_publishcardcontent") ? this.getFarAdminMap(e.getPageData()) : this.getAdminMap(e.getPageData());
        for (DynamicObject obj : e.getPageData()) {
            if (Objects.equals(obj.getString("id"), id)) {
                obj.set("iscurrent", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb", (String)"DiscModelListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isNotEmpty((CharSequence)obj.getString("iscurrent"))) {
                obj.set("iscurrent", (Object)"");
            }
            obj.set("adminname", (Object)adminMap.get(obj.getLong("id")));
            result.add((Object)obj);
        }
        e.getPageData().clear();
        e.getPageData().addAll((Collection)result);
    }

    private Map<Long, String> getAdminMap(DynamicObjectCollection pageData) {
        if (pageData.isEmpty()) {
            return Collections.emptyMap();
        }
        Set ids = pageData.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        return MemberPermHelper.getDiscModelAdmin(ids, (String)this.getBizAppId()).stream().collect(Collectors.toMap(k -> k.getLong("fidmmodel.id"), v -> this.getModelAdminUserName((DynamicObject)v), (v1, v2) -> v1));
    }

    private Map<Long, String> getFarAdminMap(DynamicObjectCollection pageData) {
        if (pageData.isEmpty()) {
            return Collections.emptyMap();
        }
        Set ids = pageData.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        return MemberPermHelper.getDiscModelAdmin(ids, (String)ApplicationTypeEnum.FAR.appnum).stream().collect(Collectors.toMap(k -> k.getLong("fidmmodel.id"), v -> this.getModelAdminUserName((DynamicObject)v), (v1, v2) -> v1));
    }

    private String getModelAdminUserName(DynamicObject modelPerm) {
        String nameStr = "";
        if (modelPerm == null) {
            return nameStr;
        }
        Object name = modelPerm.get("username");
        if (name == null) {
            return nameStr;
        }
        nameStr = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)).toString().trim() : name.toString().trim();
        return nameStr;
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        for (IListColumn col : listColumns) {
            if (!col.getListFieldKey().equals("iscurrent")) continue;
            col.getContext();
        }
    }

    private void deleteModelAdmin(Set<Object> ids) {
        String appId = this.getView().getFormShowParameter().getAppId();
        QFBuilder modelAdmin = new QFBuilder();
        modelAdmin.add(new QFilter("fidmmodel", "in", ids));
        modelAdmin.add(new QFilter("app", "=", (Object)appId));
        DeleteServiceHelper.delete((String)"bcm_modelperm", (QFilter[])modelAdmin.toArray());
        QFilter permFilter = new QFilter("fidmmodel", "in", ids);
        DeleteServiceHelper.delete((String)"bcm_auth_info", (QFilter[])new QFilter[]{permFilter});
        DeleteServiceHelper.delete((String)"bcm_permclass_entity", (QFilter[])new QFilter[]{permFilter});
        DeleteServiceHelper.delete((String)"bcm_permissionclass", (QFilter[])new QFilter[]{permFilter});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "btn_delete": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                BillList billList = (BillList)this.getControl(BILLSTAP);
                HashSet<Object> ids = new HashSet<Object>(10);
                billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
                AnalysisOpLogParam logParam = this.getMultiLogParam(billList);
                if (this.checkModelRelated(ids)) {
                    logParam.buildOpResult(OperationResult.FAILURE);
                    AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
                    return;
                }
                this.deleteModel(ids);
                this.refreshBillList();
                logParam.buildOpResult(OperationResult.SUCCESS);
                AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PaperTemplateListPlugin_04", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean checkModelRelated(Set<Object> ids) {
        QFilter qFilter = new QFilter("model", "in", ids);
        DynamicObject dm = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,status", (QFilter[])new QFilter("id", "in", ids).toArray());
        if (dm != null && !"0".equals(dm.getString("status"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u4f53\u7cfb\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"fidm_disc_variable", (QFilter[])new QFilter[]{new QFilter("model", "in", ids)})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u53d8\u91cf\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"fidm_dataset", (QFilter[])new QFilter[]{new QFilter("discmodel", "in", ids)})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u6570\u636e\u96c6\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"fidm_template", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u6a21\u677f\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"fidm_chapter", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u7ae0\u8282\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"fidm_report", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u62a5\u544a\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"fidm_modulerepository", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u7ec4\u4ef6\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (QueryServiceHelper.exists((String)"far_themeanalysis", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5b58\u5728\u4e3b\u9898\u5206\u6790\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_27", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void deleteModel(Set<Object> ids) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"fidm_model", (String)"id,apptype,", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        Map<String, List<DynamicObject>> result = Arrays.stream(objs).collect(Collectors.groupingBy(s -> s.getString("apptype")));
        ArrayList waitUpdate = new ArrayList(10);
        HashSet waitDelete = new HashSet(10);
        ApplicationTypeEnum application = this.getApplicationType();
        result.forEach((k, v) -> {
            if ("3".equals(k)) {
                if (ApplicationTypeEnum.FAR == application) {
                    v.stream().forEach(s -> {
                        s.set("apptype", (Object)"1");
                        waitUpdate.add(s);
                    });
                } else {
                    v.stream().forEach(s -> {
                        s.set("apptype", (Object)"2");
                        waitUpdate.add(s);
                    });
                }
            } else {
                Set tagids = v.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
                waitDelete.addAll(tagids);
            }
        });
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"fidm_model", (QFilter[])new QFilter[]{new QFilter("id", "in", waitDelete)});
                DeleteServiceHelper.delete((String)"bcm_userselect", (QFilter[])new QFilter[]{new QFilter("dmmodel", "in", waitDelete), new QFilter("application", "=", (Object)application.index)});
                SaveServiceHelper.update((DynamicObject[])waitUpdate.toArray(new DynamicObject[0]));
                this.deleteModelAdmin(ids);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        String apptype = this.getView().getFormShowParameter().getAppId();
        Long modelId = objs[0].getLong("id");
        if (!CollectionUtils.isEmpty(waitUpdate)) {
            FarFunPermissionHelper.dmDeletePermByModelId((Long)modelId, (String)apptype);
        } else if (!CollectionUtils.isEmpty(waitDelete)) {
            FarFunPermissionHelper.delDmPermUserByModelId((Long)modelId);
        }
        String appId = FarFunPermissionHelper.getAppID((String)this.getView().getFormShowParameter().getAppId());
        FarFunPermissionHelper.delDmPermUserRoleByModelId((Long)modelId, (String)appId);
    }

    private void actionDelete() {
        BillList billList = (BillList)this.getControl(BILLSTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4f53\u7cfb\u3002", (String)"DiscModelListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean containCurrent = Arrays.stream(billList.getSelectedRows().getPrimaryKeyValues()).anyMatch(s -> Objects.equals(this.getDMModelId().toString(), s.toString()));
        if (containCurrent) {
            AnalysisOpLogParam logParam = this.getMultiLogParam(billList).buildOpResult(OperationResult.FAILURE);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_24", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_model", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billList.getSelectedRows().getPrimaryKeyValues())});
        if (dys.stream().anyMatch(dy -> dy.getBoolean("status"))) {
            AnalysisOpLogParam logParam = this.getMultiLogParam(billList).buildOpResult(OperationResult.FAILURE);
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u4f53\u7cfb\u4e0d\u53ef\u5220\u9664\u3002", (String)"DiscModelListPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664", (String)"DiscModelListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DELETE, (IFormPlugin)this));
    }

    private void actionEnable(int i) {
        BillList billList = (BillList)this.getControl(BILLSTAP);
        ListSelectedRowCollection dys = billList.getSelectedRows();
        String enable = i == 0 ? "0" : "1";
        String msg = i == 0 ? ResManager.loadKDString((String)"\u5df2\u7981\u7528\u3002", (String)"PaperTemplateListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u542f\u7528\u3002", (String)"DiscModelListPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]);
        Map modelStatus = DiscModelService.getDiscModelStatus((Object[])dys.getPrimaryKeyValues());
        ArrayList primaryKeyValues = new ArrayList(dys.size());
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billList.getSelectedRows().getPrimaryKeyValues())});
        ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)dys.size());
        dyc.forEach(dy -> formatParamsList.add(new Object[]{dy.getString("number")}));
        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.MODEL).buildFormNumber("fidm_model").buildAppId(this.getView()).buildFormatParamsList((List)formatParamsList);
        for (Map.Entry entry : modelStatus.entrySet()) {
            if (enable.equals(((DynamicObject)entry.getValue()).getString("status"))) continue;
            primaryKeyValues.add(entry.getKey());
        }
        if (i == 1) {
            logParam.buildOpName(OperationName.ENABLE).buildOpResult(OperationResult.SUCCESS);
            if (primaryKeyValues.isEmpty()) {
                logParam.buildOpResult(OperationResult.FAILURE);
                AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u5df2\u542f\u7528\u3002", (String)"DiscModelListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (i == 0) {
            logParam.buildOpName(OperationName.DISABLE).buildOpResult(OperationResult.SUCCESS);
            if (primaryKeyValues.isEmpty()) {
                logParam.buildOpResult(OperationResult.FAILURE);
                AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u5df2\u7981\u7528\u3002", (String)"DiscModelListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        DiscModelService.updateDiscModelStatus((String)(i + ""), (Object[])primaryKeyValues.toArray());
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        this.getView().showSuccessNotification(msg);
        this.refreshBillList();
    }

    private void openGuidePage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        String formId = "fidm_modelguide";
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fidm_modelguide"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public String getModelSign() {
        return "";
    }

    private AnalysisOpLogParam getMultiLogParam(BillList billList) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billList.getSelectedRows().getPrimaryKeyValues())});
        ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)dys.size());
        dys.forEach(dy -> formatParamsList.add(new Object[]{dy.getString("number")}));
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.MODEL).buildOpName(OperationName.DELETE_MODEL).buildFormNumber("fidm_model").buildAppId(this.getView()).buildFormatParamsList((List)formatParamsList);
    }
}

