/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.module;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.model.adapter.ModelAdapter;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;

public class ModuleCatalogEditPlugin
extends AbstractBasePlugIn {
    private static final String MODEL = "model";
    private static final String PARENT = "parent";
    private static final String SEQUENCE = "sequence";
    private static final String ENTITY_NAME = "fidm_modulecatalog";
    private static final String FIDMMODEL = "fidmmodel";
    private WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ((Object)((Object)this)).getClass());

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterLoadData(EventObject e) {
        PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)this.getModelId());
        this.getModel().setDataChanged(false);
        Object parentNode = this.getModel().getValue(PARENT);
        if (Objects.isNull(parentNode)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get(MODEL);
        Object objParent = map.get(PARENT);
        Object catcalogType = map.get("catcalogType");
        this.getModel().setValue(MODEL, objModel);
        this.getModel().setValue("catalogtype", catcalogType);
        this.getModel().setValue(PARENT, objParent);
        int seq = this.getCurNodeSequence(map.get(MODEL).toString(), map.get(PARENT).toString());
        this.getModel().setValue(SEQUENCE, (Object)seq);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object parentNode = this.getModel().getValue(PARENT);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (Objects.isNull(parentNode) && Objects.nonNull(status) && status == OperationStatus.EDIT) {
            this.getModel().setDataChanged(false);
            args.setCancel(true);
            this.saveRootNode();
            return;
        }
        if (args.getSource() instanceof Save) {
            this.getModel().setValue("status", (Object)"C");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        List ids = e.getOperationResult().getSuccessPkIds();
        Object number = this.getModel().getValue("number");
        Object name = this.getModel().getValue("name");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        OperationName opName = OperationName.UNSUPPORTED;
        if ("add".equals(type)) {
            opName = OperationName.CATALOG_CREATE;
        } else if ("edit".equals(type)) {
            opName = OperationName.CATALOG_EDIT;
        }
        try {
            if (e.getSource() instanceof Save) {
                if (isSuccess) {
                    PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)ENTITY_NAME, (Long)LongUtil.toLong(ids.get(0)), (Object)LongUtil.toLong((Object)this.getModelId()), (OperationStatus)status, (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
                    this.getView().returnDataToParent((Object)ids);
                    this.getView().close();
                    this.writeOpLog(OperationResult.SUCCESS, opName);
                } else {
                    this.writeOpLog(OperationResult.FAILURE, opName);
                }
            }
        }
        catch (Exception exception) {
            this.writeOpLog(OperationResult.FAILURE, opName);
            throw exception;
        }
    }

    private void saveRootNode() {
        DynamicObject catalog = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModel().getValue("id"), (String)ENTITY_NAME);
        catalog.set("instruction", this.getModel().getValue("instruction"));
        catalog.set("status", (Object)"C");
        catalog.set("permclass", this.getModel().getValue("permclass"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{catalog});
        PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (String)ENTITY_NAME, (Long)LongUtil.toLong((Object)this.getModel().getValue("id")), (Object)LongUtil.toLong((Object)this.getModelId()), (OperationStatus)OperationStatus.EDIT, (String)FIDMMODEL);
        ArrayList<Object> ids = new ArrayList<Object>(10);
        ids.add(this.getModel().getValue("id"));
        this.getView().returnDataToParent(ids);
        this.getView().close();
    }

    private int getCurNodeSequence(String modelId, String parentId) {
        QFilter model = new QFilter(MODEL, "=", (Object)Long.valueOf(modelId));
        QFilter parent = new QFilter(PARENT, "=", (Object)Long.valueOf(parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getCatalogEntity(), (String)SEQUENCE, (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString(SEQUENCE);
            return (strSeq.isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    private String getCatalogEntity() {
        return ENTITY_NAME;
    }

    private Object getModelId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return map.get(MODEL);
    }

    private boolean isAdd() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return map.get("type") != null && map.get("type").toString().equals("add");
    }

    private void writeOpLog(OperationResult result, OperationName opName) {
        try {
            Long modelId = Long.parseLong((String)this.getModelId());
            ModelInfo model = ModelAdapter.getModelInfo((Long)modelId, (boolean)false);
            if (model == null) {
                return;
            }
            Object number = this.getModel().getValue("number");
            String catalogNumber = number != null ? number.toString() : "";
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.COMPONENT_GALLERY).buildOpName(opName).buildFormNumber("fidm_modulerepositorylist").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getNumber(), catalogNumber}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            this.log.error("fidm log error", (Throwable)ex);
        }
    }
}

