/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class ModuleRepositityPlugin
extends AbstractBaseDMFormPlugin
implements BeforeF7SelectListener,
IBillPlugin {
    private static final String CATALOG = "catalog";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String BTN_SAVE = "btn_save";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(CATALOG);
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit permclassdatasetBasedata = (BasedataEdit)this.getControl(PERMCLASS);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclassdatasetBasedata, (Object)this.getDMModelId(), (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DynamicObject root = ModuleServiceHelper.addCatalogRoot((Long)this.getDMModelId(), (String)"1");
        super.afterCreateNewData(e);
        Map moduleDyn = (Map)this.getFormCustomParam("moduleInfo");
        if (Objects.isNull(moduleDyn) || moduleDyn.isEmpty()) {
            return;
        }
        this.setValue("model", moduleDyn.get("model"));
        this.setValue(NUMBER, moduleDyn.get(NUMBER));
        this.setValue(NAME, moduleDyn.get(NAME));
        this.setValue("type", moduleDyn.get("type"));
        this.setValue("template", moduleDyn.get("template"));
        this.setValue("scope", moduleDyn.get("scope"));
        this.setValue("status", moduleDyn.get("status"));
        this.setValue("applytype", moduleDyn.get("applytype"));
        this.setValue("comefrom", moduleDyn.get("comefrom"));
        this.setValue("properties", moduleDyn.get("properties"));
        this.setValue("datasetid", moduleDyn.get("datasetid"));
        if (root != null) {
            this.setValue(CATALOG, root.getLong("id"));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "catalog": {
                this.setCatalogQfilter(evt);
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        Long dynId = this.getModel().getDataEntity().getLong("id");
        this.loadPermClass(dynId);
        this.lockBaseInfo();
        if (!StringUtils.isEmpty((String)this.checkModulePerm())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ec4\u4ef6\u7684\u8bfb\u5199\u6743\u9650,\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"ModuleRepositityPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void loadPermClass(Long dynId) {
        DynamicObject permClassEntity = PermClassEntityHelper.getDiscPermissionClassEntity((String)"fidm_modulerepository", (Long)dynId, (Object)this.getDMModelId(), (String)FIDMMODEL, (String)this.getBizAppId());
        if (permClassEntity != null) {
            Long permClassId = permClassEntity.getLong("permclass.id");
            this.getModel().setValue(PERMCLASS, (Object)permClassId);
        }
    }

    private void lockBaseInfo() {
        String type = this.getModel().getDataEntity().getString("type");
        if (ModuleEnum.EB_REPORT_SECTION.getType().equalsIgnoreCase(type)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER});
            this.getView().setEnable(Boolean.FALSE, new String[]{NAME});
        } else {
            String comeFrom = this.getModel().getDataEntity().getString("comefrom");
            String bizAPPId = this.getBizAppId();
            this.getView().setEnable(Boolean.FALSE, new String[]{PERMCLASS});
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER});
            this.getView().setEnable(Boolean.FALSE, new String[]{NAME});
            this.getView().setEnable(Boolean.FALSE, new String[]{CATALOG});
            this.getView().setEnable(Boolean.FALSE, new String[]{DESCRIPTION});
            boolean isNeedShowTip = true;
            if (("1".equals(comeFrom) || "2".equals(comeFrom)) && AppCatalogTypeEnum.FIDM_CATALOG.getAppId().equals(bizAPPId)) {
                isNeedShowTip = false;
            }
            if ("3".equals(comeFrom) && AppCatalogTypeEnum.FAR_CATALOG.getAppId().equals(bizAPPId)) {
                isNeedShowTip = false;
            }
            if (!isNeedShowTip) {
                this.getView().setEnable(Boolean.TRUE, new String[]{PERMCLASS});
                this.getView().setEnable(Boolean.TRUE, new String[]{NUMBER});
                this.getView().setEnable(Boolean.TRUE, new String[]{NAME});
                this.getView().setEnable(Boolean.TRUE, new String[]{CATALOG});
                this.getView().setEnable(Boolean.TRUE, new String[]{DESCRIPTION});
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u5e94\u7528\u5efa\u7acb\u7ec4\u4ef6\uff0c\u8bf7\u5728\u7ec4\u4ef6\u6765\u6e90\u5e94\u7528\u4fee\u6539\u57fa\u672c\u4fe1\u606f\u3002", (String)"ModuleRepositityPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setCatalogQfilter(BeforeF7SelectEvent evt) {
        ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("model", "=", (Object)this.getDMModelId());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        qFilter.and("catalogtype", "in", Arrays.asList(ModuleServiceHelper.CATALOG_TYPE_VALUE));
        QFilter qFilter2 = new QFilter("catalogtype", "!=", (Object)"2");
        qFilter2.or(NUMBER, "!=", (Object)"root");
        qFilter.and(qFilter2);
        this.addModuleCataLogPermFilter(qFilter);
        fsp.getListFilterParameter().getQFilters().add(qFilter);
        fsp.getTreeFilterParameter().setQFilters(qFilters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            this.checkPerm(BTN_SAVE);
            if (!StringUtils.isEmpty((String)this.checkModulePerm())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ec4\u4ef6\u7684\u8bfb\u5199\u6743\u9650,\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"ModuleRepositityPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && isSuccess) {
            PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)"fidm_modulerepository", (Long)LongUtil.toLong(ids.get(0)), (Object)LongUtil.toLong((Object)this.getModelId()), (OperationStatus)status, (String)FIDMMODEL, (String)this.getBizAppId());
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity().getLong("id"));
            this.getView().close();
        }
    }

    private void addModuleCataLogPermFilter(QFilter catalogBuilder) {
        HashSet noPermsCataLog = new HashSet(16);
        noPermsCataLog.addAll(PermClassEntityHelper.getFIDMPermissionMap((String)"fidm_modulecatalog", (Long)this.getDMModelId(), (Long)this.getUserId()).get((Object)"1"));
        if (noPermsCataLog.size() != 0) {
            catalogBuilder.and(new QFilter("id", "not in", noPermsCataLog));
        }
    }
}

