/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.fidm.design.DisclosurePageJumpHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewSelectHelper;
import kd.epm.far.business.fidm.module.EBReportSectionHelper;
import kd.epm.far.business.fidm.task.DisclosureTaskHepler;
import kd.epm.far.business.fidm.task.dto.PreviewTaskInput;
import kd.epm.far.business.fidm.task.dto.PreviewTaskResult;
import kd.epm.far.common.common.MessageConstant;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.module.AbstractModuleTreePlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;

public class ModuleRepositoryListPlugin
extends AbstractModuleTreePlugin {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String SEARCHAP = "searchap";
    private static final String SEARCHMAPJSON = "searchMap";
    private static final String SEARCH_ALL = "all";
    private static final String SEARCH_NUMBER = "number";
    private static final String SEARCH_NAME = "name";
    private static final String FIELDNAME = "fieldName";
    private static final String VAL = "value";
    private static final String FOCUS_NODE_ID = "focusnodeid";
    private static final String TREE_CHECK_BOX = "treecheckbox";
    private static final String CATALOG_TYPE = "catalogtype";
    private static final String ENTITY_NAME = "fidm_modulerepository";
    private static final String CATALOG_ENTITY_NAME = "fidm_modulecatalog";
    private static final String MODULEID = "moduleid";
    private static final String ISMODULEONLYREAD = "isModelOnlyRead";
    private static final String CALLBACKID_DEL_CONFIRM = "callbackid_del_confirm";
    private static final int AnalysisApplyType = 16;

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addBeforePackageDataListener(this::setCatalogText);
        billList.addHyperClickListener(this::hyperLinkClick);
        Search se = (Search)this.getControl(SEARCHAP);
        se.addEnterListener(v -> {
            List searchFields = v.getSearchFields();
            HashMap searMap = new HashMap(12);
            if (searchFields != null) {
                for (Map searchField : searchFields) {
                    List fieldName = (List)searchField.get(FIELDNAME);
                    String key = null;
                    if (fieldName.size() >= 2) {
                        key = SEARCH_ALL;
                    } else if (SEARCH_NUMBER.equals(fieldName.get(0))) {
                        key = SEARCH_NUMBER;
                    } else if (SEARCH_NAME.equals(fieldName.get(0))) {
                        key = SEARCH_NAME;
                    }
                    if (Objects.isNull(key)) continue;
                    List value = (List)searchField.get(VAL);
                    searMap.put(key, value.get(0));
                }
            }
            this.getPageCache().put(SEARCHMAPJSON, SerializationUtils.toJsonString(searMap));
            billList.clearSelection();
            billList.refresh();
        });
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            parameter.setBillFormId(ENTITY_NAME);
        }
    }

    @Override
    protected String getRootName() {
        return ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u7c7b", (String)"ModuleRepositoryListPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected QFilter getCatalogTypeQFilter() {
        return new QFilter(CATALOG_TYPE, "in", Arrays.asList(ModuleServiceHelper.CATALOG_TYPE_VALUE));
    }

    @Override
    protected String getSelectFields() {
        return "id,name,number,parent,catalogtype";
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        ModelInfo model = this.getDiscModel();
        if (model == null) {
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return;
        }
        super.afterCreateNewData(e);
        Long dmModelId = this.getDMModelId();
        this.getModel().setValue("model", (Object)dmModelId);
        this.getPageCache().put("KEY_MODEL_ID", dmModelId.toString());
        this.addCatalogRoot(dmModelId);
        this.refreshBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        String key = e.getProperty().getName();
        if (key.equals(TREE_CHECK_BOX)) {
            this.refreshBillList();
        } else if (key.equals("model")) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
                return;
            }
            this.getPageCache().put("KEY_MODEL_ID", this.getDMModelId().toString());
            this.addCatalogRoot(this.getDMModelId());
            TreeView tree = (TreeView)this.getControl("catalog");
            tree.deleteAllNodes();
            this.initTree();
            this.refreshBillList();
        }
    }

    private void addCatalogRoot(Long dmModelId) {
        if (ModuleServiceHelper.addCatalogRoot((Long)dmModelId, (String)"1") != null) {
            this.refrushTree();
        }
        String modelType = new ModelStrategyEx(dmModelId).getModel().getModelInfo().getModelType();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(modelType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_sync"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_sync"});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "bar_delete": {
                this.actionDelete();
                break;
            }
            case "bar_enable": {
                this.setStatus(true);
                break;
            }
            case "bar_disable": {
                this.setStatus(false);
                break;
            }
            case "bar_preview": {
                DynamicObject[] tempObjs1 = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ModuleRepositoryListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                if (tempObjs1 == null) break;
                if (tempObjs1.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u201c\u7ec4\u4ef6\u201d\u3002", (String)"ModuleRepositoryListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.getBizAppId().equals("fidm")) {
                    DisclosurePreviewSelectHelper.openByModuleRepository((IFormPlugin)this, (IFormView)this.getView(), (Long)this.getDMModelId(), (Long)tempObjs1[0].getLong("id"));
                    break;
                }
                ModelInfo modelInfo = this.getDiscModel();
                if (Objects.isNull(modelInfo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u4f53\u7cfb\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"AnalysisDesignListPlugin_23", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    break;
                }
                String eventArgs = AnalysisServiceHelper.previewModule((AbstractFormPlugin)this, this.getDMModelId(), modelInfo.getId(), this.getView().getPageId(), tempObjs1[0].getLong("id"));
                if (!StringUtils.isNotEmpty((CharSequence)eventArgs)) break;
                AnalysisServiceHelper.openPreviewModuleView((AbstractFormPlugin)this, this.getDMModelId(), eventArgs, tempObjs1[0].getString("scope"));
                break;
            }
            case "bar_refresh": {
                this.refrushTree();
                this.refreshPermCache();
                this.refreshBillList();
                break;
            }
            case "publishapphome": {
                this.upgradeModuleRepository();
                break;
            }
            case "bar_sync": {
                this.checkPerm("btn_save");
                EBReportSectionHelper.sync((Long)this.getDMModelId());
                this.refreshBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb\u7684\u62a5\u8868\u5207\u7247\u540c\u6b65\u5b8c\u6bd5\u3002", (String)"ModuleRepositoryListPlugin_28", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void upgradeModuleRepository() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null) {
            if (selectedIds.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u5355\u4e2a\u7ec4\u4ef6\u53d1\u5e03\u5230\u9996\u9875\u3002", (String)"ModuleRepositoryListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(selectedIds.length);
            for (Object selectedId : selectedIds) {
                ids.add((Long)selectedId);
            }
            DynamicObject module = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)ENTITY_NAME);
            module.set("publishapphome", (Object)1);
            SaveServiceHelper.update((DynamicObject)module);
        }
    }

    private void refreshPermCache() {
        this.getPageCache().remove("readOnlyList");
        this.cacheTreeNodePerm(this.getPageCache().get(FOCUS_NODE_ID));
        this.controlButtonEnable(Boolean.TRUE);
    }

    private void actionDelete() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectedIds == null || selectedIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ModuleRepositoryListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ModuleRepositoryListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_DEL_CONFIRM, (IFormPlugin)this));
    }

    private void actionDeleteResult() {
        String msg = "";
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ArrayList<Long> ids = new ArrayList<Long>(2);
        ListSelectedRowCollection deletedRows = new ListSelectedRowCollection();
        for (ListSelectedRow row : billList.getSelectedRows()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY_NAME);
            if (dynamicObject == null) {
                msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ModuleRepositoryListPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]), row.getName());
                this.getView().showTipNotification(msg);
                continue;
            }
            msg = this.checkActionDelete(dynamicObject.getLong("id"));
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                continue;
            }
            ids.add(dynamicObject.getLong("id"));
            deletedRows.add((Object)row);
        }
        if (ids.size() > 0) {
            try {
                PlatUtil.executeWithTXNew(txhandle -> {
                    QFilter filter = new QFilter("id", "in", (Object)ids);
                    DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])filter.toArray());
                    QFilter permFilter = new QFilter("entityid", "in", (Object)ids);
                    permFilter.and(new QFilter("fidmmodel", "=", (Object)this.getModelId()));
                    DeleteServiceHelper.delete((String)"bcm_permclass_entity", (QFilter[])new QFilter[]{permFilter});
                });
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.DELETE, deletedRows);
                msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"ModuleRepositoryListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]), ids.size());
                this.getView().showSuccessNotification(msg);
            }
            catch (Exception e) {
                this.batchWriteOpLog(OperationResult.FAILURE, OperationName.DELETE, deletedRows);
                throw e;
            }
        }
        this.refreshBillList();
    }

    private String checkActionDelete(Long copyFromId) {
        String fcardid;
        DynamicObject pageCardConfigCollection;
        String msg = "";
        DynamicObject copyFrom = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id,number,status,name,catalog.id", (QFilter[])new QFilter("id", "=", (Object)copyFromId).toArray());
        if (copyFrom == null) {
            return msg;
        }
        String copyFromName = copyFrom.getString(SEARCH_NAME);
        if (!"0".equals(copyFrom.getString("status"))) {
            msg = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u201d%s\u201d\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ModuleRepositoryListPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]), copyFromName);
            return msg;
        }
        DynamicObject moduleandcardFrom = QueryServiceHelper.queryOne((String)"far_moduleandcard", (String)"card", (QFilter[])new QFilter("modulerepository", "=", (Object)copyFromId).toArray());
        if (moduleandcardFrom != null && (pageCardConfigCollection = QueryServiceHelper.queryOne((String)"bos_mainpagecardconfig", (String)"cardid", (QFilter[])new QFilter("cardid", "=", (Object)Long.parseLong(fcardid = moduleandcardFrom.getString("card"))).toArray())) != null) {
            msg = String.format(ResManager.loadKDString((String)"\u9996\u9875\u7ec4\u4ef6\u5361\u7247\u5173\u7cfb\u201d\u7684\u5b57\u6bb5\u201c\u7ec4\u4ef6\u5e93\u201d\u5f15\u7528\u4e86\u7ec4\u4ef6\u3010%s\u3011\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"ModuleRepositoryListPlugin_27", (String)"epm-far-formplugin", (Object[])new Object[0]), copyFromName);
            return msg;
        }
        return msg;
    }

    private void setStatus(boolean status) {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ModuleRepositoryListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (tempObjs != null) {
            for (DynamicObject tempObj : tempObjs) {
                tempObj.set("status", (Object)(status ? "1" : "0"));
            }
            try {
                SaveServiceHelper.save((DynamicObject[])tempObjs);
            }
            catch (Exception e) {
                OperationName opName = status ? OperationName.ENABLE : OperationName.DISABLE;
                this.batchWriteOpLog(OperationResult.FAILURE, opName, selectedRows);
                throw e;
            }
            if (status) {
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.ENABLE, selectedRows);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ModuleRepositoryListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else {
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.DISABLE, selectedRows);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ModuleRepositoryListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList();
        }
    }

    private Object[] getSelectedIds() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ModuleRepositoryListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return null;
        }
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "moduleEdit": {
                this.refreshBillList();
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportDesignPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "fidm_modulerepository": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportDesignPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "far_preview_config": {
                if (!Objects.nonNull(returnData)) break;
                Map returnInfo = (Map)ObjectSerialUtil.deSerializedBytes((String)String.valueOf(returnData));
                AnalysisServiceHelper.openPreviewModuleView((AbstractFormPlugin)this, this.getDMModelId(), (String)returnInfo.get("previewresult"), "2 ");
                break;
            }
            case "fidm_report_preview": {
                if (returnData == null) break;
                PreviewTaskInput previewTaskParam = (PreviewTaskInput)this.deSerializedBytes((String)returnData);
                if (previewTaskParam == null) {
                    return;
                }
                DisclosureTaskHepler.previewDispatch((IFormPlugin)this, (IFormView)this.getView(), (PreviewTaskInput)previewTaskParam);
                break;
            }
            case "task_preview_close_back": {
                PreviewTaskResult taskResult = DisclosureTaskHepler.getPreviewCallBackData((Object)returnData);
                if (taskResult == null) {
                    return;
                }
                if (!taskResult.success.booleanValue()) {
                    this.getView().showTipNotification(taskResult.message);
                    break;
                }
                ChapterPreviewResult previewResult = taskResult.getResult();
                if (previewResult == null) {
                    return;
                }
                DisclosurePageJumpHelper.preview((IFormView)this.getView(), (Long)this.getDMModelId(), (ChapterPreviewResult)previewResult);
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "callbackid_del_confirm": {
                if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.actionDeleteResult();
                break;
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return ENTITY_NAME;
    }

    @Override
    protected String getEntryEntity() {
        return ENTITY_NAME;
    }

    @Override
    protected void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = new QFilter("model", "=", (Object)this.getDiscModelId());
        this.getCatalogQFilter(filter);
        this.addPermClassFilter(filter);
        this.setSearchFields(filter);
        e.setCustomQFilters(Collections.singletonList(filter));
        e.setOrderBy("sequence asc,number asc");
    }

    private void addPermClassFilter(QFilter filter) {
        HashSet noPermId = new HashSet(16);
        noPermId.addAll(PermClassEntityHelper.getDiscPermissionMap((String)ENTITY_NAME, (Long)this.getModelId(), (Long)this.getUserId(), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"1"));
        filter.and(new QFilter("id", "not in", noPermId));
    }

    private void getCatalogQFilter(QFilter filter) {
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (nodeId != null) {
            QFilter qFilter1 = new QFilter("catalog", "=", (Object)LongUtil.toLong((Object)nodeId));
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(TREE_CHECK_BOX).toString());
            if (isallchild) {
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                ArrayList<String> list = new ArrayList<String>(16);
                this.queryAllChildNodeList(nodeId, treeList, list);
                if (list.size() > 0) {
                    qFilter1.or("catalog", "in", (Object)LongUtil.toLongList(list));
                }
            }
            filter.and(qFilter1);
        } else {
            filter.and(new QFilter("1", "!=", (Object)1));
        }
    }

    private void setCatalogText(BeforePackageDataEvent e) {
        String catalogText = ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u7c7b", (String)"ModuleRepositoryListPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]);
        for (DynamicObject object : e.getPageData()) {
            if (object.getDataEntityType().getProperties().contains((Object)"catalog") && "root".equalsIgnoreCase(object.getString("catalog.name"))) {
                object.set("catalog.name", (Object)catalogText);
            }
            String applytype = String.valueOf(1);
            if (!StringUtils.isEmpty((CharSequence)object.getString("applytype"))) {
                applytype = object.getString("applytype");
            }
            object.set("applytype", (Object)ModuleServiceHelper.getDisplayApplyType((String)applytype));
            if (StringUtils.isEmpty((CharSequence)object.getString("type")) || !ModuleServiceHelper.FARCOMBOITEM.contains(object.getString("type"))) continue;
            object.set("type", ModuleServiceHelper.FIDMCOMBOITEM.get(ModuleServiceHelper.FARCOMBOITEM.indexOf(object.getString("type"))));
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() > 0 && !"true".equalsIgnoreCase(this.getPageCache().get("treenodeperm"))) {
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            String moduleSelectField = "id,catalog";
            QFBuilder moduleFilter = new QFBuilder();
            moduleFilter.add("id", "in", (Object)selectNodeIds);
            DynamicObject[] modules = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)moduleSelectField, (QFilter[])moduleFilter.toArray());
            HashSet<String> cataLogIds = new HashSet<String>(modules.length);
            for (DynamicObject module : modules) {
                String cataLogId = module.getString("catalog.id");
                cataLogIds.add(cataLogId);
            }
            boolean isCatalogOnlyRead = this.isNodeReadOnly(cataLogIds);
            if (isCatalogOnlyRead) {
                this.controlButtonEnable(Boolean.FALSE);
            } else {
                ArrayList readOnlyPerms = new ArrayList();
                readOnlyPerms.addAll(PermClassEntityHelper.getDiscPermissionMap((String)ENTITY_NAME, (Long)this.getModelId(), (Long)this.getUserId(), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"2"));
                this.controlButtonEnable(Boolean.TRUE);
                for (DynamicObject module : modules) {
                    Long moduleId = module.getLong("id");
                    if (!readOnlyPerms.contains(moduleId)) continue;
                    this.controlButtonEnable(Boolean.FALSE);
                    break;
                }
            }
        } else if (billList.getSelectedRows().size() != 0 && "true".equalsIgnoreCase(this.getPageCache().get("treenodeperm"))) {
            this.controlButtonEnable(Boolean.FALSE);
        } else if (billList.getSelectedRows().size() == 0) {
            this.controlButtonEnable(Boolean.TRUE);
        }
    }

    @Override
    public void checkPerm(String opkey) {
        if ((opkey.equals("btn_addnew") || opkey.equals("btn_modify") || opkey.equals("btn_delete") || opkey.equals("btn_up") || opkey.equals("btn_down")) && this.getPageCache().get("categoryReadOnly") != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ModuleRepositoryListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        super.checkPerm(opkey);
    }

    @Override
    protected String getCatalogEntryEntity() {
        return CATALOG_ENTITY_NAME;
    }

    private void setSearchFields(QFilter qFilter) {
        String searchMap = this.getPageCache().get(SEARCHMAPJSON);
        Map searchFileds = null;
        if (searchMap != null) {
            searchFileds = (Map)SerializationUtils.fromJsonString((String)searchMap, Map.class);
        }
        if (searchFileds != null && !searchFileds.isEmpty()) {
            String all = (String)searchFileds.get(SEARCH_ALL);
            String number = (String)searchFileds.get(SEARCH_NUMBER);
            String name = (String)searchFileds.get(SEARCH_NAME);
            if (all != null) {
                QFilter qFilter1 = new QFilter(SEARCH_NUMBER, "like", (Object)this.getSearchTextField(all));
                QFilter qFilter2 = new QFilter(SEARCH_NAME, "like", (Object)this.getSearchTextField(all));
                QFilter or = qFilter1.or(qFilter2);
                qFilter.and(or);
            } else if (number != null) {
                QFilter qFilter1 = new QFilter(SEARCH_NUMBER, "like", (Object)this.getSearchTextField(number));
                qFilter.and(qFilter1);
            } else if (name != null) {
                QFilter qFilter1 = new QFilter(SEARCH_NAME, "like", (Object)this.getSearchTextField(name));
                qFilter.and(qFilter1);
            }
        }
    }

    private String getSearchTextField(String tx) {
        return "%" + tx + "%";
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        if (arg.getFieldName().equals(SEARCH_NUMBER)) {
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)arg).getCurrentRow();
            this.showModuleEdit((Long)currentRow.getPrimaryKeyValue());
        }
    }

    private void showModuleEdit(Long moduleId) {
        BaseShowParameter bs = new BaseShowParameter();
        bs.setFormId(ENTITY_NAME);
        bs.getOpenStyle().setShowType(ShowType.Modal);
        bs.setCustomParam(MODULEID, (Object)moduleId);
        bs.setCustomParam(ISMODULEONLYREAD, (Object)this.getHyperLinkSelectModulePerm(moduleId));
        bs.setPkId((Object)moduleId);
        bs.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)bs);
        bs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "moduleEdit"));
        this.getView().showForm((FormShowParameter)bs);
    }

    private String getHyperLinkSelectModulePerm(Long moduleId) {
        DynamicObject module = BusinessDataServiceHelper.loadSingleFromCache((Object)moduleId, (String)ENTITY_NAME);
        Boolean isCataLogOnlyRead = this.isNodeReadOnly(module.getString("catalog.id"));
        String perm = PermClassEntityHelper.getSingleDiscPermission((String)ENTITY_NAME, (Long)moduleId, (Long)this.getModelId(), (Long)this.getUserId(), (String)"fidmmodel", (String)this.getView().getFormShowParameter().getAppId());
        if ("2".equalsIgnoreCase(perm) || isCataLogOnlyRead.booleanValue()) {
            return "true";
        }
        return "false";
    }

    private void batchWriteOpLog(OperationResult result, OperationName opName, ListSelectedRowCollection selectedRows) {
        super.batchWriteOpLogRows(OperationCategory.COMPONENT_GALLERY, opName, result, "fidm_modulerepositorylist", selectedRows);
    }
}

