/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.other;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.other.GeneralCopyHepler;
import kd.epm.far.business.common.other.dto.CopyFormParam;
import kd.epm.far.business.common.other.dto.CopyFormResult;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogUtil;
import kd.epm.far.common.common.log.oplog.OperationResult;

public class DisclosureDataCopyPlugin
extends AbstractFormPlugin {
    private static final String COPY_LOG = "COPY_LOG";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        CopyFormParam input = this.getFormInputParam();
        if (StringUtils.isNotEmpty((String)input.getInitNumber())) {
            this.getModel().setValue("number", (Object)input.getInitNumber());
        }
        if (StringUtils.isNotEmpty((String)input.getInitName())) {
            this.getModel().setValue("name", (Object)input.getInitName());
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                AnalysisOpLogParam logParam = AnalysisOpLogUtil.getLogParamFromView((IFormView)this.getView().getParentView(), (String)COPY_LOG);
                if (this.Save()) {
                    logParam.buildOpResult(OperationResult.SUCCESS);
                } else {
                    logParam.buildOpResult(OperationResult.FAILURE);
                }
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
                break;
            }
        }
    }

    private boolean Save() {
        String newNumber = this.getModel().getValue("number").toString();
        String newName = this.getModel().getValue("name").toString();
        try {
            CopyFormParam input = this.getFormInputParam();
            CopyFormResult result = GeneralCopyHepler.copyData((CopyFormParam)input, (String)newNumber, (String)newName);
            if (result != null) {
                this.getView().returnDataToParent((Object)JSON.toJSONString((Object)result));
                this.getView().close();
                return true;
            }
        }
        catch (KDBizException bizEx) {
            this.getView().showTipNotification(bizEx.getMessage());
        }
        return false;
    }

    private CopyFormParam getFormInputParam() {
        return (CopyFormParam)DisclosureFormHelper.getFormInputParam((IFormView)this.getView(), CopyFormParam.class, (Boolean)true);
    }
}

