/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.other;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.util.StringUtils;
import kd.bos.web.DispatchServiceHelper;
import org.apache.commons.beanutils.MethodUtils;

public class ShowVersionViewPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("query".equals(evt.getItemKey())) {
            String appId = this.getOrDefault("appid", "epm");
            String jarname = this.getOrDefault("jarname", "epm-far-formplugin");
            String jarInfo = this.getJarInfo(jarname);
            if (StringUtils.isEmpty((String)jarInfo) || jarInfo.length() < 20) {
                jarInfo = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"DebugMetadataService", (String)"getJarInfo", (Object[])new Object[]{jarname});
            }
            if (!StringUtils.isEmpty((String)jarInfo)) {
                List<String> commitId = Arrays.asList("Manifest-Version:", "BuildNum:", "ProjectName:", "CloudName:", "UserName:", "BuildTool:", "CommitId:", "Branch:", "Release:", "BuildImage:", "AppName:", "jarId:", "Builddate:", "BuildJDK:");
                for (String s : commitId) {
                    jarInfo = this.formatVersion(jarInfo, s);
                }
            }
            this.getView().getModel().setValue("version", (Object)(StringUtils.isEmpty((String)jarInfo) ? "no message" : jarInfo));
        }
    }

    private String getJarInfo(String jarname) {
        String ret;
        block17: {
            ret = null;
            try {
                String[] jarArray;
                String findJarname = null;
                Object jars = MethodUtils.invokeStaticMethod(Class.forName("java.lang.".concat("System")), (String)"getProperty", (Object[])new Object[]{"java.class.path"}, (Class[])new Class[]{String.class});
                Object spit = MethodUtils.invokeStaticMethod(Class.forName("java.lang.".concat("System")), (String)"getProperty", (Object[])new Object[]{"path.separator"}, (Class[])new Class[]{String.class});
                String[] var7 = jarArray = jars.toString().split(spit.toString());
                int var8 = jarArray.length;
                for (int var9 = 0; var9 < var8; ++var9) {
                    String jarFileName = var7[var9];
                    if (!jarFileName.contains(jarname)) continue;
                    findJarname = jarFileName;
                    break;
                }
                if (jarname == null || findJarname == null) break block17;
                Class<?> jarFileClass = Class.forName("java.util.jar.".concat("JarFile"));
                Constructor<?> constructor = jarFileClass.getConstructor(String.class);
                try (Object o = constructor.newInstance(findJarname);){
                    Enumeration<JarEntry> jarEntrys = ((JarFile)o).entries();
                    while (jarEntrys.hasMoreElements()) {
                        JarEntry jarEntry = jarEntrys.nextElement();
                        if (jarEntry.isDirectory() || !"META-INF/MANIFEST.MF".equals(jarEntry.getName())) continue;
                        InputStream in = ((JarFile)o).getInputStream(jarEntry);
                        BufferedReader br = new BufferedReader(new InputStreamReader(in));
                        String s = "";
                        StringBuilder sb = new StringBuilder();
                        while ((s = br.readLine()) != null) {
                            sb.append(s);
                        }
                        sb.append("<br>").append("p:").append(findJarname.replaceAll("\\\\", "**")).append("<br>");
                        ret = sb.toString();
                        break;
                    }
                }
            }
            catch (Exception var25) {
                throw new KDBizException(var25.getMessage());
            }
        }
        return Instance.getAppName() + ":" + ret;
    }

    private String formatVersion(String jarInfo, String field) {
        return jarInfo.replace(field, "\n" + field);
    }

    public String getOrDefault(String name, String defaultValue) {
        Object o = this.getView().getModel().getValue(name);
        return Objects.nonNull(o) ? o.toString() : defaultValue;
    }
}

