/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.perm;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.business.export.strategy.ExportExecuteStrategyContext;
import kd.epm.far.business.common.business.export.strategy.IExport;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.perm.FIDMAuthExportStrategy;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseListPlugin;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;
import org.apache.commons.collections.CollectionUtils;

public class DmDataAuthMainPagePlugin
extends AbstractBaseDMListPlugin {
    private static final String BAR_REFRESH = "bar_refresh";
    private static final String BAR_DEL = "bar_del";
    private static final String BAR_NEW = "bar_new";
    private static final String BAR_BATCH = "bar_batch";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_UNION = "bar_union";
    private static final String ENTRYENTITY = "entryentity";
    private static final String AUTH_NEW = "47156aff000000ac";
    private static final String AUTH_SAVE = "0=KX5+QVF5+R";
    private static final String BAR_IMPORT = "bar_import";
    private static final String BAR_EXPORT = "bar_export";
    private static final String ROW_SELECT_CACHE = "rowEditing";
    private static final String BAR_EXIT_CONFIRM = "bar_exit_confirm";
    private static final String EXIT_FLAG = "exit_flag";
    private static final String SAVE = "save";
    private static final String Exit = "exit";
    private static final String MODELTYPE = "modeltype";
    private static final String BATCH_MOPERM = "batch_noperm";
    private static final String BATCH_READONLY = "batch_readonly";
    private static final String BATCH_READWRITE = "batch_readwrite";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String MODEL = "model";
    private static final String ID = "id";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DmDataAuthMainPagePlugin.class);

    @Override
    public void initialize() {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        if (Objects.equals(beforeF7SelectEvent.getProperty().getName(), this.getModelSign())) {
            List qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (Objects.isNull(qFilterList)) {
                qFilterList = Lists.newArrayListWithExpectedSize((int)16);
            }
            qFilterList.add(new QFilter(ID, "in", (Object)MemberPermHelper.getDisModelAdmin((String)this.getView().getFormShowParameter().getAppId())));
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getUserSelect();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ID});
        ApplicationTypeEnum application = ApplicationTypeEnum.getEnumByNumber((String)this.getBizAppId());
        Set disModelAdmin = MemberPermHelper.getDisModelAdmin((String)application.getAppnum());
        if (modelId == null || CollectionUtils.isEmpty((Collection)disModelAdmin) || !disModelAdmin.contains(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"DmDataAuthMainPagePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(MODEL, null);
            return;
        }
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getPageCache().put("dmmodelid", String.valueOf(modelId));
        this.buildEntry();
        this.getPageCache().put(ROW_SELECT_CACHE, "");
        this.getPageCache().put(EXIT_FLAG, "");
    }

    private void buildPage() {
    }

    private void buildEntry() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        QFBuilder modelFilter = new QFBuilder();
        Long modelId = this.getDMModelId();
        modelFilter.add(new QFilter(FIDMMODEL, "=", (Object)modelId));
        modelFilter.add(new QFilter("authclass.app", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        String selectFields = "id,users,username,usertype,data_auth,authclass.number";
        DynamicObjectCollection authInfo = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])modelFilter.toArray(), (String)ID);
        if (CollectionUtils.isEmpty((Collection)authInfo)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, authInfo.size());
        for (int i = 0; i < authInfo.size(); ++i) {
            this.getModel().setValue(ID, ((DynamicObject)authInfo.get(i)).get(ID), i);
            this.getModel().setValue("user", ((DynamicObject)authInfo.get(i)).get("username"), i);
            this.getModel().setValue("auth_class", ((DynamicObject)authInfo.get(i)).get("authclass.number"), i);
            this.getModel().setValue("data_auth", ((DynamicObject)authInfo.get(i)).get("data_auth"), i);
            if ("bos_user".equals(((DynamicObject)authInfo.get(i)).get("usertype"))) {
                this.getModel().setValue("usertype", (Object)ResManager.loadKDString((String)"\u7528\u6237", (String)"DataAuthMainPagePlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]), i);
                continue;
            }
            this.getModel().setValue("usertype", (Object)ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"DataAuthMainPagePlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]), i);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (this.getValue(MODEL) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"DmDataAuthMainPagePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "bar_refresh": {
                this.refreshBillList();
                break;
            }
            case "bar_new": {
                this.openNewPage();
                break;
            }
            case "bar_save": {
                this.actionSaveOrExit(SAVE);
                break;
            }
            case "bar_export": {
                EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
                if (entryentity.getEntryData().getDataEntitys().length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5f15\u51fa", (String)"DmDataAuthMainPagePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.exportDatas();
                break;
            }
            case "bar_import": {
                this.importDatas();
                break;
            }
            case "bar_del": {
                this.del();
                break;
            }
            case "batch_noperm": {
                this.batchUpdatePerm("1");
                break;
            }
            case "batch_readonly": {
                this.batchUpdatePerm("2");
                break;
            }
            case "batch_readwrite": {
                this.batchUpdatePerm("3");
                break;
            }
        }
    }

    private void refreshBillList() {
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryentity.clearEntryState();
        this.buildEntry();
    }

    void openNewPage() {
        Long modelId = this.getOriModelId();
        Long dmModelId = this.getDMModelId();
        String modeltype = this.getModelType();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_data_auth_new");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL, (Object)modelId);
        showParameter.setCustomParam(FIDMMODEL, (Object)dmModelId);
        showParameter.setCustomParam(MODELTYPE, (Object)modeltype);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm(showParameter);
    }

    private void actionSaveOrExit(String operationType) {
        DynamicObjectCollection data;
        boolean isSave = true;
        if (StringUtils.equals((CharSequence)Exit, (CharSequence)operationType)) {
            isSave = false;
        }
        if ((data = this.getModel().getEntryEntity(ENTRYENTITY)).size() == 0) {
            return;
        }
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject authData = (DynamicObject)data.get(i);
            long id = authData.getLong(ID);
            QFilter qfilter = new QFilter(ID, "=", (Object)id);
            boolean exists = QueryServiceHelper.exists((String)"bcm_auth_info", (QFilter[])new QFilter[]{qfilter});
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u8bb0\u5f55\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0", (String)"DataAuthAddPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject updateObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_auth_info");
            updateObject.set("data_auth", (Object)authData.getLong("data_auth"));
            dataList.add(updateObject);
        }
        if (isSave) {
            try {
                this.getPageCache().put(ROW_SELECT_CACHE, "");
                SaveServiceHelper.update((DynamicObject[])dataList.toArray(new DynamicObject[0]));
            }
            catch (KDException e) {
                AbstractBaseListPlugin.log.error((Throwable)e);
            }
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAuthMainPagePlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void batchUpdatePerm(String perm) {
        DynamicObject[] updateObjectList;
        List<Long> selectRowsId = this.getSelectRowsId();
        if (selectRowsId.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6279\u91cf\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"DataAuthMainPagePlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectField = "usertype,username,authclass,data_auth";
        QFBuilder qfBuilder = new QFBuilder(ID, "in", selectRowsId);
        for (DynamicObject updateObject : updateObjectList = BusinessDataServiceHelper.load((String)"bcm_auth_info", (String)selectField, (QFilter[])qfBuilder.toArray())) {
            updateObject.set("data_auth", (Object)perm);
        }
        SaveServiceHelper.update((DynamicObject[])updateObjectList);
        this.refreshBillList();
    }

    List<Long> getSelectRowsId() {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        DynamicObjectCollection data = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < selectRows.length; ++i) {
            int index = selectRows[i];
            if (index >= data.size()) continue;
            long id = ((DynamicObject)data.get(index)).getLong(ID);
            ids.add(id);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDatas() {
        String preEntityNameImp = "fidm_auth_import_IMPT";
        QFilter qFilter = new QFilter("number", "=", (Object)preEntityNameImp);
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (pkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u5e94\u7528-\u5f15\u5165\u5f15\u51fa\u201d\u9884\u5236\u5bfc\u51fa\u6a21\u677f\u3002", (String)"DataAuthMainPagePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        AnalysisOpLogParam logParam = this.getSingleLogParam().buildOpName(OperationName.EXPORT);
        try {
            long modelId = this.getDMModelId();
            FormView view = (FormView)this.getView();
            String entityName = "bcm_auth_import";
            String appId = view.getFormShowParameter().getServiceAppId();
            HashMap<String, Object> exportDataParms = new HashMap<String, Object>(16);
            exportDataParms.put("modelId", modelId);
            exportDataParms.put("app", this.getView().getFormShowParameter().getAppId());
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectIndexs = entryGrid.getSelectRows();
            if (selectIndexs != null && selectIndexs.length > 0) {
                int pageRow = entryGrid.getPageRow();
                DynamicObject[] dataEntities = entryGrid.getEntryData().getDataEntitys();
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
                for (int row : selectIndexs) {
                    int cur = row % pageRow;
                    ids.add(dataEntities[cur].getLong(ID));
                }
                exportDataParms.put("idList", ids);
            }
            ExportExecuteStrategyContext exportExecuteStrategyContext = new ExportExecuteStrategyContext();
            exportExecuteStrategyContext.setExport((IExport)new FIDMAuthExportStrategy());
            String url = exportExecuteStrategyContext.export(appId, ((Long)pkIds.get(0)).longValue(), entityName, entityName, exportDataParms);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getClientViewProxy().addAction("download", (Object)url);
            }
            logParam.buildOpResult(OperationResult.SUCCESS);
        }
        catch (IOException e) {
            logParam.buildOpResult(OperationResult.FAILURE);
            logger.error((Throwable)e);
        }
        finally {
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
    }

    private void importDatas() {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importdataback");
        ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
        String listName = ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u5217\u8868", (String)"DmDataAuthMainPagePlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]);
        AbsCommonImport.invokeOperation("bcm_auth_import", "kd.epm.far.formplugin.common.perm.FidmDataAuthMainImport", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
    }

    private void del() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"DmDataAuthMainPagePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u884c\u5417\uff1f", (String)"DmDataAuthMainPagePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("del_confirm", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callId = messageBoxClosedEvent.getCallBackId();
        String name = messageBoxClosedEvent.getResultValue();
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)this.getDMModelId())});
        if ("del_confirm".equals(callId) && MessageBoxResult.Yes.name().equals(name)) {
            List<Long> selectRowsId = this.getSelectRowsId();
            if (null == selectRowsId || selectRowsId.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e", (String)"DataAuthMainPagePlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter(ID, "in", selectRowsId);
            DynamicObjectCollection delObjs = QueryServiceHelper.query((String)"bcm_auth_info", (String)"username,usertype,authclass.number,data_auth,users", (QFilter[])new QFilter[]{qFilter});
            try {
                Collection delDy = BusinessDataServiceHelper.loadFromCache((String)"bcm_auth_info", (QFilter[])new QFilter[]{qFilter}).values();
                DeleteServiceHelper.delete((String)"bcm_auth_info", (QFilter[])new QFilter[]{qFilter});
            }
            catch (KDException e) {
                AbstractBaseListPlugin.log.error((Throwable)e);
            }
            try {
                String usertype = "";
                String username = "";
                String authnumber = "";
                if (delObjs != null && delObjs.size() > 0) {
                    for (DynamicObject dy : delObjs) {
                        usertype = dy.getString("usertype");
                        username = dy.getString("username");
                        authnumber = dy.getString("authclass.number");
                        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.DATA_PERM).buildFormNumber("fidm_auth").buildAppId(this.getView()).buildOpName(OperationName.DELETE).buildOpResult(OperationResult.SUCCESS);
                        if (StringUtils.equals((CharSequence)usertype, (CharSequence)"bos_user")) {
                            logParam.buildFormatParams(new Object[]{model.getString("number"), TypeUtils.toPinYinString((String)username), TypeUtils.toPinYinString((String)authnumber)});
                            logParam.buildOpName(OperationName.DELETE_USER);
                            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
                        }
                        if (!StringUtils.equals((CharSequence)usertype, (CharSequence)"bos_usergroup")) continue;
                        logParam.buildOpName(OperationName.DELETE_USERGROUP);
                        logParam.buildFormatParams(new Object[]{model.getString("number"), TypeUtils.toPinYinString((String)username), TypeUtils.toPinYinString((String)authnumber)});
                        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
                    }
                }
            }
            catch (Exception e) {
                logger.error("save log error", (Throwable)e);
            }
            this.refreshBillList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataAuthMainPagePlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)BAR_EXIT_CONFIRM, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put(ROW_SELECT_CACHE, "");
            this.getPageCache().put(EXIT_FLAG, "1");
            this.getView().close();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals("batch")) {
            Object returnData = this.getView().getReturnData();
            if (null != returnData) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c\u6210\u529f\u3002", (String)"DataAuthMainPagePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList();
        } else if (closedCallBackEvent.getActionId().equals("close")) {
            this.refreshBillList();
        }
        if (closedCallBackEvent.getActionId().equals("IMPORT_CLOSE")) {
            this.refreshBillList();
        }
    }

    private Long getOriModelId() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (modelId != null) {
            return LongUtil.toLong((Object)modelId);
        }
        Long dmmodelId = this.getDiscModelId();
        if (LongUtil.isvalidLong((Object)dmmodelId)) {
            this.getPageCache().put("KEY_MODEL_ID", dmmodelId.toString());
        }
        return dmmodelId;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            this.refreshBillList();
        }
    }

    private String getModelType() {
        String modelType = this.getPageCache().get(MODELTYPE);
        if (modelType != null) {
            return modelType;
        }
        Long modelId = this.getDMModelId();
        DynamicObject dmmodel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"fidm_model");
        modelType = dmmodel.getString(MODELTYPE);
        this.getPageCache().put(MODELTYPE, modelType);
        return modelType;
    }

    private AnalysisOpLogParam getSingleLogParam() {
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)this.getDMModelId())});
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.DATA_PERM).buildFormNumber("fidm_auth").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString("number")});
    }
}

