/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.perm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseListPlugin;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;
import kd.epm.far.formplugin.common.util.BcmBasePluginUtil;

public class FIDMPermissionClassList
extends AbstractBaseDMListPlugin {
    private static final String BUTTON_ADD = "btn_add";
    private static final String BUTTON_DELETE = "btn_delete";
    private static final String BUTTON_REFRESH = "btn_refresh";
    private static final String ENTITY_NAME = "bcm_permissionclass";
    private static final String MODELTYPE = "modeltype";
    private static final String BILLLISTAP = "billlistap";
    private static final String FORCE_DELETE = "forceDelete";
    private static final String SUCCESS = "success";
    private static final String BUTTON_EXPORT = "btn_export";
    private static final String BUTTON_IMPORT = "btn_import";
    private static final String Model = "model";
    private static final String FIDMMODEL = "fidmmodel";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getUserSelect();
        if (modelId == null || modelId == 0L) {
            return;
        }
        this.getModel().setValue(Model, (Object)modelId);
        this.getPageCache().put("dmmodelid", String.valueOf(modelId));
        this.refreshBillList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Long modelId = this.getDMModelId();
        if (modelId == null || modelId.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "btn_add": {
                BaseShowParameter bs = this.getBaseShowParameter(ENTITY_NAME);
                bs.setStatus(OperationStatus.ADDNEW);
                this.getView().showForm((FormShowParameter)bs);
                break;
            }
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
            case "btn_delete": {
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u64cd\u4f5c\u884c\u3002", (String)"PermissionClassFormPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectedRows.size() <= 0) break;
                ConfirmCallBackListener confirm = new ConfirmCallBackListener(FORCE_DELETE, (IFormPlugin)this);
                String tip = "";
                tip = selectedRows.size() == 1 ? ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u8be5\u6743\u9650\u7c7b\u5417\uff1f", (String)"PermissionClassFormPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u591a\u4e2a\u6743\u9650\u7c7b\u5417\uff1f", (String)"PermissionClassFormPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(tip, MessageBoxOptions.YesNo, confirm);
                break;
            }
            case "btn_import": {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importdataback");
                ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
                String listName = ResManager.loadKDString((String)"\u6743\u9650\u7c7b", (String)"PermissionClassFormPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]);
                AbsCommonImport.invokeOperation(ENTITY_NAME, "kd.epm.far.formplugin.common.perm.FidmPermissionClassImport", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
                break;
            }
            case "btn_export": {
                AnalysisOpLogParam logParam = this.getSingleLogParam().buildOpName(OperationName.EXPORT);
                try {
                    QFBuilder filter = new QFBuilder();
                    filter.add(new QFilter(FIDMMODEL, "=", (Object)modelId));
                    filter.add(new QFilter("app", "=", (Object)this.getView().getFormShowParameter().getAppId()));
                    BillList list = (BillList)this.getView().getControl(BILLLISTAP);
                    if (list.getSelectedRows().size() != 0) {
                        ListSelectedRowCollection rows = list.getSelectedRows();
                        ArrayList<Object> ids = new ArrayList<Object>();
                        for (ListSelectedRow row : rows) {
                            ids.add(row.getPrimaryKeyValue());
                        }
                        filter.add("id", "in", ids);
                    }
                    this.exportData(list.getBillFormId(), filter.toArray(), ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u5217\u8868\u5bfc\u51fa", (String)"PermissionClassFormPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    logParam.buildOpResult(OperationResult.SUCCESS);
                    break;
                }
                catch (Exception e) {
                    logParam.buildOpResult(OperationResult.FAILURE);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1a%s", (String)"PermissionClassFormPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]), e.getMessage()));
                    break;
                }
                finally {
                    AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
                }
            }
        }
    }

    private BaseShowParameter getBaseShowParameter(String entityName) {
        Long modelId = this.getOriModelId();
        BaseShowParameter bs = new BaseShowParameter();
        bs.setFormId(entityName);
        bs.getOpenStyle().setShowType(ShowType.Modal);
        bs.setCustomParam(this.getModelSign(), (Object)modelId);
        Long dmModelId = this.getDMModelId();
        bs.setCustomParam(FIDMMODEL, (Object)dmModelId);
        bs.setCustomParam(MODELTYPE, (Object)this.getModelType());
        bs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BUTTON_REFRESH));
        return bs;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (Model.equals(key)) {
            this.refreshBillList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        if (FORCE_DELETE.equals(mbce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            Long modelId = this.getDMModelId();
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ArrayList<Long> list = new ArrayList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                list.add((Long)selectedRow.getPrimaryKeyValue());
            }
            if (PermClassEntityHelper.checkDistribute(list, (Long)modelId, (String)FIDMMODEL) || PermClassEntityHelper.checkIsItReferenced(list, (Long)modelId, (String)FIDMMODEL)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u5df2\u88ab\u5f15\u7528\u4e0d\u80fd\u5220\u9664\u3002", (String)"PermissionClassFormPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("id", "in", list);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,number", (QFilter[])new QFilter[]{qFilter});
            OperationResult result = OperationResult.SUCCESS;
            try {
                DeleteServiceHelper.delete((IDataEntityType)billList.getEntityType(), (Object[])list.toArray());
            }
            catch (KDException e) {
                result = OperationResult.FAILURE;
                AbstractBaseListPlugin.log.error((Throwable)e);
            }
            try {
                for (DynamicObject dy : dys) {
                    AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.PERM_CLASS).buildFormNumber("fidm_permclass_list").buildAppId(this.getView()).buildFormatParams(new Object[]{dy.getString("number")});
                    logParam.buildOpName(OperationName.DELETE);
                    logParam.buildOpResult(result);
                    AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
                }
            }
            catch (Exception e) {
                log.error("save log error", (Throwable)e);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PermissionClassFormPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object data = closedCallBackEvent.getReturnData();
        if (data instanceof String) {
            String status = (String)data;
            if (BUTTON_REFRESH.equals(closedCallBackEvent.getActionId()) && SUCCESS.equals(status)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PermissionClassFormPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.refreshBillList();
            }
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.getEntryState().setSortInfo("id");
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        Long modelId = this.getDMModelId();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (LongUtil.isvalidLong((Object)modelId)) {
            e.getQFilters().add(new QFilter(FIDMMODEL, "=", (Object)modelId));
            e.getQFilters().add(new QFilter("app", "=", (Object)appId));
        } else {
            e.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
    }

    private Long getOriModelId() {
        ModelInfo discModel = this.getDiscModel();
        if (discModel != null) {
            return discModel.getModelId();
        }
        return 0L;
    }

    private String getModelType() {
        String modelType = this.getPageCache().get(MODELTYPE);
        if (modelType != null) {
            return modelType;
        }
        Long modelId = this.getDMModelId();
        DynamicObject dmmodel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"fidm_model");
        modelType = dmmodel.getString(MODELTYPE);
        this.getPageCache().put(MODELTYPE, modelType);
        return modelType;
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        int is;
        args.setCancel(true);
        if (!MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId())) && (is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), "4715a0df000000ac")) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"PermissionClassFormPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        BillList list = (BillList)this.getControl(BILLLISTAP);
        BaseShowParameter bs = this.getBaseShowParameter(list.getBillFormId());
        bs.setPkId(list.getFocusRowPkId());
        bs.setStatus(OperationStatus.EDIT);
        bs.setCustomParam("edit", (Object)"edit");
        this.getView().showForm((FormShowParameter)bs);
    }

    private AnalysisOpLogParam getSingleLogParam() {
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.PERM_CLASS).buildFormNumber("fidm_permclass_list").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString("number")});
    }
}

