/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.perm;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.Operations;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.ImportStartPlugin;
import org.apache.commons.lang.StringUtils;

public class FidmBatchImportStartPlugin
extends ImportStartPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile", "btnpreview"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnpreview"});
    }

    public void click(EventObject evt) {
        String eventKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(eventKey)) {
            this.importData(false);
        } else if ("btnpreview".equalsIgnoreCase(eventKey)) {
            this.importData(true);
        } else {
            super.click(evt);
        }
    }

    private void importData(boolean isDryRun) {
        String url = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((String)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c", (String)"ImportStartPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!Objects.equals("new", this.getModel().getValue("importtype")) && Objects.isNull(this.getModel().getValue("keyfields"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u89c4\u5219", (String)"ImportStartPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.importData(url, isDryRun);
    }

    private void importData(String url, boolean isDryRun) {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        String billFormId = (String)showParam.getCustomParam("BillFormId");
        String listName = (String)showParam.getCustomParam("ListName");
        String serviceAppId = view.getFormShowParameter().getServiceAppId();
        String checkRightAppId = (String)showParam.getCustomParam("CheckRightAppId");
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fidm_importing");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String importType = (String)this.getModel().getValue("importtype");
        params.put("Type", importType);
        if (!Objects.equals("new", importType)) {
            params.put("KeyFields", this.getModel().getValue("keyfields"));
        }
        params.put("IsDryRunPattern", isDryRun);
        params.put("ServiceAppId", serviceAppId);
        params.put("CheckRightAppId", checkRightAppId);
        params.put("RealPermissionEntityId", showParam.getCustomParam("RealPermissionEntityId"));
        params.put("BillFormId", billFormId);
        params.put("ListName", listName);
        params.put("OpSave", ops.getSave());
        params.put("Url", url);
        params.put("ImportPlugin", this.getImportPlugin(showParam));
        params.put("BcmModelId", showParam.getCustomParam("modelid"));
        String who = (String)showParam.getCustomParam("fromUserDefinedPropertyImport");
        if (StringUtils.isNotEmpty((String)who)) {
            params.put("fromUserDefinedPropertyImport", "userDefinedPropertyImport");
        }
        params.put("OperateKey", showParam.getCustomParam("OperateKey"));
        showParameter.setCustomParams(params);
        showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        showParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        view.showForm(showParameter);
    }

    private String getImportPlugin(FormShowParameter showParam) {
        List plugins;
        String pluginName = (String)showParam.getCustomParam("ImportPlugin");
        if (StringUtils.isBlank((String)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                return (String)p.get("ClassName");
            }
        }
        return pluginName;
    }
}

