/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.perm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.Callable;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.plugin.ImportingPlugin;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class FidmBatchImportingPlugin
extends ImportingPlugin {
    private static final Log log = LogFactory.getLog(ImportingPlugin.class);
    public static final String OPTION_KEY_IMPORTING_VIEW = "dimension_manager_view";
    public static final String OPTION_KEY_IMPORT_MODEL_ID = "BcmModelId";
    public static final String OPTION_KEY_IMPORT_DIMENSION_ID = "BcmDimensionId";
    public static final String KEY_IS_DRYRUN_PATTERN = "IsDryRunPattern";
    public static final String CACHE_KEY_DRYRUN_FORMPARAMS = "dryRun_import_parms";
    private static final String IMPORT_PROGRESS_ID = "IMPORT_PROGRESS_ID";
    private static final String CHECK_START_KEY = "CHECK_START_KEY";
    private static final String CHECK_FINISHED_KEY = "CHECK_FINISHED_KEY";
    private static final String FINISHED_MARK = "START_MARK";
    private static final ThreadPool myThreadPool;
    public static final int MY_THREAD_COUNT;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btngodiff"});
        Object isDryRun = this.getView().getFormShowParameter().getCustomParam(KEY_IS_DRYRUN_PATTERN);
        if (Objects.equals(false, isDryRun)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btngodiff"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnresult"});
        }
        if (Objects.equals(true, isDryRun)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnresult"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnsuspend"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setContinueImportUnVisible();
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"failpanel", "successpanel", "btnclose", "btnok", "suspendpanel", "btngodiff"});
        FormShowParameter params = this.getView().getFormShowParameter();
        String appid = (String)params.getCustomParam("ServiceAppId");
        String checkRightAppId = (String)params.getCustomParam("CheckRightAppId");
        String billFormId = (String)params.getCustomParam("BillFormId");
        String listName = (String)params.getCustomParam("ListName");
        String pluginName = (String)params.getCustomParam("ImportPlugin");
        String url = (String)params.getCustomParam("Url");
        String opSaveKey = (String)params.getCustomParam("OpSave");
        String importType = (String)params.getCustomParam("Type");
        String keyfields = (String)params.getCustomParam("KeyFields");
        boolean forUpdateMultiLangFields = Boolean.parseBoolean((String)params.getCustomParam("ForUpdateMultiLangFields"));
        Label title = (Label)this.getControl("title");
        title.setText(listName);
        Object logId = this.createImportlog(billFormId, listName);
        this.getView().getParentView().getPageCache().put(IMPORT_PROGRESS_ID, logId.toString());
        this.getPageCache().put(IMPORT_PROGRESS_ID, logId.toString());
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        try {
            BatchImportPlugin plugin;
            progress.start();
            RequestContext rc = RequestContext.get();
            ImportContext ctx = new ImportContext(this.getView(), (Object)logId.toString(), appid, checkRightAppId, listName, billFormId, opSaveKey, url).addOption("importtype", (Object)importType).addOption("KeyFields", (Object)keyfields).addOption("ForUpdateMultiLangFields", (Object)forUpdateMultiLangFields).addOption(OPTION_KEY_IMPORT_MODEL_ID, params.getCustomParam(OPTION_KEY_IMPORT_MODEL_ID)).addOption(OPTION_KEY_IMPORT_DIMENSION_ID, params.getCustomParam(OPTION_KEY_IMPORT_DIMENSION_ID));
            String dryRunParams = SerializationUtils.serializeToBase64((Object)params);
            this.getView().getParentView().getPageCache().put(CACHE_KEY_DRYRUN_FORMPARAMS, dryRunParams);
            ctx.addOption(OPTION_KEY_IMPORTING_VIEW, (Object)this.getView().getParentView());
            Object object = plugin = !forUpdateMultiLangFields && StringUtils.isNotBlank((CharSequence)pluginName) ? (IImportDataPlugin)Class.forName(pluginName).newInstance() : new BatchImportPlugin();
            if (plugin instanceof BatchImportPlugin) {
                BatchImportPlugin batchPlugin = plugin.setContext(rc, ctx, Arrays.asList("resolveExcel", "importData"));
                myThreadPool.submit((Callable)batchPlugin);
                myThreadPool.submit((Callable)batchPlugin);
            } else {
                ImportConfig conf = new ImportConfig(this.getView(), ctx);
                myThreadPool.submit((Callable)new ImportDataTask(rc, conf, "resolveExcel"));
                myThreadPool.submit((Callable)new ImportDataTask(rc, conf, "importData"));
            }
        }
        catch (Throwable ex) {
            log.error(ex);
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"ImportingPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            String errMsg = ex instanceof KDBizException ? ex.getMessage() : ResManager.loadKDString((String)"\u5f15\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportingPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            ImportLogHelper.append((Object)logId, (String)errMsg);
        }
        this.setContinueImportUnVisible();
    }

    private Object createImportlog(String billFormId, String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_importlog");
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_importlog", dyn, null);
        dyn.set("billno", (Object)billno);
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        this.getPageCache().put(ImportDataTask.getCacheKey((String)billFormId, (String)this.getView().getPageId()), String.valueOf(dyn.getPkValue()));
        return dyn.getPkValue();
    }

    private void superOnProgress(ProgressEvent evt) {
        int importProgress = 0;
        String cacheLogStr = this.getPageCache().get("Cached_Import_Logger");
        log.info("Cached_Import_Logger<----" + cacheLogStr);
        IFormView view = this.getView();
        JSONObject info = JSON.parseObject((String)cacheLogStr);
        if (info != null) {
            importProgress = info.getIntValue("progress");
            if (importProgress < 0 || info.containsKey((Object)"err")) {
                String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : ResManager.loadKDString((String)"\u5f15\u5165\u8fc7\u7a0b\u9047\u5230\u672a\u77e5\u9519\u8bef\u3002", (String)"ImportingPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]);
                view.showErrorNotification(err);
                ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
                progressbar.stop();
                return;
            }
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            Label handlecount = (Label)this.getControl("handlecount");
            int row = info.getIntValue("curRowNum");
            int lastrow = Math.max(0, info.getIntValue("totalRowNum"));
            view.setVisible(Boolean.TRUE, new String[]{"btnsuspend"});
            view.setVisible(Boolean.FALSE, new String[]{"buttonap"});
            int total = info.getIntValue("total");
            if (row >= 0) {
                currRow.setText("" + row);
                rowCount.setText("" + lastrow);
            }
            handlecount.setText("" + total);
            if (importProgress >= 100) {
                view.hideLoading();
                view.setVisible(Boolean.FALSE, new String[]{"importpanel", "btncancel", "btnsuspend", "suspendpanel"});
                view.setVisible(Boolean.TRUE, new String[]{"buttonap"});
                int failed = info.getIntValue("failed");
                if (failed > 0) {
                    Label success = (Label)this.getControl("success");
                    Label fail = (Label)this.getControl("failed");
                    success.setText("" + (total - failed));
                    fail.setText("" + failed);
                    view.setVisible(Boolean.TRUE, new String[]{"failpanel"});
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)view.getFormShowParameter().getCustomParam("OperateKey")))) {
                        view.setVisible(Boolean.TRUE, new String[]{"btnok"});
                    }
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                    notHidden.put("gr", 1);
                    view.updateControlMetadata("failpanel", notHidden);
                } else {
                    Label success = (Label)this.getControl("successall");
                    success.setText("" + total);
                    view.setVisible(Boolean.TRUE, new String[]{"successpanel"});
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                    notHidden.put("gr", 1);
                    view.updateControlMetadata("successpanel", notHidden);
                }
                this.getAppCache(view).remove(this.getSuspendKey(view));
                this.getPageCache().remove(CHECK_START_KEY);
                this.getPageCache().put(CHECK_FINISHED_KEY, FINISHED_MARK);
            }
            if (lastrow > 0) {
                HashMap<String, Integer> meta = new HashMap<String, Integer>();
                meta.put("itime", 3000);
                view.updateControlMetadata("progressbarap", meta);
            }
        }
        evt.setProgress(importProgress);
    }

    private IAppCache getAppCache(IFormView view) {
        String billFormId = (String)view.getFormShowParameter().getCustomParam("BillFormId");
        String appId = EntityMetadataCache.getDataEntityType((String)billFormId).getAppId();
        return AppCache.get((String)appId);
    }

    private String getSuspendKey(IFormView view) {
        String billFormId = (String)view.getFormShowParameter().getCustomParam("BillFormId");
        return "IMPT_SUSPEND_" + billFormId;
    }

    public void onProgress(ProgressEvent evt) {
        this.superOnProgress(evt);
        this.setContinueImportUnVisible();
    }

    private void setContinueImportUnVisible() {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        String definedPro = (String)showParam.getCustomParam("fromUserDefinedPropertyImport");
        String defaultValue = (String)showParam.getCustomParam("fromDimDefaultValue");
        if (StringUtils.isNotEmpty((CharSequence)definedPro) || StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btngodiff"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
        }
    }

    static {
        int threadmax = 12;
        try {
            threadmax = Integer.parseInt(System.getProperty("bos.importing.thread.max", "12"));
        }
        catch (NumberFormatException var2) {
            log.error("--\u8b66\u544a\uff1aMC\u53c2\u6570bos.importing.thread.max\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u68c0\u67e5\uff01");
        }
        MY_THREAD_COUNT = threadmax;
        myThreadPool = ThreadPools.newCachedThreadPool((String)"BcmImportThreadPool", (int)2, (int)MY_THREAD_COUNT);
    }
}

