/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.perm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.helper.ImportHelper;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;
import kd.epm.far.formplugin.common.imp.ImportOperateType;

public class FidmDataAuthMainImport
extends AbsCommonImport {
    private static final String BOS_USER = "bos_user";
    private static final String BOS_USER_GROUP = "bos_usergroup";
    private final Set<String> repeatKeys = Sets.newHashSetWithExpectedSize((int)16);
    private final List<String> userTypeList = Lists.newArrayList((Object[])new String[]{"bos_user", "bos_usergroup"});
    private Map<String, DynamicObject> recordMap;
    private Map<String, DynamicObject> permClassMap;
    private DynamicObject model;
    private Map<String, DynamicObject> userMap;
    private Map<String, DynamicObject> userGroupMap;
    private Long modelId;

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.entityName = "bcm_auth_info";
        return this;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        this.initData(billDatas);
    }

    private void initData(List<ImportBillData> billDatas) {
        this.modelId = LongUtil.toLong(this.ctx.getOption().get("BcmModelId"));
        if (Objects.isNull(this.model)) {
            this.model = BusinessDataServiceHelper.loadSingleFromCache((Object)this.modelId, (String)"fidm_model");
        }
        if (Objects.isNull(this.permClassMap)) {
            HashMap permissionClass = new HashMap(16);
            permissionClass.putAll(PermClassEntityHelper.getPermissionClass((Long)this.modelId, (String)"fidmmodel.id"));
            Long orimodelId = this.model.getLong("model.id");
            permissionClass.putAll(PermClassEntityHelper.getPermissionClass((Long)orimodelId));
            this.permClassMap = permissionClass.values().stream().collect(Collectors.toMap(t -> t.getString("number"), Function.identity(), (k1, k2) -> k1));
        }
        this.recordMap = this.getDataAuthFromDb(this.modelId);
        Map<String, List<ImportBillData>> usertypeMap = billDatas.stream().collect(Collectors.groupingBy(t -> ImportHelper.getImportBillProp(t, "usertype").toString()));
        if (!CollectionUtils.isEmpty((Collection)usertypeMap.get(BOS_USER))) {
            this.userMap = this.getUserFromDb(usertypeMap.get(BOS_USER));
        }
        if (!CollectionUtils.isEmpty((Collection)usertypeMap.get(BOS_USER_GROUP))) {
            this.userGroupMap = this.getUserGroupFromDb(usertypeMap.get(BOS_USER_GROUP));
        }
    }

    private Map<String, DynamicObject> getUserFromDb(List<ImportBillData> importBillData) {
        Set numbers = importBillData.stream().map(t -> ImportHelper.getImportBillProp(t, "users.number").toString()).collect(Collectors.toSet());
        DynamicObjectCollection dys = QueryServiceHelper.query((String)BOS_USER, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        return dys.stream().collect(Collectors.toMap(t -> t.getString("number"), Function.identity()));
    }

    private Map<String, DynamicObject> getUserGroupFromDb(List<ImportBillData> importBillData) {
        Set numbers = importBillData.stream().map(t -> ImportHelper.getImportBillProp(t, "users.number").toString()).collect(Collectors.toSet());
        DynamicObjectCollection dys = QueryServiceHelper.query((String)BOS_USER_GROUP, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        return dys.stream().collect(Collectors.toMap(t -> t.getString("number"), Function.identity()));
    }

    private Map<String, DynamicObject> getDataAuthFromDb(Long modelId) {
        QFilter filter = new QFilter("fidmmodel", "=", (Object)modelId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)this.entityName).getAllFields().keySet()), (QFilter[])new QFilter[]{filter});
        if (Objects.isNull(load) || load.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(load).collect(Collectors.toMap(this::getRepeatKey, Function.identity(), (value1, value2) -> value1));
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        Optional<DynamicObject> dbOld;
        DynamicObject dynamicObject;
        String number = ImportHelper.getImportBillProp(bill, "model_number").toString();
        if (!Objects.equals(this.model.getString("number"), number)) {
            return Optional.of(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u5176\u4ed6\u4f53\u7cfb\u3002", (String)"DataAuthMainImport_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String usersNumber = ImportHelper.getImportBillProp(bill, "users.number").toString();
        if (StringUtils.isEmpty((Object)usersNumber)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u6216\u7528\u6237\u7ec4.\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (usersNumber.length() > 36) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc736\u4e2a\u5b57\u7b26\u3002", (String)"DataAuthMainImport_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String username = String.valueOf(ImportHelper.getImportBillProp(bill, "username"));
        if (StringUtils.isEmpty((Object)username)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String usertype = ImportHelper.getImportBillProp(bill, "usertype").toString();
        if (StringUtils.isEmpty((Object)usertype)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!this.userTypeList.contains(usertype)) {
            return Optional.of(ResManager.loadKDString((String)"\u7528\u6237\u7c7b\u578b\u53ea\u5141\u8bb8\u586b\u5165bos_user\u6216bos_usergroup\u3002", (String)"DataAuthMainImport_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (Objects.equals(BOS_USER, usertype) && (Objects.isNull(dynamicObject = this.userMap.get(usersNumber)) || !Objects.equals(dynamicObject.getString("name"), username))) {
            String message = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7528\u6237\u7f16\u7801\u4e3a%1$s\u4e14\u7528\u6237\u540d\u79f0\u4e3a%2$s\u7684\u7528\u6237\u3002", (String)"DataAuthMainImport_8", (String)"epm-far-formplugin", (Object[])new Object[0]), usersNumber, username);
            return Optional.of(message);
        }
        if (Objects.equals(BOS_USER_GROUP, usertype) && (Objects.isNull(dynamicObject = this.userGroupMap.get(usersNumber)) || !Objects.equals(dynamicObject.getString("name"), username))) {
            String message = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u7528\u6237\u7ec4\u7f16\u7801\u4e3a%1$s\u4e14\u7528\u6237\u540d\u79f0\u4e3a%2$s\u7684\u7528\u6237\u3002", (String)"DataAuthMainImport_9", (String)"epm-far-formplugin", (Object[])new Object[0]), usersNumber, username);
            return Optional.of(message);
        }
        String auth = ImportHelper.getImportBillProp(bill, "auth").toString();
        if (StringUtils.isEmpty((Object)auth)) {
            return Optional.of(ResManager.loadKDString((String)"\u6743\u9650\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(this.permClassMap.get(auth))) {
            return Optional.of(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u6743\u9650\u7c7b\u3002", (String)"DataAuthMainImport_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String dataAuth = ImportHelper.getImportBillProp(bill, "data_auth").toString();
        if (StringUtils.isEmpty((Object)dataAuth)) {
            return Optional.of(ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataAuthMainImport_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        if (Objects.equals((Object)importType, (Object)ImportOperateType.NEW) && (dbOld = this.getDbOld(bill)).isPresent()) {
            return Optional.of(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DataAuthMainImport_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String repeatKey = this.getRepeatKey(bill);
        if (!this.repeatKeys.add(repeatKey)) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"DataAuthMainImport_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            JSONObject data = billDataList.get(i).getData();
            DynamicObject old = (DynamicObject)data.get((Object)"existingRecordDy");
            old.set("data_auth", (Object)data.getString("data_auth"));
            dys[i] = old;
        }
        return dys;
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            long usersId;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
            ImportBillData billData = billDataList.get(i);
            dynamicObject.set("id", (Object)LongUtil.toLong((Object)ImportHelper.getImportBillProp(billData, "id")));
            String usertype = ImportHelper.getImportBillProp(billData, "usertype").toString();
            if (usertype.equals(BOS_USER)) {
                DynamicObject user = this.userMap.get(ImportHelper.getImportBillProp(billData, "users.number").toString());
                usersId = user.getLong("id");
            } else {
                DynamicObject userGroup = this.userGroupMap.get(ImportHelper.getImportBillProp(billData, "users.number").toString());
                usersId = userGroup.getLong("id");
            }
            dynamicObject.set("users", (Object)usersId);
            dynamicObject.set("usertype", (Object)usertype);
            dynamicObject.set("username", (Object)ImportHelper.getImportBillProp(billData, "username").toString());
            DynamicObject permClass = this.permClassMap.get(ImportHelper.getImportBillProp(billData, "auth").toString());
            dynamicObject.set("authclass", (Object)permClass.getLong("id"));
            dynamicObject.set("fidmmodel", (Object)this.model.getLong("id"));
            dynamicObject.set("data_auth", (Object)ImportHelper.getImportBillProp(billData, "data_auth").toString());
            dys[i] = dynamicObject;
        }
        return dys;
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        DynamicObject dynamicObject = this.recordMap.get(this.getRepeatKey(rowData));
        return Optional.ofNullable(dynamicObject);
    }

    private String getRepeatKey(ImportBillData data) {
        String usersNumber = ImportHelper.getImportBillProp(data, "users.number").toString();
        String userType = ImportHelper.getImportBillProp(data, "usertype").toString();
        String auth = ImportHelper.getImportBillProp(data, "auth").toString();
        return new StringJoiner("|").add(usersNumber).add(userType).add(auth).toString();
    }

    private String getRepeatKey(DynamicObject dy) {
        return new StringJoiner("|").add(dy.getString("users.number")).add(dy.getString("usertype")).add(dy.getString("authclass.number")).toString();
    }
}

