/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.perm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.helper.ImportHelper;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;
import kd.epm.far.formplugin.common.imp.ImportOperateType;

public class FidmPermissionClassImport
extends AbsCommonImport {
    private final Set<String> repeatKeys = Sets.newHashSetWithExpectedSize((int)16);
    private Map<String, DynamicObject> permClassMap = Maps.newHashMap();
    private DynamicObject model;

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        Optional<DynamicObject> dbOld;
        String remark;
        String showNumber = ImportHelper.getImportBillProp(bill, "fidmmodel.number").toString();
        if (!Objects.equals(this.model.getString("number"), showNumber)) {
            return Optional.of(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u5176\u4ed6\u4f53\u7cfb\u3002", (String)"PermissionClassImport_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String number = ImportHelper.getImportBillProp(bill, "number").toString();
        if (number.length() > 20) {
            return Optional.of(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7f16\u7801 \u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,20]\u3002", (String)"PermissionClassImport_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        Object objRemark = ImportHelper.getImportBillProp(bill, "remark");
        if (Objects.nonNull(objRemark) && StringUtils.isNotEmpty((String)objRemark.toString()) && (remark = LocaleString.fromMap((Map)((Map)objRemark)).getLocaleValue()) != null && remark.length() > 100) {
            return Optional.of(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5907\u6ce8\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,100]\u3002", (String)"PermissionClassImport_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        if (Objects.equals((Object)importType, (Object)ImportOperateType.NEW) && (dbOld = this.getDbOld(bill)).isPresent()) {
            return Optional.of(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PermissionClassImport_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!this.repeatKeys.add(number)) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"PermissionClassImport_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void initData() {
        Long modelId = LongUtil.toLong(this.ctx.getOption().get("BcmModelId"));
        if (Objects.isNull(this.model)) {
            this.model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"fidm_model");
        }
        Long oriModelId = this.model.getLong("model.id");
        DynamicObject[] fidmPermClass = PermClassEntityHelper.getPermissionClassByLoad((Long)modelId, (String)"fidmmodel.id");
        DynamicObject[] permClass = PermClassEntityHelper.getPermissionClassByLoad((Long)oriModelId, (String)"model.id");
        this.permClassMap.putAll(Arrays.stream(fidmPermClass).collect(Collectors.toMap(t -> t.getString("number"), Function.identity(), (k1, k2) -> k1)));
        this.permClassMap.putAll(Arrays.stream(permClass).collect(Collectors.toMap(t -> t.getString("number"), Function.identity(), (k1, k2) -> k1)));
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        Date now = new Date();
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            JSONObject data = billDataList.get(i).getData();
            DynamicObject old = (DynamicObject)data.get((Object)"existingRecordDy");
            Object remarkObj = data.get((Object)"remark");
            old.set("remark", (Object)(Objects.nonNull(remarkObj) ? LocaleString.fromMap((Map)((Map)remarkObj)).getLocaleValue() : ""));
            old.set("modifier", (Object)RequestContext.get().getCurrUserId());
            old.set("modifytime", (Object)now);
            dys[i] = old;
        }
        return dys;
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        Date now = new Date();
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
            dynamicObject.set("id", (Object)billDataList.get(i).getData().getLong("id"));
            dynamicObject.set("number", (Object)billDataList.get(i).getData().getString("number"));
            dynamicObject.set("fidmmodel", (Object)this.model);
            dynamicObject.set("app", (Object)this.ctx.getAppId());
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)now);
            Object remark = billDataList.get(i).getData().get((Object)"remark");
            dynamicObject.set("remark", (Object)(Objects.nonNull(remark) ? LocaleString.fromMap((Map)((Map)remark)).getLocaleValue() : ""));
            dys[i] = dynamicObject;
        }
        return dys;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initData();
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        String number = ImportHelper.getImportBillProp(rowData, "number").toString();
        DynamicObject old = this.permClassMap.get(number);
        return Optional.ofNullable(old);
    }
}

