/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dimension.RPTDimType;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.common.AppUtil;
import kd.epm.far.business.common.dataset.dto.CheckTreeNodeInfo;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetMetadataVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.DatasetTemplateVo;
import kd.epm.far.business.common.dataset.dto.DatasetVoucherVo;
import kd.epm.far.business.common.dataset.dto.DimInfo;
import kd.epm.far.business.common.dataset.dto.FilterVo;
import kd.epm.far.business.common.dataset.dto.SourceEntityVo;
import kd.epm.far.business.common.dataset.operatestrategy.IDataSetOperate;
import kd.epm.far.business.common.dataset.util.DatasetCheckUtil;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.adapter.DimMemberAdapter;
import kd.epm.far.business.common.model.adapter.DimensionAdapter;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.eb.EBDimensionHelper;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDim;
import kd.epm.far.business.eb.dto.EbMember;
import kd.epm.far.business.far.enums.ModelSourceEnum;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.enums.dimension.OrgStoreStatusEnum;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.dataset.SEUtils;
import kd.epm.far.formplugin.common.util.ModelUtil;
import org.apache.commons.collections.CollectionUtils;

public class DataSetDisplayUtil {
    public static final String DIMID = "dimId";
    public static final String EXT_SE = "SE";
    public static final String EXTEND = "extend";
    public static final String SOURCEFROM = "sourcefrom";
    public static final String TYPESELECT = "typeselect";
    public static final String ALLNUMBERTYPE = "allNumType";
    public static final String DATASETTYPE = "datasetType";
    public static final String SHOWNUMBER = "shownumber";
    public static final String DSEQ = "dseq";
    public static final String RANGE = "range";
    public static final String RANGENAME = "rangename";
    public static final String LABEL = "label";
    public static final String DIMLIST = "dimList";
    public static final String KEY_DIM = "dim";
    public static final String FILTERS = "filters";
    public static final String SPLITSYMBOL = "@";
    public static final String MEMBERNAME = "&&membername";
    public static final String MEMBERNUMBER = "&&membernumber";
    public static final String CUSTOM = "&&custom";
    public static final String ROOT = "root";
    public static final String TEXTTYPE = "kdfont kdfont-qushu2";
    public static final String ISPARENT = "isParent";
    public static final Set<String> defaultShortNumber = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber(), DimTypesEnum.SCENARIO.getShortNumber(), DimTypesEnum.CURRENCY.getShortNumber()});
    public static final Set<String> extendDefaultShortNumber = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber(), DimTypesEnum.SCENARIO.getShortNumber(), DimTypesEnum.CURRENCY.getShortNumber(), DimTypesEnum.PROCESS.getShortNumber(), DimTypesEnum.AUDITTRIAL.getShortNumber()});
    public static final List<FilterVo> filters = Lists.newArrayList((Object[])new FilterVo[]{new FilterVo("=", ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"DataSetDisplayPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0])), new FilterVo("in", ResManager.loadKDString((String)"\u5728......\u4e2d", (String)"DataSetDisplayPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0])), new FilterVo("like", ResManager.loadKDString((String)"\u5305\u542b", (String)"DataSetDisplayPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0])), new FilterVo(">", ResManager.loadKDString((String)"\u5927\u4e8e", (String)"DataSetDisplayPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0])), new FilterVo("<", ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"DataSetDisplayPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0])), new FilterVo(">=", ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"DataSetDisplayPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0])), new FilterVo("<=", ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"DataSetDisplayPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]))});

    public static void sendToVue(Object data, CustomControl custom) {
        if (custom != null) {
            custom.setData(data);
        }
    }

    public static void sendToVue(String propsDataTpye, CustomControl custom) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)propsDataTpye);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        DataSetDisplayUtil.sendToVue(dataObj, custom);
    }

    public static void sendDataInitVue(List<Map<String, Object>> dimList, String propsDataType, CustomControl custom, String sourceFrom, String datasetType, Set<String> allNumType) {
        JSONObject dataObj = new JSONObject();
        HashMap result = Maps.newHashMapWithExpectedSize((int)1);
        result.put(DIMLIST, dimList);
        dataObj.put(KEY_DIM, (Object)result);
        dataObj.put(FILTERS, filters);
        dataObj.put(SOURCEFROM, (Object)sourceFrom);
        dataObj.put(ALLNUMBERTYPE, allNumType);
        dataObj.put(DATASETTYPE, (Object)datasetType);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        dataObj.put("dataType", (Object)propsDataType);
        DataSetDisplayUtil.sendToVue(dataObj, custom);
    }

    public static List<TreeNode> createDimensionNode(DimInfo dimInfo, DynamicObjectCollection memberProperties, TreeNode root, boolean isEb) {
        Long currentDimId = dimInfo.getId();
        String dimId = String.valueOf(currentDimId);
        String dimName = dimInfo.getName();
        String dimShortNumber = dimInfo.getShortNumber();
        ArrayList treeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        TreeNode dimensionNode = BCMTreeUtils.createTreeNode((String)dimId, (String)dimName, (String)dimShortNumber, (String)ROOT);
        dimensionNode.setIcon(TEXTTYPE);
        treeNodeList.add(dimensionNode);
        if (isEb) {
            root.addChild(dimensionNode);
            return treeNodeList;
        }
        String localName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"DataSetDisplayPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]);
        String dimNumber = dimInfo.getNumber();
        String nameId = DataSetDisplayUtil.generateCustomTreeNodeId(dimId, localName, "name", dimNumber, ColumnTypeEnum.FIXED_COLUMN.getCode());
        TreeNode dimensionChildNmaeNode = BCMTreeUtils.createTreeNode((String)nameId, (String)localName, (String)(dimShortNumber + MEMBERNAME), (String)dimId);
        dimensionChildNmaeNode.setIcon(TEXTTYPE);
        treeNodeList.add(dimensionChildNmaeNode);
        dimensionNode.addChild(dimensionChildNmaeNode);
        String localNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"DataSetDisplayPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]);
        String numberId = DataSetDisplayUtil.generateCustomTreeNodeId(dimId, localNumber, "number", dimNumber, ColumnTypeEnum.FIXED_COLUMN.getCode());
        TreeNode dimensionChildNumberNode = BCMTreeUtils.createTreeNode((String)numberId, (String)localNumber, (String)(dimShortNumber + MEMBERNUMBER), (String)dimId);
        dimensionChildNumberNode.setIcon(TEXTTYPE);
        treeNodeList.add(dimensionChildNumberNode);
        dimensionNode.addChild(dimensionChildNumberNode);
        memberProperties.forEach(memberProperty -> {
            Long dimension = memberProperty.getLong("dimension");
            if (dimension.equals(currentDimId)) {
                Long id = memberProperty.getLong("id");
                String name = memberProperty.getString("name");
                String number = memberProperty.getString("number");
                String customId = dimId + SPLITSYMBOL + id;
                String customNodeId = DataSetDisplayUtil.generateCustomTreeNodeId(customId, name, number, dimNumber, ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode());
                TreeNode memberPropertyNode = BCMTreeUtils.createTreeNode((String)customNodeId, (String)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027 - %s", (String)"DataSetDisplayPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[]{name}), (String)(dimShortNumber + CUSTOM), (String)dimension.toString());
                memberPropertyNode.setIcon(TEXTTYPE);
                treeNodeList.add(memberPropertyNode);
                dimensionNode.addChild(memberPropertyNode);
            }
        });
        root.addChild(dimensionNode);
        return treeNodeList;
    }

    public static Map<String, List<TreeNode>> checkedTreeNode(List<TreeNode> treeNodeList, Map<String, List<Map<String, String>>> dimAndMember, List<String> selectCustomDataList, String extendValue, TreeView tree) {
        HashMap returnSelectTreeNodeList = Maps.newHashMapWithExpectedSize((int)2);
        Set<String> dataDim = dimAndMember.keySet();
        List<Object> extendList = Lists.newArrayListWithExpectedSize((int)10);
        if (StringUtils.isNotEmpty((CharSequence)extendValue)) {
            String[] extendValues = extendValue.split(",");
            extendList = Arrays.asList(extendValues);
        }
        if (dataDim.size() > 0) {
            ArrayList dimNodeList = Lists.newArrayListWithCapacity((int)6);
            ArrayList filterNodeList = Lists.newArrayListWithCapacity((int)6);
            ArrayList selectTreeNodeList = Lists.newArrayListWithExpectedSize((int)dataDim.size());
            for (TreeNode treeNode : treeNodeList) {
                String treeNodeId = treeNode.getId();
                String shortDim = (String)treeNode.getData();
                if (dataDim.contains(shortDim)) {
                    selectTreeNodeList.add(treeNode);
                    dimNodeList.add(treeNode);
                }
                if (treeNodeId.contains(SPLITSYMBOL)) {
                    int index = treeNodeId.indexOf(SPLITSYMBOL);
                    String subTreeNodeId = treeNodeId.substring(index + 1);
                    if (treeNodeId.endsWith("@3")) {
                        subTreeNodeId = String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027 - %s", (String)"DataSetDisplayPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]), subTreeNodeId);
                    }
                    if (selectCustomDataList.size() > 0 && selectCustomDataList.contains(subTreeNodeId)) {
                        selectTreeNodeList.add(treeNode);
                        filterNodeList.add(treeNode);
                    }
                }
                if (!extendList.contains(treeNodeId)) continue;
                selectTreeNodeList.add(treeNode);
            }
            if (selectTreeNodeList.size() > 0) {
                tree.checkNodes((List)selectTreeNodeList);
            }
            returnSelectTreeNodeList.put("dimnodelist", dimNodeList);
            returnSelectTreeNodeList.put("filternodelist", filterNodeList);
        }
        return returnSelectTreeNodeList;
    }

    public static List<String> getData(DatasetDto dataSetDto) {
        ArrayList selectCustomDataList = Lists.newArrayListWithExpectedSize((int)10);
        String data = dataSetDto.getData();
        if (data != null && StringUtils.isNotBlank((CharSequence)data)) {
            JSONObject customInfo = JSONObject.parseObject((String)data);
            JSONArray columns = customInfo.getJSONArray("columns");
            if (CollectionUtils.isEmpty((Collection)columns)) {
                return Collections.emptyList();
            }
            columns.forEach(column -> {
                Integer type = ((JSONObject)column).getInteger("type");
                String source = ((JSONObject)column).getString("source");
                String number = ((JSONObject)column).getString("number");
                String name = ((JSONObject)column).getString("name");
                String selectCustomData = DataSetDisplayUtil.generateCustomTreeWithoutNodeId(name, number, source, type);
                selectCustomDataList.add(selectCustomData);
            });
        }
        return selectCustomDataList;
    }

    public static String generateCustomTreeNodeId(String id, String name, String number, String source, Integer type) {
        StringBuilder generateRule = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            generateRule.append(id);
            generateRule.append(SPLITSYMBOL);
        }
        generateRule.append(name);
        generateRule.append(SPLITSYMBOL);
        generateRule.append(number);
        generateRule.append(SPLITSYMBOL);
        generateRule.append(source);
        generateRule.append(SPLITSYMBOL);
        generateRule.append(type);
        return generateRule.toString();
    }

    public static String generateCustomTreeWithoutNodeId(String name, String number, String source, Integer type) {
        String generateRule = DataSetDisplayUtil.generateCustomTreeNodeId("", name, number, source, type);
        return generateRule;
    }

    public static Boolean isMetadtaSrcType(DatasetDto dataSetDto) {
        return DatasetUtil.isMetadtaSrcType((DatasetDto)dataSetDto);
    }

    public static Boolean isBCMMetadtaSrcType(DatasetDto dataSetDto) {
        String dataSrcType = dataSetDto.getDataSrcType();
        if (DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dataSrcType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isTemplate(DatasetDto dataSetDto) {
        return Objects.equals(dataSetDto.getDataSrcType(), DataSrcTypeEnum.CM_TEMPLATE.getType());
    }

    public static Boolean isBCMSrcType(DatasetDto dataSetDto) {
        return Objects.equals(dataSetDto.getDataSrcType(), DataSrcTypeEnum.MERGE_MODEL.getType());
    }

    public static String getExtendData(DatasetDto dataSetDto) {
        ArrayList selectCustomDataList = Lists.newArrayListWithExpectedSize((int)10);
        String data = dataSetDto.getData();
        if (data != null && StringUtils.isNotBlank((CharSequence)data)) {
            JSONObject customInfo = JSONObject.parseObject((String)data);
            JSONArray columns = customInfo.getJSONArray("columns");
            columns.forEach(column -> {
                String source = ((JSONObject)column).getString("source");
                if (EXTEND.equals(source)) {
                    String number = ((JSONObject)column).getString("number");
                    selectCustomDataList.add(number);
                }
            });
        }
        String extendValue = kd.bos.util.StringUtils.getEmpty();
        if (selectCustomDataList.size() > 0) {
            extendValue = String.join((CharSequence)",", selectCustomDataList);
        }
        return extendValue;
    }

    public static Map<String, List<Map<String, String>>> getExpressionDimInfo(DatasetDto dataSetDto) {
        DatasetDataVo datasetDataVo;
        String expression = dataSetDto.getTempExpression();
        String modelType = DisModelTypeEnum.getModelType((String)dataSetDto.getDataSrcType(), (Long)dataSetDto.getDataSrcId()).getType();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dataSetDto.getDataSrcId(), modelType);
        DimensionAdapter dimensionAdapter = modelStrategyEx.getDim();
        List dimensionInfoList = dimensionAdapter.getDimList();
        Map<String, String> shortNumberMap = dimensionInfoList.stream().collect(Collectors.toMap(DimensionInfo::getShortNumber, DimensionInfo::getNumber));
        HashMap listInfo = Maps.newHashMapWithExpectedSize((int)shortNumberMap.size());
        if (ModelSourceEnum.EB.getType().equals(modelType)) {
            String EBDataset = dataSetDto.getEbDataset();
            DynamicObject model = EbServiceHelper.getModel((Long)dataSetDto.getDataSrcId());
            DataSetDisplayUtil.getEBExpressionDimList(model.getString(SHOWNUMBER), EBDataset, listInfo, expression, shortNumberMap);
        } else if (ModelSourceEnum.RPT.getType().equals(modelType) || ModelSourceEnum.CM.getType().equals(modelType)) {
            DataSetDisplayUtil.getCMExpressionDimList(dataSetDto.getDataSrcId(), listInfo, expression, shortNumberMap);
        }
        String data = dataSetDto.getData();
        if (!StringUtils.isEmpty((CharSequence)data) && StringUtils.isNotBlank((CharSequence)data) && (datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class)) != null) {
            if (datasetDataVo.getSourceEntityVo() != null) {
                SourceEntityVo sourceEntityVo = datasetDataVo.getSourceEntityVo();
                List members = sourceEntityVo.getMembers();
                List<Map<String, String>> maps = SEUtils.buildInitData(members);
                listInfo.put(EXT_SE, maps);
            } else {
                List collect;
                List columns = datasetDataVo.getColumns();
                if (columns != null && !columns.isEmpty() && !(collect = columns.stream().filter(v -> "SourceEntity".equals(v.getSource())).collect(Collectors.toList())).isEmpty()) {
                    List<Map<String, String>> maps = SEUtils.buildInitData(null);
                    listInfo.put(EXT_SE, maps);
                }
            }
        }
        return listInfo;
    }

    public static void getEBExpressionDimList(String modelNumber, String EBDataset, Map<String, List<Map<String, String>>> listInfo, String expression, Map<String, String> shortNumberMap) {
        String[] split;
        for (String s : split = expression.split(",")) {
            String shortNumber;
            if (StringUtils.isBlank((CharSequence)s)) continue;
            ArrayList memberList = Lists.newArrayList();
            if (s.contains("{")) {
                String[] split2;
                String[] split1 = s.split("\\{");
                String members = split1[1];
                members = members.substring(0, members.length() - 1);
                shortNumber = split1[0].substring(0, split1[0].length() - 1);
                for (String member : split2 = members.split(";")) {
                    HashMap map = Maps.newHashMap();
                    DataSetDisplayUtil.buildEBMemberMap(modelNumber, EBDataset, shortNumber, member, map, shortNumberMap.get(shortNumber), DatasetExpressionHelper.ExpressoinPurpose.DIMANALYSIS.toString());
                    memberList.add(map);
                    listInfo.put(shortNumber, memberList);
                }
                continue;
            }
            String[] splitCheck = s.split("\\.");
            if (splitCheck.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u65e0\u6cd5\u89e3\u6790\u7684\u7ef4\u5ea6\u6210\u5458", (String)"DataSetDimGuidePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            String[] split1 = DatasetExpressionHelper.splitDimAndMemb((String)s);
            if (split1.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u65e0\u6cd5\u89e3\u6790\u7684\u7ef4\u5ea6\u6210\u5458", (String)"DataSetDimGuidePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            shortNumber = split1[0];
            HashMap map = Maps.newHashMap();
            DataSetDisplayUtil.buildEBMemberMap(modelNumber, EBDataset, shortNumber, s.substring(shortNumber.length() + 1), map, shortNumberMap.get(shortNumber), DatasetExpressionHelper.ExpressoinPurpose.DIMANALYSIS.toString());
            memberList.add(map);
            listInfo.put(shortNumber, memberList);
        }
    }

    public static void getCMExpressionDimList(Long modelId, Map<String, List<Map<String, String>>> listInfo, String expression, Map<String, String> shortNumberMap) {
        String[] split;
        String modelNum = BCMMemberReader.findModelNumberById((Object)modelId);
        for (String s : split = expression.split(",")) {
            String shortNumber;
            String realShortNumber;
            if (StringUtils.isBlank((CharSequence)s)) continue;
            ArrayList memberList = Lists.newArrayList();
            DimInfo dimSE = SEUtils.getSEDimInfo();
            if (s.contains("{")) {
                String[] split2;
                String[] split1 = s.split("\\{");
                String members = split1[1];
                members = members.substring(0, members.length() - 1);
                shortNumber = realShortNumber = split1[0].substring(0, split1[0].length() - 1);
                if (dimSE.getShortNumber().equals(realShortNumber)) {
                    shortNumber = DimTypesEnum.ENTITY.getShortNumber();
                }
                for (String member : split2 = members.split(";")) {
                    HashMap map = Maps.newHashMap();
                    DatasetExpressionHelper.buildMemberMap((String)shortNumber, (String)member, (Map)map, (String)modelNum, (String)shortNumberMap.get(shortNumber), (String)DatasetExpressionHelper.ExpressoinPurpose.DIMANALYSIS.toString());
                    if (dimSE.getShortNumber().equals(realShortNumber)) {
                        map.put("shortNumber", dimSE.getShortNumber());
                        map.put("dimNumber", dimSE.getNumber());
                    }
                    memberList.add(map);
                }
                listInfo.put(realShortNumber, memberList);
                continue;
            }
            String[] splitCheck = s.split("\\.");
            if (splitCheck.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u65e0\u6cd5\u89e3\u6790\u7684\u7ef4\u5ea6\u6210\u5458", (String)"DataSetDimGuidePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            String[] split1 = DatasetExpressionHelper.splitDimAndMemb((String)s);
            if (split1.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u65e0\u6cd5\u89e3\u6790\u7684\u7ef4\u5ea6\u6210\u5458", (String)"DataSetDimGuidePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            shortNumber = realShortNumber = split1[0];
            if (dimSE.getShortNumber().equals(realShortNumber)) {
                shortNumber = DimTypesEnum.ENTITY.getShortNumber();
            }
            HashMap map = Maps.newHashMap();
            DatasetExpressionHelper.buildMemberMap((String)shortNumber, (String)split1[1], (Map)map, (String)modelNum, (String)shortNumberMap.get(shortNumber), (String)DatasetExpressionHelper.ExpressoinPurpose.DIMANALYSIS.toString());
            if (dimSE.getShortNumber().equals(realShortNumber)) {
                map.put("shortNumber", dimSE.getShortNumber());
                map.put("dimNumber", dimSE.getNumber());
            }
            memberList.add(map);
            listInfo.put(realShortNumber, memberList);
        }
    }

    public static void buildEBMemberMap(String modelNumber, String EBDataset, String shortNumber, String member, Map<String, String> map, String dimNum, String purpose) {
        map.put("shortNumber", shortNumber);
        map.put(RANGE, "");
        map.put(RANGENAME, "");
        map.put("dimnumber", dimNum);
        if (member.contains("$")) {
            if (member.endsWith("$")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u5176\u4ed6\u53d8\u91cf\u6210\u5458\u65e0\u6cd5\u89e3\u6790", (String)"DataSetDimGuidePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (member.equalsIgnoreCase("$cur")) {
                map.put("name", ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458", (String)"DataSetDimGuidePlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else if (member.equalsIgnoreCase("$all")) {
                map.put("name", ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"DataSetDimGuidePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else if (member.equalsIgnoreCase("$curs")) {
                map.put("name", ResManager.loadKDString((String)"\u8303\u56f4\u6210\u5458", (String)"DataSetDimGuidePlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u5176\u4ed6\u53d8\u91cf\u6210\u5458\u65e0\u6cd5\u89e3\u6790", (String)"DataSetDimGuidePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (member.length() > 4) {
                map.put("number", member.substring(0, 4));
                map.put(RANGE, member.substring(4));
                map.put(RANGENAME, member.substring(4));
            } else {
                map.put("number", member);
            }
        } else {
            String[] split3 = member.split("\\.");
            Boolean notRange = Boolean.TRUE;
            if (split3.length > 1) {
                String firstInfo = member.substring(0, member.lastIndexOf("."));
                String lastInfo = member.substring(member.lastIndexOf(".") + 1);
                RangeEnum rangeEnum = RangeEnum.getRangeByNumber((String)lastInfo);
                if (rangeEnum == null) {
                    split3[0] = member;
                    notRange = Boolean.FALSE;
                } else if (split3.length > 2) {
                    split3[0] = firstInfo;
                    split3[1] = lastInfo;
                }
            }
            if (member.endsWith(".")) {
                split3[0] = member;
            }
            map.put("number", split3[0]);
            try {
                List memberList = EbServiceHelper.getMember((String)modelNumber, (String)EBDataset, (String)dimNum, (String)member, (RangeEnum)RangeEnum.VALUE_10);
                EbMember ebMember = (EbMember)memberList.get(0);
                String ebName = ebMember.getName();
                map.put("name", ebName);
                if (DatasetExpressionHelper.ExpressoinPurpose.DIMANALYSIS.toString().equals(purpose)) {
                    String ebNumber = ebMember.getNumber();
                    map.put("id", ebNumber);
                    map.put("number", ebNumber);
                    map.put(LABEL, ebNumber + ebName);
                }
                if (split3.length > 1 && notRange.booleanValue()) {
                    String range = split3[1];
                    RangeEnum rangeEnum = RangeEnum.getRangeByNumberOrName((String)range);
                    map.put(RANGENAME, rangeEnum.getName());
                    if (!Objects.equals(RangeEnum.VALUE_10, rangeEnum)) {
                        map.put(RANGE, rangeEnum.getNumber());
                    }
                } else if (DatasetExpressionHelper.ExpressoinPurpose.DIMANALYSIS.toString().equals(purpose)) {
                    map.put(RANGE, RangeEnum.VALUE_10.getNumber());
                    map.put(RANGENAME, RangeEnum.VALUE_10.getName());
                } else {
                    map.put(RANGENAME, RangeEnum.VALUE_10.getName());
                }
            }
            catch (Exception ex) {
                map.put("name", member);
                map.put(RANGENAME, RangeEnum.VALUE_10.getName());
            }
        }
    }

    public static String buidExpression(List<Map<String, String>> members, boolean isTemplate) {
        StringBuilder ex = new StringBuilder();
        Map<String, List<Map>> map = members.stream().collect(Collectors.groupingBy(t -> (String)t.get("shortNumber")));
        for (Map.Entry<String, List<Map>> entry : map.entrySet()) {
            String rptDimType = (String)entry.getValue().get(0).get("rptDimType");
            if (isTemplate && RPTDimType.ROWCOL.getValue().equals(rptDimType)) continue;
            String key = entry.getKey();
            ex.append(key);
            List<Map> value = entry.getValue();
            if (value.size() == 1 && StringUtils.isEmpty((CharSequence)((CharSequence)value.get(0).get(RANGE)))) {
                if (isTemplate && DatasetSpecialVarHelper.isEqualsAllVar((String)((String)value.get(0).get("number")))) {
                    String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6682\u4e0d\u652f\u6301\u9009ALL\u3002", (String)"DataSetDisplayPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]);
                    if (!Objects.equals(key, "E")) {
                        msg = ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u6682\u4e0d\u652f\u6301\u9009ALL\u3002", (String)"DataSetDisplayPlugin_27", (String)"epm-far-formplugin", (Object[])new Object[0]);
                    }
                    throw new KDBizException(msg);
                }
                ex.append(".").append((String)value.get(0).get("number"));
            } else {
                if (isTemplate && !Objects.equals(key, "E")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u53c2\u6570\u6682\u4e0d\u652f\u6301\u591a\u9009\u3002", (String)"DataSetDisplayPlugin_28", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                ex.append(".").append("{");
                for (Map dy : value) {
                    if (isTemplate && DatasetSpecialVarHelper.isEqualsAllVar((String)((String)dy.get("number")))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6682\u4e0d\u652f\u6301\u9009ALL\u3002", (String)"DataSetDisplayPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    }
                    ex.append((String)dy.get("number"));
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)dy.get(RANGE)))) {
                        if (!((String)dy.get("number")).contains("$")) {
                            ex.append(".");
                        }
                        ex.append((String)dy.get(RANGE));
                    }
                    ex.append(";");
                }
                ex.deleteCharAt(ex.length() - 1);
                ex.append("}");
            }
            ex.append(",");
        }
        if (ex.length() > 1) {
            ex.deleteCharAt(ex.length() - 1);
        }
        return ex.toString();
    }

    public static List getRangeData(String dataSrcType) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)7);
        RangeEnum[] values = RangeEnum.values();
        if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
            LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)2);
            map.put(LABEL, RangeEnum.VALUE_10.getName());
            map.put("value", RangeEnum.VALUE_10.getNumber());
            result.add(map);
        } else {
            for (RangeEnum value : values) {
                if ("".equals(value.getNumber())) break;
                LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)2);
                map.put(LABEL, value.getName());
                map.put("value", value.getNumber());
                result.add(map);
            }
        }
        return result;
    }

    public static void buildSourceComboEdit(ComboEdit comboEdit) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.MERGE_MODEL.getName()), DataSrcTypeEnum.MERGE_MODEL.getType()));
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.RPT_MODEL.getName()), DataSrcTypeEnum.RPT_MODEL.getType()));
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.EB_MODEL.getName()), DataSrcTypeEnum.EB_MODEL.getType()));
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.ISC_METADATA.getName()), DataSrcTypeEnum.ISC_METADATA.getType()));
        try {
            DatasetUtil.getEntityType((String)"epdm_dm");
            items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.EPM_VOUCHER.getName()), DataSrcTypeEnum.EPM_VOUCHER.getType()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        comboEdit.setComboItems(items);
    }

    public static void buildDataSrcIdComboEdit(ComboEdit comboEdit, List<DynamicObject> array) {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)array.size());
        if (CollectionUtils.isEmpty(array)) {
            comboEdit.setComboItems((List)items);
            return;
        }
        array.forEach(dynamicObject -> items.add(new ComboItem(new LocaleString(dynamicObject.getString(SHOWNUMBER) + " " + dynamicObject.getString("name")), dynamicObject.getString("id"))));
        comboEdit.setComboItems((List)items);
    }

    public static ModelInfo getModelInfo(Long currentModelId) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(currentModelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        return modelInfo;
    }

    public static String getSrcType(Long currentModelId) {
        ModelInfo modelInfo = DataSetDisplayUtil.getModelInfo(currentModelId);
        String modelType = modelInfo.getModelType();
        String dataSrcType = DataSrcTypeEnum.MERGE_MODEL.getType();
        if (ModelSourceEnum.EB.getType().equals(modelType)) {
            dataSrcType = DataSrcTypeEnum.EB_MODEL.getType();
        } else if (ModelSourceEnum.RPT.getType().equals(modelType)) {
            dataSrcType = DataSrcTypeEnum.RPT_MODEL.getType();
        }
        return dataSrcType;
    }

    public static IModel getSourceModelType(IDataModel dataModel, IDataSetOperate dataSetOperate) {
        String dataSrcType = dataSetOperate.getStringValue(SOURCEFROM, dataModel);
        DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType((String)dataSrcType);
        IModel strategy = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.CM);
        if (Objects.isNull(typeEnum)) {
            return strategy;
        }
        switch (typeEnum) {
            case RPT_MODEL: {
                strategy = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.RPT);
                break;
            }
            case EB_MODEL: {
                strategy = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.EB);
                break;
            }
        }
        return strategy;
    }

    public static List<DimInfo> getDimInfo(Long modelSelectId, String dataSrcType, String dataSetNumber, String sourceFrom, String pageDimStr, String hiddenDimStr, String dimensionMap, String extendModelValue) {
        ArrayList dimInfoList = Lists.newArrayListWithExpectedSize((int)12);
        if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
            DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number,name,shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelSelectId)});
            if (Objects.isNull(model)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"DataSetDisplayPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)dataSetNumber)) {
                return Collections.emptyList();
            }
            List dim = EbServiceHelper.getDim((String)model.getString(SHOWNUMBER), (String)dataSetNumber);
            for (EbDim dimInfo : dim) {
                DimInfo dimInfoObject = new DimInfo();
                Long dimId = dimInfo.getId();
                dimInfoObject.setId(dimId);
                dimInfoObject.setDimId(String.valueOf(dimId));
                String dimName = dimInfo.getName();
                dimInfoObject.setName(dimName);
                String number = dimInfo.getNumber();
                dimInfoObject.setNumber(number);
                String shortNumber = dimInfo.getShortNumber();
                dimInfoObject.setShortNumber(shortNumber);
                String memberModel = dimInfo.getMemberModel();
                dimInfoObject.setMemberModel(memberModel);
                dimInfoList.add(dimInfoObject);
            }
        } else {
            DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)modelSelectId);
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelSelectId, modelType.getType());
            List dimensionInfos = modelStrategyEx.getDim().getDimList();
            Map<String, RPTDimType> extendDim = DataSetDisplayUtil.getFilterDim(dimensionInfos, sourceFrom, pageDimStr, hiddenDimStr, dimensionMap, extendModelValue);
            for (DimensionInfo v : dimensionInfos) {
                String shortNumber = v.getShortNumber();
                if (Objects.nonNull(extendDim) && !extendDim.isEmpty() && !extendDim.containsKey(shortNumber)) continue;
                DimInfo dimInfoObject = new DimInfo();
                Long dimId = v.getId();
                dimInfoObject.setId(dimId);
                dimInfoObject.setDimId(String.valueOf(dimId));
                String dimName = v.getName();
                dimInfoObject.setName(dimName);
                String number = v.getNumber();
                dimInfoObject.setNumber(number);
                dimInfoObject.setShortNumber(shortNumber);
                String entityNumber = v.getEntityName();
                dimInfoObject.setMemberModel(entityNumber);
                if (Objects.nonNull(extendDim) && extendDim.containsKey(shortNumber)) {
                    dimInfoObject.setRptDimType(extendDim.get(shortNumber));
                }
                dimInfoList.add(dimInfoObject);
            }
        }
        return dimInfoList;
    }

    public static Map<String, RPTDimType> getFilterDim(List<DimensionInfo> dimensionInfos, String sourceFrom, String pageDimStr, String hiddenDimStr, String dimensionMapStr, String extendModelValue) {
        if (StringUtils.isNotBlank((CharSequence)extendModelValue) && DataSrcTypeEnum.CM_TEMPLATE.getType().equals(sourceFrom)) {
            Map<String, RPTDimType> returnMap = defaultShortNumber.stream().collect(Collectors.toMap(dim -> dim, dim -> RPTDimType.PAGE, (a1, a2) -> a1));
            HashSet pageDimSet = Sets.newHashSetWithExpectedSize((int)8);
            Map<String, String> collect = dimensionInfos.stream().collect(Collectors.toMap(t -> t.getNumber(), t -> t.getShortNumber()));
            if (StringUtils.isNotBlank((CharSequence)pageDimStr)) {
                Map pageDim = (Map)SerializationUtils.fromJsonString((String)pageDimStr, Map.class);
                pageDim.keySet().forEach(key -> pageDimSet.add(collect.get(key)));
            }
            HashSet hiddenDimSet = Sets.newHashSetWithExpectedSize((int)8);
            if (StringUtils.isNotBlank((CharSequence)hiddenDimStr)) {
                List hidden = (List)SerializationUtils.fromJsonString((String)hiddenDimStr, List.class);
                Set hiddenDimsSet = hidden.stream().map(member -> (String)member.get("dimNumber")).collect(Collectors.toSet());
                hiddenDimsSet.stream().forEach(dim -> {
                    if (returnMap.containsKey(collect.get(dim))) {
                        return;
                    }
                    hiddenDimSet.add(collect.get(dim));
                });
            }
            Long extendId = Long.valueOf(extendModelValue);
            Set extendDimSet = DatasetCheckUtil.getOtherExtendsDims((Long)extendId);
            for (String dim2 : extendDimSet) {
                if (returnMap.containsKey(dim2)) continue;
                if (pageDimSet.contains(dim2)) {
                    returnMap.put(dim2, RPTDimType.PAGE);
                    continue;
                }
                if (hiddenDimSet.contains(dim2)) {
                    returnMap.put(dim2, RPTDimType.HIDDEN);
                    continue;
                }
                returnMap.put(dim2, RPTDimType.ROWCOL);
            }
            if (LongUtil.isvalidLong((Object)extendId)) {
                for (String shortNumber : extendDefaultShortNumber) {
                    if (returnMap.containsKey(shortNumber)) continue;
                    returnMap.put(shortNumber, RPTDimType.PAGE);
                }
            }
            return returnMap;
        }
        if (StringUtils.isNotBlank((CharSequence)extendModelValue)) {
            Long extendId = Long.valueOf(extendModelValue);
            return DatasetCheckUtil.getExtendsDims((Long)extendId).stream().collect(Collectors.toMap(dim -> dim, dim -> RPTDimType.None, (a1, a2) -> a1));
        }
        if (!DataSrcTypeEnum.CM_TEMPLATE.getType().equals(sourceFrom)) {
            return Collections.emptyMap();
        }
        Map<String, RPTDimType> returnMap = Sets.newHashSet(defaultShortNumber).stream().collect(Collectors.toMap(dim -> dim, dim -> RPTDimType.PAGE, (a1, a2) -> a1));
        Map<String, String> collect = dimensionInfos.stream().collect(Collectors.toMap(t -> t.getNumber(), t -> t.getShortNumber()));
        if (StringUtils.isNotBlank((CharSequence)pageDimStr)) {
            Map pageDim = (Map)SerializationUtils.fromJsonString((String)pageDimStr, Map.class);
            pageDim.keySet().forEach(key -> returnMap.put((String)collect.get(key), RPTDimType.PAGE));
        }
        if (StringUtils.isNotBlank((CharSequence)hiddenDimStr)) {
            List hidden = (List)SerializationUtils.fromJsonString((String)hiddenDimStr, List.class);
            Set hiddenDimsSet = hidden.stream().map(member -> (String)member.get("dimNumber")).collect(Collectors.toSet());
            hiddenDimsSet.stream().forEach(dim -> {
                if (returnMap.containsKey(collect.get(dim))) {
                    return;
                }
                returnMap.put((String)collect.get(dim), RPTDimType.HIDDEN);
            });
        }
        if (StringUtils.isNotBlank((CharSequence)dimensionMapStr)) {
            Map dimensionMap = (Map)SerializationUtils.fromJsonString((String)dimensionMapStr, Map.class);
            List colList = (List)dimensionMap.get("col");
            List rowList = (List)dimensionMap.get("row");
            ArrayList dimensionList = Lists.newArrayListWithExpectedSize((int)8);
            if (Objects.nonNull(colList)) {
                dimensionList.addAll(colList);
            }
            if (Objects.nonNull(rowList)) {
                dimensionList.addAll(rowList);
            }
            Set dimensionDim = dimensionList.stream().map(member -> (String)member.get("number")).collect(Collectors.toSet());
            dimensionDim.stream().forEach(dim -> {
                if (returnMap.containsKey(collect.get(dim))) {
                    return;
                }
                returnMap.put((String)collect.get(dim), RPTDimType.ROWCOL);
            });
        }
        return returnMap;
    }

    public static List<Map<String, Object>> getMemberList(List<EbMember> dcs, Long dimension) {
        if (dcs == null || dcs.size() == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList menberList = Lists.newArrayListWithExpectedSize((int)7);
        for (EbMember task : dcs) {
            HashMap memberMap = Maps.newHashMapWithExpectedSize((int)7);
            memberMap.put("id", task.getNumber());
            memberMap.put("number", task.getNumber());
            memberMap.put("name", task.getName());
            memberMap.put("dimension", String.valueOf(dimension));
            menberList.add(memberMap);
        }
        return menberList;
    }

    public static List<Map<String, Object>> getMemberList(DynamicObject[] dcs, Long dimension) {
        if (dcs == null || dcs.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList menberList = Lists.newArrayListWithExpectedSize((int)7);
        for (DynamicObject task : dcs) {
            HashMap memberMap = Maps.newHashMapWithExpectedSize((int)7);
            memberMap.put("id", task.get("id").toString());
            memberMap.put("number", task.getString("number"));
            memberMap.put("name", task.getString("name"));
            memberMap.put(DSEQ, task.getString(DSEQ));
            memberMap.put("dimension", String.valueOf(dimension));
            menberList.add(memberMap);
        }
        return menberList;
    }

    public static DynamicObject[] getPresetMemberDoc(Long modelId, Long dimension, String entityName, String search, IFormView view, int page, int size) {
        String orderBys = "longnumber asc,dseq asc";
        String selectFields = "id,name,number,parent,storagetype,longnumber,isleaf,level,dseq";
        QFilter filter1 = new QFilter("dimension", "=", (Object)dimension);
        filter1.and("status", "!=", (Object)OrgStoreStatusEnum.DISABLE.getValue());
        if (!StringUtils.isBlank((CharSequence)search)) {
            QFilter filter = new QFilter("name", "like", (Object)("%" + search + "%")).or("number", "like", (Object)("%" + search + "%"));
            filter1.and(filter);
        }
        DataSetDisplayUtil.filterFyAndPeriod(filter1, entityName);
        if ("bcm_audittrialmembertree".equals(entityName) && AppUtil.isEpmAppId((String)ModelUtil.queryApp(view).getAppnum())) {
            filter1.and(new QFilter("number", "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal")));
        }
        if ("bcm_entitymembertree".equals(entityName) && AppUtil.isEpmAppId((String)view.getFormShowParameter().getAppId())) {
            selectFields = selectFields + ",entitypart.isoffsetentry";
            filter1.and("entitypart.isoffsetentry", "=", (Object)false);
        }
        if (entityName != null) {
            BcmPermService bcmPermService = new BcmPermService(modelId, dimension);
            QFilter filter = bcmPermService.getPermQFilter("id");
            filter1.and(filter);
        }
        QFilter[] filters = new QFilter[]{filter1};
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)page, (int)size);
    }

    public static List<Map<String, Object>> getMemberData(IFormView view, String dataSrcType, Long modelId, Long dimId, String ebDataSet, String number, String entityName, String search, int page, int pageSize) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> memberList = null;
        if (modelId == null || dimId == null) {
            return result;
        }
        if (page < 0) {
            page = 0;
        }
        if (pageSize <= 0) {
            pageSize = 100;
        }
        HashMap dimDefaultMap = new HashMap();
        List checkMember = (List)dimDefaultMap.get(dimId.toString());
        Set<Object> memberNumber = Sets.newHashSetWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty((Collection)checkMember)) {
            memberNumber = checkMember.stream().map(c -> (String)c.get("number")).collect(Collectors.toSet());
        }
        if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
            DynamicObject model = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.EB).getModel(modelId);
            List member = EbServiceHelper.getMember((String)model.getString(SHOWNUMBER), (String)ebDataSet, (String)number, (String)number, (RangeEnum)RangeEnum.VALUE_50);
            memberList = DataSetDisplayUtil.getMemberList(member, dimId);
            if (!StringUtils.isBlank((CharSequence)search)) {
                memberList = memberList.stream().filter(x -> x.get("name").toString().contains(search) || x.get("number").toString().contains(search)).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty((Collection)memberNumber)) {
                List collect = memberList.stream().collect(Collectors.toList());
                result.addAll(collect);
            } else {
                result.addAll(memberList);
            }
        } else {
            if (EXT_SE.equals(entityName)) {
                DimInfo dimInfo = DataSetDisplayUtil.conVertSE(modelId);
                dimId = Long.parseLong(dimInfo.getDimId());
                entityName = dimInfo.getMemberModel();
            }
            DynamicObject[] dcs = DataSetDisplayUtil.getPresetMemberDoc(modelId, dimId, entityName, search, view, page, pageSize);
            memberList = DataSetDisplayUtil.getMemberList(dcs, dimId);
            result.addAll(memberList);
        }
        return result;
    }

    public static DimInfo conVertSE(Long modelId) {
        DimInfo dimInfo = new DimInfo();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, DisModelTypeEnum.CM.getType());
        List dimList = modelStrategyEx.getDim().getDimList();
        if (!dimList.isEmpty()) {
            Optional<DimensionInfo> first = dimList.stream().filter(v -> "E".equals(v.getShortNumber())).findFirst();
            dimInfo.setDimId(String.valueOf(first.get().getId()));
            dimInfo.setMemberModel(first.get().getEntityName());
        }
        return dimInfo;
    }

    public static void filterFyAndPeriod(QFilter filter, String membermodel) {
        if ("bcm_fymembertree".equals(membermodel)) {
            filter.and(new QFilter("number", "not in", (Object)new String[]{"LastYear", "CurrentYear"}));
        }
        if ("bcm_periodmembertree".equals(membermodel)) {
            filter.and(new QFilter("number", "not in", (Object)new String[]{"CurrentPeriod", "LastPeriod", "LastPeriodX"}));
        }
    }

    public static Map<String, List<Map<String, String>>> initDimAndMember(ModelStrategyEx modelStrategyEx, List<DimInfo> dimInfoList, String modelType) {
        DimMemberAdapter dimMember = modelStrategyEx.getDimMember();
        DimMemberInfo ATMemberInfo = dimMember.findMemberByNumber("AuditTrail", "ATTotal");
        HashMap dimAndMember = Maps.newHashMap();
        if (ModelSourceEnum.CM.getType().equals(modelType) || ModelSourceEnum.RPT.getType().equals(modelType)) {
            ArrayList ATMemberList = Lists.newArrayListWithExpectedSize((int)11);
            HashMap ATMember = Maps.newHashMapWithExpectedSize((int)1);
            ATMember.put("shortNumber", DimTypesEnum.AUDITTRIAL.getShortNumber());
            ATMember.put("number", "ATTotal");
            ATMember.put(DSEQ, "1");
            ATMember.put(RANGENAME, RangeEnum.VALUE_10.getName());
            ATMember.put("dimnumber", "AuditTrail");
            ATMember.put("name", ResManager.loadKDString((String)"\u6570\u636e\u6c47\u603b", (String)"DataSetDisplayPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
            ATMember.put(RANGE, "self");
            String ATMemberId = String.valueOf(ATMemberInfo.getId());
            ATMember.put("id", ATMemberId);
            ATMember.put(LABEL, "ATTotal ATTotal");
            ATMember.put("dimension", "bcm_audittrialmembertree");
            ATMemberList.add(ATMember);
            ArrayList BPMemberList = Lists.newArrayListWithExpectedSize((int)11);
            DimMemberInfo BPMemberInfo = dimMember.findMemberByNumber("Process", "Rpt");
            HashMap BPMember = Maps.newHashMapWithExpectedSize((int)1);
            BPMember.put("shortNumber", DimTypesEnum.PROCESS.getShortNumber());
            BPMember.put("number", "Rpt");
            BPMember.put(DSEQ, "1");
            BPMember.put(RANGENAME, RangeEnum.VALUE_10.getName());
            BPMember.put("dimnumber", DimTypesEnum.PROCESS.getNumber());
            BPMember.put("name", ResManager.loadKDString((String)"\u62a5\u8868\u8c03\u6574\u540e", (String)"DataSetDisplayPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
            BPMember.put(RANGE, "self");
            String BPMemberId = String.valueOf(BPMemberInfo.getId());
            BPMember.put("id", BPMemberId);
            BPMember.put(LABEL, "Rpt Rpt");
            BPMember.put("dimension", "bcm_processmembertree");
            BPMemberList.add(BPMember);
            dimAndMember.put(DimTypesEnum.AUDITTRIAL.getShortNumber(), ATMemberList);
            dimAndMember.put(DimTypesEnum.PROCESS.getShortNumber(), BPMemberList);
        }
        ArrayList memberList = Lists.newArrayListWithExpectedSize((int)11);
        dimInfoList.forEach(dim -> {
            String shorNumber = dim.getShortNumber();
            if (ModelSourceEnum.CM.getType().equals(modelType) || ModelSourceEnum.RPT.getType().equals(modelType)) {
                if (!DimTypesEnum.AUDITTRIAL.getShortNumber().equals(shorNumber) && !DimTypesEnum.PROCESS.getShortNumber().equals(shorNumber)) {
                    dimAndMember.put(shorNumber, memberList);
                }
            } else if (ModelSourceEnum.EB.getType().equals(modelType)) {
                dimAndMember.put(shorNumber, memberList);
            }
        });
        return dimAndMember;
    }

    public static void buildPropertys(List<CheckTreeNodeInfo> showList, List<DatasetPropertyVo> propertyVos) {
        for (CheckTreeNodeInfo checkTreeNodeInfo : showList) {
            if (!checkTreeNodeInfo.getId().contains(SPLITSYMBOL)) {
                DatasetPropertyVo vo = new DatasetPropertyVo();
                vo.setId(checkTreeNodeInfo.id);
                vo.setType(Integer.valueOf(ColumnTypeEnum.MEASURE.getCode()));
                vo.setName(checkTreeNodeInfo.text);
                vo.setNumber(checkTreeNodeInfo.id);
                propertyVos.add(vo);
                continue;
            }
            String checkNodeId = checkTreeNodeInfo.getId();
            if (!checkNodeId.contains(SPLITSYMBOL)) continue;
            String[] split = checkNodeId.split(SPLITSYMBOL);
            DatasetPropertyVo vo = new DatasetPropertyVo();
            vo.setId(checkTreeNodeInfo.id);
            String memberNameOrNum = split[2];
            if ("name".equals(memberNameOrNum) || "number".equals(memberNameOrNum)) {
                vo.setType(Integer.valueOf(Integer.parseInt(split[4])));
                vo.setSource(split[3]);
                vo.setNumber(split[2]);
            } else {
                vo.setNumber(split[3]);
                vo.setSource(split[4]);
                vo.setType(Integer.valueOf(Integer.parseInt(split[5])));
            }
            if (Objects.equals(vo.getType(), ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode())) {
                vo.setName(checkTreeNodeInfo.text.split("-")[1]);
            } else {
                vo.setName(checkTreeNodeInfo.text);
            }
            vo.setName(checkTreeNodeInfo.text);
            propertyVos.add(vo);
        }
    }

    public static Map<String, List<Map<String, Object>>> conversionTreeData(List<CheckTreeNodeInfo> select) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)7);
        List collect = select.stream().map(c -> {
            boolean isParent = c.isParent();
            if (isParent || "".equals(c.getParentid())) {
                c.setParentid(c.getId());
            }
            return c;
        }).collect(Collectors.toList());
        ArrayList propertyVos = Lists.newArrayListWithExpectedSize((int)16);
        Map groupbyMap = collect.stream().collect(Collectors.groupingBy(c -> c.getParentid(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : groupbyMap.entrySet()) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            String dimId = entry.getKey().toString();
            map.put(DIMID, dimId);
            List value = (List)entry.getValue();
            List<CheckTreeNodeInfo> showList = value.stream().filter(c -> !c.isParent()).collect(Collectors.toList());
            if (showList.size() > 0) {
                DataSetDisplayUtil.buildPropertys(showList, propertyVos);
                map.put("input", propertyVos);
            }
            list.add(map);
        }
        result.put(DIMLIST, list);
        return result;
    }

    public static DimInfo getDimInfo(Long dimId, String dataSrcType, Long modelId, Object dataSet) {
        DimInfo ebDim = new DimInfo();
        if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
            DynamicObject dynamicObject = EBDimensionHelper.getEbDimInfoByModelIdAndDimId((long)modelId, (long)dimId, (String)dataSet.toString());
            if (dynamicObject != null) {
                ebDim.setId(Long.valueOf(dynamicObject.getLong("id")));
                ebDim.setDimId(String.valueOf(dimId));
                ebDim.setName(dynamicObject.getString("name"));
                ebDim.setNumber(dynamicObject.getString("number"));
                ebDim.setShortNumber(dynamicObject.getString("shortnumber"));
                ebDim.setMemberModel(dynamicObject.getString("membermodel"));
            }
        } else {
            DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)modelId);
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, modelType.getType());
            List dimensionInfos = modelStrategyEx.getDim().getDimList();
            DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)dimensionInfos, (Long)dimId);
            if (dimensionInfo != null) {
                ebDim.setId(dimensionInfo.getId());
                ebDim.setDimId(String.valueOf(dimensionInfo.getId()));
                ebDim.setName(dimensionInfo.getName());
                ebDim.setNumber(dimensionInfo.getNumber());
                ebDim.setShortNumber(dimensionInfo.getShortNumber());
                ebDim.setMemberModel(dimensionInfo.getEntityName());
            }
        }
        return ebDim;
    }

    public static List<Map<String, Object>> setDataInit(IFormView view, Map<String, String> extSelects, List<DimInfo> selectDimInfoList, Long modelSelectId, String ebDataSet, String dataSrcType, Map<String, List<Map<String, String>>> dimAndMember, DatasetDto dataSetDto) {
        DatasetDataVo datasetDataVo;
        HashMap columns = Maps.newHashMapWithExpectedSize((int)16);
        if (StringUtils.isNotBlank((CharSequence)dataSetDto.getData()) && CollectionUtils.isNotEmpty((Collection)(datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dataSetDto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0])).getColumns())) {
            columns.putAll(datasetDataVo.getColumns().stream().collect(Collectors.groupingBy(DatasetPropertyVo::getSource)));
        }
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)11);
        selectDimInfoList.forEach(dim -> {
            HashMap responseData = Maps.newHashMapWithExpectedSize((int)6);
            Long dimId = dim.getId();
            responseData.put("dimInfo", dim);
            responseData.put("input", columns.get(dim.getNumber()));
            String dimNumber = dim.getNumber();
            String memberModel = dim.getMemberModel();
            List<Map<String, Object>> memberData = DataSetDisplayUtil.getMemberData(view, dataSrcType, modelSelectId, dimId, ebDataSet, dimNumber, memberModel, "", 0, 100);
            responseData.put("member", memberData);
            responseData.put(RANGE, DataSetDisplayUtil.getRangeData(dataSrcType));
            String shortNumber = dim.getShortNumber();
            List memeberList = (List)dimAndMember.get(shortNumber);
            responseData.put("default", memeberList.stream().filter(t -> !DatasetSpecialVarHelper.isEqualsCurVar((String)((String)t.get("number")))).collect(Collectors.toList()));
            dimList.add(responseData);
        });
        if (LongUtil.isvalidLong((Object)dataSetDto.getExtendsModelId())) {
            HashMap responseData = Maps.newHashMapWithExpectedSize((int)6);
            DimInfo dimInfo = new DimInfo();
            dimInfo.setNumber(EXTEND);
            dimInfo.setName(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4", (String)"DataSetDisplayPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            responseData.put("dimInfo", dimInfo);
            String extendValue = dataSetDto.getValue();
            if (StringUtils.isBlank((CharSequence)extendValue)) {
                return dimList;
            }
            List propertyVos = (List)columns.get(EXTEND);
            HashSet extendsMember = Sets.newHashSetWithExpectedSize((int)16);
            if (CollectionUtils.isNotEmpty((Collection)propertyVos)) {
                extendsMember.addAll(propertyVos.stream().map(DatasetPropertyVo::getNumber).collect(Collectors.toList()));
            } else {
                propertyVos = Lists.newArrayListWithExpectedSize((int)16);
            }
            for (String s : extendValue.split(",")) {
                if (extendsMember.contains(s)) continue;
                DatasetPropertyVo propertyVo = new DatasetPropertyVo();
                propertyVo.setId(s);
                propertyVo.setNumber(s);
                propertyVo.setType(Integer.valueOf(ColumnTypeEnum.MEASURE.getCode()));
                propertyVo.setSource(EXTEND);
                if (Objects.nonNull(extSelects)) {
                    propertyVo.setName(extSelects.get(s));
                }
                propertyVos.add(propertyVo);
            }
            responseData.put("input", propertyVos);
            dimList.add(responseData);
        }
        return dimList;
    }

    public static void setDataVo(DatasetDto datasetDto, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        List datas = (List)JSON.parseObject((String)jsonObject.getString("custom"), (TypeReference)new TypeReference<List<DatasetPropertyVo>>(){}, (Feature[])new Feature[0]);
        List collect = datas.stream().filter(v -> "SourceEntity".equals(v.getSource())).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            datasetDto.setHasSourceOrg(true);
        }
        DatasetDataVo datasetDataVo = new DatasetDataVo();
        datasetDataVo.setColumns(datas);
        Long metadataId = datasetDto.getMetadataId();
        String metadataType = datasetDto.getMetadataType();
        DatasetMetadataVo datasetMetadataVo = new DatasetMetadataVo();
        datasetMetadataVo.setMetadataId(metadataId);
        datasetMetadataVo.setMetadataType(metadataType);
        datasetDataVo.setMetadata(datasetMetadataVo);
        DatasetVoucherVo datasetVoucherVo = new DatasetVoucherVo();
        datasetVoucherVo.setId(datasetDto.getVoucherId());
        datasetVoucherVo.setVoucherNumber(datasetDto.getVoucherNumber());
        datasetVoucherVo.setVoucherType(datasetDto.getVoucherType());
        datasetDataVo.setDatasetVoucherVo(datasetVoucherVo);
        DatasetTemplateVo templateVo = new DatasetTemplateVo();
        templateVo.setTemplateId(datasetDto.getTemplateId());
        templateVo.setArea(datasetDto.getArea());
        datasetDataVo.setTemplate(templateVo);
        datasetDto.setData(JSON.toJSONString((Object)datasetDataVo));
    }

    public static boolean isCMTemplate(IDataModel model) {
        String dataSrcType = (String)model.getValue(SOURCEFROM);
        return Objects.equals(dataSrcType, DataSrcTypeEnum.MERGE_MODEL.getType()) && DatasetModelTypeEnum.TEMPLATE.getIndex().equals(model.getValue(TYPESELECT));
    }
}

