/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.config.ConfigServiceHelper;
import kd.epm.far.business.common.perm.FarFunPermissionHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.CurrencyEnum;
import kd.epm.far.common.common.util.QFBuilder;

public class ModelUtil {
    public static final Set<String> CM_VIEW_LIST = Sets.newHashSet((Object[])new String[]{"bcm_report_list", "bcm_report_search", "bcm_user_assignperm", "bcm_user_assignrole", "bcm_systemperm_report", "bcm_roleorguser", "report_card_financialdata", "perm_user_assigndisfun", "bcm_functionperm_log", "bcm_chkspeechlist", "bcm_datacollection", "bcm_analyticssolutiondata"});
    private static final String APP_HOME = "apphome";
    private static final String REPORT_TYPE = "ReportType";
    private static final String PARENTFORMID = "parentFormId";
    private static final Map<String, String> PAGE_MAP = new HashMap<String, String>(10);
    private static final List<String> NEED_ADMIN_FORM = Lists.newArrayList((Object[])new String[]{"fidm_user_assignperm", "fidm_user_assignrole", "fidm_roleuserorg", "fidm_roleorguser"});

    public static ApplicationTypeEnum queryApp(IFormView view) {
        ApplicationTypeEnum application = ApplicationTypeEnum.CM;
        String formNumber = ((FormView)view).getFormId();
        String appnumber = view.getFormShowParameter().getAppId();
        if ("far_cardapphome_bcm".equals(formNumber)) {
            appnumber = "far";
        }
        if (StringUtils.isEmpty((String)appnumber)) {
            return application;
        }
        return ApplicationTypeEnum.getEnumByNumber((String)appnumber);
    }

    public static List<QFilter> getDmModelFilter(IFormView view) {
        ApplicationTypeEnum app = ModelUtil.queryApp(view);
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        if (app == ApplicationTypeEnum.FAR) {
            modelQFilters.add(new QFilter("apptype", "in", (Object)Lists.newArrayList((Object[])new String[]{"3", "2"})));
        } else {
            modelQFilters.add(new QFilter("apptype", "in", (Object)Lists.newArrayList((Object[])new String[]{"3", "1"})));
        }
        modelQFilters.add(new QFilter("status", "=", (Object)"1"));
        if (ModelUtil.needAdmin(view)) {
            String appNumber = view.getFormShowParameter().getAppId();
            modelQFilters.add(new QFilter("id", "in", (Object)MemberPermHelper.getDisModelAdmin((String)appNumber)));
            return modelQFilters;
        }
        HasPermDimObjResult result = ModelUtil.getHasPermModel(app);
        if (result != null) {
            if (result.hasAllDimObjPerm()) {
                return modelQFilters;
            }
            modelQFilters.add(new QFilter("id", "in", (Object)result.getHasPermDimObjs()));
        }
        return modelQFilters;
    }

    public static List<QFilter> getFarPubModelFilter(IFormView view) {
        ArrayList modelQFilters = Lists.newArrayListWithExpectedSize((int)4);
        modelQFilters.add(new QFilter("apptype", "in", (Object)Lists.newArrayList((Object[])new String[]{"3", "2"})));
        modelQFilters.add(new QFilter("status", "=", (Object)"1"));
        if (ModelUtil.needAdmin(view)) {
            modelQFilters.add(new QFilter("id", "in", (Object)MemberPermHelper.getDisModelAdmin((String)ApplicationTypeEnum.FAR.getAppnum())));
            return modelQFilters;
        }
        HasPermDimObjResult result = ModelUtil.getHasPermModel(ApplicationTypeEnum.FAR);
        if (Objects.nonNull(result)) {
            if (result.hasAllDimObjPerm()) {
                return modelQFilters;
            }
            modelQFilters.add(new QFilter("id", "in", (Object)result.getHasPermDimObjs()));
        }
        return modelQFilters;
    }

    public static List<QFilter> getModelFilter(IFormView view) {
        QFilter qf = ModelUtil.getModelQfilterByApp(view);
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        modelQFilters.add(qf);
        if (view.getParentView() != null) {
            if (!"bcm_card_myvalue".equals(view.getParentView().getEntityId()) && !"bcm_upgrademanage".equals(view.getParentView().getEntityId())) {
                QFilter upgradedid = new QFilter("id", "in", ModelUtil.getUpgradesModelIds());
                modelQFilters.add(upgradedid);
            }
            if ("bcm_user_assignperm".equals(view.getParentView().getEntityId())) {
                Set ids = MemberPermHelper.getLimitedModelListByUser();
                modelQFilters.add(new QFilter("id", "in", (Object)ids));
            } else {
                QFilter qFilter = null;
                qFilter = view.getFormShowParameter().getCustomParams().containsKey(PARENTFORMID) ? new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser((String)((String)view.getFormShowParameter().getCustomParam(PARENTFORMID)), (ApplicationTypeEnum)ModelUtil.queryApp(view))) : new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
                if ("bcm_memberperm_view".equals(view.getEntityId()) && !ConfigServiceHelper.getGlobalBoolParam((String)"isPEnableGrantPerm")) {
                    modelQFilters.add(qFilter);
                    return modelQFilters;
                }
                QFilter haspermid = new QFilter("id", "in", (Object)FarFunPermissionHelper.getEffectiveByPermModel((String)view.getEntityId(), (ApplicationTypeEnum)ModelUtil.queryApp(view)));
                ModelUtil.addSpecialFilter(view.getEntityId(), qFilter, view);
                if (CM_VIEW_LIST.contains(view.getEntityId())) {
                    QFilter perRoleIds = new QFilter("id", "in", (Object)FarFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)ApplicationTypeEnum.CM, (String)view.getEntityId(), (String)"47150e89000000ac"));
                    qFilter.or(perRoleIds);
                }
                modelQFilters.add(qFilter.or(haspermid));
            }
        }
        return modelQFilters;
    }

    private static Set<Object> getUpgradesModelIds() {
        QFBuilder qb = new QFBuilder("number", "=", (Object)CurrencyEnum.DC.getNumber());
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id,number,model", (QFilter[])qb.toArray());
        Set<Object> ids = ModelUtil.getFieldSet(records, "model");
        return ids;
    }

    private static Set<Object> getFieldSet(DynamicObjectCollection doc, String field) {
        HashSet set = Sets.newHashSet();
        for (DynamicObject dy : doc) {
            set.add(dy.get(field));
        }
        return set;
    }

    private static void addSpecialFilter(String entryId, QFilter superId, IFormView view) {
        if (PAGE_MAP.containsKey(entryId)) {
            entryId = PAGE_MAP.get(entryId);
        }
        QFilter roleIds = new QFilter("id", "in", (Object)FarFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)ModelUtil.queryApp(view), (String)entryId, (String)"47150e89000000ac"));
        superId.or(roleIds);
    }

    private static boolean needAdmin(IFormView view) {
        IFormView parentViewNoPlugin = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (Objects.isNull(parentViewNoPlugin)) {
            return false;
        }
        return NEED_ADMIN_FORM.contains(parentViewNoPlugin.getEntityId());
    }

    public static QFilter getModelQfilterByApp(IFormView view) {
        ApplicationTypeEnum application = ModelUtil.queryApp(view);
        QFilter qcf = new QFilter(REPORT_TYPE, "=", (Object)application.getOIndex());
        switch (application) {
            case RPT: {
                qcf = FarFunPermissionHelper.getRptAdminModelQFilter();
                IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
                if (!CM_VIEW_LIST.contains(view.getEntityId()) && (parentView == null || !CM_VIEW_LIST.contains(parentView.getEntityId()) && !APP_HOME.contains(parentView.getEntityId()))) break;
                qcf.or(new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.CM.getOIndex()));
                break;
            }
            case IEP: 
            case DI: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.CM.getOIndex());
                break;
            }
            case BGM: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
            case EB: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.EB.getOIndex());
                break;
            }
            case BGC: 
            case BGBD: {
                qcf = new QFilter(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.EB.getOIndex()).or(REPORT_TYPE, "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
        }
        return qcf;
    }

    public static HasPermDimObjResult getHasPermModel(ApplicationTypeEnum app) {
        HasPermDimObjResult result;
        try {
            Class<?> version = Class.forName("kd.bos.permission.cache.UserHasPermDimObjCache");
            Method newVersionMethod = version.getDeclaredMethod("getUserHasPermDimObjs", Long.TYPE, String.class, String.class);
            result = (HasPermDimObjResult)newVersionMethod.invoke((Object)new UserHasPermDimObjCache(), RequestContext.get().getCurrUserId(), app.getAppnum(), "fidm_model");
        }
        catch (NoSuchMethodException exc) {
            result = PermissionServiceHelper.getUserHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"fidm_model");
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    static {
        PAGE_MAP.put("bcm_query_mainpage", "bcm_dimensionmanager");
        PAGE_MAP.put("bcm_bdmapping", "bcm_dimensionmanager");
        PAGE_MAP.put("bcm_sycndimensionmember", "bcm_dimensionmanager");
        PAGE_MAP.put("bcm_showprogress", "bcm_mergecontrollist");
        PAGE_MAP.put("bcm_mergeoperationlog", "bcm_mergecontrollist");
        PAGE_MAP.put("bcm_analyticssolutionlist", "bcm_analyticssolutiondata");
        PAGE_MAP.put("bcm_extendsmodel_list", "bcm_dimensionmanager");
    }
}

