/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.variable;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.bcm.f7.BasedataEditSingleMemberF7BCM;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.business.common.variable.dto.Variable;
import kd.epm.far.business.common.variable.dto.VariableEnum;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogUtil;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.DateTimeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;

public class VariableEditPlugin
extends AbstractBaseDMFormPlugin
implements BeforeF7SelectListener {
    public static final String disc_model = "model";
    public static final String advconap = "advconap";
    public static final String valuetype = "valuetype";
    public static final String ctl_entryentity = "entryentity";
    public static final String isdefault = "isdefault";
    public static final String KEY_DISC_MODEL_ID = "DISC_MODEL_ID";
    public static final String hintap = "hintap";
    public static final String defaultvalue = "defaultvalue";
    public static final String textareavalue = "textareavalue";
    public static final String decimalvalue = "decimalvalue";
    public static final String datevalue = "datevalue";
    public static final String dimmembertype = "dimmembertype";
    public static final String membervalue = "membervalue";
    public static final String disc_dim = "disc_dim";
    public static final String VAR_SCOP = "varscop";
    public static final String VAR_CHAPTERID = "chapterid";
    public static final String KEY_ALL_DIM_ENTITY_MAP = "key_all_dim_entity_map";
    private static final String CREATE_MODIFY_LOG = "CREATE_MODIFY_LOG";
    private static final String[] identifierEnable = new String[]{"number", "name", "describe", "valuetype", "disc_dim", "dimmembertype", "membervalue"};
    private static final String[] identifierVisible = new String[]{"btn_save", "btn_addnew", "describe"};

    @Override
    public void initialize() {
        super.initialize();
        this.getPlugin().getView().addCustomControls(new String[]{membervalue});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap", advconap);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getPageCache().get("KEY_MODEL_ID"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        if (beforeF7SelectEvent.getSource() instanceof BasedataEditSingleMemberF7BCM && membervalue.equals(((BasedataEditSingleMemberF7BCM)beforeF7SelectEvent.getSource()).getKey())) {
            QFilter qFilter = new QFilter(disc_model, "=", (Object)this.getSourceModelId());
            ((BasedataEditSingleMemberF7BCM)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
            filterList.add(qFilter);
            beforeF7SelectEvent.setCustomQFilters(filterList);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().equals(membervalue)) {
            String dimId = (String)this.getValue(disc_dim);
            if (StringUtils.isEmpty((CharSequence)dimId)) {
                return;
            }
            Long modelId = this.getSourceModelId();
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            DimensionInfo dim = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(), (Long)LongUtil.toLong((Object)dimId));
            BasedataEdit f7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dim, e.getKey(), null, false, "");
            e.setControl((Control)f7);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getPageCache().put("isNew", "true");
        }
        String discModelId = (String)this.getFormCustomParam(KEY_DISC_MODEL_ID);
        this.getModel().setValue(disc_model, (Object)discModelId);
        this.getPageCache().put(KEY_DISC_MODEL_ID, discModelId);
        this.getPageCache().put("KEY_MODEL_ID", discModelId);
        this.getModel().setValue("scope", (Object)this.getFormCustomParam(VAR_SCOP, "1"));
        this.getModel().setValue(VAR_CHAPTERID, (Object)this.getFormCustomParam(VAR_CHAPTERID, 0));
        this.initControlVisibleByType();
        this.initDimInfo();
        this.getView().setVisible(Boolean.FALSE, new String[]{"permclass"});
    }

    private void initDimInfo() {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getSourceModelId());
        List dims = modelStrategyEx.getDim().getDimList();
        HashMap<String, String> dimMap = new HashMap<String, String>(16);
        ComboEdit comboEdit = (ComboEdit)this.getControl(disc_dim);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (DimensionInfo dim : dims) {
            String comboName = dim.getName();
            comboItems.add(new ComboItem(new LocaleString(comboName), dim.getId().toString()));
            dimMap.put(dim.getId().toString(), dim.getEntityName());
        }
        comboEdit.setComboItems(comboItems);
        this.getView().updateView(disc_dim);
        this.getPageCache().put(KEY_ALL_DIM_ENTITY_MAP, SerializationUtils.toJsonString(dimMap));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String discModelId = (String)this.getFormCustomParam(KEY_DISC_MODEL_ID);
        this.getModel().setValue(disc_model, (Object)discModelId);
        this.getPageCache().put(KEY_DISC_MODEL_ID, discModelId);
        this.getPageCache().put("KEY_MODEL_ID", discModelId);
        this.getModel().setValue("scope", (Object)this.getFormCustomParam(VAR_SCOP, "1"));
        this.getModel().setValue(VAR_CHAPTERID, (Object)this.getFormCustomParam(VAR_CHAPTERID, 0));
        this.initControlVisibleByType();
        this.initDimInfo();
        this.initDefaultValueByType();
        this.getView().setVisible(Boolean.FALSE, new String[]{"permclass"});
        this.getModel().setDataChanged(false);
        this.getView().setEnable(Boolean.valueOf((Boolean)VariableService.isVariableUsed((Long)Long.valueOf((long)this.getModel().getDataEntity().getLong((String)"id")), (String)"").p1 == false), new String[]{"number"});
        this.getModel().setValue(hintap, (Object)ResManager.loadKDString((String)"\u4f8b\u5982\uff0c\u82e5\u53d8\u91cf\u503c\u4e3a P.{M_M01;M_M02}\uff0c\u5728\u8fdb\u884c\u6570\u636e\u96c6\u5168\u5c40\u53d8\u91cf\u586b\u5145\u65f6\u9009\u62e9\u8be5\u5168\u5c40\u53d8\u91cf\uff0c\u53d8\u91cf\u503c\u80fd\u591f\u4f20\u5165\u6570\u636e\u96c6\u516c\u5f0f\uff0c\u671f\u95f4\u7ef4\u5ea6\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a1 \u6708\u30012 \u6708\u3002 \u6587\u672c\u7c7b\u578b\u5168\u5c40\u53d8\u91cf\u547d\u540d\u89c4\u8303\u4e3a\"\u5b57\u6bb5\u7b80\u7801.{\u5b57\u6bb5\u6210\u54581\u7f16\u7801;\u5b57\u6bb5\u6210\u54582\u7f16\u7801\uff1b\u2026}\u3002", (String)"VariableEditPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if (DmVariableTypeEnum.DIM.getIndex().equals(this.getModel().getValue(valuetype))) {
            this.getView().setEnable(Boolean.FALSE, identifierEnable);
            this.getView().setVisible(Boolean.FALSE, identifierVisible);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7c7b\u578b\u7684\u5168\u5c40\u53d8\u91cf\u4e0d\u518d\u652f\u6301\u65b0\u589e\u548c\u66f4\u65b0\uff0c\u8bf7\u65b0\u5efa\u6587\u672c\u7c7b\u578b\u5168\u5c40\u53d8\u91cf\u4ee3\u66ff\u3002", (String)"VariableEditPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.actionSave(false);
                break;
            }
            case "btn_addnew": {
                this.actionSave(true);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Date value;
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (valuetype.equals(keyName)) {
            this.getModel().setValue(defaultvalue, (Object)"");
            this.initControlVisibleByType();
        }
        if (textareavalue.equals(keyName)) {
            this.getModel().setValue(defaultvalue, this.getValue(keyName));
        }
        if (decimalvalue.equals(keyName)) {
            this.getModel().setValue(defaultvalue, this.getValue(keyName));
        }
        if (datevalue.equals(keyName) && (value = (Date)this.getValue(keyName)) != null) {
            this.getModel().setValue(defaultvalue, (Object)DateTimeUtils.format((Date)value, (String)"yyyy-MM-dd"));
        }
        if (membervalue.equals(keyName) && (value = (DynamicObject)this.getValue(keyName)) != null) {
            this.getModel().beginInit();
            this.getModel().setValue(defaultvalue, (Object)value.getString("id"));
            this.getModel().endInit();
        }
        if (isdefault.equals(keyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            EntryGrid entryentity = (EntryGrid)this.getControl(ctl_entryentity);
            if (((Boolean)changeData.getNewValue()).booleanValue()) {
                this.getModel().beginInit();
                this.getModel().setValue(defaultvalue, (Object)changeData.getDataEntity().getString("enum_number"));
                for (int row = 0; row < entryentity.getEntryData().getDataEntitys().length; ++row) {
                    if (changeData.getRowIndex() == row) continue;
                    this.getModel().setValue(isdefault, (Object)Boolean.FALSE, row);
                }
                this.getModel().endInit();
                this.getView().updateView(ctl_entryentity);
            }
        }
        if (disc_dim.equals(keyName)) {
            String discDimid = (String)this.getModel().getValue(disc_dim);
            String dimMapStr = this.getPageCache().get(KEY_ALL_DIM_ENTITY_MAP);
            if (dimMapStr != null && kd.bos.util.StringUtils.isNotEmpty((String)discDimid)) {
                Map dimMap = (Map)SerializationUtils.fromJsonString((String)dimMapStr, Map.class);
                this.getModel().setValue(dimmembertype, dimMap.get(discDimid));
            }
        }
    }

    private void setDefaultValeBeforeSave() {
        DynamicObject find;
        DynamicObject dynamicObject;
        DynamicObjectCollection entryentity;
        String valuetype = (String)this.getValue(valuetype);
        if (DmVariableTypeEnum.TEXT.getIndex().equals(valuetype)) {
            this.getModel().setValue(defaultvalue, this.getValue(textareavalue));
        } else if (DmVariableTypeEnum.NUM.getIndex().equals(valuetype)) {
            this.getModel().setValue(defaultvalue, this.getValue(decimalvalue));
        } else if (DmVariableTypeEnum.DATE.getIndex().equals(valuetype)) {
            Date value = (Date)this.getValue(datevalue);
            if (value != null) {
                this.getModel().setValue(defaultvalue, (Object)DateTimeUtils.format((Date)value, (String)"yyyy-MM-dd"));
            }
        } else if (DmVariableTypeEnum.DIM.getIndex().equals(valuetype)) {
            DynamicObject value = (DynamicObject)this.getValue(membervalue);
            if (value != null) {
                this.getModel().beginInit();
                this.getModel().setValue(defaultvalue, (Object)value.getString("id"));
                this.getModel().endInit();
            }
        } else if (DmVariableTypeEnum.ENUM.getIndex().equals(valuetype) && Objects.nonNull(entryentity = (dynamicObject = this.getModel().getDataEntity(true)).getDynamicObjectCollection(ctl_entryentity)) && entryentity.size() > 0 && Objects.nonNull(find = (DynamicObject)entryentity.stream().filter(x -> x.getBoolean(isdefault)).findAny().orElse(null)) && StringUtils.isNotEmpty((CharSequence)find.getString("enum_number"))) {
            this.getModel().setValue(defaultvalue, (Object)find.getString("enum_number"));
        }
    }

    private void initDefaultValueByType() {
        String valuetype = (String)this.getValue(valuetype);
        String defaultvalue = (String)this.getValue(defaultvalue);
        if (DmVariableTypeEnum.TEXT.getIndex().equals(valuetype)) {
            this.getModel().setValue(textareavalue, (Object)defaultvalue);
        } else if (DmVariableTypeEnum.NUM.getIndex().equals(valuetype)) {
            this.getModel().setValue(decimalvalue, (Object)defaultvalue);
        } else if (DmVariableTypeEnum.DATE.getIndex().equals(valuetype)) {
            Date date = new Date();
            try {
                date = DateTimeUtils.parseDate((String)defaultvalue, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                AbstractBaseFormPlugin.log.error(String.format("VariableEditPlugin.initDefaultValueByType DateTimeUtils parseDate error: %s ", e));
            }
            this.getModel().setValue(datevalue, (Object)date);
        } else if (DmVariableTypeEnum.DIM.getIndex().equals(valuetype)) {
            this.getModel().setValue(membervalue, (Object)defaultvalue);
        } else if (DmVariableTypeEnum.ENUM.getIndex().equals(valuetype)) {
            // empty if block
        }
    }

    private void initControlVisibleByType() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{defaultvalue, dimmembertype});
        Container container = (Container)this.getControl(advconap);
        container.setCollapse(false);
        String valtype = (String)this.getValue(valuetype);
        this.getView().setVisible(Boolean.valueOf(DmVariableTypeEnum.ENUM.getIndex().equals(valtype)), new String[]{advconap});
        this.getView().setVisible(Boolean.valueOf(DmVariableTypeEnum.TEXT.getIndex().equals(valtype)), new String[]{textareavalue, hintap});
        this.getView().setVisible(Boolean.valueOf(DmVariableTypeEnum.NUM.getIndex().equals(valtype)), new String[]{decimalvalue});
        this.getView().setVisible(Boolean.valueOf(DmVariableTypeEnum.DATE.getIndex().equals(valtype)), new String[]{datevalue});
        this.getView().setVisible(Boolean.valueOf(DmVariableTypeEnum.DIM.getIndex().equals(valtype)), new String[]{membervalue, disc_dim});
        DynamicObject dm = (DynamicObject)this.getModel().getValue(disc_model);
        if (DisModelTypeEnum.EB.getType().equals(dm.getString("modeltype"))) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(valuetype);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            comboItems.add(new ComboItem(new LocaleString(DmVariableTypeEnum.TEXT.getName()), DmVariableTypeEnum.TEXT.getIndex()));
            comboItems.add(new ComboItem(new LocaleString(DmVariableTypeEnum.NUM.getName()), DmVariableTypeEnum.NUM.getIndex()));
            comboItems.add(new ComboItem(new LocaleString(DmVariableTypeEnum.DATE.getName()), DmVariableTypeEnum.DATE.getIndex()));
            comboEdit.setComboItems(comboItems);
            this.getView().updateView(valuetype);
        }
    }

    private void actionSave(boolean isContinue) {
        boolean recordOplog;
        this.setDefaultValeBeforeSave();
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        AnalysisOpLogParam logParam = AnalysisOpLogUtil.getLogParamFromView((IFormView)this.getView().getParentView(), (String)CREATE_MODIFY_LOG);
        boolean bl = recordOplog = OperationCategory.UNDEFINED != logParam.getSubject();
        if (this.checkDataBeforeSave(dynamicObject, isContinue)) {
            if (this.saveData(dynamicObject) && recordOplog) {
                logParam.buildOpResult(OperationResult.SUCCESS).appendFormatParams(new Object[]{dynamicObject.getString("number")});
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            } else if (recordOplog) {
                logParam.buildOpResult(OperationResult.FAILURE).appendFormatParams(new Object[]{dynamicObject.getString("number")});
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            }
            if (isContinue) {
                this.getModel().createNewData();
                this.getModel().setValue(disc_model, this.getFormCustomParam(KEY_DISC_MODEL_ID));
                this.getModel().setValue("scope", (Object)this.getFormCustomParam(VAR_SCOP, "1"));
                this.getModel().setValue(VAR_CHAPTERID, (Object)this.getFormCustomParam(VAR_CHAPTERID, 0));
                this.getView().updateView();
                this.getModel().setDataChanged(false);
                this.getPageCache().put("isNew", "true");
            } else {
                this.returnDataToParent("OK");
                this.getView().close();
            }
        } else if (recordOplog) {
            logParam.buildOpResult(OperationResult.FAILURE).appendFormatParams(new Object[]{dynamicObject.getString("number"), dynamicObject.getString("name")});
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
    }

    private boolean checkDataBeforeSave(DynamicObject dynamicObject, boolean isContinue) {
        DynamicObjectCollection entryentity;
        Long id = dynamicObject.getLong("id");
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        String valuetype = dynamicObject.getString(valuetype);
        String dimid = dynamicObject.getString(disc_dim);
        String defaultvalue = dynamicObject.getString(defaultvalue);
        String scope = dynamicObject.getString("scope");
        String chapterid = dynamicObject.getString(VAR_CHAPTERID);
        Variable variable = new Variable();
        variable.setId(id.longValue());
        variable.setNumber(number);
        variable.setName(name);
        variable.setDefaultValue(defaultvalue);
        variable.setScope(scope);
        variable.setChapterId(TypeUtils.convertValueToLong((Object)chapterid).longValue());
        variable.setType(valuetype);
        variable.setDimId(TypeUtils.convertToLong((Object)dimid).longValue());
        ArrayList<VariableEnum> variableEnums = new ArrayList<VariableEnum>(10);
        if (DmVariableTypeEnum.ENUM.getIndex().equals(valuetype) && (entryentity = dynamicObject.getDynamicObjectCollection(ctl_entryentity)) != null && entryentity.size() > 0) {
            int index = 0;
            for (DynamicObject dy : entryentity) {
                VariableEnum item = new VariableEnum();
                item.setNumber(dy.getString("enum_number"));
                item.setName(dy.getString("enum_name"));
                item.setDseq(++index);
                item.setIsDefault(dy.getBoolean(isdefault));
                variableEnums.add(item);
            }
        }
        variable.setEnums(variableEnums);
        ResultInfo resultInfo = VariableService.checkSave((Long)this.getSourceModelId(), (Variable)variable);
        if (!resultInfo.isSuccess().booleanValue()) {
            this.getView().showErrorNotification(resultInfo.getMessage());
            return false;
        }
        return true;
    }

    private boolean saveData(DynamicObject dynamicObject) {
        boolean saveStatus = true;
        try (TXHandle tx = TX.required();){
            try {
                dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
                Object[] o = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"VariableEditPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.getPageCache().remove("isNew");
                this.initControlVisibleByType();
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                tx.markRollback();
                saveStatus = false;
            }
        }
        return saveStatus;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_ALL_DIM_ENTITY_MAP);
    }
}

