/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.variable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.variable.dto.Variable;
import kd.epm.far.business.common.variable.dto.VariableEnum;
import kd.epm.far.business.common.variable.util.VariableCheckUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.helper.ImportHelper;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;
import kd.epm.far.formplugin.common.imp.ImportOperateType;

public class VariableImportPlugin
extends AbsCommonImport {
    private DynamicObject model;
    private Map<String, DynamicObject> recordMap;
    private Set<String> repeatKeys = Sets.newHashSetWithExpectedSize((int)16);
    private Long userId = RequestContext.get().getCurrUserId();

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.model = DatasetDataReader.getModel((Long)LongUtil.toLong(ctx.getOption().get("BcmModelId")));
        this.entityName = "fidm_disc_variable";
        return this;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initData(billdatas);
    }

    private void initData(List<ImportBillData> billData) {
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)billData.size());
        for (ImportBillData billDatum : billData) {
            String number = ImportHelper.getImportBillProp(billDatum, "number").toString();
            numbers.add(number);
        }
        QFilter modelFilter = new QFilter("model.id", "=", this.ctx.getOption().get("BcmModelId"));
        QFilter numberFilter = new QFilter("number", "in", (Object)numbers);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)this.entityName).getAllFields().keySet()), (QFilter[])new QFilter[]{modelFilter, numberFilter});
        this.recordMap = Arrays.stream(load).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (k1, k2) -> k1));
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        Variable variable = new Variable();
        try {
            this.buildVariable(bill, variable);
            ImportOperateType importType = ImportHelper.getImportType(this.ctx);
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (dbOld.isPresent() && Objects.equals((Object)importType, (Object)ImportOperateType.NEW)) {
                return Optional.of(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"VariableImportPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            VariableCheckUtil.valid((Variable)variable, (DynamicObject)this.model);
        }
        catch (KDBizException e) {
            return Optional.of(e.getMessage());
        }
        if (!this.repeatKeys.add(variable.getNumber())) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"DataAuthMainImport_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void buildVariable(ImportBillData bill, Variable dto) {
        String valueType = ImportHelper.getImportBillProp(bill, "valuetype").toString();
        dto.setNumber(ImportHelper.getImportBillProp(bill, "number").toString());
        dto.setName(this.getMultiLanguageString(bill, "name"));
        dto.setDefaultValue(ImportHelper.getImportBillProp(bill, "defaultvalue").toString());
        dto.setDescribe(this.getMultiLanguageString(bill, "describe"));
        dto.setType(valueType);
        JSONArray array = (JSONArray)ImportHelper.getImportBillProp(bill, "entryentity");
        for (Object o : array) {
            JSONObject enumObject = (JSONObject)o;
            VariableEnum variableEnum = new VariableEnum();
            String enumNum = enumObject.getString("enum_number");
            variableEnum.setNumber(enumNum);
            Map nameMap = (Map)enumObject.getObject("enum_name", Map.class);
            if (Objects.nonNull(nameMap)) {
                Collection name = nameMap.values();
                variableEnum.setName(name.iterator().next().toString());
            } else {
                variableEnum.setName("");
            }
            dto.addEnums(variableEnum);
        }
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        String number = ImportHelper.getImportBillProp(rowData, "number").toString();
        DynamicObject dynamicObject = this.recordMap.get(number);
        return Optional.ofNullable(dynamicObject);
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        return new DynamicObject[0];
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        ArrayList dys = Lists.newArrayListWithExpectedSize((int)billDataList.size());
        for (ImportBillData bill : billDataList) {
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (!dbOld.isPresent()) continue;
            DynamicObject variable = dbOld.get();
            this.buildVariableDym(bill, variable, false);
            dys.add(variable);
        }
        return dys.toArray(new DynamicObject[0]);
    }

    @Override
    protected void batchInsertDBOpt(List<ImportBillData> billDataList) {
        long[] longs = DBServiceHelper.genLongIds((String)"fidm_disc_variable", (int)billDataList.size());
        ArrayList variables = Lists.newArrayListWithExpectedSize((int)billDataList.size());
        for (int i = 0; i < billDataList.size(); ++i) {
            ImportBillData bill = billDataList.get(i);
            DynamicObject variable = BusinessDataServiceHelper.newDynamicObject((String)"fidm_disc_variable");
            variable.set("id", (Object)longs[i]);
            this.buildVariableDym(bill, variable, true);
            variables.add(variable);
        }
        SaveServiceHelper.save((DynamicObject[])variables.toArray(new DynamicObject[0]));
    }

    @Override
    protected void batchUpdateDBOpt(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildUpdateDynamicObject(billDataList);
        SaveServiceHelper.save((DynamicObject[])dys);
    }

    private void buildVariableDym(ImportBillData bill, DynamicObject variable, boolean newVariable) {
        if (newVariable) {
            variable.set("number", (Object)ImportHelper.getImportBillProp(bill, "number").toString());
            variable.set("model", (Object)this.model.getLong("id"));
            variable.set("creator", (Object)this.userId);
            variable.set("createdate", (Object)TimeServiceHelper.now());
            variable.set("scope", (Object)1);
        }
        variable.set("modifier", (Object)this.userId);
        variable.set("modifydate", (Object)TimeServiceHelper.now());
        variable.set("name", (Object)this.getMultiLanguageString(bill, "name"));
        variable.set("describe", (Object)this.getMultiLanguageString(bill, "describe"));
        String valueType = ImportHelper.getImportBillProp(bill, "valuetype").toString();
        String defaultValue = ImportHelper.getImportBillProp(bill, "defaultvalue").toString();
        if (DmVariableTypeEnum.NUM.getIndex().equals(valueType)) {
            BigDecimal decimal = new BigDecimal(defaultValue.replaceAll(",", ""));
            defaultValue = decimal.setScale(10, RoundingMode.HALF_UP).toString();
        }
        variable.set("valuetype", (Object)valueType);
        variable.set("defaultvalue", (Object)defaultValue);
        if (!newVariable) {
            variable.getDynamicObjectCollection("entryentity").clear();
        }
        if (DmVariableTypeEnum.ENUM.getIndex().equals(valueType)) {
            JSONArray array = (JSONArray)ImportHelper.getImportBillProp(bill, "entryentity");
            for (Object o : array) {
                JSONObject enumObject = (JSONObject)o;
                DynamicObject enumEntity = variable.getDynamicObjectCollection("entryentity").addNew();
                String enumNum = enumObject.getString("enum_number");
                enumEntity.set("enum_number", (Object)enumNum);
                if (enumNum.equals(defaultValue)) {
                    enumEntity.set("isdefault", (Object)true);
                }
                Map nameMap = (Map)enumObject.getObject("enum_name", Map.class);
                enumEntity.set("enum_name", (Object)nameMap.get(Lang.get().name()).toString());
            }
        }
    }

    private String getMultiLanguageString(ImportBillData bill, String fieldName) {
        Object field = ImportHelper.getImportBillProp(bill, fieldName);
        if (field.toString().length() != 0) {
            return ((Map)ImportHelper.getImportBillProp(bill, fieldName)).get(Lang.get().name()).toString();
        }
        return "";
    }
}

