/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.variable;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DisclosureCopyEnum;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.other.GeneralCopyHepler;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.business.fidm.chapter.DisclosureCopyHelper;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;

public class VariableListPlugin
extends AbstractBaseDMListPlugin
implements HyperLinkClickListener {
    public static final String DISC_MODEL = "model";
    public static final String BILLLISTAP = "billlistap";
    public static final String KEY_DISC_MODEL_ID = "DISC_MODEL_ID";
    public static final String CALLBACKID_DEL_CONFIRM = "callbackid_del_confirm";
    public static final String CALLBACKID_COPYVAL = "callbackid_copyval";
    public static final String DM_DISC_VARIABLE_CLOSE = "dm_disc_variable_close";
    public static final String IMPORT_DATA_BACK = "importdataback";
    public static final String SEARCH_LIST_TEMP = "search_list_temp";
    public static final String VAR_SCOP = "varscop";
    private static final String CREATE_MODIFY_LOG = "CREATE_MODIFY_LOG";
    private static final String COPY_LOG = "COPY_LOG";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addPackageDataListener(evt -> this.packData((PackageDataEvent)evt));
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    VariableListPlugin.this.getPageCache().put(VariableListPlugin.SEARCH_LIST_TEMP, event.getText());
                } else {
                    VariableListPlugin.this.getPageCache().remove(VariableListPlugin.SEARCH_LIST_TEMP);
                }
                VariableListPlugin.this.refreshBill();
            }
        });
    }

    private void packData(PackageDataEvent e) {
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            String key = ((ColumnDesc)e.getSource()).getKey();
            if ("defaultvalue".equals(key) && DmVariableTypeEnum.DIM.getIndex().equals(e.getRowData().getString("valuetype"))) {
                DynamicObject dynamicObject;
                String entityNum = DmDimMemberEntityEnum.getOldEntityNum((String)e.getRowData().getString("dimmembertype"));
                if (StringUtils.isEmpty((String)entityNum)) {
                    entityNum = e.getRowData().getString("dimmembertype");
                }
                if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityNum, (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)e.getRowData().getLong("defaultvalue")).toArray())) != null) {
                    String name = dynamicObject.getLocaleString("name").getLocaleValue();
                    if (name == null || StringUtils.isEmpty((String)name.trim())) {
                        name = dynamicObject.getString("name");
                    }
                    e.setFormatValue((Object)name);
                }
            }
            if ("defaultvalue".equals(key) && DmVariableTypeEnum.NUM.getIndex().equals(e.getRowData().getString("valuetype")) && e.getRowData().getBigDecimal("defaultvalue") != null) {
                e.setFormatValue((Object)e.getRowData().getBigDecimal("defaultvalue").stripTrailingZeros().toPlainString());
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long dmmodel = this.getDMModelId();
        if (dmmodel != null && dmmodel != 0L) {
            this.getModel().setValue(DISC_MODEL, (Object)dmmodel);
            this.getPageCache().put(KEY_DISC_MODEL_ID, dmmodel.toString());
            this.getPageCache().put("KEY_MODEL_ID", dmmodel.toString());
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addPackageDataListener(evt -> this.packData((PackageDataEvent)evt));
        this.refreshBill();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        this.checkPerm("btn_edit");
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        Object pkId = list.getFocusRowPkId();
        this.openVariableDetailPage(pkId.toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "callbackid_del_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.actionDeleteResult();
                break;
            }
            case "callbackid_copyval": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.openCopyFormPage();
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_addnew": {
                this.openVariableDetailPage(null);
                break;
            }
            case "btn_delete": {
                this.actionDelete();
                break;
            }
            case "btn_refresh": {
                this.refreshBill();
                break;
            }
            case "btn_copy": {
                this.actionCopy();
                break;
            }
            case "btn_import": {
                this.importData();
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
        }
    }

    private void importData() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableListPlugin_29", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IMPORT_DATA_BACK);
        String listName = ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf\u5217\u8868", (String)"VariableListPlugin_30", (String)"epm-far-formplugin", (Object[])new Object[0]);
        ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
        AbsCommonImport.invokeOperation("fidm_disc_variable", "kd.epm.far.formplugin.common.variable.VariableImportPlugin", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportData() {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection rows = list.getSelectedRows();
        AnalysisOpLogParam logParam = this.getSingleLogParam().buildOpName(OperationName.EXPORT);
        try {
            if (rows.isEmpty()) {
                QFBuilder filter = new QFBuilder(DISC_MODEL, "=", (Object)this.getModelId());
                filter.add("valuetype", "!=", (Object)DmVariableTypeEnum.DIM.getIndex());
                filter.add("scope", "=", (Object)"1");
                this.exportData("fidm_disc_variable", filter.toArray(), ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf\u5217\u8868\u5bfc\u51fa", (String)"VariableListPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]), "fidm_disc_variable_IMPT_S", null);
            } else {
                Object[] ids = rows.getPrimaryKeyValues();
                QFBuilder filter = new QFBuilder("id", "in", (Object)ids);
                filter.add("valuetype", "!=", (Object)DmVariableTypeEnum.DIM.getIndex());
                DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id", (QFilter[])filter.toArray());
                if (ids.length != dys.size()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7c7b\u578b\u7684\u5168\u5c40\u53d8\u91cf\u4e0d\u518d\u652f\u6301\u5bfc\u5165\u5bfc\u51fa\u3002", (String)"VariableListPlugin_28", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                if (dys.size() == 0) {
                    return;
                }
                this.exportData("fidm_disc_variable", filter.toArray(), ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf\u5217\u8868\u5bfc\u51fa", (String)"VariableListPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]), "fidm_disc_variable_IMPT_S", null);
            }
            logParam.buildOpResult(OperationResult.SUCCESS);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf\u5217\u8868\u5bfc\u51fa\u6210\u529f\u3002", (String)"VariableListPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logParam.buildOpResult(OperationResult.FAILURE);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf\u5217\u8868\u5bfc\u51fa\u5931\u8d25\u3002", (String)"VariableListPlugin_27", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        finally {
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
    }

    private void actionDelete() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"VariableListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"VariableListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_DEL_CONFIRM, (IFormPlugin)this));
    }

    private void actionDeleteResult() {
        String msg = "";
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        AnalysisOpLogParam logParamSuccess = this.getMultiLogParam(billList.getSelectedRows().size()).buildOpResult(OperationResult.SUCCESS);
        AnalysisOpLogParam logParamFailure = this.getMultiLogParam(billList.getSelectedRows().size()).buildOpResult(OperationResult.FAILURE);
        ModelInfo modelInfo = new ModelStrategyEx(this.getDMModelId()).getModel().getModelInfo();
        ArrayList<Long> ids = new ArrayList<Long>(2);
        for (ListSelectedRow row : billList.getSelectedRows()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"fidm_disc_variable");
            if (dynamicObject == null) {
                msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"VariableListPlugin_24", (String)"epm-far-formplugin", (Object[])new Object[0]), row.getName());
                this.getView().showTipNotification(msg);
                continue;
            }
            Pair isVariableUsed = VariableService.isVariableUsed((Long)dynamicObject.getLong("id"), (String)dynamicObject.getString("name"));
            if (((Boolean)isVariableUsed.p1).booleanValue()) {
                this.getView().showTipNotification((String)isVariableUsed.p2);
                logParamFailure.buildBatchFormatParams(new Object[]{modelInfo.getNumber(), modelInfo.getName(), dynamicObject.getString("number"), dynamicObject.getString("name")});
                continue;
            }
            logParamSuccess.buildBatchFormatParams(new Object[]{modelInfo.getNumber(), dynamicObject.getString("number")});
            ids.add(dynamicObject.getLong("id"));
        }
        if (ids.size() > 0) {
            QFilter filter = new QFilter("id", "in", ids);
            BusinessDataWriter.delete((String)"fidm_disc_variable", (QFilter[])new QFilter[]{filter});
            msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"VariableListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]), ids.size());
            this.getView().showSuccessNotification(msg);
        }
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParamSuccess);
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParamFailure);
        this.refreshBill();
    }

    private void refreshBill() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addPackageDataListener(e -> this.packData((PackageDataEvent)e));
        FilterParameter fp = new FilterParameter();
        fp.setFilter(this.setBillListFilter());
        billList.setFilterParameter(fp);
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter setBillListFilter() {
        if (this.getPageCache().get(KEY_DISC_MODEL_ID) == null) {
            return new QFilter(DISC_MODEL, "=", (Object)-1);
        }
        Long modelId = Long.valueOf(this.getPageCache().get(KEY_DISC_MODEL_ID));
        QFilter filter = new QFilter(DISC_MODEL, "=", (Object)modelId);
        filter.and("scope", "=", (Object)"1");
        if (this.getPageCache().get(SEARCH_LIST_TEMP) != null) {
            String searchStr = this.getPageCache().get(SEARCH_LIST_TEMP);
            QFilter filter1 = new QFilter("number", "like", (Object)("%" + searchStr + "%"));
            filter1.or("name", "like", (Object)("%" + searchStr + "%"));
            filter.and(filter1);
        }
        return filter;
    }

    private void openVariableDetailPage(String id) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "fidm_disc_variable");
        openParameter.put("pkId", id);
        if (this.getPageCache().get(KEY_DISC_MODEL_ID) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"VariableListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setStatus(id == null ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        formShowParameter.setCustomParam(KEY_DISC_MODEL_ID, (Object)this.getPageCache().get(KEY_DISC_MODEL_ID));
        formShowParameter.setCustomParam(VAR_SCOP, (Object)"1");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        AnalysisOpLogParam logParam = this.getSingleLogParam();
        if (id == null) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u91cf\u65b0\u589e", (String)"VariableListPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
            logParam.buildOpName(OperationName.CREATE);
        } else {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u91cf\u7f16\u8f91", (String)"VariableListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            logParam.buildOpName(OperationName.MODIFY);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DM_DISC_VARIABLE_CLOSE));
        this.getPageCache().put(CREATE_MODIFY_LOG, logParam.toString());
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        switch (evt.getActionId()) {
            case "dm_disc_variable_close": {
                if (evt.getReturnData() != null) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"VariableEditPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                this.refreshBill();
                break;
            }
            case "fidm_data_copy": {
                if (evt.getReturnData() != null) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"VariableListPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                this.refreshBill();
                break;
            }
            case "importdataback": {
                this.refreshBill();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (DISC_MODEL.equals(keyName) && e.getChangeSet()[0].getNewValue() != null) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                this.getPageCache().put(KEY_DISC_MODEL_ID, newValue.getString("id"));
            }
            this.refreshBill();
        }
    }

    private void actionCopy() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"VariableListPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue(), (String)"fidm_disc_variable");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"VariableListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (DmVariableTypeEnum.DIM.getIndex().equals(dynamicObject.getString("valuetype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7c7b\u578b\u7684\u5168\u5c40\u53d8\u91cf\u4e0d\u518d\u652f\u6301\u65b0\u589e\u548c\u66f4\u65b0\uff0c\u8bf7\u65b0\u5efa\u6587\u672c\u7c7b\u578b\u5168\u5c40\u53d8\u91cf\u4ee3\u66ff\u3002", (String)"VariableEditPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        AnalysisOpLogParam logParam = this.getSingleLogParam(dynamicObject).buildOpName(OperationName.COPY);
        String newNumber = dynamicObject.getString("number").concat("copy");
        String newName = dynamicObject.getString("name").concat("copy");
        QFilter qf = new QFilter(DISC_MODEL, "=", (Object)dynamicObject.getLong("model.id"));
        qf.and("number", "=", (Object)newNumber);
        if (newNumber.length() > 50 || newName.length() > 50) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u590d\u5236\u751f\u6210\u7684\u53d8\u91cf\u7f16\u7801\u6216\u540d\u79f0\u8d85\u8fc7\u5236\u5b9a\u957f\u5ea6\u65e0\u6cd5\u4fdd\u5b58\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"VariableListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_COPYVAL, (IFormPlugin)this));
            this.getPageCache().put(COPY_LOG, logParam.toString());
        } else if (QueryServiceHelper.exists((String)"fidm_disc_variable", (QFilter[])qf.toArray())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u590d\u5236\u751f\u6210\u7684\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"VariableListPlugin_21", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_COPYVAL, (IFormPlugin)this));
            this.getPageCache().put(COPY_LOG, logParam.toString());
        } else {
            DisclosureCopyHelper.copyVariable((Long)dynamicObject.getLong("id"), (String)newNumber, (String)newName);
            logParam.buildOpResult(OperationResult.SUCCESS);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"VariableListPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.refreshBill();
        }
    }

    private void openCopyFormPage() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() != 1) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue(), (String)"fidm_disc_variable");
        if (dynamicObject == null) {
            return;
        }
        Long oldValId = dynamicObject.getLong("id");
        String title = ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf\u590d\u5236", (String)"VariableListPlugin_23", (String)"epm-far-formplugin", (Object[])new Object[0]);
        GeneralCopyHepler.openWindow((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getDMModelId(), (DisclosureCopyEnum)DisclosureCopyEnum.Variable, (Long)oldValId, (String)title);
    }

    private AnalysisOpLogParam getSingleLogParam(DynamicObject dynamicObject) {
        ModelInfo modelInfo = new ModelStrategyEx(this.getDMModelId()).getModel().getModelInfo();
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.GLOBAL_VAR).buildFormNumber("fidm_disc_variable_list").buildAppId(this.getView()).buildFormatParams(new Object[]{modelInfo.getNumber(), dynamicObject.getString("number")});
    }

    private AnalysisOpLogParam getSingleLogParam() {
        ModelInfo modelInfo = new ModelStrategyEx(this.getDMModelId()).getModel().getModelInfo();
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.GLOBAL_VAR).buildFormNumber("fidm_disc_variable_list").buildAppId(this.getView()).buildFormatParams(new Object[]{modelInfo.getNumber()});
    }

    private AnalysisOpLogParam getMultiLogParam(int size) {
        return new AnalysisOpLogParam(size).buildOpCategory(OperationCategory.GLOBAL_VAR).buildFormNumber("fidm_disc_variable_list").buildAppId(this.getView()).buildOpName(OperationName.DELETE);
    }
}

