/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.ChapterCommitStatusEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSHelper;
import kd.epm.far.business.common.f7.dto.MutilF7MemberResult;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.ResultInfoEx;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.business.fidm.base.DisclosureConstants;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.chapter.LockChapterHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.design.dto.DesignFormInput;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewSelectHelper;
import kd.epm.far.business.fidm.gpt.DiscloseGPTService;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.business.fidm.report.dto.GenerateFormInput;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.json.JacksonUtils;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.MainPage;
import kd.epm.far.formplugin.common.helper.DmSingleF7ServiceHelper;

public class AbstractDesignPlugin
extends AbstractBaseDMFormPlugin
implements UploadListener,
BeforeF7SelectListener,
AfterF7SelectListener,
MainPage {
    protected static final String KEY_TEMPLATEDIMMAP = "KEY_TEMPLATEDIMMAP";
    protected static final String KEY_DIMF7MAP = "KEY_DIMF7MAP";
    protected static final String KEY_CHAPTER_VUE = "KEY_CHAPTER_VUE";
    protected static final String KEY_OPERATION = "KEY_OPERATION";
    protected static final String KEY_DESIGN_TEMPLATE_INNPUT = "KEY_DESIGN_TEMPLATE_INNPUT";
    protected static final String PARAM_TEMPLATEID = "templateId";
    protected static final String CTL_MODEL = "model";
    protected static final String CTL_TOOLBAR_AP = "toolbarap";
    protected static final String CTL_FLEXPANELAPQUERY = "flexpanelapquery";
    protected static final String CTL_CUSTOMCONTROLAP = "customcontrolap";
    protected static final String CLOSEDCALLBACK_FILTER_VALUE = "singlememberf7";
    protected static final String DATASET_BASEDATA = "dataset_basedata";
    protected static final String DATASET_BASEDATA_FORMULA = "dataset_basedata_formula";
    protected static final String BTN_REFRESH = "btn_refresh";
    protected static final String BTN_SAVE = "btn_save";
    protected static final String BTN_BASEINFO = "btn_baseinfo";
    protected static final String BTN_PREVIEW = "btn_preview";
    protected static final String BTN_EXIT = "btn_exit";
    protected static final String BTN_GENERATEREPORT = "btn_generatereport";
    protected static final String BTN_COMMIT_ITEM = "btn_commit_item";
    protected static final String BTN_SENDBACK_ITEM = "btn_sendback_item";
    protected static final String BTN_ENABLE_ITEM = "btn_enable_item";
    protected static final String BTN_DISABLE_ITEM = "btn_disable_item";
    protected static final String BTN_MODULE_SAVE = "btn_module_save";
    protected static final String FIDM_DESGIN_CHAPTERDELETE = "fidm_desgin_chapterdelete";
    protected static final String FIDM_DESGIN_CHAPTEREDIT = "fidm_desgin_chapteredit";
    protected static final String FIDM_MSG_CLOSE = "fidm_msg_close";
    protected static final String FIDM_DESGIN_CHAPTERSHARE = "fidm_desgin_chaptershare";
    protected static final String BTN_CLICK_CHAPTER = "btn_click_chapte";
    protected static final String CLOSEDCALLBACK_ADD_VARIABLE = "dm_disc_variable_close";
    protected static final String CLOSEDCALLBACK_ADD_DATASET = "closedcallback_add_dataset";
    protected static final String CALLBACKID_DEL_CONFIRM = "callbackid_delVar_confirm";
    protected static final String CALLBACKID_DELDATASET_CONFIRM = "callbackid_delDataSet_confirm";
    protected static final String CALLBACKID_CHAPTER_REFRESH = "callbackid_chapter_refresh";
    protected static final String CALLBACKID_CHAPTER_CLOSE = "callbackid_chapter_close";
    protected static final String CALLBACKID_SELECT_MEMBERS_CLOSE = "callbackid_select_members_close";
    protected static final String FIMDMODEL = "fidmmodel";
    protected static final String ChapterEdit = "fidm_chapter_edit";

    protected OpenWordEnum getWordView() {
        return OpenWordEnum.WEB;
    }

    @Override
    public void initialize() {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit datasetBasedata;
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.registerListener(e);
        this.addItemClickListeners(CTL_TOOLBAR_AP);
        if (this.getControl(DATASET_BASEDATA) != null) {
            datasetBasedata = (BasedataEdit)this.getControl(DATASET_BASEDATA);
            datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            datasetBasedata.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if (this.getControl(DATASET_BASEDATA_FORMULA) != null) {
            datasetBasedata = (BasedataEdit)this.getControl(DATASET_BASEDATA_FORMULA);
            datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            datasetBasedata.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.afterCreateNewData(e);
        this.initModel();
        this.initDesignFormInput();
        this.dataInit();
    }

    private void initModel() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        this.setValue(CTL_MODEL, modelId);
        this.getView().setEnable(Boolean.FALSE, new String[]{CTL_MODEL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CTL_FLEXPANELAPQUERY});
    }

    protected void initDesignFormInput() {
        Long templateId = (Long)this.getFormCustomParam(PARAM_TEMPLATEID);
        String perm = PermClassTemplateHelper.getTemplatePerm((Long)templateId);
        if (PermClassBaseHelper.isNoPerm((String)perm)) {
            String msg = ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u65e0\u6743\u9650\u6216\u5df2\u5220\u9664\u3002", (String)"AbstractChapterPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(msg, MessageTypes.Default, new ConfirmCallBackListener(FIDM_MSG_CLOSE));
            return;
        }
        Map chapterPermMap = PermClassTemplateHelper.getChapterPermMap((Long)this.getDmModelId(), (Long)templateId);
        DesignFormInput formInput = new DesignFormInput();
        formInput.setDmModelId(this.getDmModelId());
        formInput.setTemplateId(templateId);
        formInput.setTemplatePerm(perm);
        formInput.setChapterPermMap(chapterPermMap);
        this.getPageCache().put(KEY_DESIGN_TEMPLATE_INNPUT, JSON.toJSONString((Object)formInput));
    }

    protected DesignFormInput getDesignFormInput() {
        String data = this.getPageCache().get(KEY_DESIGN_TEMPLATE_INNPUT);
        if (data == null) {
            return null;
        }
        return (DesignFormInput)JSON.parseObject((String)data, DesignFormInput.class);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshOper();
                break;
            }
            case "btn_save": {
                this.checkPerm(itemKey);
                this.saveOper();
                break;
            }
            case "btn_baseinfo": {
                this.checkPerm(itemKey);
                this.modifyBaseInfoOper();
                break;
            }
            case "btn_preview": {
                this.checkPerm(itemKey);
                this.previewOper();
                break;
            }
            case "btn_generatereport": {
                this.generalReportOper();
                break;
            }
            case "btn_exit": {
                this.existOper();
                break;
            }
            case "btn_commit_item": {
                this.checkPerm(itemKey);
                boolean succ = DisclosureChapterHelper.commit((IFormView)this.getView(), (Long)this.getTemplateId(), (Long)this.getSelectChapterId());
                if (!succ) break;
                DynamicObject chapter = DisclosureChapterHelper.getChapter((Long)this.getSelectChapterId());
                this.setRefreshControl(chapter);
                this.chapterTreeReturn(null);
                break;
            }
            case "btn_sendback_item": {
                this.checkPerm(itemKey);
                boolean succ = DisclosureChapterHelper.sendback((IFormView)this.getView(), (Long)this.getTemplateId(), (Long)this.getSelectChapterId());
                if (!succ) break;
                DynamicObject chapter = DisclosureChapterHelper.getChapter((Long)this.getSelectChapterId());
                this.setRefreshControl(chapter);
                this.chapterTreeReturn(null);
                break;
            }
            case "btn_enable_item": {
                this.checkPerm(itemKey);
                DisclosureChapterHelper.enable((IFormView)this.getView(), (Long)this.getTemplateId(), (Long)this.getSelectChapterId());
                this.chapterTreeReturn(null);
                break;
            }
            case "btn_disable_item": {
                this.checkPerm(itemKey);
                DisclosureChapterHelper.disable((IFormView)this.getView(), (Long)this.getTemplateId(), (Long)this.getSelectChapterId());
                this.chapterTreeReturn(null);
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        if (Objects.isNull(this.getDmModelId())) {
            return;
        }
        String key = evt.getProperty().getName();
        JSONObject jsonObject = null;
        switch (key) {
            case "singlememberf7": {
                Map f7DimMap;
                String dimKey;
                jsonObject = this.getCallBackType(DisclosureConstants.CallBackType.EVENT_DIM_F7);
                if (!Objects.nonNull(jsonObject) || !kd.bos.util.StringUtils.isNotEmpty((String)(dimKey = jsonObject.getJSONObject("dim").getString("number").toLowerCase())) || !Objects.nonNull((f7DimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_DIMF7MAP), Map.class)).get(dimKey))) break;
                Map templateDimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TEMPLATEDIMMAP), Map.class);
                Object scenario = f7DimMap.containsKey("scenario") ? f7DimMap.get("scenario") : null;
                DmSingleF7ServiceHelper.beforeF7Select(evt, this.getSourceModelId(), templateDimMap, f7DimMap, scenario, dimKey);
                break;
            }
            case "dataset_basedata": {
                String typeStr;
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter filter = DatasetServiceHelper.getAllDataSetAndChapterDataSetQFilter((Long)this.getDmModelId(), (Long)this.getSelectChapterId(), (String)ApplicationTypeEnum.FIDM.getAppnum());
                jsonObject = this.getCallBackType(DisclosureConstants.CallBackType.EVENT_DS_F7);
                if (Objects.nonNull(jsonObject) && kd.bos.util.StringUtils.isNotEmpty((String)(typeStr = jsonObject.getString("type")))) {
                    filter.and("type", "in", Arrays.asList(ModuleEnum.getModuleByType((String)typeStr).getDatasetTypes()));
                }
                filter.and("status", "=", (Object)"1");
                formShowParameter.getListFilterParameter().setFilter(filter);
                break;
            }
            case "dataset_basedata_formula": {
                ListShowParameter formParameter = (ListShowParameter)evt.getFormShowParameter();
                JSONObject json = this.getCallBackType(DisclosureConstants.CallBackType.EVENT_DATASET_FORMULA);
                if (!Objects.nonNull(json)) break;
                QFilter formulaFilter = new QFilter("dataset", "=", (Object)json.getLong("id"));
                formParameter.getListFilterParameter().setFilter(formulaFilter);
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afevt) {
        Object newVaule;
        String key = ((BasedataEdit)afevt.getSource()).getKey();
        if (DATASET_BASEDATA.equalsIgnoreCase(key)) {
            Object newVaule2 = this.getModel().getValue(DATASET_BASEDATA);
            if (Objects.nonNull(newVaule2)) {
                String primaryKey = this.getCallBackPrimaryKey(DisclosureConstants.CallBackType.EVENT_DS_F7);
                Object data = DisclosureDesignHelper.dsF7Result((Long)this.getDmModelId(), (Long)this.getSelectChapterId(), (DynamicObject)((DynamicObject)newVaule2), (String)primaryKey);
                this.SendToVue(data);
            }
        } else if (DATASET_BASEDATA_FORMULA.equalsIgnoreCase(key) && Objects.nonNull(newVaule = this.getModel().getValue(DATASET_BASEDATA_FORMULA))) {
            String primaryKey = this.getCallBackPrimaryKey(DisclosureConstants.CallBackType.EVENT_DATASET_FORMULA);
            Object data = DisclosureDesignHelper.datasetFormulaResult((DynamicObject)((DynamicObject)newVaule), (String)primaryKey);
            this.SendToVue(data);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "callbackid_delVar_confirm": {
                String id;
                JSONObject jsonObject;
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult()) || !Objects.nonNull(jsonObject = this.getCallBackType(DisclosureConstants.CallBackType.EVENT_VAR_DELETE)) || !kd.bos.util.StringUtils.isNotEmpty((String)(id = jsonObject.getString("id")))) break;
                HashSet<Long> ids = new HashSet<Long>(10);
                ids.add(Long.parseLong(id));
                QFilter filter = new QFilter("id", "in", ids);
                int delete = BusinessDataWriter.delete((String)"fidm_disc_variable", (QFilter[])new QFilter[]{filter});
                if (delete != 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractDesignPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                this.varRefresh(DisclosureConstants.CallBackType.EVENT_VAR_DELETE);
                break;
            }
            case "callbackid_delDataSet_confirm": {
                String id;
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                HashSet<Long> ids = new HashSet<Long>(10);
                JSONObject jsonObject = this.getCallBackType(DisclosureConstants.CallBackType.EVENT_DS_DELETE);
                if (!Objects.nonNull(jsonObject) || !kd.bos.util.StringUtils.isNotEmpty((String)(id = jsonObject.getString("id"))) || !kd.bos.util.StringUtils.isEmpty((String)this.checkDataSetPerm(id))) break;
                ids.add(Long.parseLong(id));
                if (QueryServiceHelper.exists((String)"fidm_modulerepository", (QFilter[])new QFilter[]{new QFilter("datasetid", "=", (Object)LongUtil.toLong((Object)id))})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u96c6\uff0c\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AbstractDesignPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean res = DatasetServiceHelper.deleteDataSet(ids);
                if (res) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractDesignPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"AbstractDesignPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                this.dsRefresh(DisclosureConstants.CallBackType.EVENT_DS_DELETE);
                break;
            }
            case "callbackid_chapter_refresh": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.changeChapter(this.getSelectChapterId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"AbstractReportPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "callbackid_chapter_close": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.getView().close();
                break;
            }
            case "fidm_desgin_chapterdelete": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                boolean succ = DisclosureChapterHelper.delete((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getDmModelId(), (Long)this.getSelectChapterId());
                if (succ) {
                    this.chapterTreeReturn(null);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractDesignPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"AbstractDesignPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "fidm_msg_close": {
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "fidm_modulerepository": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractChapterPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.moduleSaveCallBack();
                break;
            }
            case "fidm_chaptersave": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractChapterPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "singlememberf7": {
                this.dimMemberReturn(returnData, false);
                break;
            }
            case "fidm_dsfilter_entry": {
                this.datasetFilterEntryCallback(returnData);
                break;
            }
            case "fidm_template": {
                if (!Objects.nonNull(returnData)) break;
                this.chapterTreeReturn(ChapterEdit);
                break;
            }
            case "dm_disc_variable_close": {
                this.varRefresh(DisclosureConstants.CallBackType.EVENT_VAR_ADD);
                break;
            }
            case "closedcallback_add_dataset": {
                this.dsRefresh(DisclosureConstants.CallBackType.EVENT_DS_ADD);
                break;
            }
            case "fidm_chapter": 
            case "fidm_chapter_edit": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractChapterPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.chapterTreeReturn(actionId);
                break;
            }
            case "callbackid_select_members_close": {
                this.dimMemberReturn(returnData, true);
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        try {
            DisclosureConstants.CallBackType callBackType = DisclosureConstants.CallBackType.valueOf((String)eventName);
            this.putCallBackType(callBackType, eventArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (eventName.equals(DisclosureConstants.CallBackType.EVENT_GETITEMID.toString())) {
            this.evGetItemId(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DS_F7.toString())) {
            this.evDSF7(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DATASET_FORMULA.toString())) {
            this.evDatasetFormula(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_SAVE.toString())) {
            this.evSave(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_VAR_ADD.toString())) {
            this.evVarAdd(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_VAR_DELETE.toString())) {
            this.evVarDelete(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_VAR_EDIT.toString())) {
            this.evVarEdit(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DS_ADD.toString())) {
            this.evDSAdd(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DS_DELETE.toString())) {
            this.evDSDelete(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DS_EDIT.toString())) {
            this.evDSEdit(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DS_FILTER.toString())) {
            this.evDSFilter(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_MODULE_SAVE.toString())) {
            this.evSaveModule(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_MODULE_ADDITEM.toString())) {
            this.evModuleAddItem(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DIM_F7.toString())) {
            this.evDimF7(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DATASET_VIEW.toString())) {
            this.evDatasetView(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_MODULE_CHANGENAME.toString())) {
            this.evChangeModuleName(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_FOCUS_BOOKMARK.toString())) {
            this.evFocusBookMark(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_MODULE_DELETE.toString())) {
            this.evModuleDelete(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DOCUMENT_CHANGED.toString())) {
            this.evDocumentChanged(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_UPLOAD_IMAGE.toString())) {
            this.evUploadImage(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_AI_USER_COMMAND.toString())) {
            this.evAIUserCommand(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_EXIT.toString())) {
            this.evExit(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_CHAPTER_ADD.toString())) {
            this.evChapterAdd(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_CHAPTER_EDIT.toString())) {
            this.evChapterEdit(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_CHAPTER_DELETE.toString())) {
            this.evChapterDelete(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_CHAPTER_MOVE.toString())) {
            this.evChapterMove(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_CHAPTER_SHARE.toString())) {
            this.evChapterShare(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_CHAPTER_SWITCH.toString())) {
            this.evChapterSwitch(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DS_LIST.toString())) {
            this.evDsList(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DS_DETAIL.toString())) {
            this.evDsDetail(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DIM_MEMBER_LIST.toString())) {
            this.evDimMemberList(eventArgs);
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseChapter();
        this.cleanPageCache();
        super.pageRelease(e);
    }

    protected void releaseChapter() {
        String curLockedChapter = this.getPageCache().get("curlockedchapter");
        if (StringUtils.isNotEmpty((CharSequence)curLockedChapter)) {
            LockChapterHelper.releaseChapter((String)"fidm_webdesign", (IPageCache)this.getPageCache(), (String)curLockedChapter);
        }
    }

    protected void releaseChapter(String chapterId) {
        LockChapterHelper.releaseChapter((String)"fidm_webdesign", (IPageCache)this.getPageCache(), (String)chapterId);
    }

    protected void cleanPageCache() {
        this.getPageCache().remove(KEY_DESIGN_TEMPLATE_INNPUT);
        this.getPageCache().remove("curlockedchapter");
    }

    protected void evGetItemId(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String itemId = String.valueOf(ID.genLongId());
        JSONObject data = new JSONObject(2);
        data.fluentPut("type", (Object)jsonObject.getString("type"));
        data.fluentPut("itemId", (Object)itemId);
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_GETITEMID_RESULT, (Object)data, (String)jsonObject.getString("primaryKey"));
        this.SendToVue(result);
    }

    protected void evDSF7(String eventArgs) {
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(DATASET_BASEDATA);
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        datasetBasedata.click();
    }

    protected void evDatasetFormula(String eventArgs) {
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(DATASET_BASEDATA_FORMULA);
        if (Objects.nonNull(datasetBasedata)) {
            datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            datasetBasedata.click();
        }
    }

    protected void evSave(String eventArgs) {
    }

    protected void evVarAdd(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        VariableService.openVariableEditView((IFormView)this.getView(), (IFormPlugin)this, null, (String)this.getDmModelId().toString(), (Long)this.getSelectChapterId());
    }

    protected void evVarDelete(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        String id = JSON.parseObject((String)eventArgs).getString("id");
        VariableService.showDelVarConfirmView((IFormView)this.getView(), (IFormPlugin)this, (String)id);
    }

    protected void evVarEdit(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)eventArgs)) {
            return;
        }
        String id = JSON.parseObject((String)eventArgs).getString("id");
        VariableService.openVariableEditView((IFormView)this.getView(), (IFormPlugin)this, (String)id, (String)this.getDmModelId().toString(), (Long)this.getSelectChapterId());
    }

    protected void evDSAdd(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        DatasetServiceHelper.openAddNewDataSetView((IFormView)this.getView(), (IFormPlugin)this, (String)this.getDmModelId().toString(), (Long)this.getSelectChapterId());
    }

    protected void evDSDelete(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)eventArgs)) {
            return;
        }
        String id = JSON.parseObject((String)eventArgs).getString("id");
        String msg = this.checkDataSetPerm(id);
        if (!kd.bos.util.StringUtils.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        DatasetServiceHelper.showDelDataSetConfirmView((IFormView)this.getView(), (IFormPlugin)this, (String)id);
    }

    protected void evDSEdit(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        String id = JSON.parseObject((String)eventArgs).getString("id");
        String msg = this.checkDataSetPerm(id);
        if (!kd.bos.util.StringUtils.isEmpty((String)msg)) {
            this.getPageCache().put("chapterDataSetPerm", "true");
        }
        DatasetServiceHelper.openEditDataSetView((IFormView)this.getView(), (IFormPlugin)this, (Long)Long.parseLong(id), (String)"fidm_dataset");
    }

    protected void evDSFilter(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String datesetFilterItemsStr = "[]";
        Long datasetId = LongUtil.toLong((Object)jsonObject.getString("dsId"));
        JSONArray datesetFilterItems = jsonObject.getJSONArray("datesetFilterItems");
        if (!Objects.isNull(datesetFilterItems)) {
            datesetFilterItemsStr = datesetFilterItems.toJSONString();
        }
        if (Objects.isNull(datasetId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6570\u636e\u96c6\u201d\u3002", (String)"AbstractDesignPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!DatasetServiceHelper.isMultiRowDataset((Long)datasetId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u201c\u6570\u636e\u96c6\u201d\u5fc5\u987b\u662f\u591a\u884c\u3002", (String)"AbstractDesignPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DatasetFilterHelper.openEdit((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getDmModelId(), (Long)datasetId, (String)datesetFilterItemsStr);
    }

    protected void evSaveModule(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        this.checkPerm(BTN_MODULE_SAVE);
        DisclosureDesignHelper.saveModule((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getDmModelId(), (String)eventArgs);
    }

    protected void evModuleAddItem(String eventArgs) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            JSONObject newItem = DisclosureDesignHelper.moduleAddItem((Long)this.getDmModelId(), (Long)this.getSelectChapterId(), (String)eventArgs, (String)this.getWordView().getType());
            if (Objects.nonNull(newItem)) {
                JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_MODULE_ADDITEM_RESULT, (Object)newItem, (String)jsonObject.getString("primaryKey"));
                this.SendToVue(result);
            }
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected void evDimF7(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject dimJsonObject = jsonObject.getJSONObject("dim");
        JSONArray dimListObject = jsonObject.getJSONArray("dimList");
        Long dimensionId = dimJsonObject.getLong("id");
        String isDim = DisclosureJsonHelper.getValue((JSONObject)dimJsonObject, (String)"isDim", null);
        if (Objects.isNull(this.getPageCache().get(KEY_TEMPLATEDIMMAP))) {
            this.initDimF7();
        }
        Map templateDimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TEMPLATEDIMMAP), Map.class);
        LinkedHashMap<String, Long> dimF7Map = new LinkedHashMap<String, Long>(templateDimMap.size());
        if (Objects.nonNull(dimListObject) && dimListObject.size() > 0) {
            for (Object dimObject : dimListObject) {
                JSONObject dim = (JSONObject)dimObject;
                dimF7Map.put(dim.getString("number").toLowerCase(), dim.getLong("id"));
            }
        } else {
            dimF7Map.put(dimJsonObject.getString("number").toLowerCase(), dimJsonObject.getLong("id"));
        }
        this.getPageCache().put(KEY_DIMF7MAP, SerializationUtils.toJsonString(dimF7Map));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getSourceModelId());
        DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(false), (Long)dimensionId);
        if ("2".equalsIgnoreCase(isDim)) {
            modelStrategyEx.getDimensionF7().openMutilF7Ex((AbstractFormPlugin)this, dimensionInfo, new ArrayList(10), new CloseCallBack((IFormPlugin)this, CALLBACKID_SELECT_MEMBERS_CLOSE), false);
        } else {
            modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, CLOSEDCALLBACK_FILTER_VALUE, this.getClass().getName(), true, "");
        }
    }

    protected void evDatasetView(String eventArgs) {
        String id = JSON.parseObject((String)eventArgs).getString("id");
        DatasetServiceHelper.openPreviewPage((IFormView)this.getView(), (IFormPlugin)this, (long)this.getDmModelId(), (long)LongUtil.toLong((Object)id));
    }

    protected void evChangeModuleName(String eventArgs) {
    }

    protected void evFocusBookMark(String eventArgs) {
    }

    protected void evModuleDelete(String eventArgs) {
    }

    protected void evDocumentChanged(String eventArgs) {
    }

    protected void evUploadImage(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String id = jsonObject.getString("id");
        String base64String = jsonObject.getString("base64");
        String url = DisclosureFileHelper.uploadGenealFile((String)"fidm_webdesign", (Object)GlobalIdUtil.genGlobalLongId(), (String)(GlobalIdUtil.genGlobalLongId() + ".png"), (String)base64String, (boolean)true);
        JSONObject data = new JSONObject(2);
        data.fluentPut("id", (Object)id);
        data.fluentPut("src", (Object)url);
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_UPLOAD_IMAGE, (Object)data, (String)jsonObject.getString("primaryKey"));
        this.SendToVue(result);
    }

    protected void evAIUserCommand(String eventArgs) {
        try {
            JSONObject result = DiscloseGPTService.invokeGpt((String)eventArgs);
            this.SendToVue(result);
        }
        catch (KDBizException bizException) {
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            String primaryKey = jsonObject.getString("primaryKey");
            this.SendToVue(DisclosureVueHelper.getErrorResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_AI_USER_COMMAND, (String)bizException.getMessage(), (String)primaryKey));
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u6267\u884cGPT\u529f\u80fd\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractDesignPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.SendToVue(DisclosureVueHelper.getErrorResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_AI_USER_COMMAND, (String)tips, (String)this.getCallBackPrimaryKey(DisclosureConstants.CallBackType.EVENT_AI_USER_COMMAND)));
        }
    }

    protected void evExit(String eventArgs) {
        this.getView().close();
        this.releaseChapter();
    }

    protected void evChapterAdd(String eventArgs) {
        if (!this.checkTemplatePermClass().booleanValue()) {
            return;
        }
        this.checkPerm(FIDM_DESGIN_CHAPTEREDIT);
        DisclosureChapterHelper.openAdd((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getDmModelId(), (Long)this.getTemplateId(), (int)this.getWordView().getTypeToInt());
    }

    protected void evChapterEdit(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        this.checkPerm(FIDM_DESGIN_CHAPTEREDIT);
        Long chapterId = DisclosureJsonHelper.getValue((JSONObject)DisclosureJsonHelper.convert((String)eventArgs), (String)"id", (long)0L);
        if (LongUtil.isvalidLong((Object)chapterId)) {
            DisclosureChapterHelper.openEdit((IFormView)this.getView(), (IFormPlugin)this, (Long)chapterId);
        }
    }

    protected void evChapterDelete(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        this.checkPerm(FIDM_DESGIN_CHAPTERDELETE);
        Long chapterId = DisclosureJsonHelper.getValue((JSONObject)DisclosureJsonHelper.convert((String)eventArgs), (String)"id", (long)0L);
        if (LongUtil.isvalidLong((Object)chapterId)) {
            DynamicObject chapter = DisclosureChapterHelper.getChapter((Long)chapterId);
            String msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\u201c%s\u201d\u3002", (String)"AbstractChapterPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), chapter.getString("name"));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(FIDM_DESGIN_CHAPTERDELETE, (IFormPlugin)this));
        }
    }

    protected void evChapterMove(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        this.checkPerm(FIDM_DESGIN_CHAPTEREDIT);
        JSONObject jsonObject = DisclosureJsonHelper.convert((String)eventArgs);
        if (jsonObject == null) {
            return;
        }
        String id = jsonObject.getString("id");
        String toId = jsonObject.getString("toId");
        if (kd.bos.util.StringUtils.isEmpty((String)id) || kd.bos.util.StringUtils.isEmpty((String)toId)) {
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getDmModelId());
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        DynamicObject chapter1 = DisclosureChapterHelper.getChapter((Long)LongUtil.toLong((Object)id));
        DynamicObject chapter2 = DisclosureChapterHelper.getChapter((Long)LongUtil.toLong((Object)toId));
        if (chapter1 != null && chapter2 != null) {
            Long chapter1Id = chapter1.getLong("id");
            Long chapter2Id = chapter2.getLong("id");
            Integer sequence1 = chapter1.getInt("sequence");
            Integer sequence2 = chapter2.getInt("sequence");
            OperationName operationName = OperationName.CATALOG_MOVE_UP;
            if (sequence1 != null && sequence2 != null && sequence2 > sequence1) {
                operationName = OperationName.CATALOG_MOVE_DOWN;
            }
            try {
                LinkedHashMap<String, Integer> sequenceData = new LinkedHashMap<String, Integer>(10);
                sequenceData.put(chapter1Id.toString(), sequence2);
                sequenceData.put(chapter2Id.toString(), sequence1);
                DisclosureChapterHelper.updateSequence(sequenceData);
            }
            catch (Exception ex) {
                DisclosureLogHelper.writeTemplateChapter((OperationResult)OperationResult.FAILURE, (OperationName)operationName, (ModelInfo)modelInfo, (Long)chapter1Id);
                throw ex;
            }
            DisclosureLogHelper.writeTemplateChapter((OperationResult)OperationResult.SUCCESS, (OperationName)operationName, (ModelInfo)modelInfo, (Long)chapter1Id);
            this.chapterTreeReturn(ChapterEdit);
        }
    }

    protected void evChapterShare(String eventArgs) {
        if (!this.checkPermClass().booleanValue()) {
            return;
        }
        this.checkPerm(FIDM_DESGIN_CHAPTERSHARE);
        Long chapterId = DisclosureJsonHelper.getValue((JSONObject)DisclosureJsonHelper.convert((String)eventArgs), (String)"id", (long)0L);
        if (LongUtil.isvalidLong((Object)chapterId)) {
            this.saveAsChapter(chapterId);
        }
    }

    protected void evChapterSwitch(String eventArgs) {
        Long chapterId = DisclosureJsonHelper.getValue((JSONObject)DisclosureJsonHelper.convert((String)eventArgs), (String)"id", (long)0L);
        if (LongUtil.isvalidLong((Object)chapterId)) {
            this.changeChapter(chapterId);
        } else {
            this.chapterTreeReturn(ChapterEdit);
        }
    }

    protected void evDsList(String eventArgs) {
        List list = ExpressionDSHelper.getDatasets((Long)this.getDmModelId());
        JSONObject data = new JSONObject();
        data.put("datasets", (Object)list);
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_DS_LIST, (Object)data, (String)"");
        this.SendToVue(result);
    }

    protected void evDsDetail(String eventArgs) {
        ResultInfoEx resultInfoEx;
        Long datasetId = DisclosureJsonHelper.getValue((JSONObject)DisclosureJsonHelper.convert((String)eventArgs), (String)"id", (long)0L);
        if (LongUtil.isvalidLong((Object)datasetId) && (resultInfoEx = ExpressionDSHelper.getDatasetDtoById((Long)this.getDmModelId(), (Long)datasetId)).isSuccess().booleanValue()) {
            JSONObject data = JSONObject.parseObject((String)JSON.toJSONString((Object)resultInfoEx.getData()));
            DisclosureJsonHelper.convertLongToStringFromJson((Object)data);
            JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_DS_DETAIL, (Object)data, (String)"");
            this.SendToVue(result);
        }
    }

    protected void evDimMemberList(String eventArgs) {
        JSONObject input = DisclosureJsonHelper.convert((String)eventArgs);
        String key = DisclosureJsonHelper.getValue((JSONObject)input, (String)"key", (String)"");
        String dimNumber = DisclosureJsonHelper.getValue((JSONObject)input, (String)"dimNumber", (String)"");
        int top = DisclosureJsonHelper.getValue((JSONObject)input, (String)"top", (int)10);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getDmModelId());
        List dimensionInfos = modelStrategyEx.getDim().getDimList();
        DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber((List)dimensionInfos, (String)dimNumber);
        if (dimensionInfo == null) {
            return;
        }
        List memberInfos = modelStrategyEx.getDimMember().getMemberList(dimensionInfo, key, top);
        JSONObject data = new JSONObject();
        data.put("members", (Object)memberInfos);
        data.put("dimId", (Object)dimensionInfo.getId().toString());
        data.put("dimNumber", (Object)dimensionInfo.getNumber());
        data.put("dimName", (Object)dimensionInfo.getName());
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_DIM_MEMBER_LIST, (Object)data, (String)"");
        this.SendToVue(result);
    }

    protected void SendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    protected void putCallBackType(DisclosureConstants.CallBackType callBackType, String value) {
        this.getPageCache().put("KEY_" + callBackType.toString(), value);
    }

    protected JSONObject getCallBackType(DisclosureConstants.CallBackType callBackType) {
        String data = this.getPageCache().get("KEY_" + callBackType.toString());
        if (!kd.bos.util.StringUtils.isEmpty((String)data)) {
            return JSON.parseObject((String)data);
        }
        return null;
    }

    protected String getCallBackPrimaryKey(DisclosureConstants.CallBackType callBackType) {
        String result = "";
        JSONObject jsonObject = this.getCallBackType(callBackType);
        if (Objects.nonNull(jsonObject) && kd.bos.util.StringUtils.isEmpty((String)(result = jsonObject.getString("primaryKey")))) {
            result = "";
        }
        return result;
    }

    protected void initDimF7() {
        if (this.getDmModelId() <= 0L) {
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getDmModelId());
        Map templateDimMap = modelStrategyEx.getDim().getDimDataMap(null);
        LinkedHashMap<String, Long> dimF7Map = new LinkedHashMap<String, Long>(templateDimMap.size());
        for (Map.Entry entry : templateDimMap.entrySet()) {
            String dimKey = (String)entry.getKey();
            String[] splitDimKey = dimKey.split("/");
            Long dimensionId = LongUtil.toLong((Object)splitDimKey[0]);
            String dimNumber = splitDimKey[1];
            dimF7Map.put(dimNumber.toLowerCase(), dimensionId);
        }
        this.getPageCache().put(KEY_DIMF7MAP, SerializationUtils.toJsonString(dimF7Map));
        this.getPageCache().put(KEY_TEMPLATEDIMMAP, SerializationUtils.toJsonString((Object)templateDimMap));
    }

    protected void dataInit() {
        DesignFormInput input = this.getDesignFormInput();
        Map chapterPermMap = input == null ? new LinkedHashMap(10) : input.getChapterPermMap();
        List chapters = DisclosureDesignHelper.getChapterInfoByTemplateAndPerm((Long)this.getTemplateId(), chapterPermMap);
        Long chapterId = 0L;
        if (chapters.size() > 0) {
            chapterId = LongUtil.toLong(((Map)chapters.get(0)).get("id"));
        }
        this.changeChapter(chapterId);
    }

    protected void dataInit(Long chapterId) {
    }

    private void changeChapter(Long newChapterId) {
        this.initDesignFormInput();
        Long oldChapterId = this.getSelectChapterId();
        DynamicObject newChapter = DisclosureChapterHelper.getChapter((Long)newChapterId, (boolean)false);
        this.releaseChapter(oldChapterId == null ? "" : oldChapterId.toString());
        this.setSelectChapterId(newChapterId);
        this.setRefreshControl(newChapter);
        if (LongUtil.isvalidLong((Object)newChapterId)) {
            this.dataInit(newChapterId);
        } else {
            JSONObject data = DisclosureDesignHelper.dataInfo((String)ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u5de6\u4fa7\u7684\u65b0\u589e\u7ae0\u8282\u6309\u94ae\uff0c\u65b0\u589e\u7ae0\u8282\u540e\u9009\u4e2d\u7ae0\u8282\u5f00\u59cb\u8bbe\u8ba1\u62ab\u9732\u62a5\u544a\u3002", (String)"DisclosureServiceHelper_21", (String)"epm-far-business", (Object[])new Object[0]));
            this.SendToVue(data);
        }
    }

    private void setRefreshControl(DynamicObject newChapter) {
        boolean isSaveBtnEnable = true;
        if (newChapter != null) {
            DesignFormInput input;
            boolean commited = ChapterCommitStatusEnum.COMMIT.getType().equalsIgnoreCase(newChapter.getString("commitstatus"));
            if (commited) {
                isSaveBtnEnable = false;
            }
            Long newCharpteId = newChapter.getLong("id");
            ArrayList tips = new ArrayList(2);
            int status = LockChapterHelper.lockChapter((String)"fidm_webdesign", (IPageCache)this.getPageCache(), (String)String.valueOf(newCharpteId), tips);
            if (status == 2) {
                tips.forEach(m -> this.getView().showTipNotification(m));
                isSaveBtnEnable = false;
            }
            if ((input = this.getDesignFormInput()) != null) {
                Map chapterPermMap = input.getChapterPermMap();
                String perm = (String)chapterPermMap.get(newCharpteId);
                boolean isReadOnlly = false;
                if (PermClassBaseHelper.isNoPerm((String)perm)) {
                    String msg = ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u65e0\u6743\u9650\u6216\u5df2\u5220\u9664\u3002", (String)"AbstractChapterPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]);
                    this.getView().showMessage(msg, MessageTypes.Default, new ConfirmCallBackListener(FIDM_MSG_CLOSE));
                    isReadOnlly = true;
                } else if (DataTypeEnum.READ.getIndex().equalsIgnoreCase(perm)) {
                    isReadOnlly = true;
                }
                this.getView().setEnable(Boolean.valueOf(!isReadOnlly), new String[]{BTN_SAVE, BTN_COMMIT_ITEM, BTN_SENDBACK_ITEM, BTN_ENABLE_ITEM, BTN_DISABLE_ITEM});
                if (isSaveBtnEnable && isReadOnlly) {
                    isSaveBtnEnable = false;
                }
            }
            this.getView().setEnable(Boolean.valueOf(isSaveBtnEnable), new String[]{BTN_SAVE});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_PREVIEW});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_COMMIT_ITEM, BTN_SENDBACK_ITEM, BTN_ENABLE_ITEM, BTN_DISABLE_ITEM, BTN_PREVIEW});
        }
    }

    protected String checkDataSetPerm(String dataSetId) {
        String msg = "";
        String perm = PermClassEntityHelper.getSingleFIDMPermission((String)"fidm_dataset", (Long)LongUtil.toLong((Object)dataSetId), (Long)this.getDmModelId(), (Long)this.getUserId(), (String)FIMDMODEL);
        if ("2".equals(perm)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AbstractDesignPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
        }
        return msg;
    }

    protected void moduleSaveCallBack() {
        List moduleList = ModuleServiceHelper.getModuleList((Long)this.getDmModelId(), (String)"1");
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_MODULE_REFRESH, (Object)moduleList, (String)this.getCallBackPrimaryKey(DisclosureConstants.CallBackType.EVENT_MODULE_SAVE));
        this.SendToVue(result);
    }

    protected boolean dimMemberReturn(Object returnData, boolean isMuti) {
        JSONObject jsonObject = this.getCallBackType(DisclosureConstants.CallBackType.EVENT_DIM_F7);
        if (jsonObject == null) {
            return false;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getDmModelId());
        String dimNumber = jsonObject.getJSONObject("dim").getString("number");
        String dimShortNumber = jsonObject.getJSONObject("dim").getString("shortNumber");
        JSONObject data = new JSONObject(2);
        data.fluentPut("dimNumber", (Object)dimNumber);
        data.fluentPut("dimShortNumber", (Object)dimShortNumber);
        if (isMuti) {
            MutilF7MemberResult mutilF7MemberResult = modelStrategyEx.getDimensionF7().getMutilF7MemberList((AbstractFormPlugin)this, returnData);
            if (mutilF7MemberResult.getMemberInfos().size() == 0) {
                return false;
            }
            data.put("member", new LinkedHashMap(1));
            data.fluentPut("members", (Object)DimensionUtils.dimMemberConvertToMap((List)mutilF7MemberResult.getMemberInfos()));
            data.fluentPut("dislapyText", (Object)String.join((CharSequence)",", mutilF7MemberResult.getMemberInfos().stream().map(m -> m.getName()).collect(Collectors.toList())));
            data.fluentPut("isDim", (Object)"2");
        } else {
            DimMemberInfo memberInfo = modelStrategyEx.getDimensionF7().singleClosedCallBack(returnData);
            if (memberInfo == null) {
                return false;
            }
            data.fluentPut("member", (Object)DimensionUtils.dimMemberConvertToMap((DimMemberInfo)memberInfo));
            data.fluentPut("dislapyText", (Object)memberInfo.getName());
        }
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_DIM_F7_RESULT, (Object)data, (String)jsonObject.getString("primaryKey"));
        this.SendToVue(result);
        return true;
    }

    private void datasetFilterEntryCallback(Object returnData) {
        if (Objects.isNull(returnData)) {
            return;
        }
        List filterEntry = (List)JacksonUtils.fromJson((String)((String)returnData), (TypeReference)new TypeReference<List<DatasetFilterItem>>(){});
        String itemId = "";
        String datasetId = "";
        String filterView = "";
        JSONObject jsonObject = this.getCallBackType(DisclosureConstants.CallBackType.EVENT_DS_FILTER);
        if (Objects.nonNull(jsonObject)) {
            itemId = jsonObject.getString("itemId");
            datasetId = jsonObject.getString("dsId");
            filterView = DatasetFilterHelper.getFilterView((Long)this.getDmModelId(), (Long)LongUtil.toLong((Object)datasetId), (List)filterEntry);
        }
        JSONArray filterEntryJson = JSON.parseArray((String)JSON.toJSONString((Object)filterEntry));
        for (Object filter : filterEntryJson) {
            JSONObject filterObject = (JSONObject)filter;
            filterObject.put("dimensionId", (Object)filterObject.getString("dimensionId"));
            filterObject.put("memberId", (Object)filterObject.getString("memberId"));
        }
        JSONObject data = new JSONObject(4);
        data.fluentPut("itemId", (Object)itemId);
        data.fluentPut("dsId", (Object)datasetId);
        data.fluentPut("datesetFilterItems", (Object)filterEntryJson);
        data.fluentPut("datesetFilterItemsStr", (Object)filterView);
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_DS_FILTER_RESULT, (Object)data, (String)this.getCallBackPrimaryKey(DisclosureConstants.CallBackType.EVENT_DS_FILTER));
        this.SendToVue(result);
    }

    protected void varRefresh(DisclosureConstants.CallBackType callBackType) {
        List chapterTreeList = VariableService.getChapterTreeList((Long)this.getDmModelId(), (Long)this.getSelectChapterId());
        String primaryKey = this.getCallBackPrimaryKey(callBackType);
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_VAR_REFRESH, (Object)chapterTreeList, (String)primaryKey);
        this.SendToVue(result);
    }

    protected void dsRefresh(DisclosureConstants.CallBackType callBackType) {
        List chapterTreeList = DatasetServiceHelper.getChapterTreeList((Long)this.getDmModelId(), (Long)this.getSelectChapterId(), (String)ApplicationTypeEnum.FIDM.getAppnum());
        String primaryKey = this.getCallBackPrimaryKey(callBackType);
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_DS_REFRESH, (Object)chapterTreeList, (String)primaryKey);
        this.SendToVue(result);
    }

    protected boolean chapterTreeReturn(String actionId) {
        DisclosureConstants.CallBackType callBackType = null;
        callBackType = "fidm_chapter".equalsIgnoreCase(actionId) ? DisclosureConstants.CallBackType.EVENT_CHAPTER_ADD : (ChapterEdit.equalsIgnoreCase(actionId) ? DisclosureConstants.CallBackType.EVENT_CHAPTER_EDIT : DisclosureConstants.CallBackType.EVENT_CHAPTER_DELETE);
        String primaryKey = "";
        JSONObject jsonObject = this.getCallBackType(callBackType);
        if (jsonObject != null) {
            primaryKey = jsonObject.getString("primaryKey");
        }
        this.initDesignFormInput();
        DesignFormInput input = this.getDesignFormInput();
        Map chapterPermMap = input == null ? new LinkedHashMap(10) : input.getChapterPermMap();
        List chapters = DisclosureDesignHelper.getChapterInfoByTemplateAndPerm((Long)this.getTemplateId(), chapterPermMap);
        Map template = DisclosureDesignHelper.getTempalteInfo((Long)this.getTemplateId());
        JSONObject data = new JSONObject();
        data.put("chapter", (Object)chapters);
        data.put("template", (Object)template);
        if (chapters.size() == 0) {
            this.changeChapter(null);
        }
        if (callBackType == DisclosureConstants.CallBackType.EVENT_CHAPTER_ADD && chapters.size() == 1) {
            this.changeChapter(LongUtil.toLong(((Map)chapters.get(0)).get("id")));
            return true;
        }
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_CHAPTER_TREE, (Object)data, (String)primaryKey);
        this.SendToVue(result);
        return true;
    }

    public Long getDmModelId() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        return modelId;
    }

    public Long getTemplateId() {
        Long templateId = null;
        DesignFormInput input = this.getDesignFormInput();
        if (input != null) {
            templateId = input.getTemplateId();
        }
        return templateId;
    }

    protected Long getSelectChapterId() {
        String chapterIdStr = this.getPageCache().get(KEY_CHAPTER_VUE);
        if (kd.bos.util.StringUtils.isEmpty((String)chapterIdStr)) {
            return 0L;
        }
        return LongUtil.toLong((Object)chapterIdStr);
    }

    protected void setSelectChapterId(Long chapterId) {
        this.getPageCache().put(KEY_CHAPTER_VUE, chapterId == null ? "0" : chapterId.toString());
    }

    protected Boolean checkPermClass() {
        String perm;
        DesignFormInput input = this.getDesignFormInput();
        if (input == null) {
            return true;
        }
        Long chapterId = this.getSelectChapterId();
        if (LongUtil.isvalidLong((Object)chapterId) && (PermClassBaseHelper.isNoPerm((String)(perm = (String)input.getChapterPermMap().get(chapterId))) || PermClassBaseHelper.isReadPerm((String)perm))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"AbstractChapterPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Boolean checkTemplatePermClass() {
        DesignFormInput input = this.getDesignFormInput();
        if (input == null) {
            return true;
        }
        String perm = input.getTemplatePerm();
        if (PermClassBaseHelper.isNoPerm((String)perm) || PermClassBaseHelper.isReadPerm((String)perm)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6a21\u677f\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"AbstractChapterPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean checkSelectChapter() {
        Long chapterId = this.getSelectChapterId();
        if (Objects.isNull(chapterId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ae0\u8282\u201d\u3002", (String)"AbstractChapterPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void saveOper() {
        if (!this.checkSelectChapter()) {
            return;
        }
        String msg = this.checkAnalysisTemplatePerm();
        if (!kd.bos.util.StringUtils.isEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        this.SendToVue(DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_SAVE));
    }

    protected void modifyBaseInfoOper() {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("fidm_template");
        param.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AbstractDesignPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        Long templateID = this.getTemplateId();
        param.setPkId((Object)templateID);
        param.setCustomParam(PARAM_TEMPLATEID, (Object)templateID);
        param.setAppId("fidm");
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fidm_template"));
        this.getView().showForm((FormShowParameter)param);
    }

    protected void saveAsChapter(Long chapterId) {
        if (Objects.isNull(chapterId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ae0\u8282\u3002", (String)"AbstractChapterPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = "fidm_chaptersave";
        Long dmModelId = this.getDmModelId();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("oldChapterId", (Object)chapterId);
        formShowParameter.setCustomParam("dmmodelid", (Object)dmModelId);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u53e6\u5b58\u4e3a\u7ae0\u8282\u5e93", (String)"AbstractChapterPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
        this.getPlugin().getView().showForm(formShowParameter);
    }

    protected void previewOper() {
        this.previewOper(false);
    }

    protected void previewOper(boolean randFileName) {
        if (!this.checkSelectChapter()) {
            return;
        }
        DynamicObject chapter = DisclosureChapterHelper.getChapter((Long)this.getSelectChapterId(), (boolean)false);
        if (chapter != null && kd.bos.util.StringUtils.isEmpty((String)chapter.getString("url"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ae0\u8282\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u7ae0\u8282\u3002", (String)"AbstractDesignPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Long templateId = this.getTemplateId();
        if (templateId == null || templateId <= 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ae0\u8282\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4fdd\u5b58\u7ae0\u8282\u3002", (String)"AbstractDesignPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DisclosurePreviewSelectHelper.openByChapter((IFormPlugin)this, (IFormView)this.getView(), (Long)this.getDmModelId(), (Long)templateId, (Long)this.getSelectChapterId(), (boolean)randFileName, (String)this.getWordView().getType());
    }

    protected void generalReportOper() {
        String formId = "fidm_report_generate";
        String caption = ResManager.loadKDString((String)"\u751f\u6210\u62a5\u544a", (String)"DiscTemplateListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]);
        GenerateFormInput formInput = new GenerateFormInput();
        formInput.setDmModelId(this.getDmModelId());
        formInput.setTemplateId(this.getTemplateId());
        formInput.setOperType("generate");
        FormShowParameter formShowParameter = DisclosureFormHelper.createFormParam((Object)formInput);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(caption);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    protected void refreshOper() {
        Long chapterId = this.getSelectChapterId();
        if (Objects.isNull(chapterId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ae0\u8282\u201d\u3002", (String)"AbstractChapterPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(KEY_OPERATION, BTN_REFRESH);
        this.isDocChanged();
    }

    protected void existOper() {
        this.getPageCache().put(KEY_OPERATION, BTN_EXIT);
        Long chapterId = this.getSelectChapterId();
        if (Objects.isNull(chapterId)) {
            this.isDocChangedResult(false);
            return;
        }
        this.isDocChanged();
    }

    protected void isDocChanged() {
    }

    protected void isDocChangedResult(boolean isChanged) {
        String opertion = this.getPageCache().get(KEY_OPERATION);
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u672c\u64cd\u4f5c\u4f1a\u4e22\u5931\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"AbstractDesignPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]);
        if (BTN_REFRESH.equals(opertion)) {
            if (isChanged) {
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_CHAPTER_REFRESH, (IFormPlugin)this));
            } else {
                MessageBoxClosedEvent event = new MessageBoxClosedEvent((Object)this, CALLBACKID_CHAPTER_REFRESH, MessageBoxResult.Yes.getValue());
                this.confirmCallBack(event);
            }
        } else if (BTN_EXIT.equals(opertion)) {
            if (isChanged) {
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_CHAPTER_CLOSE, (IFormPlugin)this));
            } else {
                MessageBoxClosedEvent event = new MessageBoxClosedEvent((Object)this, CALLBACKID_CHAPTER_CLOSE, MessageBoxResult.Yes.getValue());
                this.confirmCallBack(event);
            }
        } else if (BTN_CLICK_CHAPTER.equals(opertion)) {
            if (isChanged) {
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_CHAPTER_REFRESH, (IFormPlugin)this));
            } else {
                MessageBoxClosedEvent event = new MessageBoxClosedEvent((Object)this, CALLBACKID_CHAPTER_REFRESH, MessageBoxResult.Yes.getValue());
                this.confirmCallBack(event);
            }
        }
    }
}

