/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.MyReportStatusEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureConstants;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.chapter.LockChapterHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.gpt.DiscloseGPTService;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassReportHelper;
import kd.epm.far.business.fidm.report.DisclosureReportFileHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.report.dto.ReportEditFormInput;
import kd.epm.far.business.fidm.task.DisclosureTaskHepler;
import kd.epm.far.business.fidm.task.dto.ModuleResetTaskResult;
import kd.epm.far.business.fidm.web.WebServiceHelper;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.MainPage;

public class AbstractReportEidtPlugin
extends AbstractBaseDMFormPlugin
implements MainPage {
    protected static final String CTL_MODEL = "model";
    protected static final String CTL_CUSTOMCONTROLAP = "customcontrolap";
    protected static final String BTN_SAVE = "btn_save";
    protected static final String BTN_FINALIZE = "btn_finalize";
    protected static final String BTN_DRAFT = "btn_draft";
    protected static final String BTN_DOWNLOADWORD = "btn_downloadword";
    protected static final String BTN_DOWNLOADPDF = "btn_downloadpdf";
    protected static final String BTN_DOWNLOADREPORT_WORD = "btn_downloadreport_word";
    protected static final String BTN_DOWNLOADREPORT_PDF = "btn_downloadreport_pdf";
    protected static final String BTN_CHAPTER_INFO = "btn_chapter_info";
    protected static final String BTN_REFRESH = "btn_refresh";
    protected static final String BTN_RESET = "btn_reset";
    protected static final String BTN_ERRORRESET = "btn_errorreset";
    protected static final String BTN_EXIT = "btn_exit";
    protected static final String BTN_CLICK_CHAPTER = "btn_click_chapte";
    protected static final String PARAM_REPORT_ID = "reportId";
    protected static final String REPORTCHAPTER_BASEINFO_CLOSED = "REPORTCHAPTER_BASEINFO_CLOSED";
    protected static final String REPORT_RESET_CLOSEDCALLBACK = "REPORT_RESET_CLOSEDCALLBACK";
    protected static final String REPORT_ERRORRESET_CLOSEDCALLBACK = "REPORT_ERRORRESET_CLOSEDCALLBACK";
    protected static final String CALLBACKID_REPORT_REFRESH = "callbackid_report_refresh";
    protected static final String CALLBACKID_CHAPTER_REFRESH = "callbackid_chapter_refresh";
    protected static final String CALLBACKID_CHAPTER_CLOSE = "callbackid_chapter_close";
    protected static final String FIDM_MSG_CLOSE = "fidm_msg_close";
    protected static final String KEY_OPERATION = "KEY_OPERATION";
    protected static final String KEY_CHAPTER_VUE = "KEY_CHAPTER_VUE";
    protected static final String KEY_RESET_TYPE = "KEY_RESET_TYPE";
    protected static final String KEY_DESIGN_REPORT_INNPUT = "KEY_DESIGN_REPORT_INNPUT";

    protected OpenWordEnum getWordView() {
        return OpenWordEnum.WEB;
    }

    @Override
    public void initialize() {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.afterCreateNewData(e);
        this.initModel();
        this.initEditFormInput();
        this.initParamsF7();
        this.checkReportStatus();
        this.dataInit();
    }

    private void initModel() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        this.setValue(CTL_MODEL, modelId);
        this.getView().setEnable(Boolean.FALSE, new String[]{CTL_MODEL});
    }

    protected void initEditFormInput() {
        Long reportId = (Long)this.getFormCustomParam(PARAM_REPORT_ID);
        String perm = PermClassReportHelper.getReportPerm((Long)reportId);
        if (PermClassBaseHelper.isNoPerm((String)perm)) {
            String msg = ResManager.loadKDString((String)"\u62a5\u544a\u65e0\u6743\u9650\u6216\u5df2\u5220\u9664\u3002", (String)"AbstractChapterPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(msg, MessageTypes.Default, new ConfirmCallBackListener(FIDM_MSG_CLOSE));
            return;
        }
        DynamicObject report = DisclosureReportHelper.getReport((Long)reportId);
        Map chapterPermMap = PermClassReportHelper.getChapterPermMapByReport((Long)this.getDmModelId(), (Long)reportId);
        ReportEditFormInput formInput = new ReportEditFormInput();
        formInput.setDmModelId(this.getDmModelId());
        formInput.setReportId(reportId);
        formInput.setReportPerm(perm);
        formInput.setChapterPermMap(chapterPermMap);
        formInput.setEdit("0".equals(report.getString("isedit")));
        this.getPageCache().put(KEY_DESIGN_REPORT_INNPUT, JSON.toJSONString((Object)formInput));
    }

    protected ReportEditFormInput getEditFormInput() {
        String data = this.getPageCache().get(KEY_DESIGN_REPORT_INNPUT);
        if (data == null) {
            return null;
        }
        return (ReportEditFormInput)JSON.parseObject((String)data, ReportEditFormInput.class);
    }

    private void initParamsF7() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        this.initParamsF7(modelId, this.getReportId(), this.getView());
    }

    public Long getDmModelId() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        return modelId;
    }

    protected Long getReportId() {
        ReportEditFormInput input = this.getEditFormInput();
        Long reportId = (Long)this.getFormCustomParam(PARAM_REPORT_ID);
        if (input != null) {
            reportId = input.getReportId();
        }
        return reportId;
    }

    protected void releaseChapter(String chapterId) {
        LockChapterHelper.releaseChapter((String)"fidm_webreport_edit", (IPageCache)this.getPageCache(), (String)chapterId);
    }

    protected void releaseChapter() {
        String curLockedChapter = this.getPageCache().get("curlockedchapter");
        if (StringUtils.isNotEmpty((CharSequence)curLockedChapter)) {
            LockChapterHelper.releaseChapter((String)"fidm_webreport_edit", (IPageCache)this.getPageCache(), (String)curLockedChapter);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": {
                this.getPageCache().put(KEY_OPERATION, BTN_REFRESH);
                if (LongUtil.isvalidLong((Object)this.getSelectChapterId())) {
                    this.isDocChanged();
                    break;
                }
                this.isDocChangedResult(false);
                break;
            }
            case "btn_exit": {
                this.getPageCache().put(KEY_OPERATION, BTN_EXIT);
                if (LongUtil.isvalidLong((Object)this.getSelectChapterId())) {
                    this.isDocChanged();
                    break;
                }
                this.isDocChangedResult(false);
                break;
            }
            case "btn_save": {
                this.checkPerm(itemKey);
                if (!this.checkPermClass()) break;
                this.saveDoc();
                break;
            }
            case "btn_finalize": 
            case "btn_draft": {
                this.checkPerm(itemKey);
                if (!this.checkPermClass()) break;
                this.setCurrReportChapterStatus(itemKey);
                break;
            }
            case "btn_downloadword": 
            case "btn_downloadpdf": {
                this.checkPerm(itemKey);
                this.downloadChapter(itemKey);
                break;
            }
            case "btn_downloadreport_word": 
            case "btn_downloadreport_pdf": {
                this.checkPerm(BTN_DOWNLOADWORD);
                this.downloadReport(itemKey);
                break;
            }
            case "btn_chapter_info": {
                this.checkPerm(itemKey);
                this.modifyReportChapterInfo();
                break;
            }
            case "btn_reset": {
                this.checkPerm(BTN_RESET);
                this.resetChapter();
                break;
            }
            case "btn_errorreset": {
                this.checkPerm(BTN_RESET);
                this.resetErrorChapter();
                break;
            }
        }
    }

    protected boolean checkPermClass() {
        return this.checkPermClass(true);
    }

    protected boolean checkPermClass(boolean isShowTip) {
        String perm;
        ReportEditFormInput input = this.getEditFormInput();
        if (input == null) {
            return true;
        }
        Long chapterId = this.getSelectChapterId();
        if (LongUtil.isvalidLong((Object)chapterId) && (PermClassBaseHelper.isNoPerm((String)(perm = (String)input.getChapterPermMap().get(chapterId))) || PermClassBaseHelper.isReadPerm((String)perm))) {
            if (isShowTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"AbstractReportPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "callbackid_report_refresh": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.changeChapter(this.getSelectChapterId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"AbstractReportPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "callbackid_chapter_refresh": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.changeChapter(this.getSelectChapterId());
                break;
            }
            case "callbackid_chapter_close": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.getView().close();
                break;
            }
            case "REPORT_RESET_CLOSEDCALLBACK": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.resetDataOper(BTN_RESET);
                break;
            }
            case "REPORT_ERRORRESET_CLOSEDCALLBACK": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.resetDataOper(BTN_ERRORRESET);
                break;
            }
            case "fidm_msg_close": {
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "REPORTCHAPTER_BASEINFO_CLOSED": {
                if (!Objects.nonNull(returnData)) break;
                this.chapterTreeReturn();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractReportPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "task_modulereset_close_back": {
                ModuleResetTaskResult moduleResetTaskResult = DisclosureTaskHepler.getModuleResetCallBackData((Object)returnData);
                if (moduleResetTaskResult == null) {
                    return;
                }
                if (!moduleResetTaskResult.getSuccess().booleanValue()) {
                    this.getView().showTipNotification(moduleResetTaskResult.getMessage());
                    break;
                }
                this.resetDataResultSuccess(moduleResetTaskResult);
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        try {
            DisclosureConstants.CallBackType callBackType = DisclosureConstants.CallBackType.valueOf((String)eventName);
            this.putCallBackType(callBackType, eventArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (eventName.equals(DisclosureConstants.CallBackType.EVENT_SAVE.toString())) {
            this.evSave(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_DOCUMENT_CHANGED.toString())) {
            this.evDocumentChanged(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_FOCUS_BOOKMARK.toString())) {
            this.evFocusBookMark(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_MODULEDATARESET.toString())) {
            this.evModuleDataReset(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_AI_USER_COMMAND.toString())) {
            this.evAIUserCommand(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_UPLOAD_IMAGE.toString())) {
            this.evUploadImage(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_EXIT.toString())) {
            this.evExit(eventArgs);
        } else if (eventName.equals(DisclosureConstants.CallBackType.EVENT_REPORT_CHAPTER_SWITCH.toString())) {
            this.evReportChapterSwitch(eventArgs);
        }
    }

    protected void evSave(String eventArgs) {
    }

    protected void evDocumentChanged(String eventArgs) {
    }

    protected void evFocusBookMark(String eventArgs) {
    }

    protected void evModuleDataReset(String eventArgs) {
    }

    protected void evAIUserCommand(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String primaryKey = "";
        if (jsonObject != null) {
            String type = jsonObject.getString("type");
            primaryKey = jsonObject.getString("primaryKey");
            if ("1".equals(type)) {
                JSONObject item = WebServiceHelper.getModuleByReport((Long)this.getReportId(), (Long)this.getSelectChapterId(), (Long)LongUtil.toLong((Object)jsonObject.getString("content")));
                if (item != null) {
                    Object itemDataResult = item.get((Object)"data");
                    if (itemDataResult == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7ed3\u679c\u6570\u636e\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u4e3a\u65e7\u7248\u672c\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractDesignPlugin_21", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    }
                    jsonObject.put("content", item.get((Object)"data"));
                }
                eventArgs = jsonObject.toJSONString();
            }
        }
        try {
            JSONObject result = DiscloseGPTService.invokeGpt((String)eventArgs);
            this.SendToVue(result);
        }
        catch (KDBizException bizException) {
            this.SendToVue(DisclosureVueHelper.getErrorResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_AI_USER_COMMAND, (String)bizException.getMessage(), (String)primaryKey));
        }
        catch (Exception ex) {
            String tips = ResManager.loadKDString((String)"\u6267\u884cGPT\u529f\u80fd\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractDesignPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.SendToVue(DisclosureVueHelper.getErrorResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_AI_USER_COMMAND, (String)tips, (String)primaryKey));
        }
    }

    protected void evUploadImage(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String id = jsonObject.getString("id");
        String base64String = jsonObject.getString("base64");
        String url = DisclosureFileHelper.uploadGenealFile((String)"fidm_webdesign", (Object)GlobalIdUtil.genGlobalLongId(), (String)(GlobalIdUtil.genGlobalLongId() + ".png"), (String)base64String, (boolean)true);
        JSONObject data = new JSONObject(2);
        data.fluentPut("id", (Object)id);
        data.fluentPut("src", (Object)url);
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_UPLOAD_IMAGE, (Object)data, (String)jsonObject.getString("primaryKey"));
        this.SendToVue(result);
    }

    protected void evExit(String eventArgs) {
        this.getView().close();
        this.releaseChapter();
    }

    protected void evReportChapterSwitch(String eventArgs) {
        Long chapterId = DisclosureJsonHelper.getValue((JSONObject)DisclosureJsonHelper.convert((String)eventArgs), (String)"id", (long)0L);
        if (LongUtil.isvalidLong((Object)chapterId)) {
            this.changeChapter(chapterId);
        } else {
            this.changeChapter(0L);
        }
    }

    protected void SendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    protected void putCallBackType(DisclosureConstants.CallBackType callBackType, String value) {
        this.getPageCache().put("KEY_" + callBackType.toString(), value);
    }

    protected boolean chapterTreeReturn() {
        String primaryKey = "";
        Long reportId = this.getReportId();
        Long dmModelId = this.getDmModelId();
        Map report = ReportChapterHelper.getReport((Long)reportId);
        List chapters = ReportChapterHelper.getChapterInfoByReportAndPerm((Long)dmModelId, (Long)reportId);
        JSONObject data = new JSONObject();
        data.put("chapter", (Object)chapters);
        data.put("report", (Object)report);
        if (chapters.size() == 0) {
            JSONObject msgData = DisclosureDesignHelper.dataInfo((String)ResManager.loadKDString((String)"\u62a5\u544a\u65e0\u7ae0\u8282\u6570\u636e\uff0c\u53ef\u80fd\u65e0\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u9000\u51fa\u91cd\u8fdb\u3002", (String)"AbstractDesignPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.SendToVue(msgData);
            return true;
        }
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_CHAPTER_TREE, (Object)data, (String)primaryKey);
        this.SendToVue(result);
        return true;
    }

    private boolean setRefreshSaveControl(DynamicObject newChapter) {
        boolean ischeck;
        if (newChapter == null) {
            return false;
        }
        Long chapterId = newChapter.getLong("id");
        Map chapter = ReportChapterHelper.getChapterInfo((Long)this.getReportId(), (Long)chapterId);
        if (chapter == null) {
            return false;
        }
        boolean isSaveBtnEnable = true;
        if (!this.checkReportBeforeLocked().booleanValue()) {
            isSaveBtnEnable = false;
        }
        if (ischeck = ((Boolean)chapter.get("ischeck")).booleanValue()) {
            isSaveBtnEnable = false;
        }
        if (isSaveBtnEnable) {
            String selectChapterIdStr = String.valueOf(chapterId);
            ArrayList tips = new ArrayList(2);
            int status = LockChapterHelper.lockChapter((String)"fidm_webreport_edit", (IPageCache)this.getPageCache(), (String)selectChapterIdStr, tips);
            if (status == 2) {
                tips.forEach(m -> this.getView().showTipNotification(m));
                isSaveBtnEnable = false;
            }
        }
        return isSaveBtnEnable;
    }

    private void setRefreshControl(DynamicObject newChapter) {
        boolean isChapter = newChapter != null;
        boolean isReadOnlly = true;
        boolean isSaveBtnEnable = true;
        boolean chapterInfoEnable = true;
        if (isChapter) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_download"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_downloadreport"});
            isSaveBtnEnable = this.setRefreshSaveControl(newChapter);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_download"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_downloadreport"});
            isSaveBtnEnable = false;
            chapterInfoEnable = false;
        }
        ReportEditFormInput input = this.getEditFormInput();
        if (isChapter && input != null) {
            Map chapterPermMap = input.getChapterPermMap();
            String perm = (String)chapterPermMap.get(newChapter.getLong("id"));
            if (PermClassBaseHelper.isNoPerm((String)perm)) {
                String msg = ResManager.loadKDString((String)"\u62a5\u544a\u65e0\u6743\u9650\u6216\u5df2\u5220\u9664\u3002", (String)"AbstractChapterPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(msg, MessageTypes.Default, new ConfirmCallBackListener(FIDM_MSG_CLOSE));
                isReadOnlly = true;
            } else {
                isReadOnlly = DataTypeEnum.READ.getIndex().equalsIgnoreCase(perm);
            }
            if (isSaveBtnEnable && isReadOnlly) {
                isSaveBtnEnable = false;
            }
            if (!input.isEdit()) {
                chapterInfoEnable = false;
                isReadOnlly = true;
                isSaveBtnEnable = false;
            }
        }
        this.getView().setEnable(Boolean.valueOf(chapterInfoEnable), new String[]{BTN_CHAPTER_INFO});
        this.getView().setEnable(Boolean.valueOf(!isReadOnlly), new String[]{BTN_DRAFT, BTN_FINALIZE, BTN_RESET, BTN_ERRORRESET});
        this.getView().setEnable(Boolean.valueOf(isSaveBtnEnable), new String[]{BTN_SAVE});
    }

    protected Boolean checkReportBeforeLocked() {
        Long reportId = this.getReportId();
        if (Objects.isNull(reportId)) {
            return Boolean.FALSE;
        }
        DynamicObject report = DisclosureReportHelper.getReport((Long)reportId);
        String status = report.getString("status");
        String isedit = report.getString("isedit");
        if (!"0".equals(isedit)) {
            return Boolean.FALSE;
        }
        if (!MyReportStatusEnum.UNCOMMIT.getValue().equals(status) && !MyReportStatusEnum.BACKED.getValue().equals(status)) {
            return Boolean.FALSE;
        }
        if (!this.checkPermClass(false)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected boolean saveDoc() {
        return false;
    }

    private void downloadChapter(String opKey) {
        if (!this.checkSelectReportChapter()) {
            return;
        }
        DisclosureReportFileHelper.downloadChapter((IFormView)this.getView(), (Long)this.getReportId(), (Long)this.getSelectChapterId(), (String)(opKey.equalsIgnoreCase(BTN_DOWNLOADPDF) ? "pdf" : "docx"));
    }

    private void downloadReport(String opKey) {
        if (!this.checkSelectReportChapter()) {
            return;
        }
        DisclosureReportFileHelper.downloadReport((IFormView)this.getView(), (Long)this.getReportId(), (String)(opKey.equalsIgnoreCase(BTN_DOWNLOADREPORT_PDF) ? "pdf" : "docx"));
    }

    private void modifyReportChapterInfo() {
        ReportChapterHelper.openReportChapterEditView((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getReportId(), (Long)this.getSelectChapterId());
    }

    private void resetChapter() {
        Long selectChapterId = this.getSelectChapterId();
        if (Objects.isNull(this.getReportId()) || Objects.isNull(selectChapterId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ae0\u8282\u201d\u3002", (String)"AbstractReportPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5bf9\u672c\u7ae0\u8282\u4e2d\u5168\u90e8\u7ec4\u4ef6\u6570\u636e\u8fdb\u884c\u91cd\u65b0\u8ba1\u7b97\u64cd\u4f5c\uff1f", (String)"AbstractReportPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(REPORT_RESET_CLOSEDCALLBACK, (IFormPlugin)this));
    }

    private void resetErrorChapter() {
        Long selectChapterId = this.getSelectChapterId();
        if (Objects.isNull(this.getReportId()) || Objects.isNull(selectChapterId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ae0\u8282\u201d\u3002", (String)"AbstractReportPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5bf9\u672c\u7ae0\u8282\u4e2d\u8ba1\u7b97\u5931\u8d25\u7684\u7ec4\u4ef6\u6570\u636e\u8fdb\u884c\u8ba1\u7b97\u64cd\u4f5c\uff1f", (String)"AbstractReportPlugin_24", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(REPORT_ERRORRESET_CLOSEDCALLBACK, (IFormPlugin)this));
    }

    private boolean setCurrReportChapterStatus(String itemKey) {
        if (!this.checkSelectReportChapter()) {
            return false;
        }
        Long reportId = this.getReportId();
        Long chapterId = this.getSelectChapterId();
        ResultInfo resultInfo = ResultInfo.success();
        String successMsg = "";
        if (BTN_DRAFT.equalsIgnoreCase(itemKey)) {
            resultInfo = ReportChapterHelper.setDraft((Long)reportId, (Long)chapterId);
            successMsg = ResManager.loadKDString((String)"\u6539\u4e3a\u8349\u7a3f\u3002", (String)"AbstractReportPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]);
        } else {
            resultInfo = ReportChapterHelper.setFinalize((Long)reportId, (Long)chapterId);
            successMsg = ResManager.loadKDString((String)"\u5b9a\u7a3f\u6210\u529f\u3002", (String)"AbstractReportPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        if (resultInfo.isSuccess().booleanValue()) {
            this.getView().showSuccessNotification(successMsg);
        } else {
            this.getView().showTipNotification(resultInfo.getMessage());
        }
        DynamicObject newChapter = DisclosureChapterHelper.getChapter((Long)chapterId);
        this.setRefreshControl(newChapter);
        this.chapterTreeReturn();
        return true;
    }

    private void dataInit() {
        ReportEditFormInput formInput = this.getEditFormInput();
        Map chapterPermMap = formInput == null ? new LinkedHashMap(10) : formInput.getChapterPermMap();
        Long reportId = this.getReportId();
        List chapters = ReportChapterHelper.getChapterInfoByReportAndPerm((Long)reportId, chapterPermMap);
        if (chapters.size() == 0) {
            JSONObject data = DisclosureDesignHelper.dataInfo((String)ResManager.loadKDString((String)"\u62a5\u544a\u65e0\u7ae0\u8282\u6570\u636e\uff0c\u53ef\u80fd\u65e0\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u9000\u51fa\u91cd\u8fdb\u3002", (String)"AbstractDesignPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.SendToVue(data);
            return;
        }
        Long chapterId = LongUtil.toLong(((Map)chapters.get(0)).get("id"));
        this.changeChapter(chapterId);
    }

    protected void dataInit(Long chapterId) {
    }

    private void changeChapter(Long newChapterId) {
        this.initEditFormInput();
        Long oldChapterId = this.getSelectChapterId();
        DynamicObject newChapter = DisclosureChapterHelper.getChapter((Long)newChapterId, (boolean)false);
        this.releaseChapter(oldChapterId == null ? "" : oldChapterId.toString());
        this.setSelectChapterId(newChapterId);
        this.setRefreshControl(newChapter);
        this.dataInit(newChapterId);
    }

    protected void setSelectChapterId(Long chapterId) {
        this.getPageCache().put(KEY_CHAPTER_VUE, chapterId == null ? "0" : chapterId.toString());
    }

    protected Long getSelectChapterId() {
        String chapterIdStr = this.getPageCache().get(KEY_CHAPTER_VUE);
        if (kd.bos.util.StringUtils.isEmpty((String)chapterIdStr)) {
            return 0L;
        }
        return LongUtil.toLong((Object)chapterIdStr);
    }

    protected boolean checkSelectReportChapter() {
        Long chapterId = this.getSelectChapterId();
        if (Objects.isNull(chapterId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ae0\u8282\u201d\u3002", (String)"AbstractReportPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void checkReportStatus() {
        Long reportId = this.getReportId();
        if (Objects.isNull(reportId)) {
            return;
        }
        DynamicObject report = QueryServiceHelper.queryOne((String)"fidm_report", (String)"id,status,isedit", (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        if (report != null) {
            String status = report.getString("status");
            if (!MyReportStatusEnum.UNCOMMIT.getValue().equals(status) && !MyReportStatusEnum.BACKED.getValue().equals(status)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u544a\u5df2\u7ecf%s,\u65e0\u6cd5\u8fdb\u884c\u7f16\u8f91\u4ec5\u4ee5\u67e5\u770b\u529f\u80fd\u6253\u5f00\u3002", (String)"AbstractReportPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]), MyReportStatusEnum.getStatusEnumByValue((String)status)));
            }
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseChapter();
        super.pageRelease(e);
    }

    protected void isDocChanged() {
    }

    protected void isDocChangedResult(boolean isChanged) {
        String opertion = this.getPageCache().get(KEY_OPERATION);
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u672c\u64cd\u4f5c\u4f1a\u4e22\u5931\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"AbstractDesignPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]);
        if (BTN_REFRESH.equals(opertion)) {
            if (isChanged) {
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_REPORT_REFRESH, (IFormPlugin)this));
            } else {
                MessageBoxClosedEvent event = new MessageBoxClosedEvent((Object)this, CALLBACKID_REPORT_REFRESH, MessageBoxResult.Yes.getValue());
                this.confirmCallBack(event);
            }
        } else if (BTN_EXIT.equals(opertion)) {
            if (isChanged) {
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_CHAPTER_CLOSE, (IFormPlugin)this));
            } else {
                MessageBoxClosedEvent event = new MessageBoxClosedEvent((Object)this, CALLBACKID_CHAPTER_CLOSE, MessageBoxResult.Yes.getValue());
                this.confirmCallBack(event);
            }
        } else if (BTN_CLICK_CHAPTER.equals(opertion)) {
            if (isChanged) {
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_CHAPTER_REFRESH, (IFormPlugin)this));
            } else {
                MessageBoxClosedEvent event = new MessageBoxClosedEvent((Object)this, CALLBACKID_CHAPTER_REFRESH, MessageBoxResult.Yes.getValue());
                this.confirmCallBack(event);
            }
        }
    }

    protected void resetDataOper(String btnName) {
        this.getPageCache().put(KEY_RESET_TYPE, btnName);
        this.resetDataOper();
    }

    protected void resetDataOper() {
    }

    protected void resetDataResultSuccess(ModuleResetTaskResult taskResult) {
    }

    protected boolean isResetDataALL() {
        String type = this.getPageCache().get(KEY_RESET_TYPE);
        return !BTN_ERRORRESET.equalsIgnoreCase(type);
    }

    protected void initParamsF7(Long modelId, Long reportId, IFormView view) {
        if (Objects.isNull(modelId)) {
            return;
        }
        ModelInfo dmmodel = new ModelStrategyEx(modelId).getModel().getModelInfo();
        String modelType = dmmodel.getModelType();
        if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            this.setF7Visable(false, view);
        } else {
            this.setF7Visable(true, view);
        }
        this.setF7Value(modelType, reportId, view);
    }

    protected void setF7Visable(boolean visable, IFormView view) {
        view.setVisible(Boolean.valueOf(visable), new String[]{"bcmentity", "bcmfy", "bcmperiod"});
        view.setVisible(Boolean.valueOf(!visable), new String[]{"epmentity", "budgetperiod", "epmver"});
    }

    protected void setF7Value(String type, Long reportId, IFormView view) {
        String selectFileds = "name,bcmentity,epmentity,year,budgetperiod,period,version";
        DynamicObject report = QueryServiceHelper.queryOne((String)"fidm_report", (String)selectFileds, (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        if (DisModelTypeEnum.EB.getType().equals(type)) {
            view.getModel().setValue("epmentity", report.get("epmentity"));
            view.getModel().setValue("budgetperiod", report.get("budgetperiod"));
            view.getModel().setValue("epmver", report.get("version"));
        } else {
            view.getModel().setValue("bcmentity", report.get("bcmentity"));
            view.getModel().setValue("bcmfy", report.get("year"));
            view.getModel().setValue("bcmperiod", report.get("period"));
        }
        view.getPageCache().put("Report_Name", report.getString("name"));
    }
}

