/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.base;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.MyReportStatusEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassReportHelper;
import kd.epm.far.business.fidm.report.DisclosureReportFileHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.report.ReportFlowStatusHelper;
import kd.epm.far.business.fidm.report.dto.ReportEditFormInput;
import kd.epm.far.business.fidm.report.dto.ReportFlowFormResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class AbstractReportViewPlugin
extends AbstractBaseDMFormPlugin
implements UploadListener {
    private static final String CTL_MODEL = "model";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_BASEINFO = "btn_baseinfo";
    private static final String BTN_DOWNLOADWORD = "btn_downloadword";
    private static final String BTN_DOWNLOADPDF = "btn_downloadpdf";
    private static final String BTN_SUBMIT = "btn_submit";
    private static final String BTN_BACK = "btn_back";
    private static final String BTN_AUDIT = "btn_audit";
    private static final String BTN_UNAUDIT = "btn_unaudit";
    private static final String BTN_ARCHIVER = "btn_archiver";
    private static final String BTN_CANCELARCHIVER = "btn_cancelarchiver";
    private static final String PARAM_REPORT_ID = "reportId";
    private static final String REPORT_BASEINFOR_CLOSED = "report_baseinfor_closed";
    protected static final String FIDM_MSG_CLOSE = "fidm_msg_close";
    protected static final String KEY_DESIGN_REPORT_INNPUT = "KEY_DESIGN_REPORT_INNPUT";

    protected OpenWordEnum getWordView() {
        return OpenWordEnum.WEB;
    }

    @Override
    public void initialize() {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.registerListener(e);
        this.addItemClickListeners(TOOLBARAP);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.afterCreateNewData(e);
        this.initModel();
        this.initEditFormInput();
        this.initParamsF7();
        this.initGetLasestReport();
        this.dataInit();
        this.initFlowButton();
        this.setRefreshControl();
    }

    protected void initModel() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        this.setValue(CTL_MODEL, modelId);
        this.getView().setEnable(Boolean.FALSE, new String[]{CTL_MODEL});
    }

    protected void initEditFormInput() {
        Long reportId = (Long)this.getFormCustomParam(PARAM_REPORT_ID);
        String perm = PermClassReportHelper.getReportPerm((Long)reportId);
        if (PermClassBaseHelper.isNoPerm((String)perm)) {
            String msg = ResManager.loadKDString((String)"\u62a5\u544a\u65e0\u6743\u9650\u6216\u5df2\u5220\u9664\u3002", (String)"AbstractChapterPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(msg, MessageTypes.Default, new ConfirmCallBackListener(FIDM_MSG_CLOSE));
            return;
        }
        DynamicObject report = DisclosureReportHelper.getReport((Long)reportId);
        Map chapterPermMap = PermClassReportHelper.getChapterPermMapByReport((Long)this.getDmModelId(), (Long)reportId);
        ReportEditFormInput formInput = new ReportEditFormInput();
        formInput.setDmModelId(this.getDmModelId());
        formInput.setReportId(reportId);
        formInput.setReportPerm(perm);
        formInput.setChapterPermMap(chapterPermMap);
        formInput.setEdit("0".equals(report.getString("isedit")));
        this.getPageCache().put(KEY_DESIGN_REPORT_INNPUT, JSON.toJSONString((Object)formInput));
    }

    protected ReportEditFormInput getEditFormInput() {
        String data = this.getPageCache().get(KEY_DESIGN_REPORT_INNPUT);
        if (data == null) {
            return null;
        }
        return (ReportEditFormInput)JSON.parseObject((String)data, ReportEditFormInput.class);
    }

    protected void initParamsF7() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        this.initParamsF7(modelId, this.getReportId(), this.getView());
    }

    protected void initGetLasestReport() {
        DisclosureReportHelper.mergeReport((Long)this.getReportId(), new ArrayList(2));
    }

    protected void initFlowButton() {
        String perm;
        DynamicObject report = QueryServiceHelper.queryOne((String)"fidm_report", (String)"id,status,isarchived", (QFilter[])new QFilter("id", "=", (Object)this.getReportId()).toArray());
        if (report == null) {
            return;
        }
        boolean isEdit = true;
        ReportEditFormInput input = this.getEditFormInput();
        if (input != null && (PermClassBaseHelper.isNoPerm((String)(perm = input.getReportPerm())) || PermClassBaseHelper.isReadPerm((String)perm))) {
            isEdit = false;
        }
        String status = report.getString("status");
        String isarchived = report.getString("isarchived");
        boolean unCommit = MyReportStatusEnum.UNCOMMIT.getValue().equals(status) || MyReportStatusEnum.BACKED.getValue().equals(status);
        this.getView().setVisible(Boolean.valueOf(isEdit && unCommit && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)), new String[]{BTN_SUBMIT});
        this.getView().setVisible(Boolean.valueOf(isEdit && MyReportStatusEnum.COMMITED.getValue().equals(status) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)), new String[]{BTN_BACK});
        this.getView().setVisible(Boolean.valueOf(isEdit && MyReportStatusEnum.COMMITED.getValue().equals(status) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)), new String[]{BTN_AUDIT});
        this.getView().setVisible(Boolean.valueOf(isEdit && MyReportStatusEnum.AUDITED.getValue().equals(status) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)), new String[]{BTN_UNAUDIT});
        this.getView().setVisible(Boolean.valueOf(isEdit && MyReportStatusEnum.AUDITED.getValue().equals(status) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)), new String[]{BTN_ARCHIVER});
        this.getView().setVisible(Boolean.valueOf(isEdit && MyReportStatusEnum.AUDITED.getValue().equals(status) && MyReportStatusEnum.ARCHIVED.getValue().equals(isarchived)), new String[]{BTN_CANCELARCHIVER});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVE});
    }

    private void setRefreshControl() {
        boolean reportInfoEnable = true;
        ReportEditFormInput input = this.getEditFormInput();
        if (input != null && !input.isEdit()) {
            reportInfoEnable = false;
        }
        this.getView().setEnable(Boolean.valueOf(reportInfoEnable), new String[]{BTN_BASEINFO});
    }

    protected Long getDmModelId() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        return modelId;
    }

    protected Long getReportId() {
        ReportEditFormInput input = this.getEditFormInput();
        Long reportId = (Long)this.getFormCustomParam(PARAM_REPORT_ID);
        if (input != null) {
            reportId = input.getReportId();
        }
        return reportId;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_baseinfo": {
                this.checkPerm(itemKey);
                this.modifyBaseInfo();
                break;
            }
            case "btn_downloadword": 
            case "btn_downloadpdf": {
                this.checkPerm(itemKey);
                this.downloadReport(itemKey);
                break;
            }
            case "btn_submit": 
            case "btn_back": 
            case "btn_audit": 
            case "btn_unaudit": 
            case "btn_archiver": 
            case "btn_cancelarchiver": {
                this.checkPerm(itemKey);
                if (!this.checkPermClass()) {
                    return;
                }
                ReportFlowStatusHelper.comfirmForm((IFormView)this.getView(), (IFormPlugin)this, Collections.singletonList(this.getReportId()), (String)itemKey);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "fidm_msg_close": {
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "report_baseinfor_closed": {
                if (returnData == null) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"AbstractReportViewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "fidm_flowcommitpage": {
                ReportFlowFormResult reportFlowFormResult;
                if (returnData == null || (reportFlowFormResult = (ReportFlowFormResult)returnData) == null) break;
                this.updateReportStatusResult(reportFlowFormResult);
                break;
            }
        }
    }

    private void updateReportStatusResult(ReportFlowFormResult formResult) {
        if (formResult == null) {
            return;
        }
        if (formResult.getErrorResult().size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u64cd\u4f5c\u6210\u529f\u3002", (String)"AbstractReportViewPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.initFlowButton();
            return;
        }
        for (Map.Entry item : formResult.getErrorResult().entrySet()) {
            this.getView().showTipNotification((String)item.getValue());
        }
        this.initFlowButton();
    }

    private void modifyBaseInfo() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REPORT_BASEINFOR_CLOSED));
        fsp.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AbstractReportViewPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        fsp.setFormId("fidm_report_baseinfo");
        fsp.setCustomParam("modelId", (Object)this.getDmModelId());
        Long rportId = this.getReportId();
        fsp.setCustomParam(PARAM_REPORT_ID, (Object)rportId);
        this.getView().showForm(fsp);
    }

    private void downloadReport(String opKey) {
        DisclosureReportFileHelper.downloadReport((IFormView)this.getView(), (Long)this.getReportId(), (String)(opKey.equals(BTN_DOWNLOADPDF) ? "pdf" : "docx"));
    }

    protected void dataInit() {
    }

    protected void initParamsF7(Long modelId, Long reportId, IFormView view) {
        if (Objects.isNull(modelId)) {
            return;
        }
        String modelType = new ModelStrategyEx(modelId).getModel().getModelInfo().getModelType();
        if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            this.setF7Visable(false, view);
        } else {
            this.setF7Visable(true, view);
        }
        this.setF7Value(modelType, reportId, view);
    }

    protected void setF7Visable(boolean visable, IFormView view) {
        view.setVisible(Boolean.valueOf(visable), new String[]{"bcmentity", "bcmfy", "bcmperiod"});
        view.setVisible(Boolean.valueOf(!visable), new String[]{"epmentity", "budgetperiod", "epmver"});
    }

    protected void setF7Value(String type, Long reportId, IFormView view) {
        String selectFileds = "name,bcmentity,epmentity,year,budgetperiod,period,version";
        DynamicObject report = QueryServiceHelper.queryOne((String)"fidm_report", (String)selectFileds, (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        if (DisModelTypeEnum.EB.getType().equals(type)) {
            view.getModel().setValue("epmentity", report.get("epmentity"));
            view.getModel().setValue("budgetperiod", report.get("budgetperiod"));
            view.getModel().setValue("epmver", report.get("version"));
        } else {
            view.getModel().setValue("bcmentity", report.get("bcmentity"));
            view.getModel().setValue("bcmfy", report.get("year"));
            view.getModel().setValue("bcmperiod", report.get("period"));
        }
        view.getPageCache().put("Report_Name", report.getString("name"));
    }

    protected boolean checkPermClass() {
        String perm;
        ReportEditFormInput input = this.getEditFormInput();
        if (input == null) {
            return true;
        }
        Long reportId = this.getReportId();
        if (LongUtil.isvalidLong((Object)reportId) && (PermClassBaseHelper.isNoPerm((String)(perm = input.getReportPerm())) || PermClassBaseHelper.isReadPerm((String)perm))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u62a5\u544a\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"AbstractReportPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

