/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.chapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.chapter.DisclosureCopyHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassChapterRepositoryHelper;
import kd.epm.far.business.fidm.perm.PermClassReportHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ChapterPlugin
extends AbstractBaseDMFormPlugin
implements BeforeF7SelectListener,
IBillPlugin {
    private static final String PARAM_GROUPID = "KEY_GROUP_ID";
    private static final String MODEL = "model";
    private static final String TEMPLATE = "template";
    private static final String GROUP = "group";
    private static final String SEQUENCE = "sequence";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String CTL_IMPORT_CHAPTER = "ctl_import_chapter";
    private static final String CTL_GROUP = "group";

    protected IDataModel getModel() {
        return super.getModel();
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit datasetBaseGroup;
        BasedataEdit datasetBasedata;
        Long modelId1 = this.getParamModelId();
        if (modelId1 == null && this.getModel().getValue(MODEL) instanceof DynamicObject) {
            modelId1 = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        }
        if (Objects.nonNull(modelId1)) {
            PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERMCLASS)), (Object)modelId1, (String)FIDMMODEL, (String)ApplicationTypeEnum.FIDM.getAppnum());
        }
        if ((datasetBasedata = (BasedataEdit)this.getControl(CTL_IMPORT_CHAPTER)) != null) {
            datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((datasetBaseGroup = (BasedataEdit)this.getControl("group")) != null) {
            datasetBaseGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Integer saveWordType;
        String msg;
        super.afterCreateNewData(e);
        Long modelId = this.getParamModelId();
        if (Objects.nonNull(modelId)) {
            this.setValue(MODEL, modelId);
        }
        if (!StringUtils.isEmpty((String)(msg = this.checkChapterPerm()))) {
            this.getView().showTipNotification(msg);
        }
        DisclosureChapterHelper.getAndCreateChapterCatalogRoot((Long)this.getModelId());
        Long templateId = (Long)this.getFormCustomParam("templateId");
        if (Objects.nonNull(templateId)) {
            this.setValue(TEMPLATE, templateId);
        }
        if ((saveWordType = (Integer)this.getFormCustomParam("savewordtype")) != null && saveWordType > 0) {
            this.setValue("saveWordType", saveWordType);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"group"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{CTL_IMPORT_CHAPTER});
    }

    public void afterLoadData(EventObject e) {
        String reportId = (String)this.getFormCustomParam("reportId");
        if (LongUtil.isvalidLong((Object)LongUtil.toLong((Object)reportId))) {
            String perm;
            Long readReportId = LongUtil.toLong((Object)reportId);
            Long chapterId = DisclosureFormHelper.getFormControlValueLong((Object)this.getView().getModel().getValue("id"), (String)"id");
            DynamicObject reportDy = DisclosureReportHelper.getReport((Long)readReportId);
            if (LongUtil.isvalidLong((Object)chapterId) && (PermClassBaseHelper.isNoPerm((String)(perm = PermClassReportHelper.getReportChapterPerm((Long)reportDy.getLong("model.id"), (Long)readReportId, (Long)chapterId))) || PermClassBaseHelper.isReadPerm((String)perm))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save1"});
            }
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"group"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CTL_IMPORT_CHAPTER});
    }

    private Long getParamModelId() {
        Long modelId = null;
        Object temp = this.getFormCustomParam("KEY_MODEL_ID");
        modelId = temp instanceof Integer ? Long.valueOf(((Integer)temp).intValue()) : (Long)temp;
        return modelId;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (e.getSource() instanceof Save && isSuccess) {
            Long curCharpterId = 0L;
            try {
                Object oldChapterId;
                curCharpterId = LongUtil.toLong((Object)this.getValue("id"));
                if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW) && Objects.nonNull(oldChapterId = this.getModel().getValue(CTL_IMPORT_CHAPTER))) {
                    DisclosureCopyHelper.copyChapter((Long)((DynamicObject)oldChapterId).getLong("id"), (Long)curCharpterId);
                }
                this.savePermClass();
            }
            catch (Exception ex) {
                DisclosureLogHelper.writeTemplateChapter((OperationResult)OperationResult.FAILURE, (OperationName)OperationName.EDIT, (Long)curCharpterId);
                throw ex;
            }
            DisclosureLogHelper.writeTemplateChapter((OperationResult)OperationResult.SUCCESS, (OperationName)OperationName.EDIT, (Long)curCharpterId);
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity().getLong("id"));
            this.getView().close();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (args.getSource() instanceof Save) {
            this.checkPerm("bar_save1");
            if (!this.validateNumber()) {
                args.setCancel(true);
                return;
            }
            String msg = this.checkChapterPerm();
            if (!StringUtils.isEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                return;
            }
            if (!OperationStatus.EDIT.equals((Object)parameter.getStatus())) {
                this.beforeAdd();
            }
        }
    }

    private void beforeAdd() {
        Long modelId = this.getParamModelId();
        Long templateId = (Long)this.getFormCustomParam("templateId");
        Long groupId = (Long)this.getFormCustomParam(PARAM_GROUPID);
        int sequence = this.getCurNodeSequence(modelId, templateId, groupId);
        this.setValue(SEQUENCE, sequence);
    }

    private int getCurNodeSequence(Long modelId, Long templateId, Long groupId) {
        QFilter filter = new QFilter(MODEL, "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
        filter.and(TEMPLATE, "=", (Object)(Objects.nonNull(templateId) ? templateId : 0L));
        DynamicObjectCollection list = QueryServiceHelper.query((String)this.getClass().getName(), (String)"fidm_chapter", (String)SEQUENCE, (QFilter[])new QFilter[]{filter}, (String)"sequence desc", (int)1);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 1;
        }
        DynamicObject maxSeqDynObj = (DynamicObject)list.iterator().next();
        return maxSeqDynObj.getInt(SEQUENCE) + 1;
    }

    private void savePermClass() {
        try (TXHandle tx = TX.required();){
            try {
                PermClassEntityHelper.savePermClass((DynamicObject)this.getModel().getDataEntity(), (String)FIDMMODEL);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                tx.markRollback();
            }
        }
    }

    private boolean validateNumber() {
        ResultInfo wordNameRes;
        ResultInfo resultInfo;
        String number = (String)this.getValue("number");
        if (StringUtils.isNotEmpty((String)number) && !(resultInfo = FarNumberRule.checkChapterNumber((String)number)).isSuccess().booleanValue()) {
            this.getView().showTipNotification(resultInfo.getMessage());
            return false;
        }
        Object name = this.getValue("name");
        if (name != null && !(wordNameRes = FarNumberRule.checkWordName((String)name.toString())).isSuccess().booleanValue()) {
            this.getView().showTipNotification(wordNameRes.getMessage());
            return false;
        }
        Long pkId = null;
        if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
            pkId = (Long)((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
        }
        Long modelId = ((DynamicObject)this.getValue(MODEL)).getLong("id");
        Object reportId = this.getFormCustomParam("reportId");
        if (Objects.nonNull(reportId)) {
            return this.checkReportChapter(modelId, number, pkId, LongUtil.toLong((Object)reportId));
        }
        return this.checkTemplateChapter(modelId, number, pkId);
    }

    private boolean checkReportChapter(Long modelId, String number, Long pkId, Long reportId) {
        int count;
        List chapterIds = DisclosureReportHelper.getChapterInfoByReport((Long)reportId);
        QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
        filter.and("id", "in", (Object)chapterIds);
        filter.and("number", "=", (Object)number);
        if (Objects.nonNull(pkId)) {
            filter.and("id", "!=", (Object)pkId);
        }
        if ((count = QueryServiceHelper.queryOne((String)"fidm_chapter", (String)"count(id) num", (QFilter[])new QFilter[]{filter}).getInt("num")) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s: \u201c\u7f16\u7801\u201d \u5df2\u5b58\u5728\u3002", (String)"ChapterPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    private boolean checkTemplateChapter(Long modelId, String number, Long pkId) {
        int count;
        DynamicObject templateDyn = (DynamicObject)this.getValue(TEMPLATE);
        Long templateId = Objects.nonNull(templateDyn) ? Long.valueOf(templateDyn.getLong("id")) : null;
        QFilter filter = new QFilter(MODEL, "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
        filter.and(TEMPLATE, "=", (Object)(Objects.nonNull(templateId) ? templateId : 0L));
        filter.and("number", "=", (Object)number);
        if (Objects.nonNull(pkId)) {
            filter.and("id", "!=", (Object)pkId);
        }
        if ((count = QueryServiceHelper.queryOne((String)"fidm_chapter", (String)"count(id) num", (QFilter[])new QFilter[]{filter}).getInt("num")) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s: \u201c\u7f16\u7801\u201d \u5df2\u5b58\u5728\u3002", (String)"ChapterPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    private String checkChapterPerm() {
        String perm = (String)this.getView().getFormShowParameter().getCustomParam("perm");
        String msg = "";
        if ("2".equals(perm)) {
            msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u7ae0\u8282\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ReportEditPlgin_19", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (CTL_IMPORT_CHAPTER.equals(key)) {
            Long modelId1 = this.getParamModelId();
            evt.setCustomQFilters(PermClassChapterRepositoryHelper.getChapterRepositoryListFilters((Long)modelId1));
            ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
            fsp.getTreeFilterParameter().setQFilters(PermClassChapterRepositoryHelper.getChapterRepositoryCatalogFilters((Long)modelId1));
        } else if ("group".equals(key)) {
            Long modelId1 = this.getParamModelId();
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
            filterList.add(new QFilter(MODEL, "=", (Object)modelId1));
            evt.setCustomQFilters(filterList);
            ArrayList<QFilter> filterList2 = new ArrayList<QFilter>(1);
            filterList2.add(new QFilter(MODEL, "=", (Object)modelId1));
            ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
            fsp.getTreeFilterParameter().setQFilters(filterList2);
        }
    }
}

