/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.chapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureTreeHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.business.fidm.chapter.ChapterRepositoryHelper;
import kd.epm.far.business.fidm.design.DisclosurePageJumpHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewSelectHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassChapterRepositoryHelper;
import kd.epm.far.business.fidm.task.DisclosureTaskHepler;
import kd.epm.far.business.fidm.task.dto.PreviewTaskInput;
import kd.epm.far.business.fidm.task.dto.PreviewTaskResult;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.MessageConstant;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.disclosure.chapter.AbstractChapterTreePlugin;

public class ChapterRepositoryListPlugin
extends AbstractChapterTreePlugin {
    private static final String CTL_MODEL = "model";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String SEARCHAP = "searchap";
    private static final String SEARCHMAPJSON = "searchMap";
    private static final String SEARCH_ALL = "all";
    private static final String SEARCH_NUMBER = "number";
    private static final String SEARCH_NAME = "name";
    private static final String FIELDNAME = "fieldName";
    private static final String VAL = "value";
    private static final String TREE_CHECK_BOX = "treecheckbox";
    private static final String CALLBACKID_DEL_CONFIRM = "callbackid_del_confirm";

    @Override
    public void initialize() {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addBeforePackageDataListener(this::setCatalogText);
        billList.addHyperClickListener(this::hyperLinkClick);
        billList.addSetFilterListener(this::setFilter);
        billList.setBillFormId(this.getBizEntityNumber());
        Search se = (Search)this.getControl(SEARCHAP);
        se.addEnterListener(v -> {
            List searchFields = v.getSearchFields();
            HashMap searMap = new HashMap(12);
            if (searchFields != null) {
                for (Map searchField : searchFields) {
                    List fieldName = (List)searchField.get(FIELDNAME);
                    String key = null;
                    if (fieldName.size() >= 2) {
                        key = SEARCH_ALL;
                    } else if (SEARCH_NUMBER.equals(fieldName.get(0))) {
                        key = SEARCH_NUMBER;
                    } else if (SEARCH_NAME.equals(fieldName.get(0))) {
                        key = SEARCH_NAME;
                    }
                    if (Objects.isNull(key)) continue;
                    List value = (List)searchField.get(VAL);
                    searMap.put(key, value.get(0));
                }
            }
            this.getPageCache().put(SEARCHMAPJSON, SerializationUtils.toJsonString(searMap));
            billList.clearSelection();
            billList.refresh();
        });
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            parameter.setBillFormId("fidm_chapter");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        ModelInfo model = this.getDiscModel();
        if (model == null) {
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return;
        }
        super.afterCreateNewData(e);
        Long dmModelId = this.getDMModelId();
        this.getModel().setValue(CTL_MODEL, (Object)dmModelId);
        this.getPageCache().put("KEY_MODEL_ID", dmModelId.toString());
        this.refreshTreeAndList(null);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        String key = e.getProperty().getName();
        if (key.equals(TREE_CHECK_BOX)) {
            this.refreshBillList();
        } else if (key.equals(CTL_MODEL)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
                return;
            }
            this.getPageCache().put("KEY_MODEL_ID", this.getDMModelId().toString());
            this.refreshTreeAndList(null);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "bar_delete": {
                this.actionDelete();
                break;
            }
            case "bar_enable": {
                this.setStatus(true);
                break;
            }
            case "bar_disable": {
                this.setStatus(false);
                break;
            }
            case "bar_preview": {
                DynamicObject[] tempObjs1 = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ChapterRepositoryListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                if (tempObjs1 == null) break;
                if (tempObjs1.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u201c\u7ae0\u8282\u201d\u3002", (String)"ChapterRepositoryListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                DisclosurePreviewSelectHelper.openByChapterRepository((IFormPlugin)this, (IFormView)this.getView(), (Long)this.getDMModelId(), (Long)tempObjs1[0].getLong("id"));
                break;
            }
            case "bar_refresh": {
                this.refreshTreeAndList(this.getFocusCataLog());
                break;
            }
        }
    }

    private void actionDelete() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds == null || selectedIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ChapterRepositoryListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ChapterRepositoryListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_DEL_CONFIRM, (IFormPlugin)this));
    }

    private void actionDeleteResult() {
        String msg = "";
        Long dmModelId = this.getDMModelId();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ArrayList<Long> deleteSuccessIds = new ArrayList<Long>(billList.getSelectedRows().size());
        for (ListSelectedRow row : billList.getSelectedRows()) {
            Long chapterId = LongUtil.toLong((Object)row.getPrimaryKeyValue());
            try {
                ResultInfo resultInfo = ChapterRepositoryHelper.deleteChapter((long)dmModelId, (long)chapterId);
                if (!resultInfo.isSuccess().booleanValue()) {
                    msg = row.getName() + "\uff1a" + resultInfo.getMessage();
                    this.getView().showTipNotification(msg);
                    continue;
                }
                deleteSuccessIds.add(chapterId);
                this.writeOpLog(OperationResult.SUCCESS, OperationName.DELETE, row);
            }
            catch (Exception ex) {
                this.writeOpLog(OperationResult.FAILURE, OperationName.DELETE, row);
                throw ex;
            }
        }
        if (deleteSuccessIds.size() > 0) {
            msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"ChapterRepositoryListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]), deleteSuccessIds.size());
            this.getView().showSuccessNotification(msg);
        }
        this.refreshBillList();
    }

    private void setStatus(boolean status) {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ChapterRepositoryListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        boolean repeat = false;
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (tempObjs != null) {
            for (DynamicObject tempObj : tempObjs) {
                tempObj.set("enable", (Object)(status ? "1" : "0"));
                tempObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                tempObj.set("modifytime", (Object)TimeServiceHelper.now());
            }
            if (repeat) {
                return;
            }
            try {
                SaveServiceHelper.save((DynamicObject[])tempObjs);
            }
            catch (Exception e) {
                OperationName opName = status ? OperationName.ENABLE : OperationName.DISABLE;
                this.batchWriteOpLog(OperationResult.FAILURE, opName, selectedRows);
                throw e;
            }
            if (status) {
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.ENABLE, selectedRows);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"ChapterRepositoryListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else {
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.DISABLE, selectedRows);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"ChapterRepositoryListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList();
        }
    }

    private Object[] getSelectedIds() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "fidm_chaptersave": {
                this.refreshBillList();
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportDesignPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "fidm_modulerepository": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportDesignPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "fidm_chapter": {
                if (returnData == null) break;
                this.refreshBillList();
                break;
            }
            case "fidm_report_preview": {
                if (returnData == null) break;
                PreviewTaskInput previewTaskParam = (PreviewTaskInput)this.deSerializedBytes((String)returnData);
                if (previewTaskParam == null) {
                    return;
                }
                DisclosureTaskHepler.previewDispatch((IFormPlugin)this, (IFormView)this.getView(), (PreviewTaskInput)previewTaskParam);
                break;
            }
            case "task_preview_close_back": {
                PreviewTaskResult taskResult = DisclosureTaskHepler.getPreviewCallBackData((Object)returnData);
                if (taskResult == null) {
                    return;
                }
                if (!taskResult.success.booleanValue()) {
                    this.getView().showTipNotification(taskResult.message);
                    break;
                }
                ChapterPreviewResult previewResult = taskResult.getResult();
                if (previewResult == null) {
                    return;
                }
                DisclosurePageJumpHelper.preview((IFormView)this.getView(), (Long)this.getDMModelId(), (ChapterPreviewResult)previewResult);
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "callbackid_del_confirm": {
                if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.actionDeleteResult();
                break;
            }
        }
    }

    @Override
    protected void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = new QFilter(CTL_MODEL, "=", (Object)this.getDiscModelId());
        filter.and(new QFilter("group", "!=", (Object)0));
        this.addPermClassFilter(filter);
        this.getCatalogQFilter(filter);
        this.setSearchFields(filter);
        e.setCustomQFilters(Collections.singletonList(filter));
        e.setOrderBy("sequence asc,number asc");
    }

    private void addPermClassFilter(QFilter qFilter) {
        List noPermIds = PermClassBaseHelper.getNoPermIds((Long)this.getDMModelId(), (String)"fidm", (String)"fidm_chapter");
        if (noPermIds.size() > 0) {
            qFilter.and(new QFilter("id", "not in", (Object)noPermIds));
        }
    }

    private void getCatalogQFilter(QFilter filter) {
        List<DisclosureTreeDto> treeDtos = this.getTreeList();
        String nodeId = this.getFocusCataLog();
        if (!StringUtils.isEmpty((String)nodeId)) {
            boolean isallchild = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(TREE_CHECK_BOX));
            ArrayList<String> cataLogIds = new ArrayList<String>(treeDtos.size());
            if (isallchild) {
                cataLogIds.addAll(DisclosureTreeHelper.getTreeIds(treeDtos, (String)nodeId));
            } else {
                cataLogIds.add(nodeId);
            }
            filter.and(new QFilter("group", "in", (Object)LongUtil.toLongList(cataLogIds)));
        } else {
            filter.and(new QFilter("1", "!=", (Object)1));
        }
    }

    private void setCatalogText(BeforePackageDataEvent e) {
        String categoryText = ResManager.loadKDString((String)"\u7ae0\u8282\u5206\u7c7b", (String)"ChapterRepositoryListPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]);
        for (DynamicObject object : e.getPageData()) {
            if (!object.getDataEntityType().getProperties().contains((Object)"group") || !"root".equalsIgnoreCase(object.getString("group.name"))) continue;
            object.set("group.name", (Object)categoryText);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        String nodeId = this.getFocusCataLog();
        boolean cateLogReadOnly = this.isCataLogReadOnly(nodeId);
        if (billList.getSelectedRows().size() > 0 && !cateLogReadOnly) {
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            Map tempaltePermMap = PermClassChapterRepositoryHelper.getChapterRepositoryPermMap((Long)this.getDMModelId(), (List)TypeUtils.convertValueToLongList((Object[])selectNodeIds));
            boolean isWrite = true;
            for (Map.Entry cateEntry : tempaltePermMap.entrySet()) {
                if (!PermClassBaseHelper.isNoPerm((String)((String)cateEntry.getValue())) && !PermClassBaseHelper.isReadPerm((String)((String)cateEntry.getValue()))) continue;
                isWrite = false;
                break;
            }
            if (isWrite) {
                this.setButtonEnable(true);
            } else {
                this.setButtonEnable(false);
            }
        } else if (billList.getSelectedRows().size() == 0 && !cateLogReadOnly) {
            this.setButtonEnable(true);
        }
    }

    private void setSearchFields(QFilter qFilter) {
        String searchMap = this.getPageCache().get(SEARCHMAPJSON);
        Map searchFileds = null;
        if (searchMap != null) {
            searchFileds = (Map)SerializationUtils.fromJsonString((String)searchMap, Map.class);
        }
        if (searchFileds != null && !searchFileds.isEmpty()) {
            String all = (String)searchFileds.get(SEARCH_ALL);
            String number = (String)searchFileds.get(SEARCH_NUMBER);
            String name = (String)searchFileds.get(SEARCH_NAME);
            if (all != null) {
                QFilter qFilter1 = new QFilter(SEARCH_NUMBER, "like", (Object)this.getSearchTextField(all));
                QFilter qFilter2 = new QFilter(SEARCH_NAME, "like", (Object)this.getSearchTextField(all));
                QFilter or = qFilter1.or(qFilter2);
                qFilter.and(or);
            } else if (number != null) {
                QFilter qFilter1 = new QFilter(SEARCH_NUMBER, "like", (Object)this.getSearchTextField(number));
                qFilter.and(qFilter1);
            } else if (name != null) {
                QFilter qFilter1 = new QFilter(SEARCH_NAME, "like", (Object)this.getSearchTextField(name));
                qFilter.and(qFilter1);
            }
        }
    }

    private String getSearchTextField(String tx) {
        return "%" + tx + "%";
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        if (arg.getFieldName().equals(SEARCH_NUMBER)) {
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)arg).getCurrentRow();
            this.showChapterEdit((Long)currentRow.getPrimaryKeyValue());
        }
    }

    private void showChapterEdit(Long chapterId) {
        if (Objects.isNull(chapterId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ae0\u8282\u3002", (String)"AbstractChapterPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = "fidm_chaptersave";
        Long dmModelId = this.getDMModelId();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("chapterId", (Object)chapterId);
        formShowParameter.setCustomParam("dmmodelid", (Object)dmModelId);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getPlugin().getView().showForm(formShowParameter);
    }

    private void writeOpLog(OperationResult result, OperationName opName, ListSelectedRow row) {
        super.writeOpLog(OperationCategory.CHAPTEREPOSITORY, opName, result, "fidm_chapterepositorylist", row.getNumber(), row.getName());
    }

    private void batchWriteOpLog(OperationResult result, OperationName opName, ListSelectedRowCollection selectedRows) {
        super.batchWriteOpLogRows(OperationCategory.CHAPTEREPOSITORY, opName, result, "fidm_chapterepositorylist", selectedRows);
    }
}

