/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.chapter;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.chapter.ChapterRepositoryHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.chapter.dto.ChapterSaveInput;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassChapterRepositoryHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class ChapterRepositoryPlugin
extends AbstractBaseDMFormPlugin
implements BeforeF7SelectListener,
IBillPlugin {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String GROUP = "group";
    private static final String DESCRIPTION = "description";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String PARAM_CHAPTER_ID = "chapterId";
    private static final String PARAM_OLDCHAPTER_ID = "oldChapterId";
    private static final String BTN_CLOSE = "btn_close";
    private static final String BTN_SAVE = "btn_save";

    protected IDataModel getModel() {
        return super.getModel();
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit datasetBaseGroup;
        Long modelId1 = this.getParamModelId();
        if (modelId1 == null && this.getModel().getValue("model") instanceof DynamicObject) {
            modelId1 = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        }
        if (Objects.nonNull(modelId1)) {
            PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERMCLASS)), (Object)modelId1, (String)FIDMMODEL, (String)ApplicationTypeEnum.FIDM.getAppnum());
        }
        if ((datasetBaseGroup = (BasedataEdit)this.getControl(GROUP)) != null) {
            datasetBaseGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(BTN_CLOSE, BTN_SAVE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long chapterId;
        super.afterCreateNewData(e);
        DynamicObject root = DisclosureChapterHelper.getAndCreateChapterCatalogRoot((Long)this.getModelId());
        if (root != null) {
            this.setValue(GROUP, root.getLong("id"));
        }
        String number = "";
        String name = "";
        Long oldChapterId = (Long)this.getFormCustomParam(PARAM_OLDCHAPTER_ID);
        if (Objects.nonNull(oldChapterId)) {
            DynamicObject chapterDyn = DisclosureChapterHelper.getChapterInfo((Long)oldChapterId);
            number = chapterDyn.getString(NUMBER);
            name = chapterDyn.getString(NAME);
        }
        if (Objects.nonNull(chapterId = (Long)this.getFormCustomParam(PARAM_CHAPTER_ID))) {
            DynamicObject chapterDyn = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
            number = chapterDyn.getString(NUMBER);
            name = chapterDyn.getString(NAME);
            this.setValue(PERMCLASS, chapterDyn.getLong("permclass.id"));
            this.setValue(GROUP, chapterDyn.getLong("group.id"));
            this.setValue(DESCRIPTION, chapterDyn.get(DESCRIPTION));
        }
        this.setValue(NUMBER, number);
        this.setValue(NAME, name);
        this.initSaveButton(chapterId);
    }

    private Long getParamModelId() {
        return TypeUtils.convertToLong((Object)this.getFormCustomParam("dmmodelid"));
    }

    private void initSaveButton(Long chapterId) {
        String perm;
        if (LongUtil.isvalidLong((Object)chapterId) && (PermClassBaseHelper.isNoPerm((String)(perm = PermClassChapterRepositoryHelper.getChapterRepositoryPerm((Long)this.getModelId(), (Long)chapterId))) || PermClassBaseHelper.isReadPerm((String)perm))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE});
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_SAVE.equals(key)) {
            this.save();
        } else if (BTN_CLOSE.equals(key)) {
            this.getView().close();
        }
    }

    private void save() {
        ChapterSaveInput input = new ChapterSaveInput();
        input.setDmModelId(TypeUtils.convertToLong((Object)this.getFormCustomParam("dmmodelid")));
        input.setChapterId(TypeUtils.convertToLong((Object)this.getFormCustomParam(PARAM_CHAPTER_ID)));
        input.setOldChapterId(TypeUtils.convertToLong((Object)this.getFormCustomParam(PARAM_OLDCHAPTER_ID)));
        input.setCatalogId(this.getIdFromDynamic((DynamicObject)this.getModel().getValue(GROUP), "id"));
        input.setDescription(this.getModel().getValue(DESCRIPTION));
        input.setNumber(TypeUtils.convertToString((Object)this.getModel().getValue(NUMBER)));
        input.setName(this.getModel().getValue(NAME));
        input.setPermClassId(this.getIdFromDynamic((DynamicObject)this.getModel().getValue(PERMCLASS), "id"));
        input.setSaveWordType(OpenWordEnum.WEB);
        ResultInfo resultInfo = ChapterRepositoryHelper.save((ChapterSaveInput)input);
        if (!resultInfo.isSuccess().booleanValue()) {
            this.getView().showTipNotification(resultInfo.getMessage());
            return;
        }
        this.returnDataToParent(resultInfo.getData());
        this.getView().close();
    }

    private Long getIdFromDynamic(DynamicObject dy, String propertyName) {
        if (dy == null) {
            return null;
        }
        return dy.getLong(propertyName);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (GROUP.equals(key)) {
            Long modelId = this.getParamModelId();
            evt.setCustomQFilters(PermClassChapterRepositoryHelper.getChapterRepositoryCatalogdWritePermFilter((Long)modelId));
            ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
            fsp.getTreeFilterParameter().setQFilters(PermClassChapterRepositoryHelper.getChapterRepositoryCatalogdWritePermFilter((Long)modelId));
        }
    }
}

