/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.module;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.module.dto.ModuleSaveInput;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class ModuleSavePlugin
extends AbstractBaseDMFormPlugin
implements BeforeF7SelectListener,
IBillPlugin {
    private static final String CATALOG = "catalog";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_CLOSE = "btn_close";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(CATALOG);
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit permclassdatasetBasedata = (BasedataEdit)this.getControl(PERMCLASS);
        ModuleSaveInput moduleSaveInput = this.getFormInputParam(false);
        if (moduleSaveInput != null) {
            PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclassdatasetBasedata, (Object)moduleSaveInput.getDmModelId(), (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
        }
        this.addClickListeners(BTN_SAVE, BTN_CLOSE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DynamicObject root = ModuleServiceHelper.addCatalogRoot((Long)this.getDMModelId(), (String)"1");
        super.afterCreateNewData(e);
        ModuleSaveInput moduleSaveInput = this.getFormInputParam(true);
        if (moduleSaveInput == null) {
            return;
        }
        this.setValue("number", moduleSaveInput.getNumber());
        this.setValue("name", moduleSaveInput.getName());
        if (root != null) {
            this.setValue(CATALOG, root.getLong("id"));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "catalog": {
                this.setCatalogQfilter(evt);
                break;
            }
        }
    }

    private void setCatalogQfilter(BeforeF7SelectEvent evt) {
        ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("model", "=", (Object)this.getDMModelId());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        qFilter.and("catalogtype", "in", Arrays.asList(ModuleServiceHelper.CATALOG_TYPE_VALUE));
        QFilter qFilter2 = new QFilter("catalogtype", "!=", (Object)"2");
        qFilter2.or("number", "!=", (Object)"root");
        qFilter.and(qFilter2);
        HashSet noPermsCataLog = new HashSet(16);
        noPermsCataLog.addAll(PermClassEntityHelper.getFIDMPermissionMap((String)"fidm_modulecatalog", (Long)this.getDMModelId(), (Long)this.getUserId()).get((Object)"1"));
        if (noPermsCataLog.size() != 0) {
            qFilter.and(new QFilter("id", "not in", noPermsCataLog));
        }
        fsp.getListFilterParameter().getQFilters().add(qFilter);
        fsp.getTreeFilterParameter().setQFilters(qFilters);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_SAVE.equals(key)) {
            this.save();
        } else if (BTN_CLOSE.equals(key)) {
            this.getView().close();
        }
    }

    private void save() {
        JSONObject properties;
        ModuleSaveInput moduleSaveInput = this.getFormInputParam(true);
        if (moduleSaveInput == null) {
            return;
        }
        String number = DisclosureFormHelper.getFormControlValueStr((Object)this.getModel().getValue("number"));
        String name = DisclosureFormHelper.getFormControlValueStr((Object)this.getModel().getValue("name"));
        String description = DisclosureFormHelper.getFormControlValueStr((Object)this.getModel().getValue("description"));
        Long catalogId = DisclosureFormHelper.getFormControlValueLong((Object)this.getModel().getValue(CATALOG), (String)"id");
        Long permclassId = DisclosureFormHelper.getFormControlValueLong((Object)this.getModel().getValue(PERMCLASS), (String)"id");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(moduleSaveInput.getDmModelId());
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        ResultInfo checkResult = ModuleServiceHelper.checkModule((long)moduleSaveInput.getDmModelId(), (String)number, (String)name, (long)catalogId, (String)description, (String)moduleSaveInput.getProperties());
        if (!checkResult.isSuccess().booleanValue()) {
            this.getView().showTipNotification(checkResult.getMessage());
            return;
        }
        DynamicObject module = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
        long id = GlobalIdUtil.genGlobalLongId();
        String propertiesStr = StringUtils.getEmpty();
        if (StringUtils.isNotEmpty((String)moduleSaveInput.getProperties()) && (properties = JSON.parseObject((String)moduleSaveInput.getProperties())) != null && properties.containsKey((Object)"id")) {
            properties.put("id", (Object)id);
            properties.put("name", (Object)name);
            properties.put("number", (Object)number);
            propertiesStr = JSON.toJSONString((Object)properties);
        }
        module.set("id", (Object)id);
        module.set("model", (Object)moduleSaveInput.getDmModelId());
        module.set("number", (Object)number);
        module.set("name", (Object)name);
        module.set("description", (Object)moduleSaveInput.getDescription());
        module.set("template", (Object)0L);
        module.set(CATALOG, (Object)catalogId);
        module.set("modifier", (Object)RequestContext.get().getCurrUserId());
        module.set("creator", (Object)RequestContext.get().getCurrUserId());
        module.set("scope", (Object)moduleSaveInput.getScope());
        module.set("status", (Object)moduleSaveInput.getStatus());
        module.set("type", (Object)moduleSaveInput.getType());
        module.set("applytype", (Object)moduleSaveInput.getApplytype());
        module.set("comefrom", (Object)moduleSaveInput.getComefrom());
        module.set("datasetid", (Object)moduleSaveInput.getDatasetid());
        module.set(PERMCLASS, (Object)permclassId);
        module.set("properties", (Object)propertiesStr);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{module});
            PermClassEntityHelper.saveDiscPermClass((DynamicObject)module, (String)FIDMMODEL, (String)ApplicationTypeEnum.FIDM.getAppnum());
            DisclosureLogHelper.writeModuleRepository((OperationResult)OperationResult.SUCCESS, (OperationName)OperationName.CREATE, (ModelInfo)modelInfo, (DynamicObject)module);
        }
        catch (Exception ex) {
            DisclosureLogHelper.writeModuleRepository((OperationResult)OperationResult.FAILURE, (OperationName)OperationName.CREATE, (ModelInfo)modelInfo, (DynamicObject)module);
        }
        this.returnDataToParent(id);
        this.getView().close();
    }

    private ModuleSaveInput getFormInputParam(Boolean isShowNullExpetion) {
        return (ModuleSaveInput)DisclosureFormHelper.getFormInputParam((IFormView)this.getView(), ModuleSaveInput.class, (Boolean)isShowNullExpetion);
    }
}

