/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.module;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureOldModuleHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class SectionListPlugin
extends AbstractBaseDMFormPlugin {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(SectionListPlugin.class);
    private static final String DMMODEL = "dmmodel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntryRows(this.getOriginSourceModel());
        this.setValue(DMMODEL, this.getDMModelId());
    }

    private void initEntryRows(DynamicObject dmModel) {
        if (dmModel == null || dmModel.getDynamicObjectType().getName().equalsIgnoreCase("fidm_model")) {
            return;
        }
        Long dmModelId = dmModel.getLong("id");
        TableValueSetter ts = null;
        DynamicObjectCollection modules = QueryServiceHelper.query((String)"fidm_modulerepository", (String)"id,number,name,type,catalog.id,catalog.name,permclass,permclass.id,description,creator,creator.name,createtime,properties", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)dmModelId), new QFilter("type", "=", (Object)"10"), new QFilter("catalog", "!=", (Object)0L)});
        if (modules.size() > 0) {
            HashMap moduleComponentMap = new HashMap(2);
            List templateIds = modules.stream().map(m -> {
                Long componentId = this.getComponentId(dmModelId, (DynamicObject)m);
                moduleComponentMap.put(m.getLong("id"), componentId);
                return componentId;
            }).collect(Collectors.toList());
            templateIds.remove(0L);
            DynamicObject[] components = BusinessDataServiceHelper.load((Object[])templateIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_component_info"));
            ts = new TableValueSetter(new String[0]);
            int index = 0;
            for (DynamicObject module : modules) {
                ts.set("modulenumber", (Object)module.getString("number"), index);
                ts.set("modulename", (Object)module.getString("name"), index);
                ts.set("modulecatename", (Object)module.getString("catalog.name"), index);
                ts.set("description", (Object)module.getString("description"), index);
                ts.set("creator", (Object)module.getString("creator.name"), index);
                ts.set("createtime", (Object)module.getDate("createtime"), index);
                Long componentId = (Long)moduleComponentMap.get(module.getLong("id"));
                if (componentId != null && componentId > 0L) {
                    DynamicObject find = Arrays.stream(components).filter(m -> m.getLong("id") == componentId.longValue()).findAny().orElse(null);
                    if (find != null) {
                        ts.set("templatenumber", (Object)find.getString("template.number"), index);
                        ts.set("templatename", (Object)find.getString("template.name"), index);
                        ts.set("selectedarea", (Object)find.getString("selectedarea"), index);
                        if (StringUtils.isEmpty((String)find.getString("template.id"))) {
                            ts.set("description", (Object)ResManager.loadKDString((String)"\u8be5\u7ec4\u4ef6\u5173\u8054\u7684\u62a5\u8868\u6a21\u677f\u5df2\u88ab\u5220\u9664\u3002", (String)"SectionListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), index);
                        }
                    } else {
                        ts.set("description", (Object)ResManager.loadKDString((String)"\u8be5\u7ec4\u4ef6\u5173\u8054\u7684\u62a5\u8868\u6a21\u677f\u5df2\u88ab\u5220\u9664\u3002", (String)"SectionListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), index);
                    }
                }
                ++index;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u65e0\u62a5\u8868\u5207\u7247\u6570\u636e\u3002", (String)"SectionListPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        if (ts != null) {
            model.batchCreateNewEntryRow("entryentity", ts);
        }
        model.setDataChanged(false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.setPageIndex(1);
        entryGrid.clearEntryState();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
    }

    private Long getComponentId(Long dmModelId, DynamicObject moduleDy) {
        Long componentId = 0L;
        if (moduleDy == null) {
            return componentId;
        }
        HashMap<String, String> moduleMap = new HashMap<String, String>(2);
        moduleMap.put("id", moduleDy.getString("id"));
        moduleMap.put("name", moduleDy.getString("name"));
        moduleMap.put("number", moduleDy.getString("number"));
        moduleMap.put("type", moduleDy.getString("type"));
        moduleMap.put("properties", moduleDy.getString("properties"));
        JSONObject moduleProperties = DisclosureOldModuleHelper.converToNewVersion((Long)dmModelId, (Long)0L, moduleMap);
        componentId = LongUtil.toLong((Object)DisclosureJsonHelper.getValue((JSONObject)moduleProperties, (String)"specialMap", (String)"componentId", (String)""));
        return componentId;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.initEntryRows(this.getOriginSourceModel());
                break;
            }
            case "btn_close": {
                this.getView().close();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.initEntryRows(this.getOriginSourceModel());
    }

    @Override
    public String getModelSign() {
        return DMMODEL;
    }
}

