/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.report;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassReportHelper;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;

public class ReportBaseInforPlugin
extends AbstractBaseFormPlugin {
    private static final String btn_save = "btnok";
    private static final String report_id = "reportId";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_save);
        BasedataEdit permclass = (BasedataEdit)this.getControl(PERMCLASS);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclass, (Object)this.getDMModelId(), (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.checkReportPerm()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u62a5\u544a\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ReportEditPlgin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        this.initPage();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (btn_save.equals(key)) {
            if (!this.checkReportPerm()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u62a5\u544a\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ReportEditPlgin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveReportInfor();
        }
    }

    private void saveReportInfor() {
        Long reportId = this.getRportId();
        String report_name = this.getModel().getValue("report_name").toString();
        DynamicObject oldReport = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(Long.valueOf(oldReport.getLong("model.id")));
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        if (StringUtils.isNotEmpty((CharSequence)report_name)) {
            try {
                DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report", (String)"name");
                report.set("name", (Object)report_name);
                SaveServiceHelper.save((IDataEntityType)report.getDynamicObjectType(), (Object[])new Object[]{report});
                this.savePermClass();
                this.returnDataToParent("success");
                this.getView().close();
                DisclosureLogHelper.writeReportOper((OperationResult)OperationResult.SUCCESS, (ModelInfo)modelInfo, (DynamicObject)oldReport, (OperationName)OperationName.EDIT_REPORT);
            }
            catch (Exception e) {
                DisclosureLogHelper.writeReportOper((OperationResult)OperationResult.FAILURE, (ModelInfo)modelInfo, (DynamicObject)oldReport, (OperationName)OperationName.EDIT_REPORT);
                AbstractBaseFormPlugin.log.error((Throwable)e);
            }
        }
    }

    private void initPage() {
        Long rportId = this.getRportId();
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)rportId, (String)"fidm_report", (String)"name,template");
        String template_name = report.getString("template.name");
        String report_name = report.getString("name");
        this.getModel().setValue("report_templatename", (Object)template_name);
        this.getModel().setValue("report_name", (Object)report_name);
        this.setPermClass();
    }

    private void setPermClass() {
        QFBuilder permClassEntityFilter = new QFBuilder();
        permClassEntityFilter.add(new QFilter(FIDMMODEL, "=", (Object)this.getDMModelId()));
        permClassEntityFilter.add(new QFilter("entityid", "=", (Object)this.getRportId()));
        permClassEntityFilter.add(new QFilter("entityname", "=", (Object)"fidm_report"));
        String selectField = PERMCLASS;
        DynamicObject permClassEntity = QueryServiceHelper.queryOne((String)"bcm_permclass_entity", (String)selectField, (QFilter[])permClassEntityFilter.toArray());
        if (permClassEntity != null) {
            Long permClassId = permClassEntity.getLong(PERMCLASS);
            this.getModel().setValue(PERMCLASS, (Object)permClassId);
        }
    }

    private void savePermClass() {
        PermClassEntityHelper.savePermClass((IDataModel)this.getModel(), (String)"fidm_report", (Long)this.getRportId(), (Object)this.getDMModelId(), (OperationStatus)OperationStatus.EDIT, (String)FIDMMODEL);
    }

    public Long getRportId() {
        Long reportId = (Long)this.getFormCustomParam(report_id);
        return reportId;
    }

    @Override
    public Long getDMModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
    }

    protected boolean checkReportPerm() {
        String perm = PermClassReportHelper.getReportPerm((Long)this.getRportId());
        return !PermClassBaseHelper.isNoPerm((String)perm) && !PermClassBaseHelper.isReadPerm((String)perm);
    }
}

