/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.report.ReportFlowStatusHelper;
import kd.epm.far.business.fidm.report.dto.ReportFlowFormInput;
import kd.epm.far.business.fidm.report.dto.ReportFlowFormResult;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;

public class ReportFlowConfirmPlugin
extends AbstractBaseFormPlugin {
    protected static final String TEXTAREAFIELD = "textareafield";
    protected static final String LABELAP_INFO = "labelap_info";
    protected static final String BTNOK = "btnok";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTNOK);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportFlowFormInput flowFormInput = this.getFormInputParam();
        Label labelapInfo = (Label)this.getControl(LABELAP_INFO);
        labelapInfo.setText(this.getOperMsg(flowFormInput.getOperType()));
    }

    private String getOperMsg(String operType) {
        String msg = String.format(ResManager.loadKDString((String)"\u60a8\u6b63\u5728\u8fdb\u884c\u62a5\u544a%s\u64cd\u4f5c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ReportFlowConfirmPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]), ReportFlowStatusHelper.getOperMsg((String)operType));
        return msg;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            String key;
            switch (key = ((Button)evt.getSource()).getKey()) {
                case "btnok": {
                    this.confrimOper();
                    break;
                }
            }
        }
    }

    private void confrimOper() {
        ReportFlowFormInput flowFormInput = this.getFormInputParam();
        String remark = DisclosureFormHelper.getFormControlValueStr((Object)this.getModel().getValue(TEXTAREAFIELD));
        ArrayList<Long> susccessIds = new ArrayList<Long>(flowFormInput.getReports().size());
        LinkedHashMap<Long, String> errorResult = new LinkedHashMap<Long, String>(flowFormInput.getReports().size());
        for (Long reportId : flowFormInput.getReports()) {
            try {
                ReportFlowStatusHelper.updateFlowStatus((Long)reportId, (String)flowFormInput.getOperType(), (String)remark);
                susccessIds.add(reportId);
            }
            catch (KDBizException kdBizException) {
                errorResult.put(reportId, kdBizException.getMessage());
            }
        }
        ReportFlowFormResult reportFlowFormResult = new ReportFlowFormResult();
        reportFlowFormResult.setInput(flowFormInput);
        reportFlowFormResult.setSuccessResult(susccessIds);
        reportFlowFormResult.setErrorResult(errorResult);
        this.getView().returnDataToParent((Object)reportFlowFormResult);
        this.getView().close();
    }

    private ReportFlowFormInput getFormInputParam() {
        return (ReportFlowFormInput)DisclosureFormHelper.getFormInputParam((IFormView)this.getView(), ReportFlowFormInput.class, (Boolean)true);
    }
}

