/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.f7.base.MutilF7DimsionUtils;
import kd.epm.far.business.common.f7.dto.MutilF7DimsionInfo;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.report.DisclosureReportNameHelper;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.report.dto.GenerateFormDataDto;
import kd.epm.far.business.fidm.report.dto.GenerateFormInput;
import kd.epm.far.business.fidm.report.dto.GenerateFormResult;
import kd.epm.far.business.fidm.report.dto.GenerateInput;
import kd.epm.far.business.fidm.report.dto.GenerateInputFormular;
import kd.epm.far.business.fidm.report.dto.ReportNameResult;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.f7.MutipleMemberF7Helper;

public class ReportGenerateEditPlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage {
    private static final String CTL_GENERATEREPORT = "btn_generate";
    private static final String CTL_REPORTNAME = "reportname";
    private static final String CTL_ISEDIT = "isedit";
    private static final String CTL_USENAMERULE = "usenamerule";
    private static final String CTL_ISTOREPORT = "istoreport";
    private static final String CTL_PERMCLASS = "permclass";
    private static final String CTL_FLEXPANELAP = "f7flex";
    private static final String CTL_RANGE = "range";
    private static final String CTL_UNIT = "unit";
    private static final String CTL_ISSCALE = "isscale";
    private static final String CTL_SCALE = "scale";
    private static final String FIDMMODEL = "fidmmodel";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(CTL_GENERATEREPORT);
        BasedataEdit permclass = (BasedataEdit)this.getControl(CTL_PERMCLASS);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclass, (Object)this.getOwnerDmModelId(), (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        GenerateFormInput formInput = this.getFormInputParam();
        this.setRangeControl();
        this.setBatchgenerateControl(formInput);
        this.setScaleControl();
        this.setF7Control(formInput);
    }

    private void setBatchgenerateControl(GenerateFormInput formInput) {
        if ("batchgenerate".equals(formInput.getOperType())) {
            this.getModel().setValue(CTL_REPORTNAME, (Object)new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0\u751f\u6210\u89c4\u5219", (String)"ReportGenerateEditPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0])));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CTL_REPORTNAME});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CTL_USENAMERULE});
            this.getModel().setValue(CTL_ISTOREPORT, (Object)Boolean.FALSE);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CTL_ISTOREPORT});
        }
    }

    private void setF7Control(GenerateFormInput formInput) {
        Long templateId = formInput.getTemplateId();
        Long dmModelId = formInput.getDmModelId();
        if (templateId == null) {
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fidm_template");
        String templateCatalogName = template.getDynamicObject("templatecatalog").getString("name");
        this.getModel().setValue("catalog", (Object)templateCatalogName);
        this.getModel().setValue("template", (Object)template.getString("name"));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"catalog"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"template"});
        List filterDimIdList = DisclosureTemplateHelper.getTemplateDimKey((Long)dmModelId, (Long)templateId);
        List dimList = modelStrategyEx.getDim().getDimDataByIds(filterDimIdList);
        ArrayList<MutilF7DimsionInfo> mutilF7DimsionInfos = new ArrayList<MutilF7DimsionInfo>(dimList.size());
        for (DimensionInfo dim : dimList) {
            MutilF7DimsionInfo mutilF7DimsionInfo = new MutilF7DimsionInfo();
            mutilF7DimsionInfo.setDimensionInfo(dim);
            if ("entity".equalsIgnoreCase(dim.getNumber()) && "batchgenerate".equals(formInput.getOperType())) {
                mutilF7DimsionInfo.setMutil(true);
            } else {
                mutilF7DimsionInfo.setMutil(false);
            }
            mutilF7DimsionInfo.setF7Sgin(dim.getNumber().toLowerCase() + "_f7");
            mutilF7DimsionInfos.add(mutilF7DimsionInfo);
        }
        MutipleMemberF7Helper.createDimensionPage(this, this, CTL_FLEXPANELAP, mutilF7DimsionInfos, MutipleMemberF7Helper.PageEnum.General);
    }

    private void setScaleControl() {
        boolean isscale = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(CTL_ISSCALE));
        this.getView().setEnable(Boolean.valueOf(isscale), new String[]{CTL_SCALE});
    }

    public void onGetControl(OnGetControlArgs e) {
        if (this.getPage(this.getView()) != null) {
            MutipleMemberF7Helper.onGetControl(this, this.getView(), this, this.getModel(), this, e, this.getOwnerDmModelId());
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        MutipleMemberF7Helper.createBeforeF7Select(this, beforeF7SelectEvent, this.getOwnerDmModelId(), null);
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (CTL_GENERATEREPORT.equals(key)) {
            this.generaterOper();
        } else if ("entity_f7".equals(key)) {
            MutipleMemberF7Helper.showMultiF7(this, this.getOwnerDmModelId(), "Entity", false);
        }
    }

    private Long getOwnerDmModelId() {
        GenerateFormInput formInput = this.getFormInputParam();
        return formInput.getDmModelId();
    }

    private void setRangeControl() {
        ComboEdit edit = (ComboEdit)this.getView().getControl(CTL_RANGE);
        if (edit != null) {
            ModuleEnum[] moduleEnums;
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(ModuleEnum.values().length);
            for (ModuleEnum e : moduleEnums = new ModuleEnum[]{ModuleEnum.VAR, ModuleEnum.REPORT_SECTION, ModuleEnum.TABLE, ModuleEnum.PIE, ModuleEnum.DOUGHNUT, ModuleEnum.AREA, ModuleEnum.STACKED_COLUMNAR, ModuleEnum.STACKED_BAR, ModuleEnum.CLUSTERED_BAR, ModuleEnum.CLUSTERED_COLUMNAR, ModuleEnum.LINE, ModuleEnum.LINE_STACKED_COLUMNAR, ModuleEnum.LINE_CLUSTERED_COLUMNAR}) {
                items.add(new ComboItem(new LocaleString(e.getName()), e.getType()));
            }
            edit.setComboItems(items);
        }
    }

    private void generaterOper() {
        GenerateFormInput formInput = this.getFormInputParam();
        Long templateId = formInput.getTemplateId();
        Long dmModelId = this.getOwnerDmModelId();
        if (dmModelId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportGenerateEditPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportChapterHelper.checkTemplateChapters((Long)templateId);
        String F7Msg = this.checkF7(dmModelId);
        if (!StringUtils.isEmpty((String)F7Msg)) {
            this.getView().showTipNotification(F7Msg);
            return;
        }
        GenerateFormDataDto formDataDto = this.generateFormDataDto();
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getRealMutilF7DimsionInfos(this, this.getModel(), dmModelId);
        MutilF7DimsionInfo entityDim = MutilF7DimsionUtils.findMultiDimInfoByDimNumber(mutilF7DimsionInfos, (String)"Entity");
        if (entityDim == null || entityDim.getMemberInfos().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportGenerateEditPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        List<ReportNameResult> reportNameResults = this.getReportNameList(formInput, entityDim, mutilF7DimsionInfos, formDataDto.reportName);
        ArrayList<GenerateInput> inputList = new ArrayList<GenerateInput>(reportNameResults.size());
        for (ReportNameResult reportNameResult : reportNameResults) {
            GenerateInput input = new GenerateInput();
            input.setDmModelId(dmModelId);
            input.setTemplateId(templateId);
            input.setReportName(reportNameResult.getName());
            input.setDesq(Integer.valueOf(reportNameResult.getDesq()));
            input.setEdit(formDataDto.isEdit);
            input.setCreateTime(new Date());
            input.setMembers(this.getDimMembers(mutilF7DimsionInfos));
            input.getMembers().remove("entity");
            input.getMembers().put("entity", reportNameResult.getEntityMember());
            input.setEntityId(reportNameResult.getEntityMember().getId());
            input.setPermClassId(formDataDto.permClassId);
            inputList.add(input);
        }
        List<DimensionInfo> dimReturnData = this.getReturnDimMembers(mutilF7DimsionInfos);
        GenerateFormResult genetateFormResult = new GenerateFormResult();
        genetateFormResult.setInputList(inputList);
        genetateFormResult.setDimList(dimReturnData);
        genetateFormResult.setOperType(formInput.getOperType());
        genetateFormResult.setGoToReportDetail(Boolean.valueOf(formDataDto.isToReport));
        genetateFormResult.setFormularInput(this.getGenerateInputFormular(formDataDto));
        this.returnDataToParent(genetateFormResult);
        this.getView().close();
    }

    private GenerateInputFormular getGenerateInputFormular(GenerateFormDataDto formDataDto) {
        GenerateInputFormular formular = new GenerateInputFormular();
        formular.setModuleRange(formDataDto.moduleRange);
        formular.setUnit(formDataDto.unit);
        formular.setDecimalEnable(formDataDto.decimalEnable);
        formular.setDecimal(formDataDto.decimal);
        return formular;
    }

    private List<ReportNameResult> getReportNameList(GenerateFormInput formInput, MutilF7DimsionInfo entityDim, List<MutilF7DimsionInfo> mutilF7DimsionInfos, String reportName) {
        Long templateId = formInput.getTemplateId();
        Long dmModelId = this.getOwnerDmModelId();
        List<ReportNameResult> reportNameResults = new ArrayList(entityDim.getMemberInfos().size());
        if ("batchgenerate".equalsIgnoreCase(formInput.getOperType())) {
            reportNameResults = DisclosureReportNameHelper.createReportName((Long)this.getOwnerDmModelId(), (Long)templateId, mutilF7DimsionInfos);
        } else if ("generate".equalsIgnoreCase(formInput.getOperType())) {
            String isuserule = String.valueOf(this.getModel().getValue(CTL_USENAMERULE));
            if ("true".equals(isuserule)) {
                reportNameResults = DisclosureReportNameHelper.createReportName((Long)this.getOwnerDmModelId(), (Long)templateId, mutilF7DimsionInfos);
            } else {
                DisclosureReportNameHelper.checkReportName((Long)this.getOwnerDmModelId(), (Long)templateId, mutilF7DimsionInfos, (String)reportName);
                ReportNameResult reportNameResult = new ReportNameResult();
                reportNameResult.setName(reportName);
                reportNameResult.setEntityMember((DimMemberInfo)entityDim.getMemberInfos().get(0));
                reportNameResult.setDesq(0);
                reportNameResults.add(reportNameResult);
            }
        }
        return reportNameResults;
    }

    private Map<String, DimMemberInfo> getDimMembers(List<MutilF7DimsionInfo> mutilF7DimsionInfos) {
        LinkedHashMap<String, DimMemberInfo> members = new LinkedHashMap<String, DimMemberInfo>(mutilF7DimsionInfos.size());
        for (MutilF7DimsionInfo mutilF7DimsionInfo : mutilF7DimsionInfos) {
            if (mutilF7DimsionInfo.getMemberInfos().size() == 0) continue;
            members.put(mutilF7DimsionInfo.getDimensionInfo().getNumber().toLowerCase(), (DimMemberInfo)mutilF7DimsionInfo.getMemberInfos().get(0));
        }
        return members;
    }

    private List<DimensionInfo> getReturnDimMembers(List<MutilF7DimsionInfo> mutilF7DimsionInfos) {
        ArrayList<DimensionInfo> dimensionInfos = new ArrayList<DimensionInfo>(mutilF7DimsionInfos.size());
        for (MutilF7DimsionInfo mutilF7DimsionInfo : mutilF7DimsionInfos) {
            DimensionInfo dimensionInfo = mutilF7DimsionInfo.getDimensionInfo();
            if (mutilF7DimsionInfo.getMemberInfos().size() > 0) {
                dimensionInfo.getMembers().addAll(mutilF7DimsionInfo.getMemberInfos());
            }
            dimensionInfos.add(dimensionInfo);
        }
        return dimensionInfos;
    }

    private String checkF7(Long dmModelId) {
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getRealMutilF7DimsionInfos(this, this.getModel(), dmModelId);
        String errormsg = "";
        for (MutilF7DimsionInfo mutilF7DimsionInfo : mutilF7DimsionInfos) {
            if (mutilF7DimsionInfo.getMemberInfos().size() != 0) continue;
            errormsg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportGenerateEditPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]), mutilF7DimsionInfo.getDimensionInfo().getName());
            break;
        }
        return errormsg;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "select_member_close": {
                MutipleMemberF7Helper.setMemberNum(this, this.getModel(), this.getOwnerDmModelId(), evt.getReturnData());
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (CTL_USENAMERULE.equalsIgnoreCase(propertyName)) {
            String isuserule = String.valueOf(this.getModel().getValue(CTL_USENAMERULE));
            if ("true".equals(isuserule)) {
                this.getModel().setValue(CTL_REPORTNAME, (Object)ResManager.loadKDString((String)"\u540d\u79f0\u751f\u6210\u89c4\u5219", (String)"ReportGenerateEditPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{CTL_REPORTNAME});
            } else if ("false".equals(isuserule)) {
                this.getModel().setValue(CTL_REPORTNAME, null);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{CTL_REPORTNAME});
            }
        } else if (CTL_ISSCALE.equalsIgnoreCase(propertyName)) {
            this.setScaleControl();
        }
    }

    private GenerateFormDataDto generateFormDataDto() {
        DynamicObject permClassDy;
        GenerateFormInput formInput = this.getFormInputParam();
        Long templateId = formInput.getTemplateId();
        Long dmModelId = formInput.getDmModelId();
        GenerateFormDataDto dataDto = new GenerateFormDataDto();
        dataDto.dmModelId = dmModelId;
        dataDto.tempalteId = templateId;
        Object permClassObject = this.getModel().getValue(CTL_PERMCLASS);
        if (permClassObject instanceof DynamicObject && (permClassDy = (DynamicObject)permClassObject) != null) {
            dataDto.permClassId = permClassDy.getLong("id");
        }
        dataDto.reportName = DisclosureFormHelper.getFormControlValueStr((Object)this.getModel().getValue(CTL_REPORTNAME));
        dataDto.useNameRule = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(CTL_USENAMERULE));
        dataDto.isEdit = !DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(CTL_ISEDIT));
        dataDto.isToReport = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(CTL_ISTOREPORT));
        dataDto.unit = DisclosureFormHelper.getFormControlValueCombo((Object)this.getModel().getValue(CTL_UNIT), (String)"0");
        dataDto.decimalEnable = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(CTL_ISSCALE));
        dataDto.decimal = DisclosureFormHelper.getFormControlValueInt((Object)this.getModel().getValue(CTL_SCALE), (int)2);
        String moduleRange = DisclosureFormHelper.getFormControlValueStr((Object)this.getModel().getValue(CTL_RANGE));
        if (!StringUtils.isEmpty((String)moduleRange)) {
            dataDto.moduleRange = new ArrayList<String>(Arrays.asList(moduleRange.split(",")));
        }
        return dataDto;
    }

    private GenerateFormInput getFormInputParam() {
        GenerateFormInput input = (GenerateFormInput)DisclosureFormHelper.getFormInputParam((IFormView)this.getView(), GenerateFormInput.class, (Boolean)true);
        return input;
    }
}

