/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.common.config.DMConfigServiceHelper;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.enums.MyReportStatusEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.f7.dto.MutilF7DimsionInfo;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureTreeHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.business.fidm.design.DisclosurePageJumpHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassReportHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.report.ReportFlowStatusHelper;
import kd.epm.far.business.fidm.report.dto.GenerateFormInput;
import kd.epm.far.business.fidm.report.dto.GenerateFormResult;
import kd.epm.far.business.fidm.report.dto.GenerateResult;
import kd.epm.far.business.fidm.report.dto.MyReportListInput;
import kd.epm.far.business.fidm.report.dto.ReportDownloadInput;
import kd.epm.far.business.fidm.report.dto.ReportFlowFormResult;
import kd.epm.far.business.fidm.task.DisclosureTaskHepler;
import kd.epm.far.business.fidm.task.dto.GenerateTaskInput;
import kd.epm.far.business.fidm.task.dto.GenerateTaskResult;
import kd.epm.far.business.fidm.task.dto.ReportDownloadTaskInput;
import kd.epm.far.business.fidm.task.dto.ReportDownloadTaskResult;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.f7.MutipleMemberF7Helper;

public class ReportListPlugin
extends AbstractBaseDMListPlugin
implements DynamicPage,
TreeNodeClickListener,
HyperLinkClickListener,
CreateListColumnsListener {
    protected static final String MODEL = "model";
    protected static final String TREEVIEW = "treeview";
    protected static final String FLEXPANELAP = "f7flex";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String TEMPLATE = "template";
    private static final String TREENODECLICKFLAG = "treenodeclick";
    protected static final String KEY_DIMMEBERPERMLIST = "key_dimmeberpermlist";
    protected static final String BOX_ALL = "box_all";
    protected static final String BOX_UNCOMMIT = "box_uncommit";
    protected static final String BOX_COMMITED = "box_commited";
    protected static final String BOX_AUDIT = "box_audit";
    protected static final String BOX_BACKED = "box_backed";
    public static final Map<String, String> FlowControls = new LinkedHashMap<String, String>(){
        {
            this.put(ReportListPlugin.BOX_UNCOMMIT, MyReportStatusEnum.UNCOMMIT.getValue());
            this.put(ReportListPlugin.BOX_COMMITED, MyReportStatusEnum.COMMITED.getValue());
            this.put(ReportListPlugin.BOX_AUDIT, MyReportStatusEnum.AUDITED.getValue());
            this.put(ReportListPlugin.BOX_BACKED, MyReportStatusEnum.BACKED.getValue());
        }
    };
    protected static final String KEY_FLOWCONTROLS_VALUE_LOCK = "key_flowcontrols_value_lock";
    protected static final String KEY_QUARYDATAFILTERS = "key_quarydatafilters";
    protected static final String KEY_FLOWCONTROLS_RESET = "key_flowcontrols_reset";
    private static final String CALLBACKID_DEL_CONFIRM = "callbackid_del_confirm";

    @Override
    public void initialize() {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setBillFormId("fidm_report");
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.registerListener(e);
        TreeView templateTree = (TreeView)this.getControl(TREEVIEW);
        this.getPageCache().put(TREENODECLICKFLAG, "0");
        templateTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setBillFormId("fidm_report");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addSetFilterListener(this::setFilter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.setFocusCataLog(evt.getNodeId().toString());
        this.getPageCache().put(TREENODECLICKFLAG, "1");
        this.refreshBillList(true);
    }

    private void setButtonEnable(Boolean status) {
        this.getView().setEnable(status, new String[]{"delete", "baritemap", "btn_submit", "btn_back", "btn_audit", "btn_unaudit", "btn_archiver", "btn_cancelarchiver"});
    }

    protected void refreshControl() {
        String nodeId = this.getFocusCataLog();
        if (!StringUtils.isEmpty((String)nodeId) && this.isCataLogReadOnly(nodeId)) {
            this.setButtonEnable(false);
        } else {
            this.setButtonEnable(true);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.afterCreateNewData(e);
        this.initModel();
        this.initTree(null);
        this.initF7();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"report_cat"});
        DMConfigServiceHelper.repair();
        this.refreshBillList(true);
    }

    private void initModel() {
        Long dmModelId = this.getUserSelect();
        MyReportListInput input = this.getFormInputParam();
        if (input != null) {
            dmModelId = input.getDmModelId();
        }
        if (dmModelId != null && dmModelId != 0L) {
            this.getModel().setValue(MODEL, (Object)dmModelId);
            this.getPageCache().put("dmmodelid", String.valueOf(dmModelId));
        }
    }

    protected Long getDmModelId() {
        return LongUtil.toLong((Object)this.getPageCache().get("dmmodelid"));
    }

    protected String getFocusCataLog() {
        String nodeId = this.getPageCache().get("focusnodeid");
        return nodeId;
    }

    protected void setFocusCataLog(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getPageCache().remove("focusnodeid");
        } else {
            this.getPageCache().put("focusnodeid", nodeId);
        }
    }

    protected String getRootNode() {
        String nodeId = this.getPageCache().get("headnodeid");
        return nodeId;
    }

    protected void setRootNode(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getPageCache().remove("headnodeid");
        } else {
            this.getPageCache().put("headnodeid", nodeId);
        }
    }

    protected List<DisclosureTreeDto> getTreeList() {
        String data = this.getPageCache().get("treelist");
        if (StringUtils.isEmpty((String)data)) {
            return new ArrayList<DisclosureTreeDto>(1);
        }
        return JSONArray.parseArray((String)data, DisclosureTreeDto.class);
    }

    protected void setTreeList(List<DisclosureTreeDto> templatecatalogs) {
        if (templatecatalogs == null || templatecatalogs.size() == 0) {
            this.getPageCache().remove("treelist");
        } else {
            this.getPageCache().put("treelist", JSON.toJSONString(templatecatalogs));
        }
    }

    private void initTree(String focusNodeId) {
        Long dmModelId = this.getDMModelId();
        List templatecatalogs = PermClassReportHelper.getReportTreeList((Long)dmModelId, (String)AppCatalogTypeEnum.FIDM_CATALOG.getType());
        DisclosureTreeDto rootDto = DisclosureTreeHelper.getRoot((List)templatecatalogs);
        if (rootDto == null) {
            return;
        }
        TreeNode root = new TreeNode();
        root.setId(rootDto.getId());
        root.setParentid("");
        root.setText(DiscTemplateCatalogTypeEnum.getCatalogByAppId((String)this.getBizAppId()).getName());
        if (StringUtils.isNotEmpty((String)rootDto.getIcon())) {
            root.setIcon(rootDto.getIcon());
        }
        DisclosureTreeHelper.setEntryNode((TreeNode)root, (List)templatecatalogs, (String)rootDto.getId());
        DisclosureTreeHelper.spreadAllNode((TreeNode)root);
        this.setTreeList(templatecatalogs);
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        tree.deleteAllNodes();
        tree.addNode(root);
        TreeNode focusNode = DisclosureTreeHelper.findFocusNodeById((TreeNode)root, (String)focusNodeId);
        if (focusNode == null) {
            focusNode = root;
        }
        tree.focusNode(focusNode);
        this.setRootNode(rootDto.getId());
        this.setFocusCataLog(focusNode.getId());
    }

    protected void refreshBillList(boolean isRefreshFlowContrl) {
        if (isRefreshFlowContrl) {
            this.getModel().setValue(BOX_ALL, (Object)true);
            this.getPageCache().put(KEY_FLOWCONTROLS_RESET, "1");
        } else {
            this.getPageCache().remove(KEY_FLOWCONTROLS_RESET);
        }
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setClearSelection(true);
        billList.addSetFilterListener(this::setFilter);
        billList.addAfterBindDataListener(this::afterBindData);
        billList.refresh();
        this.refreshControl();
    }

    private Set<Long> findLeafNodeList(Long focusNodeId, SetMultimap<Long, Long> relationMap) {
        HashSet<Long> leafNodeId = new HashSet<Long>(16);
        if (relationMap.get((Object)focusNodeId) != null && relationMap.get((Object)focusNodeId).size() != 0) {
            Set childNodeList = relationMap.get((Object)focusNodeId);
            for (Long childNode : childNodeList) {
                leafNodeId.addAll(this.findLeafNodeList(childNode, relationMap));
            }
        } else {
            leafNodeId.add(focusNodeId);
        }
        return leafNodeId;
    }

    private SetMultimap<Long, Long> buildRelationMap() {
        HashMultimap relationMap = HashMultimap.create();
        List<DisclosureTreeDto> treeList = this.getTreeList();
        for (DisclosureTreeDto tree : treeList) {
            Long parent = LongUtil.toLong((Object)tree.getParentId());
            relationMap.put((Object)parent, (Object)LongUtil.toLong((Object)tree.getId()));
        }
        return relationMap;
    }

    protected boolean isCataLogReadOnly(String nodeId) {
        List<DisclosureTreeDto> treeDtos = this.getTreeList();
        DisclosureTreeDto treeDto = DisclosureTreeHelper.findDtoById(treeDtos, (String)nodeId);
        if (treeDto == null) {
            return false;
        }
        return DataTypeEnum.READ.getIndex().equalsIgnoreCase(treeDto.getPermClassType());
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        String nodeId = this.getFocusCataLog();
        boolean cateLogReadOnly = this.isCataLogReadOnly(nodeId);
        if (billList.getSelectedRows().size() > 0) {
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            Map reportPermMap = PermClassReportHelper.getReportPermMap((Long)this.getDMModelId(), (List)TypeUtils.convertValueToLongList((Object[])selectNodeIds));
            boolean isWrite = true;
            for (Map.Entry cateEntry : reportPermMap.entrySet()) {
                if (!PermClassBaseHelper.isNoPerm((String)((String)cateEntry.getValue())) && !PermClassBaseHelper.isReadPerm((String)((String)cateEntry.getValue()))) continue;
                isWrite = false;
                break;
            }
            if (isWrite) {
                this.setButtonEnable(true);
            } else {
                this.setButtonEnable(false);
            }
        } else if (billList.getSelectedRows().size() == 0 && !cateLogReadOnly) {
            this.setButtonEnable(true);
        }
    }

    private void refreshPageF7() {
        MutipleMemberF7Helper.resetEmpty((AbstractFormPlugin)this, this.getModel());
    }

    private void initF7() {
        Long dmModelId = LongUtil.toLong((Object)this.getPageCache().get("dmmodelid"));
        if (!LongUtil.isvalidLong((Object)dmModelId)) {
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List allDims = modelStrategyEx.getDim().getDimList();
        List<Object> filterDims = new ArrayList(allDims.size());
        String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
        filterDims = DisModelTypeEnum.EB.getType().equals(modelType) ? allDims.stream().filter(m -> TypeUtils.containsIgnore((Collection)DisclosureReportHelper.EPMDIM, (String)m.getNumber())).collect(Collectors.toList()) : allDims.stream().filter(m -> TypeUtils.containsIgnore((Collection)DisclosureReportHelper.BCMDIM, (String)m.getNumber())).collect(Collectors.toList());
        ArrayList<MutilF7DimsionInfo> mutilF7DimsionInfos = new ArrayList<MutilF7DimsionInfo>(filterDims.size());
        for (DimensionInfo dim : filterDims) {
            MutilF7DimsionInfo mutilF7DimsionInfo = new MutilF7DimsionInfo();
            mutilF7DimsionInfo.setDimensionInfo(dim);
            mutilF7DimsionInfo.setMutil(false);
            if (!DisModelTypeEnum.EB.getType().equals(modelType) && dim.getNumber().equalsIgnoreCase("Entity")) {
                mutilF7DimsionInfo.setMutil(true);
            }
            mutilF7DimsionInfo.setF7Sgin(dim.getNumber().toLowerCase() + "_f7");
            mutilF7DimsionInfos.add(mutilF7DimsionInfo);
        }
        MutipleMemberF7Helper.createDimensionPage((AbstractFormPlugin)this, this, FLEXPANELAP, mutilF7DimsionInfos, MutipleMemberF7Helper.PageEnum.ReportList);
        this.saveDimMemberPerms();
    }

    private QFilter getDimMemberPerms() {
        Long dmModelId = LongUtil.toLong((Object)this.getPageCache().get("dmmodelid"));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getMutilF7DimsionInfos((AbstractFormPlugin)this);
        QFilter qFilter = null;
        for (MutilF7DimsionInfo mutilF7DimsionInfo : mutilF7DimsionInfos) {
            String columName = DisclosureReportHelper.changeDimNumber2F7Sign((String)mutilF7DimsionInfo.getDimensionInfo().getNumber(), (String)modelType);
            QFilter bcmQf = modelStrategyEx.getDimMember().getPerm(columName, mutilF7DimsionInfo.getDimensionInfo().getId());
            if (bcmQf == null) continue;
            if (qFilter == null) {
                qFilter = bcmQf;
                continue;
            }
            qFilter.and(bcmQf);
        }
        return qFilter;
    }

    private void saveDimMemberPerms() {
        QFilter qFilter = this.getDimMemberPerms();
        this.getPageCache().put(KEY_DIMMEBERPERMLIST, qFilter == null ? "" : qFilter.toSerializedString());
    }

    public QFilter getDimMemberPermsFromRedis() {
        QFilter qFilter = null;
        String permStr = this.getPageCache().get(KEY_DIMMEBERPERMLIST);
        if (StringUtils.isEmpty((String)permStr)) {
            return null;
        }
        try {
            qFilter = QFilter.fromSerializedString((String)permStr);
        }
        catch (Exception ex) {
            log.error("dm myreportlist getDimMemberPermsFromRedis error:", (Throwable)ex);
            qFilter = this.getDimMemberPerms();
        }
        return qFilter;
    }

    @Override
    public void afterBindData(EventObject e) {
        List filters;
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>(10);
        HashMap<String, Integer> isarchivedMap = new HashMap<String, Integer>(10);
        String quryStr = this.getPageCache().get(KEY_QUARYDATAFILTERS);
        isarchivedMap.put(MyReportStatusEnum.ARCHIVED.getValue(), 0);
        isarchivedMap.put(MyReportStatusEnum.UNARCHIVE.getValue(), 0);
        if (!StringUtils.isEmpty((String)quryStr) && (filters = DisclosureFormHelper.fromSerializedString((String)quryStr)).size() > 0) {
            Collection reports = BusinessDataServiceHelper.loadFromCache((String)"fidm_report", (String)"id,status,isarchived", (QFilter[])filters.toArray(new QFilter[0])).values();
            for (DynamicObject dynamicObject : reports) {
                String status;
                Integer stautsItem = (Integer)statusMap.get(status = dynamicObject.getString("status"));
                statusMap.put(status, (stautsItem == null ? 0 : stautsItem) + 1);
                String isarchived = dynamicObject.getString("isarchived");
                Integer isarchivedItem = (Integer)isarchivedMap.get(isarchived);
                isarchivedMap.put(isarchived, (isarchivedItem == null ? 0 : isarchivedItem) + 1);
            }
        }
        String sumTips = String.format(ResManager.loadKDString((String)"\u5f52\u6863\u5408\u8ba1\uff1a%1s;  \u672a\u5f52\u6863\u5408\u8ba1\uff1a%2s", (String)"ReportListPlugin_30", (String)"epm-far-formplugin", (Object[])new Object[0]), isarchivedMap.get(MyReportStatusEnum.ARCHIVED.getValue()), isarchivedMap.get(MyReportStatusEnum.UNARCHIVE.getValue()));
        this.setLabelText("lab_sumtips", sumTips);
        if (this.getPageCache().get(KEY_FLOWCONTROLS_RESET) != null) {
            int sum = 0;
            for (Map.Entry entry : FlowControls.entrySet()) {
                String labelName = ((String)entry.getKey()).replace("box_", "lab_");
                Integer item = (Integer)statusMap.get(entry.getValue());
                int labCount = item == null ? 0 : item;
                sum += labCount;
                this.setLabelText(labelName, "\uff08" + labCount + "\uff09");
            }
            this.setLabelText("lab_all", "\uff08" + sum + "\uff09");
        }
    }

    private void setLabelText(String labelName, String text) {
        try {
            Label lab = (Label)this.getControl(labelName);
            if (lab != null) {
                lab.setText(text);
            }
        }
        catch (Exception ex) {
            log.error(" reports setValue  controlFlag error", (Throwable)ex);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        Element c;
        this.getBcmControl(e);
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(e.getKey())) != null) {
            String f7sign = e.getKey();
            MutilF7DimsionInfo find = MutipleMemberF7Helper.findMultiDimInfoByF7Sign((AbstractFormPlugin)this, f7sign);
            if (find == null) {
                return;
            }
            if (find.isMutil()) {
                TextEdit edit = new TextEdit();
                edit.setKey(e.getKey());
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            } else {
                BasedataEdit f7 = new ModelStrategyEx(this.getDMModelId()).getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, find.getDimensionInfo(), f7sign, null, false, "");
                e.setControl((Control)f7);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (!MODEL.equalsIgnoreCase(dimKey)) {
            Long dmModelId = this.getDMModelId();
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
            MutilF7DimsionInfo f7DimsionInfo = MutipleMemberF7Helper.findMultiDimInfoByF7Sign((AbstractFormPlugin)this, dimKey);
            ArrayList<QFilter> newFilterList = new ArrayList<QFilter>(10);
            if (f7DimsionInfo != null && DisModelTypeEnum.CM.getType().equals(modelStrategyEx.getModel().getModelInfo().getModelType())) {
                BcmPermService bcmPermService = new BcmPermService(dmModelId, f7DimsionInfo.getDimensionInfo().getId());
                QFilter filter = bcmPermService.getPermQFilter("id");
                newFilterList.add(filter);
            }
            MutipleMemberF7Helper.createBeforeF7Select((AbstractFormPlugin)this, beforeF7SelectEvent, dmModelId, newFilterList);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        String treeNodeClickFlag = this.getPageCache().get(TREENODECLICKFLAG);
        if (MODEL.equals(name)) {
            this.initTree(null);
            this.initF7();
            this.refreshPageF7();
            this.refreshBillList(true);
        }
        if (name.startsWith("box_")) {
            this.refreshFlowControl(name);
        } else {
            MutilF7DimsionInfo f7DimsionInfo = MutipleMemberF7Helper.findMultiDimInfoByF7Sign((AbstractFormPlugin)this, name);
            if (f7DimsionInfo != null) {
                if (f7DimsionInfo.isMutil() && (this.getModel().getValue(name) == null || this.getModel().getValue(name).toString().equals(""))) {
                    MutipleMemberF7Helper.clearMultiDimInfoByF7Sign((AbstractFormPlugin)this, name);
                }
                if ("0".equals(treeNodeClickFlag)) {
                    this.refreshBillList(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFlowControl(String controlFlag) {
        if (StringUtils.isEmpty((String)controlFlag)) {
            return;
        }
        if (this.getPageCache().get(KEY_FLOWCONTROLS_VALUE_LOCK) != null) {
            return;
        }
        this.getPageCache().put(KEY_FLOWCONTROLS_VALUE_LOCK, "1");
        try {
            boolean currentControl = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(controlFlag));
            if (controlFlag.toLowerCase().contains("all")) {
                for (String itemFlag : FlowControls.keySet()) {
                    this.getModel().setValue(itemFlag, (Object)currentControl);
                }
            } else {
                boolean isAll = true;
                for (String itemFlag : FlowControls.keySet()) {
                    boolean itemFlagValue = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(itemFlag));
                    if (itemFlagValue) continue;
                    isAll = false;
                    break;
                }
                this.getModel().setValue(BOX_ALL, (Object)isAll);
            }
        }
        catch (Exception ex) {
            log.error("dm report update flowcontrol error", (Throwable)ex);
        }
        finally {
            this.getPageCache().remove(KEY_FLOWCONTROLS_VALUE_LOCK);
        }
        this.refreshBillList(false);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opKey = evt.getItemKey();
        BillList control = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRowCollection = control.getSelectedRows();
        Long dmModelId = this.getDMModelId();
        if (!LongUtil.isvalidLong((Object)dmModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Long focusNodeId = LongUtil.toLong((Object)this.getFocusCataLog());
        switch (opKey) {
            case "delete": {
                this.actionDelete();
                break;
            }
            case "report_cat": {
                if (selectedRowCollection.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ReportListPlugin_31", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                DisclosurePageJumpHelper.openEditPage((IFormView)this.getView(), (Long)LongUtil.toLong((Object)selectedRowCollection.get(0).getPrimaryKeyValue()), (Long)dmModelId);
                break;
            }
            case "baritemap_refresh": {
                this.initTree(this.getFocusCataLog());
                this.refreshBillList(true);
                break;
            }
            case "generatereport": {
                if (LongUtil.isvalidLong((Object)focusNodeId)) {
                    List<DisclosureTreeDto> treeList = this.getTreeList();
                    for (DisclosureTreeDto tree : treeList) {
                        if (!focusNodeId.toString().equals(tree.getId())) continue;
                        this.checkTemplate(tree, focusNodeId, "generate");
                        return;
                    }
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u3002", (String)"ReportListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            case "btn_submit": 
            case "btn_back": 
            case "btn_audit": 
            case "btn_unaudit": 
            case "btn_archiver": 
            case "btn_cancelarchiver": {
                this.updateReportStatus(opKey);
                break;
            }
            case "btn_downloadword": 
            case "btn_downloadpdf": {
                if (selectedRowCollection.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ReportListPlugin_31", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                List reports = selectedRowCollection.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
                ArrayList<Long> ids = new ArrayList<Long>(reports.size());
                for (Object report : reports) {
                    ids.add((Long)report);
                }
                ReportDownloadInput reportDownloadInput = new ReportDownloadInput();
                reportDownloadInput.setReportIds(ids);
                reportDownloadInput.setFileType(opKey.equals("btn_downloadpdf") ? "pdf" : "docx");
                reportDownloadInput.setUrlPrefix(DisclosureFileHelper.getUrlPrefix());
                reportDownloadInput.setNeedZip(true);
                ReportDownloadTaskInput taskInput = new ReportDownloadTaskInput();
                taskInput.setInput(reportDownloadInput);
                DisclosureTaskHepler.reportDownloadDispatch((IFormPlugin)this, (IFormView)this.getView(), (ReportDownloadTaskInput)taskInput);
                break;
            }
            case "batchgeneratereport": {
                if (LongUtil.isvalidLong((Object)focusNodeId)) {
                    List<DisclosureTreeDto> treeListMap = this.getTreeList();
                    for (DisclosureTreeDto tree : treeListMap) {
                        if (!focusNodeId.toString().equals(tree.getId())) continue;
                        this.checkTemplate(tree, focusNodeId, "batchgenerate");
                        return;
                    }
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u3002", (String)"ReportListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            case "report_edit": {
                if (selectedRowCollection.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ReportListPlugin_31", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                String openType = DMConfigServiceHelper.getAndCheckOpenWordEnum();
                if (openType.equals(OpenWordEnum.WPSPLUGIN.getType()) && selectedRowCollection.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6587\u4ef6\u7f16\u8f91\u65b9\u5f0f\u4e3a\"\u91d1\u5c71WPS\u5ba2\u6237\u7aef\"\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ReportListPlugin_35", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (ListSelectedRow row2 : selectedRowCollection) {
                    DisclosurePageJumpHelper.openReportPage((IFormView)this.getView(), (Long)LongUtil.toLong((Object)row2.getPrimaryKeyValue()), (Long)dmModelId);
                }
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("entity_f7".equals(key)) {
            MutipleMemberF7Helper.showMultiF7((AbstractFormPlugin)this, this.getDMModelId(), "Entity", true);
        }
    }

    private void checkTemplate(DisclosureTreeDto tree, Long focusNodeId, String operateMode) {
        if (TEMPLATE.equals(tree.getType())) {
            DynamicObject tmpl = BusinessDataServiceHelper.loadSingleFromCache((Object)focusNodeId, (String)"fidm_template", (String)"status");
            if (tmpl == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ReportListPlugin_23", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!QueryServiceHelper.exists((String)"fidm_chapter", (QFilter[])new QFilter(TEMPLATE, "=", (Object)focusNodeId).toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u5165\u6a21\u677f\u7f16\u8f91\u9875\u9762\uff0c\u65b0\u589e\u7ae0\u8282\u540e\u518d\u751f\u6210\u62a5\u544a\u3002", (String)"DiscTemplateListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (tmpl.getBoolean("status")) {
                this.openGeneratePage(focusNodeId, this.getDMModelId(), operateMode);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"ReportListPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u3002", (String)"ReportListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateReportStatus(String opKey) {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRowCollection = billList.getSelectedRows();
        ArrayList<Long> reportIds = new ArrayList<Long>(selectedRowCollection.size());
        for (ListSelectedRow row : selectedRowCollection) {
            reportIds.add(LongUtil.toLong((Object)row.getPrimaryKeyValue()));
        }
        if (reportIds.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ReportListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportFlowStatusHelper.comfirmForm((IFormView)this.getView(), (IFormPlugin)this, reportIds, (String)opKey);
    }

    private void updateReportStatusResult(ReportFlowFormResult formResult) {
        if (formResult == null) {
            return;
        }
        int successCount = formResult.getSuccessResult().size();
        if (formResult.getErrorResult().size() == 0) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f%s\u6761\u3002", (String)"ReportListPlugin_29", (String)"epm-far-formplugin", (Object[])new Object[0]), successCount));
            this.refreshBillList(true);
            return;
        }
        ArrayList msgs = new ArrayList(formResult.getErrorResult().size() + 1);
        String title = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f%1s\u6761\uff0c\u5b58\u5728\u672a\u5904\u7406\u8bb0\u5f55%2s\u6761", (String)"ReportListPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]), successCount, formResult.getErrorResult().size());
        for (Map.Entry item : formResult.getErrorResult().entrySet()) {
            msgs.add(item.getValue());
        }
        this.getView().showMessage(title, Joiner.on((String)"\n").join(msgs), MessageTypes.Default);
        this.refreshBillList(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "callbackid_del_confirm": {
                if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.actionDeleteResult();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "fidm_fieldchangelog_list": {
                this.refreshBillList(true);
                break;
            }
            case "fidm_report_generate": {
                if (returnData == null) break;
                GenerateFormResult genetateFormResult = (GenerateFormResult)this.deSerializedBytes((String)returnData);
                if (genetateFormResult == null) {
                    return;
                }
                GenerateTaskInput generateTaskInput = new GenerateTaskInput();
                generateTaskInput.setGenetateFormResult(genetateFormResult);
                DisclosureTaskHepler.generateDispatch((IFormPlugin)this, (IFormView)this.getView(), (GenerateTaskInput)generateTaskInput);
                break;
            }
            case "task_general_close_back": {
                GenerateTaskResult generateTaskResult = DisclosureTaskHepler.getGeneralCallBackData((Object)returnData);
                if (generateTaskResult == null) {
                    return;
                }
                if (!generateTaskResult.getSuccess().booleanValue()) {
                    this.getView().showTipNotification(generateTaskResult.getMessage());
                    break;
                }
                List generateResults = generateTaskResult.getResult();
                if (generateResults == null || generateResults.size() == 0) {
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"ReportListPlugin_28", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.refreshBillList(true);
                if (generateResults.size() <= 0) break;
                GenerateResult firstResult = (GenerateResult)generateResults.get(0);
                if (!generateTaskResult.getInput().getGenetateFormResult().getGoToReportDetail().booleanValue()) break;
                this.checkPerm("report_cat");
                DisclosurePageJumpHelper.openEditPage((IFormView)this.getView(), (Long)firstResult.getReportId(), (Long)this.getDMModelId());
                break;
            }
            case "select_member_close": {
                MutipleMemberF7Helper.setMemberNum((AbstractFormPlugin)this, this.getModel(), this.getDMModelId(), evt.getReturnData());
                break;
            }
            case "fidm_flowcommitpage": {
                ReportFlowFormResult reportFlowFormResult;
                if (evt.getReturnData() == null || (reportFlowFormResult = (ReportFlowFormResult)returnData) == null) break;
                this.updateReportStatusResult(reportFlowFormResult);
                break;
            }
            case "task_reportdownload_close_back": {
                ReportDownloadTaskResult reportDownloadTaskResult = DisclosureTaskHepler.getReportDownloadCallBackData((Object)returnData);
                if (reportDownloadTaskResult == null) {
                    return;
                }
                if (!reportDownloadTaskResult.getSuccess().booleanValue()) {
                    this.getView().showTipNotification(reportDownloadTaskResult.getMessage());
                    break;
                }
                this.downloadFile(reportDownloadTaskResult);
                break;
            }
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        Object pkId = list.getFocusRowPkId();
        if ("status".equals(hyperLinkClickEvent.getFieldName()) || "isarchived".equals(hyperLinkClickEvent.getFieldName())) {
            this.openFlowListPage(pkId.toString(), hyperLinkClickEvent.getFieldName());
        } else if ("name".equals(hyperLinkClickEvent.getFieldName())) {
            this.checkPerm("report_cat");
            DisclosurePageJumpHelper.openEditPage((IFormView)this.getView(), (Long)LongUtil.toLong((Object)pkId.toString()), (Long)this.getDMModelId());
        }
    }

    private void openFlowListPage(String entitykey, String fieldkey) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("fidm_fieldchangelog_list");
        QFilter qf = new QFilter(MODEL, "=", (Object)this.getDMModelId());
        qf.and(new QFilter("entitykey", "=", (Object)LongUtil.toLong((Object)entitykey)));
        qf.and(new QFilter("dealfieldkey", "=", (Object)fieldkey));
        ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
        filterParameter.setFilter(qf);
        filterParameter.setOrderBy("dealtime");
        formShowParameter.setCustomParam("isCustom", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u8bb0\u5f55", (String)"ReportListPlugin_21", (String)"epm-far-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fidm_fieldchangelog_list"));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void actionDelete() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds == null || selectedIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ChapterRepositoryListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ChapterRepositoryListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_DEL_CONFIRM, (IFormPlugin)this));
    }

    private void actionDeleteResult() {
        String msg = "";
        Long dmModelId = this.getDMModelId();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ArrayList<Long> deleteSuccessIds = new ArrayList<Long>(billList.getSelectedRows().size());
        for (ListSelectedRow row : billList.getSelectedRows()) {
            Long reportId = LongUtil.toLong((Object)row.getPrimaryKeyValue());
            ResultInfo resultInfo = DisclosureReportHelper.deleteReport((long)dmModelId, (long)reportId);
            if (!resultInfo.isSuccess().booleanValue()) {
                msg = row.getName() + "\uff1a" + resultInfo.getMessage();
                this.getView().showTipNotification(msg);
                continue;
            }
            deleteSuccessIds.add(reportId);
        }
        if (deleteSuccessIds.size() > 0) {
            msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"ChapterRepositoryListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]), deleteSuccessIds.size());
            this.getView().showSuccessNotification(msg);
        }
        this.refreshBillList(true);
    }

    private void openGeneratePage(Long templateId, Long modelId, String type) {
        String formId = "fidm_report_generate";
        GenerateFormInput formInput = new GenerateFormInput();
        formInput.setDmModelId(modelId);
        formInput.setTemplateId(templateId);
        formInput.setOperType(type);
        FormShowParameter formShowParameter = DisclosureFormHelper.createFormParam((Object)formInput);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId(formId);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm(formShowParameter);
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        ListColumn entity;
        Long dmModelId = this.getDMModelId();
        String modelType = DisModelTypeEnum.CM.getType();
        if (LongUtil.isvalidLong((Object)dmModelId)) {
            modelType = new ModelStrategyEx(dmModelId).getModel().getModelInfo().getModelType();
        }
        List colnumlist = args.getListColumns();
        int index = 0;
        for (IListColumn column : colnumlist) {
            if ("template.name".equals(column.getListFieldKey())) {
                index = colnumlist.indexOf(column);
            }
            if ("param".equals(column.getListFieldKey())) {
                column.setVisible(0);
                continue;
            }
            if (!"paramnumber".equals(column.getListFieldKey())) continue;
            column.setVisible(0);
        }
        if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            ListColumn datatype = this.createListColumn("datatype.name", ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"ReportListPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]), index + 1);
            colnumlist.add(index + 1, datatype);
            entity = this.createListColumn("epmentity.name", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ReportListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]), index + 2);
            colnumlist.add(index + 2, entity);
            ListColumn version = this.createListColumn("budgetperiod.name", ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4", (String)"ReportListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]), index + 3);
            colnumlist.add(index + 3, version);
            ListColumn budgetperiod = this.createListColumn("version.name", ResManager.loadKDString((String)"\u7248\u672c", (String)"ReportListPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]), index + 4);
            colnumlist.add(index + 4, budgetperiod);
        } else {
            ListColumn scenario = this.createListColumn("scenario.name", ResManager.loadKDString((String)"\u60c5\u666f", (String)"ReportListPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]), index + 1);
            colnumlist.add(index + 1, scenario);
            entity = this.createListColumn("bcmentity.name", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ReportListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]), index + 2);
            colnumlist.add(index + 2, entity);
            ListColumn year = this.createListColumn("year.name", ResManager.loadKDString((String)"\u8d22\u5e74", (String)"ReportListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]), index + 3);
            colnumlist.add(index + 3, year);
            ListColumn period = this.createListColumn("period.name", ResManager.loadKDString((String)"\u671f\u95f4", (String)"ReportListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]), index + 4);
            colnumlist.add(index + 4, period);
        }
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setColumnOrderAndFilter(true);
        col.setListFieldKey(key);
        col.setKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setWidth(new LocaleString("8%"));
        return col;
    }

    public void setFilter(SetFilterEvent e) {
        Long focusTemplateNodeId = LongUtil.toLong((Object)this.getFocusCataLog());
        if (this.getModel().getValue(MODEL) != null && LongUtil.isvalidLong((Object)focusTemplateNodeId)) {
            Set<Long> noPermId;
            QFilter flowFilter;
            Long dmModelId = this.getDMModelId();
            HashMultimap relationMap = HashMultimap.create();
            relationMap.putAll(this.buildRelationMap());
            Set<Long> leafNodeList = this.findLeafNodeList(focusTemplateNodeId, (SetMultimap<Long, Long>)relationMap);
            QFilter qFilter = new QFilter(MODEL, "=", (Object)dmModelId);
            qFilter.and(new QFilter(TEMPLATE, "in", leafNodeList));
            qFilter.and(new QFilter("ispreview", "=", (Object)Boolean.FALSE));
            QFilter f7QFilter = this.getPageF7Filter(dmModelId);
            if (f7QFilter != null) {
                qFilter.and(f7QFilter);
            }
            if ((flowFilter = this.getFlowStatusFilter()) != null) {
                qFilter.and(flowFilter);
            }
            if ((noPermId = this.getNotPermClassReportIds(dmModelId)).size() > 0) {
                qFilter.and(new QFilter("id", "not in", noPermId));
            }
            e.getQFilters().add(qFilter);
            e.setOrderBy("name");
            this.getPageCache().put(KEY_QUARYDATAFILTERS, DisclosureFormHelper.toSerializedString((List)e.getQFilters()));
        } else {
            e.getQFilters().add(new QFilter("1", "!=", (Object)1));
            this.getPageCache().remove(KEY_QUARYDATAFILTERS);
        }
    }

    private QFilter getFlowStatusFilter() {
        boolean all = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(BOX_ALL));
        if (all) {
            return null;
        }
        ArrayList<String> statusList = new ArrayList<String>(10);
        for (Map.Entry<String, String> controlFlag : FlowControls.entrySet()) {
            boolean c = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(controlFlag.getKey()));
            if (!c) continue;
            statusList.add(controlFlag.getValue());
        }
        if (statusList.size() == FlowControls.size()) {
            return null;
        }
        if (statusList.size() == 0) {
            QFilter qFilter = new QFilter("1", "!=", (Object)1);
            return qFilter;
        }
        return new QFilter("status", "in", statusList);
    }

    private QFilter getPageF7Filter(Long dmModelId) {
        List<MutilF7DimsionInfo> dimsionInfos = MutipleMemberF7Helper.getRealMutilF7DimsionInfos((AbstractFormPlugin)this, this.getModel(), dmModelId);
        if (dimsionInfos.size() == 0) {
            return null;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
        QFilter qFilter = new QFilter(MODEL, "=", (Object)dmModelId);
        for (MutilF7DimsionInfo dimsionInfo : dimsionInfos) {
            String columName = DisclosureReportHelper.changeDimNumber2F7Sign((String)dimsionInfo.getDimensionInfo().getNumber(), (String)modelType);
            if (dimsionInfo.getNotRangeMemberInfos().size() <= 0) continue;
            List<Object> memberIds = new ArrayList(1);
            if ("Entity".equalsIgnoreCase(dimsionInfo.getDimensionInfo().getNumber())) {
                List memberNumbers = dimsionInfo.getNotRangeMemberInfos().stream().map(m -> m.getMember().getNumber()).collect(Collectors.toList());
                List memberInfos = modelStrategyEx.getDimMember().getMemberIdsByNumber(dimsionInfo.getDimensionInfo(), memberNumbers);
                memberIds = memberInfos.stream().map(m -> m.getId()).collect(Collectors.toList());
            } else {
                memberIds = dimsionInfo.getNotRangeMemberInfos().stream().map(m -> m.getMember().getId()).collect(Collectors.toList());
            }
            qFilter.and(new QFilter(columName, "in", memberIds));
        }
        QFilter permList = this.getDimMemberPermsFromRedis();
        if (permList != null) {
            qFilter.and(permList);
        }
        return qFilter;
    }

    private void downloadFile(ReportDownloadTaskResult reportDownloadTaskResult) {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        for (ListSelectedRow row : billList.getSelectedRows()) {
            this.writeOpLog(OperationResult.SUCCESS, OperationName.EXPORT, row);
        }
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)reportDownloadTaskResult.getResult().getZipUrl());
        List strMessage = reportDownloadTaskResult.getResult().getTips();
        if (strMessage != null && strMessage.size() > 0) {
            String title = ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\u4fe1\u606f", (String)"ReportListPlugin_36", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, Joiner.on((String)"\n").join((Iterable)strMessage), MessageTypes.Default);
        }
    }

    private Object[] getSelectedIds() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    private Set<Long> getNotPermClassReportIds(Long dmModelId) {
        HashSet<Long> noPermIds = new HashSet<Long>(100);
        noPermIds.addAll(PermClassBaseHelper.getNoPermIds((Long)dmModelId, (String)"fidm", (String)"fidm_report"));
        return noPermIds;
    }

    private MyReportListInput getFormInputParam() {
        return (MyReportListInput)DisclosureFormHelper.getFormInputParam((IFormView)this.getView(), MyReportListInput.class, (Boolean)false);
    }

    private void writeOpLog(OperationResult result, OperationName opName, ListSelectedRow row) {
        super.writeOpLog(OperationCategory.REPORT, opName, result, "fidm_myreportlist", TypeUtils.toPinYinString((String)row.getName()));
    }
}

