/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.report;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.design.dto.PreviewFormParam;
import kd.epm.far.business.fidm.task.dto.PreviewTaskInput;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.helper.DmSingleF7ServiceHelper;

public class ReportPreviewEditPlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage {
    private static final String MODELTYPE = "modeltype";
    private static final String DIMF7MAP = "dimf7map";
    private static final String TEMPLATEDIMMAP = "templatedimmap";
    private static final String FLEXPANELAP = "flexpanelap";
    private WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, this.getClass());

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners("btnpreview");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        PreviewFormParam formParam = this.getFormInputParam();
        if (formParam == null) {
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(formParam.getDmModelId());
        String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
        Long sourceModelId = modelStrategyEx.getModel().getModelInfo().getModelId();
        this.getPageCache().put("KEY_MODEL_ID", sourceModelId.toString());
        this.getPageCache().put(MODELTYPE, modelType);
        HashMap<String, Long> dimF7Map = new HashMap<String, Long>(10);
        List dimList = formParam.getDimensionInfos();
        ArrayList<String> filterDimIdList = new ArrayList<String>(dimList.size());
        for (DimensionInfo dim : dimList) {
            dimF7Map.put(dim.getNumber().toLowerCase(), dim.getId());
            filterDimIdList.add(dim.getId().toString());
        }
        Map templateDimMap = modelStrategyEx.getDim().getDimDataMap(filterDimIdList);
        this.getPageCache().put(TEMPLATEDIMMAP, SerializationUtils.toJsonString((Object)templateDimMap));
        this.getPageCache().put(DIMF7MAP, SerializationUtils.toJsonString(dimF7Map));
        DmSingleF7ServiceHelper.createDimensionPage(this, this, FLEXPANELAP, templateDimMap);
        this.setDefaultDimValue(dimList);
        this.setReadOnlyDim(formParam.getReadonlyDimension());
    }

    private void setDefaultDimValue(List<DimensionInfo> dimList) {
        if (dimList == null || dimList.size() == 0) {
            return;
        }
        for (DimensionInfo dim : dimList) {
            if (dim.getMembers().size() <= 0 || this.getModel().getProperty(dim.getNumber()) == null) continue;
            this.getModel().setValue(dim.getNumber(), (Object)((DimMemberInfo)dim.getMembers().get(0)).getId());
        }
    }

    private void setReadOnlyDim(List<String> filterReadDimNumbers) {
        if (filterReadDimNumbers == null || filterReadDimNumbers.size() == 0) {
            return;
        }
        for (String number : filterReadDimNumbers) {
            try {
                if (this.getModel().getProperty(number) == null) continue;
                this.getView().setEnable(Boolean.valueOf(false), new String[]{number.toLowerCase()});
            }
            catch (Exception ex) {
                this.log.error("setReadOnlyDim filterReadDimNumbers:" + JSON.toJSONString(filterReadDimNumbers), (Throwable)ex);
            }
        }
    }

    private PreviewFormParam getFormInputParam() {
        return (PreviewFormParam)DisclosureFormHelper.getFormInputParam((IFormView)this.getView(), PreviewFormParam.class, (Boolean)true);
    }

    public void onGetControl(OnGetControlArgs e) {
        Element c;
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(e.getKey())) != null) {
            Long modeId = LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
            BasedataEdit f7 = DmSingleF7ServiceHelper.createBaseDataEdit(this, modeId, e.getKey());
            e.setControl((Control)f7);
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnpreview".equals(key)) {
            PreviewFormParam formParam = this.getFormInputParam();
            if (formParam == null) {
                return;
            }
            Map templateDimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(TEMPLATEDIMMAP), Map.class);
            HashMap<String, DimMemberInfo> memberMap = new HashMap<String, DimMemberInfo>(16);
            for (String F7Key : templateDimMap.keySet()) {
                String[] F7Split = F7Key.split("/");
                String F7Number = F7Split[1];
                String F7Name = F7Split[2];
                if (this.getModel().getValue(F7Number.toLowerCase()) == null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportPreviewEditPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), F7Name));
                    return;
                }
                DynamicObject memberDy = (DynamicObject)this.getModel().getValue(F7Number.toLowerCase());
                memberMap.put(F7Number.toLowerCase(), DimensionUtils.convertToMemberInfo((DynamicObject)memberDy));
            }
            PreviewTaskInput previewTaskParam = new PreviewTaskInput();
            previewTaskParam.setFormParam(formParam);
            previewTaskParam.setMemberMap(memberMap);
            this.returnDataToParent(previewTaskParam);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DimMemberInfo dimMemberInfo;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIMF7MAP));
        if (f7DimMap.containsKey(actionId) && (dimMemberInfo = new ModelStrategyEx(this.getDMModelId()).getDimensionF7().singleClosedCallBack(closedCallBackEvent.getReturnData())) != null) {
            this.getModel().setValue(actionId, (Object)dimMemberInfo.getId());
            this.getView().updateView(actionId);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        Long modeId = LongUtil.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        DmSingleF7ServiceHelper.createBeforeF7Select(this, beforeF7SelectEvent, modeId);
    }
}

