/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureTreeHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.business.fidm.template.TemplateCatalogHelper;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.AppUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;

public class AbstractDiscTemplateTreePlugin
extends AbstractBaseDMListPlugin {
    public static final String TEMPLATECATALOG = "templatecatalog";
    protected static final String MODEL = "model";
    protected Set<String> permControlButton = new HashSet<String>(Arrays.asList("btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down"));

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addListeners();
    }

    protected void addListeners() {
        this.addClickListeners("btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down");
        TreeView tview = (TreeView)this.getControl(TEMPLATECATALOG);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                AbstractDiscTemplateTreePlugin.this.setFocusCataLog(evt.getNodeId().toString());
                if (AbstractDiscTemplateTreePlugin.this.isCataLogReadOnly(evt.getNodeId().toString())) {
                    AbstractDiscTemplateTreePlugin.this.setButtonEnable(false);
                } else {
                    AbstractDiscTemplateTreePlugin.this.setButtonEnable(true);
                }
                AbstractDiscTemplateTreePlugin.this.refreshBillList();
            }
        });
    }

    protected void setButtonEnable(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"bar_add", "bar_copy", "bar_uploadtemplate", "bar_delete", "bar_enable", "bar_disable"});
    }

    protected String getFocusCataLog() {
        String nodeId = this.getPageCache().get("focusnodeid");
        return nodeId;
    }

    protected void setFocusCataLog(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getPageCache().remove("focusnodeid");
        } else {
            this.getPageCache().put("focusnodeid", nodeId);
        }
    }

    protected String getRootNode() {
        String nodeId = this.getPageCache().get("headnodeid");
        return nodeId;
    }

    protected void setRootNode(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getPageCache().remove("headnodeid");
        } else {
            this.getPageCache().put("headnodeid", nodeId);
        }
    }

    protected List<DisclosureTreeDto> getTreeList() {
        String data = this.getPageCache().get("treelist");
        if (StringUtils.isEmpty((String)data)) {
            return new ArrayList<DisclosureTreeDto>(1);
        }
        return JSONArray.parseArray((String)data, DisclosureTreeDto.class);
    }

    protected void setTreeList(List<DisclosureTreeDto> templatecatalogs) {
        if (templatecatalogs == null || templatecatalogs.size() == 0) {
            this.getPageCache().remove("treelist");
        } else {
            this.getPageCache().put("treelist", JSON.toJSONString(templatecatalogs));
        }
    }

    protected void initTree(String focusNodeId) {
        Long dmModelId = this.getDMModelId();
        List templatecatalogs = PermClassTemplateHelper.getTemplateCatalogList((Long)dmModelId, (String)AppCatalogTypeEnum.FIDM_CATALOG.getType());
        DisclosureTreeDto rootDto = DisclosureTreeHelper.getRoot((List)templatecatalogs);
        if (rootDto == null) {
            return;
        }
        TreeNode root = new TreeNode();
        root.setId(rootDto.getId());
        root.setParentid("");
        root.setText(DiscTemplateCatalogTypeEnum.getCatalogByAppId((String)this.getBizAppId()).getName());
        DisclosureTreeHelper.setEntryNode((TreeNode)root, (List)templatecatalogs, (String)rootDto.getId());
        DisclosureTreeHelper.spreadAllNode((TreeNode)root);
        this.setTreeList(templatecatalogs);
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        tree.deleteAllNodes();
        tree.addNode(root);
        TreeNode focusNode = DisclosureTreeHelper.findFocusNodeById((TreeNode)root, (String)focusNodeId);
        if (focusNode == null) {
            focusNode = root;
        }
        tree.focusNode(focusNode);
        this.setRootNode(rootDto.getId());
        this.setFocusCataLog(focusNode.getId());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (!this.validator()) {
            return;
        }
        String nodeId = this.getFocusCataLog();
        String headId = this.getRootNode();
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6a21\u677f\u5206\u7c7b\u6811\u8282\u70b9\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractTemplateTreePlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.permControlButton.contains(c.getKey().toLowerCase(Locale.ENGLISH)) && this.isCataLogReadOnly(nodeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"DiscTemplateListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addnew": {
                this.newTemplateCatalog(nodeId, true);
                break;
            }
            case "btn_delete": {
                if (nodeId.equalsIgnoreCase(headId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"AbstractTemplateTreePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u5220\u6a21\u677f\u5206\u7c7b\u4e0b\u7684\u6a21\u677f\u5c06\u4f1a\u88ab\u79fb\u52a8\u5230\u5176\u76f4\u63a5\u4e0a\u7ea7\u6a21\u677f\u5206\u7c7b\u4e0a\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AbstractTemplateTreePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletecatalog_comfirm", (IFormPlugin)this));
                break;
            }
            case "btn_modify": {
                if (nodeId.equalsIgnoreCase(headId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u7f16\u8f91\u3002", (String)"AbstractTemplateTreePlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.newTemplateCatalog(nodeId, false);
                break;
            }
            case "btn_up": 
            case "btn_down": {
                if (nodeId.equalsIgnoreCase(headId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u79fb\u52a8\u3002", (String)"AbstractTemplateTreePlugin_21", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.downAndUpMember(c.getKey().toLowerCase(Locale.ENGLISH));
                break;
            }
        }
    }

    protected boolean isCataLogReadOnly(String nodeId) {
        List<DisclosureTreeDto> treeDtos = this.getTreeList();
        DisclosureTreeDto treeDto = DisclosureTreeHelper.findDtoById(treeDtos, (String)nodeId);
        if (treeDto == null) {
            return false;
        }
        return DataTypeEnum.READ.getIndex().equalsIgnoreCase(treeDto.getPermClassType());
    }

    protected void downAndUpMember(String key) {
        TreeView treeView = (TreeView)this.getView().getControl(TEMPLATECATALOG);
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodeIds = treeState.getSelectedNodeId();
        if (selectNodeIds == null || selectNodeIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u5206\u7c7b\u3002", (String)"AbstractTemplateTreePlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectedNodeId = (String)selectNodeIds.get(selectNodeIds.size() - 1);
        try {
            if ("btn_up".equals(key)) {
                this.checkCatalogSeq(selectedNodeId);
                this.moveCatelogUp(selectedNodeId, this.getTemplateCataLogEntryEntity());
            } else if ("btn_down".equals(key)) {
                this.checkCatalogSeq(selectedNodeId);
                this.moveCatalogDown(selectedNodeId, this.getTemplateCataLogEntryEntity());
            }
        }
        catch (Exception e) {
            DynamicObject dyTree = BusinessDataReader.loadSingle((Object)Long.parseLong(selectedNodeId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getTemplateCataLogEntryEntity()));
            OperationName operationName = "btn_up".equals(key) ? OperationName.CATALOG_MOVE_UP : OperationName.CATALOG_MOVE_DOWN;
            this.writeOpLog(OperationResult.FAILURE, operationName, dyTree);
            throw e;
        }
    }

    protected void checkCatalogSeq(String selectNodeId) {
        String parentId = this.queryParentId(selectNodeId, this.getTemplateCataLogEntryEntity());
        this.dealChildSeq(parentId);
    }

    protected void moveCatelogUp(String id, String formId) {
        DynamicObject dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        if (seq == 1) {
            if (AppUtils.isFidmReport((String)this.getBizAppId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ee9\u6548\u5206\u6790\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else {
            QFilter qf1 = new QFilter("sequence", "<", (Object)dyTree.getInt("sequence"));
            String parentId = this.queryParentId(id, formId);
            QFilter filter = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
            QFilter[] filters = new QFilter[]{qf1, filter};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence desc", (int)1);
            if (seq != 0) {
                if (dcs != null && dcs.size() > 0) {
                    DynamicObject dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                    int seq2 = dyTree2.getInt("sequence");
                    dyTree2.set("sequence", (Object)seq);
                    dyTree.set("sequence", (Object)seq2);
                    SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                    this.initTree(id);
                    this.writeOpLog(OperationResult.SUCCESS, OperationName.CATALOG_MOVE_UP, dyTree);
                } else if (AppUtils.isFidmReport((String)this.getBizAppId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ee9\u6548\u5206\u6790\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    protected String queryParentId(String id, String entityId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)id))};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityId, (String)"parent", (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getString("parent");
        }
        return "";
    }

    protected void dealChildSeq(String parentId) {
        QFilter parent = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.getTemplateCataLogEntryEntity(), (String)"id,sequence", (QFilter[])filters, (String)"longnumber");
        if (dcs != null && dcs.size() > 0) {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(16);
            ArrayList<Long> arrayList = new ArrayList<Long>(16);
            for (DynamicObject dy : dcs) {
                Long id = dy.getLong("id");
                arrayList.add(id);
                map.put(id, dy.getInt("sequence"));
            }
            if (map.values().contains(0)) {
                DynamicObject dyCatelog = BusinessDataServiceHelper.newDynamicObject((String)this.getTemplateCataLogEntryEntity());
                Object[] dyDealSeq = (DynamicObject[])BusinessDataReader.load((Object[])arrayList.toArray(), (IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyCatelog.getDynamicObjectType().getName()));
                for (int i = 0; i < dyDealSeq.length; ++i) {
                    dyDealSeq[i].set("sequence", (Object)(i + 1));
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyCatelog.getDynamicObjectType().getName()), (Object[])dyDealSeq);
            }
        }
    }

    protected int getDSeq(long id, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"sequence", (QFilter[])filters, (String)"sequence");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getInt("sequence");
        }
        return 1;
    }

    protected void moveCatalogDown(String id, String formId) {
        DynamicObject dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        QFilter qf1 = new QFilter("sequence", ">", (Object)dyTree.getInt("sequence"));
        String parentId = this.queryParentId(id, formId);
        QFilter filter = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{qf1, filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence asc", (int)1);
        if (seq != 0) {
            if (dcs != null && dcs.size() > 0) {
                DynamicObject dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                int seq2 = dyTree2.getInt("sequence");
                dyTree2.set("sequence", (Object)seq);
                dyTree.set("sequence", (Object)seq2);
                SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                this.initTree(id);
                this.writeOpLog(OperationResult.SUCCESS, OperationName.CATALOG_MOVE_DOWN, dyTree);
            } else if (AppUtils.isFidmReport((String)this.getBizAppId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbstractTemplateTreePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ee9\u6548\u5206\u6790\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbstractTemplateTreePlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void newTemplateCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, this.getPageCache().get("dmmodelid"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "fidm_tmplcatalog");
        Long parentId = Long.parseLong(nodeId);
        List<DisclosureTreeDto> treeDtos = this.getTreeList();
        DisclosureTreeDto findDto = DisclosureTreeHelper.findDtoById(treeDtos, (String)nodeId);
        if (isAddNew) {
            params.put("parent", parentId);
            params.put("catcalogType", this.getCatalogType());
            params.put("type", "add");
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, 0L);
        } else {
            params.put("catcalogType", this.getCatalogType());
            params.put("parent", findDto == null ? null : findDto.getParentId());
            params.put("type", "edit");
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, parentId);
        }
    }

    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        params.put("entity", this.getTemplateCataLogEntryEntity());
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    protected DynamicObject[] getSelectedTempDynaObjs(String noSelectedMsg) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList.getSelectedRows().size() == 0) {
            if (StringUtils.isNotEmpty((String)noSelectedMsg)) {
                this.getView().showTipNotification(noSelectedMsg);
            }
            return null;
        }
        return BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("deletecatalog_comfirm") && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            Long dmModelId = this.getDMModelId();
            TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
            Map map = tree.getTreeState().getFocusNode();
            String nodeId = (String)map.get("id");
            ResultInfo resultInfo = TemplateCatalogHelper.deleteCatalog((long)dmModelId, (long)LongUtil.toLong((Object)nodeId));
            if (!resultInfo.isSuccess().booleanValue()) {
                this.getView().showErrorNotification(resultInfo.getMessage());
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractDesignPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.refreshTreeAndList(null);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("fidm_tmplcatalog".equals(actionId)) {
            ArrayList ids;
            ArrayList arrayList = ids = closedCallBackEvent.getReturnData() == null ? null : (ArrayList)closedCallBackEvent.getReturnData();
            if (ids != null && ids.size() > 0) {
                String nodeid = ((Long)ids.get(0)).toString();
                this.refreshTreeAndList(nodeid);
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return "fidm_template";
    }

    protected String getEntryEntity() {
        return "fidm_template";
    }

    protected String getCatalogType() {
        return DiscTemplateCatalogTypeEnum.getCatalogByAppId((String)this.getBizAppId()).getType();
    }

    protected String getTemplateCataLogEntryEntity() {
        return "fidm_tmplcatalog";
    }

    public void refreshTreeAndList(String focusNodeId) {
        this.initTree(focusNodeId);
        this.refreshControl();
        this.refreshBillList();
    }

    protected void refreshControl() {
    }

    protected void refreshBillList() {
    }

    private void writeOpLog(OperationResult result, OperationName opName, DynamicObject template) {
        String templateNumber = template != null ? template.getString("number") : "";
        OperationCategory operationCategory = OperationCategory.ANALYSIS_DESIGN;
        String formId = "far_analysisdesign";
        if (this.getBizAppId().equalsIgnoreCase("fidm")) {
            operationCategory = OperationCategory.TEMPLATE;
            formId = "fidm_templatelist";
        }
        super.writeOpLog(operationCategory, opName, result, formId, templateNumber);
    }
}

