/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.template;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;

public class DiscTemplateCatalogEditPlugin
extends AbstractBasePlugIn {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DiscTemplateCatalogEditPlugin.class);
    private static final String MODEL = "model";
    private static final String PARENT = "parent";
    private static final String SEQUENCE = "sequence";
    private static final String FIDMMODEL = "fidmmodel";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)this.getModelId(), (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
    }

    public void afterLoadData(EventObject e) {
        PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)this.getModelId());
        this.getModel().setDataChanged(false);
        Object parentNode = this.getModel().getValue(PARENT);
        if (Objects.isNull(parentNode)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get(MODEL);
        Object objParent = map.get(PARENT);
        Object catcalogType = map.get("catcalogType");
        this.getModel().setValue(MODEL, objModel);
        this.getModel().setValue("catalogtype", catcalogType);
        this.getModel().setValue(PARENT, objParent);
        int seq = this.getCurNodeSequence(map.get(MODEL).toString(), map.get(PARENT).toString());
        this.getModel().setValue(SEQUENCE, (Object)seq);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            this.getModel().setValue("status", (Object)"C");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        List ids = e.getOperationResult().getSuccessPkIds();
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        OperationName opName = OperationName.UNSUPPORTED;
        if ("add".equals(type)) {
            opName = OperationName.CATALOG_CREATE;
        } else if ("edit".equals(type)) {
            opName = OperationName.CATALOG_EDIT;
        }
        try {
            if (e.getSource() instanceof Save) {
                if (issuccess) {
                    PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)"fidm_tmplcatalog", (Long)LongUtil.toLong(ids.get(0)), (Object)LongUtil.toLong((Object)this.getModelId()), (OperationStatus)status, (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
                    this.getView().returnDataToParent((Object)ids);
                    this.getView().close();
                    this.writeOpLog(OperationResult.SUCCESS, opName);
                } else {
                    this.writeOpLog(OperationResult.FAILURE, opName);
                }
            }
        }
        catch (Exception exception) {
            this.writeOpLog(OperationResult.FAILURE, opName);
            throw exception;
        }
    }

    private int getCurNodeSequence(String modelId, String parentId) {
        QFilter model = new QFilter(MODEL, "=", (Object)Long.valueOf(modelId));
        QFilter parent = new QFilter(PARENT, "=", (Object)Long.valueOf(parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getCATALOGEntity(), (String)SEQUENCE, (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString(SEQUENCE);
            return (strSeq.isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    private String getCATALOGEntity() {
        return "fidm_tmplcatalog";
    }

    private Object getModelId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return map.get(MODEL);
    }

    private void writeOpLog(OperationResult result, OperationName opName) {
        try {
            String catcalogType = DisclosureFormHelper.getFormControlValueStr((Object)this.getModel().getValue("catalogtype"));
            OperationCategory operationCategory = OperationCategory.ANALYSIS_DESIGN;
            String formId = "far_analysisdesign";
            if (catcalogType.equalsIgnoreCase(DiscTemplateCatalogTypeEnum.TMPL_CATALOG.getType())) {
                operationCategory = OperationCategory.TEMPLATE;
                formId = "fidm_templatelist";
            }
            Long modelId = Long.parseLong((String)this.getModelId());
            ModelInfo modelInfo = new ModelStrategyEx(modelId).getModel().getModelInfo();
            Object number = this.getModel().getValue("number");
            String catalogNumber = number != null ? number.toString() : "";
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(operationCategory).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildFormatParams(new Object[]{modelInfo.getNumber(), catalogNumber}).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            logger.error("dm log error", (Throwable)ex);
        }
    }
}

