/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.fidm.base.DisclosureTreeHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.common.common.MessageConstant;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;

public class DiscTemplateCatalogSelectPlugin
extends AbstractBaseFormPlugin {
    protected static final String TREEVIEWWAP = "treeviewap";
    protected static final String TREEROOT = "treeroot";
    protected static final String ROWLIST = "rowlist";
    protected static final String FOCUS = "focus";

    @Override
    public void initialize() {
        super.initialize();
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(var1 -> {
            if (var1.getText() != null && !"".equals(var1.getText())) {
                this.searchMember(var1.getText().toLowerCase(Locale.ENGLISH).trim());
            } else {
                this.getPageCache().put(ROWLIST, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_confirm", "btn_cancel", "searchbefore", "searchnext");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree(null);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_confirm": {
                this.doConfirm();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            TreeNode old;
            String rowcache = this.getPageCache().get(ROWLIST);
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"DiscTemplateCatalogSelectPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode[] rowList = (TreeNode[])SerializationUtils.fromJsonString((String)rowcache, TreeNode[].class);
            int rowCount = Integer.parseInt(this.getPageCache().get(FOCUS));
            if ("searchbefore".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DiscTemplateCatalogSelectPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else {
                if (rowList.length - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DiscTemplateCatalogSelectPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            this.getPageCache().put(FOCUS, String.valueOf(rowCount));
            TreeNode focusNode = rowList[rowCount];
            TreeView treeView = (TreeView)this.getControl(TREEVIEWWAP);
            String oldnode = this.getPageCache().get("oldnode");
            TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
            if (old != null) {
                old.setColor("");
                treeView.updateNode(old);
            }
            focusNode.setColor("blue");
            treeView.updateNode(focusNode);
            treeView.focusNode(focusNode);
            this.getPageCache().put("oldnode", SerializationUtils.serializeToBase64((Object)focusNode));
        }
    }

    public void doConfirm() {
        TreeView tree = (TreeView)this.getControl(TREEVIEWWAP);
        Map map = tree.getTreeState().getFocusNode();
        this.getView().returnDataToParent((Object)map);
        this.getView().close();
    }

    private Long getDmModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
    }

    protected String getFocusCataLog() {
        String nodeId = this.getPageCache().get("focusnodeid");
        return nodeId;
    }

    protected void setFocusCataLog(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getPageCache().remove("focusnodeid");
        } else {
            this.getPageCache().put("focusnodeid", nodeId);
        }
    }

    protected String getRootNode() {
        String nodeId = this.getPageCache().get("headnodeid");
        return nodeId;
    }

    protected void setRootNode(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getPageCache().remove("headnodeid");
        } else {
            this.getPageCache().put("headnodeid", nodeId);
        }
    }

    protected List<DisclosureTreeDto> getTreeList() {
        String data = this.getPageCache().get("treelist");
        if (StringUtils.isEmpty((String)data)) {
            return new ArrayList<DisclosureTreeDto>(1);
        }
        return JSONArray.parseArray((String)data, DisclosureTreeDto.class);
    }

    protected void setTreeList(List<DisclosureTreeDto> templatecatalogs) {
        if (templatecatalogs == null || templatecatalogs.size() == 0) {
            this.getPageCache().remove("treelist");
        } else {
            this.getPageCache().put("treelist", JSON.toJSONString(templatecatalogs));
        }
    }

    private void initTree(String focusNodeId) {
        Long dmModelId = this.getDmModelId();
        List templatecatalogs = PermClassTemplateHelper.getTemplateCatalogList((Long)dmModelId, (String)this.getCatalogType());
        DisclosureTreeDto rootDto = DisclosureTreeHelper.getRoot((List)templatecatalogs);
        if (rootDto == null) {
            return;
        }
        TreeNode root = new TreeNode();
        root.setId(rootDto.getId());
        root.setParentid("");
        root.setText(DiscTemplateCatalogTypeEnum.getCatalogByAppId((String)this.getBizAppId()).getName());
        DisclosureTreeHelper.setEntryNode((TreeNode)root, (List)templatecatalogs, (String)rootDto.getId());
        DisclosureTreeHelper.spreadAllNode((TreeNode)root);
        this.setTreeList(templatecatalogs);
        TreeView tree = (TreeView)this.getControl(TREEVIEWWAP);
        tree.deleteAllNodes();
        tree.addNode(root);
        TreeNode focusNode = DisclosureTreeHelper.findFocusNodeById((TreeNode)root, (String)focusNodeId);
        if (focusNode == null) {
            focusNode = root;
        }
        tree.focusNode(focusNode);
        this.setRootNode(rootDto.getId());
        this.setFocusCataLog(focusNode.getId());
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)root));
    }

    private void searchMember(String text) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        TreeView mTree = (TreeView)this.getControl(TREEVIEWWAP);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        this.getTreeNodeListByText(root, treeNodes, text);
        ArrayList<TreeNode> alltreeNodes = new ArrayList<TreeNode>(10);
        this.getTreeNodeListByText(root, alltreeNodes, "");
        for (TreeNode treeNode : alltreeNodes) {
            treeNode.setIsOpened(true);
        }
        mTree.updateNodes(alltreeNodes);
        if (treeNodes.size() > 0) {
            this.getPageCache().put(ROWLIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
            TreeNode asd = (TreeNode)treeNodes.get(0);
            this.getPageCache().put(FOCUS, "0");
            mTree.updateNode(asd);
            mTree.focusNode(asd);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"DiscTemplateCatalogSelectPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
    }

    protected String getCatalogType() {
        return DiscTemplateCatalogTypeEnum.getCatalogByAppId((String)this.getBizAppId()).getType();
    }
}

