/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.IBillPlugin;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.helper.ElementHelper;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.business.far.model.DimDefaultValueVo;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.dto.ZipFileItem;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.template.convert.DisclosureTemplateImportService;
import kd.epm.far.business.fidm.template.convert.dto.TemplateUploadFile;
import kd.epm.far.business.fidm.template.convert.dto.TemplateUploadParam;
import kd.epm.far.business.fidm.template.dto.DiscTemplateModel;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.AppUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;

public class DiscTemplateEditPlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage,
IBillPlugin {
    private static final String DEFDIMPANEL = "defdimpanel";
    private static final String PARAMPANEL = "parampanel";
    private static final String MODEL = "model";
    private static final String SEQUENCE = "sequence";
    private static final String TEMPLATE_CATALOG = "templatecatalog";
    private static final String DIMF7MAP = "dimf7map";
    private static final String DIM2NAMEANDMODEL = "dim2NameAndModel";
    private static final String DIM2NAMEANDMODELMEMBER = "dim2NameAndModelMember";
    private static final String REALMODELID = "realModelId";
    private static final String PARAMDIM = "paramDim";
    private static final String ALLOWABLEDRAG = "allowableDrag";
    private static final String MODELTYPE = "modelType";
    private static final String PARAMDIMMAP = "paramDimName";
    private static final String VALUETYPE = "valuetype";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String MOVEROWUP = "moveRowUp";
    private static final String MOVEROWDOWN = "moveRowDown";
    private static final String CHANGEDATA = "changeData";
    private static final String EDITINIT = "editinit";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultTabViewVisiable();
        this.setDefaultValue();
        this.initDimCombolEdit(false);
        this.saveCacheDimMember();
    }

    private void initDimCombolEdit(boolean hasdsq) {
        HashMap paramDimMap = new HashMap(16);
        paramDimMap.putAll((Map)this.deSerializedBytes(this.getPageCache().get(PARAMDIMMAP)));
        ComboEdit dimComboEdit = (ComboEdit)this.getControl("fieldname");
        List fieldData = DisclosureTemplateHelper.getDimCombols(paramDimMap, (boolean)hasdsq);
        dimComboEdit.setComboItems(fieldData);
    }

    public void afterLoadData(EventObject e) {
        this.setDefaultTabViewVisiable();
        this.setEditValue();
        this.saveCacheDimMember();
        this.initSaveButton();
    }

    private void initSaveButton() {
        String perm;
        Long templateId = (Long)this.getFormCustomParam("templateId");
        if (LongUtil.isvalidLong((Object)templateId) && (PermClassBaseHelper.isNoPerm((String)(perm = PermClassTemplateHelper.getTemplatePerm((Long)templateId))) || PermClassBaseHelper.isReadPerm((String)perm))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"save"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void setDefaultTabViewVisiable() {
        if (!AppUtils.isFidmReport((String)this.getBizAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"params"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportname"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadtemplate"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadtemplatepanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnext"});
        } else if (this.getIsUploadTemplateFileModle()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baseinfo"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"params"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportname"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
            this.setSplitControl();
            this.getView().getModel().setValue("name", (Object)ResManager.loadKDString((String)"\u4e0a\u4f20\u6a21\u677f\u751f\u6210", (String)"DiscTemplateListPlugin_36", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadtemplate"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadtemplatepanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnext"});
        }
    }

    private void setSplitControl() {
        boolean issplit = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue("issplit"));
        this.getView().setEnable(Boolean.valueOf(issplit), new String[]{"splititem"});
        try {
            boolean isEnable = true;
            Control attachmentControl = this.getView().getControl("attachmentpanelap");
            AttachmentPanel panel = (AttachmentPanel)attachmentControl;
            List attachmentData = panel.getAttachmentData();
            if (attachmentData.size() > 1 && issplit) {
                isEnable = false;
                this.getModel().setValue("openaftercreate", (Object)Boolean.FALSE);
            }
            this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"openaftercreate"});
        }
        catch (Exception ex) {
            log.error("fidm  setSplitControl failed:", (Throwable)ex);
        }
    }

    private boolean getIsUploadTemplateFileModle() {
        if (!AppUtils.isFidmReport((String)this.getBizAppId())) {
            return false;
        }
        String isUploadTemplateFile = (String)this.getFormCustomParam("isUploadTemplateFile");
        return "1".equalsIgnoreCase(isUploadTemplateFile);
    }

    private boolean checkHasDesq() {
        DynamicObjectCollection nameRuleDefined = this.getModel().getEntryEntity("reportnamedefined");
        for (DynamicObject nameRule : nameRuleDefined) {
            String fieldName = nameRule.getString("fieldname");
            String fieldType = fieldName.substring(0, 3);
            if (!"dsq".equals(fieldType)) continue;
            return true;
        }
        return false;
    }

    private void setEditValue() {
        Long templateId = (Long)this.getFormCustomParam("templateId");
        if (templateId != null) {
            DiscTemplateModel discTemplateModel = DiscTemplateModel.genTemplateModelById((Long)templateId);
            ArrayList<String> paramDim = new ArrayList<String>(10);
            discTemplateModel.getParamDimensionEntries().forEach(p -> paramDim.add(p.getDimension().getNumber().toLowerCase(Locale.ENGLISH) + "_f7"));
            this.initCache(discTemplateModel.getModelId(), paramDim);
            this.setPanelContent(paramDim);
            this.initDimCombolEdit(this.checkHasDesq());
            this.changeNameRule("fieldname", EDITINIT);
            this.initDimCombolShowText();
            discTemplateModel.getDefaultDimensionEntries().forEach(p -> this.getModel().setValue(p.getDimension().getNumber().toLowerCase(Locale.ENGLISH) + "_f7", (Object)p.getMember().getId()));
            this.getModel().setDataChanged(false);
        }
    }

    private void initDimCombolShowText() {
        DynamicObjectCollection nameRules = this.getModel().getEntryEntity("reportnamedefined");
        for (DynamicObject nameRule : nameRules) {
            nameRule.set(VALUETYPE, (Object)DisclosureTemplateHelper.changeValuetoText((String)nameRule.getString(VALUETYPE)));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(TEMPLATE_CATALOG);
        TextEdit textEdit = (TextEdit)this.getControl(VALUETYPE);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (textEdit != null) {
            textEdit.addClickListener((ClickListener)this);
        }
        this.addClickListeners("btnnext");
        this.addItemClickListeners("advcontoolbarap");
        this.setPermClassFilter();
    }

    private void initCache(Long modelId, List<String> paramDim) {
        Map initCacheData = DisclosureTemplateHelper.getInitCache((Long)modelId, paramDim);
        HashMap<String, String> cache = new HashMap<String, String>();
        cache.put(REALMODELID, initCacheData.get(REALMODELID).toString());
        cache.put(DIMF7MAP, this.toByteSerialized(initCacheData.get(DIMF7MAP)));
        cache.put(DIM2NAMEANDMODEL, this.toByteSerialized(initCacheData.get(DIM2NAMEANDMODEL)));
        cache.put(ALLOWABLEDRAG, this.toByteSerialized(initCacheData.get(ALLOWABLEDRAG)));
        cache.put(MODELTYPE, initCacheData.get(MODELTYPE).toString());
        this.getPageCache().put(cache);
    }

    private void setDefaultValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long templateCatalogId = (Long)formShowParameter.getCustomParam("templateCatalogId");
        Long modelId = (Long)formShowParameter.getCustomParam("modelId");
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getModel().setValue(TEMPLATE_CATALOG, (Object)templateCatalogId);
        int seq = this.getCurrMaxSequence(modelId);
        this.getModel().setValue(SEQUENCE, (Object)seq);
        this.initCache(modelId, null);
        List paramDim = DisclosureTemplateHelper.getDefaultDimList((String)this.getPageCache().get(MODELTYPE));
        this.setPanelContent(paramDim);
        this.setDefaultMemberValue(modelId, paramDim);
    }

    private void setDefaultMemberValue(Long dmModelId, List<String> paramDim) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List allDimInfos = modelStrategyEx.getDim().getDimList();
        String modeltype = modelStrategyEx.getModel().getModelInfo().getModelType();
        DisModelTypeEnum enumByType = DisModelTypeEnum.getEnumByType((String)modeltype);
        for (DimensionInfo dim : allDimInfos) {
            DimMemberInfo bcmMember;
            DimDefaultValueVo member = DimDefaultValueHelper.getDefaultValue((String)dim.getShortNumber(), (Long)dmModelId, (DisModelTypeEnum)enumByType);
            if (member == null) continue;
            Long memberId = 0L;
            if (StringUtils.isNotEmpty((String)member.getDefaultValue()) && (bcmMember = modelStrategyEx.getDimMember().findMemberByNumber(dim.getNumber(), member.getDefaultValue(), false)) != null) {
                memberId = bcmMember.getId();
            }
            if (!LongUtil.isvalidLong((Object)memberId)) continue;
            String number = dim.getNumber().toLowerCase(Locale.ENGLISH) + "_f7";
            if (paramDim != null && paramDim.contains(number) || this.getModel().getProperty(number) == null) continue;
            this.getModel().setValue(number, (Object)memberId);
        }
    }

    private void setPermClassFilter() {
        BasedataEdit permClass = (BasedataEdit)this.getControl(PERMCLASS);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        if (modelId == null) {
            modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        }
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permClass, (Object)modelId, (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
    }

    private TemplateUploadParam importFile(Long templateId) {
        if (!LongUtil.isvalidLong((Object)templateId)) {
            return null;
        }
        if (!this.getIsUploadTemplateFileModle()) {
            return null;
        }
        String zipFileItemListStr = this.getPageCache().get("zipFileItemList");
        if (StringUtils.isEmpty((String)zipFileItemListStr)) {
            return null;
        }
        List zipFileItemList = JSONArray.parseArray((String)zipFileItemListStr, ZipFileItem.class);
        if (zipFileItemList == null || zipFileItemList.size() == 0) {
            return null;
        }
        TemplateUploadParam param = new TemplateUploadParam();
        param.setDmModelId(this.getDMModelId());
        param.setTemplateId(templateId);
        param.setSplit(DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue("issplit")));
        param.setConvertmodule(DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue("isconvertmodule")));
        param.setOpenAfterCreate(DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue("openaftercreate")));
        param.setSplititem(DisclosureFormHelper.getFormControlValueStr((Object)this.getModel().getValue("splititem")));
        param.setZipFileItems(zipFileItemList);
        DisclosureTemplateImportService.createChapter((TemplateUploadParam)param);
        return param;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey())) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                Long templateId = LongUtil.toLong(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0));
                TemplateUploadParam param = this.importFile(templateId);
                if (param != null) {
                    GlobalCacheServiceHelper.getCommonCache().getOrLoad(CacheKey.BasePrefixString + "_opentemplate_" + templateId, () -> param.isOpenAfterCreate() ? "1" : "0");
                }
                this.writeOpLog(OperationResult.SUCCESS);
                this.getView().returnDataToParent(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0));
            } else {
                this.writeOpLog(OperationResult.FAILURE);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        String appId = this.getBizAppId();
        Long dmModelId = this.getDMModelId();
        try {
            DisclosureTemplateHelper.checkSave((Long)dmModelId, (IDataModel)model, (String)appId);
        }
        catch (KDBizException kdBizException) {
            args.setCancel(true);
            this.getView().showTipNotification(kdBizException.getMessage(), Integer.valueOf(5000));
            return;
        }
        Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIMF7MAP));
        List paramDim = (List)this.deSerializedBytes(this.getPageCache().get(PARAMDIM));
        DynamicObjectCollection defMembEntry = (DynamicObjectCollection)model.getValue("defmembentry");
        DynamicObjectType defEntryType = defMembEntry.getDynamicObjectType();
        DynamicObjectCollection paramMembEntry = (DynamicObjectCollection)model.getValue("parammembentry");
        DynamicObjectType paramEntryType = paramMembEntry.getDynamicObjectType();
        String dimType = new ModelStrategyEx(dmModelId).getDim().getDimEntity();
        int defSeq = 1;
        int paramSeq = 1;
        this.repairData();
        Map dim2NameAndModelMembers = (Map)this.deSerializedBytes(this.getPageCache().get(DIM2NAMEANDMODELMEMBER));
        defMembEntry.clear();
        paramMembEntry.clear();
        for (Map.Entry entry : f7DimMap.entrySet()) {
            DynamicObject param;
            String dimKey = (String)entry.getKey();
            if (!paramDim.contains(dimKey)) {
                if (dim2NameAndModelMembers.get(dimKey) == null) continue;
                param = new DynamicObject(defEntryType);
                param.set("defdimtype", (Object)dimType);
                param.set("defdimension", entry.getValue());
                param.set("defmemberid", (Object)LongUtil.toLong(((Map)dim2NameAndModelMembers.get(dimKey)).get("id")));
                param.set("seq", (Object)defSeq++);
                defMembEntry.add((Object)param);
                continue;
            }
            param = new DynamicObject(paramEntryType);
            param.set("paramdimtype", (Object)dimType);
            param.set("paramdimension", entry.getValue());
            param.set("seq", (Object)paramSeq++);
            paramMembEntry.add((Object)param);
        }
        DynamicObjectCollection reportNameRule = this.getModel().getEntryEntity("reportnamedefined");
        int index = 0;
        for (Object reportName : reportNameRule) {
            reportName.set("desq", (Object)index);
            String valuetype = String.valueOf(this.getModel().getValue(VALUETYPE, index));
            reportName.set(VALUETYPE, (Object)DisclosureTemplateHelper.changeValueTypeItem((String)valuetype));
            ++index;
        }
        ArrayList defmembentryList = new ArrayList(5);
        for (DynamicObject defDy : defMembEntry) {
            HashMap<String, Object> defMap = new HashMap<String, Object>(2);
            defMap.put("defdimtype", defDy.get("defdimtype"));
            defMap.put("defdimension", defDy.get("defdimension"));
            defMap.put("defmemberid", defDy.get("defmemberid"));
            defMap.put("seq", defDy.get("seq"));
            defmembentryList.add(defMap);
        }
        ArrayList paramMembEntryList = new ArrayList(5);
        for (DynamicObject paramDy : paramMembEntry) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("paramdimtype", paramDy.get("paramdimtype"));
            paramMap.put("paramdimension", paramDy.get("paramdimension"));
            paramMap.put("seq", paramDy.get("seq"));
            paramMembEntryList.add(paramMap);
        }
        ThreadCache.put((Object)(CacheKey.PrefixString + "dimNumbers"), f7DimMap.keySet());
        ThreadCache.put((Object)(CacheKey.PrefixString + "defmembentry"), defmembentryList);
        ThreadCache.put((Object)(CacheKey.PrefixString + "parammembentry"), paramMembEntryList);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("issplit".equalsIgnoreCase(propertyName)) {
            this.setSplitControl();
        } else {
            this.changeNameRule(propertyName, CHANGEDATA);
            this.saveCacheDimMember();
        }
    }

    private void saveCacheDimMember() {
        HashMap memberCacheList = new HashMap(2);
        Map dim2NameAndModel = (Map)this.deSerializedBytes(this.getPageCache().get(DIM2NAMEANDMODEL));
        for (Map.Entry entry : dim2NameAndModel.entrySet()) {
            String dimNumber = (String)entry.getKey();
            DynamicObject dy = (DynamicObject)this.getModel().getValue(dimNumber);
            if (dy == null) {
                memberCacheList.put(dimNumber, null);
                continue;
            }
            HashMap<String, String> memberMap = new HashMap<String, String>(2);
            memberMap.put("id", dy.getString("id"));
            memberMap.put("name", dy.getString("name"));
            memberMap.put("number", dy.getString("number"));
            memberCacheList.put(dimNumber, memberMap);
        }
        this.getPageCache().put(DIM2NAMEANDMODELMEMBER, this.toByteSerialized(memberCacheList));
    }

    private void changeNameRule(String propertyName, String actionType) {
        if ("fieldname".equals(propertyName)) {
            EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl("reportnamedefined");
            ArrayList<Integer> moveRowList = new ArrayList<Integer>(16);
            if (CHANGEDATA.equals(actionType)) {
                int row = reportNameEntry.getSelectRows()[0];
                moveRowList.addAll(this.getMoveRow(row, actionType));
            } else {
                moveRowList.addAll(this.getMoveRow(0, actionType));
            }
            Iterator row = moveRowList.iterator();
            while (row.hasNext()) {
                int curRow = (Integer)row.next();
                String fieldName = String.valueOf(this.getModel().getValue("fieldname", curRow));
                if (!StringUtils.isEmpty((String)fieldName)) {
                    String fieldType;
                    switch (fieldType = fieldName.substring(0, 3)) {
                        case "dim": 
                        case "dat": {
                            this.getView().setEnable(Boolean.valueOf(false), curRow, new String[]{"value"});
                            this.getView().setEnable(Boolean.valueOf(true), curRow, new String[]{VALUETYPE});
                            break;
                        }
                        case "dsq": 
                        case "tna": 
                        case "tnm": {
                            this.getView().setEnable(Boolean.valueOf(false), curRow, new String[]{"value"});
                            this.getView().setEnable(Boolean.valueOf(false), curRow, new String[]{VALUETYPE});
                            break;
                        }
                        case "val": {
                            this.getView().setEnable(Boolean.valueOf(true), curRow, new String[]{"value"});
                            this.getView().setEnable(Boolean.valueOf(false), curRow, new String[]{VALUETYPE});
                        }
                    }
                    if (!CHANGEDATA.equals(actionType)) continue;
                    this.getModel().setValue(VALUETYPE, (Object)"");
                    this.getModel().setValue("value", (Object)"");
                    continue;
                }
                this.getModel().setValue("value", (Object)"", curRow);
                this.getModel().setValue(VALUETYPE, null, curRow);
            }
            int rows = this.getModel().getEntryRowCount("reportnamedefined");
            String hasDsqFlag = "0";
            for (int rowline = 0; rowline < rows; ++rowline) {
                String value = String.valueOf(this.getModel().getValue("fieldname", rowline));
                String valueType = "";
                if (!StringUtils.isEmpty((String)value)) {
                    valueType = value.substring(0, 3);
                }
                if (!"dsq".equals(valueType)) continue;
                hasDsqFlag = "1";
                this.initDimCombolEdit(true);
                break;
            }
            if ("0".equals(hasDsqFlag)) {
                this.initDimCombolEdit(false);
            }
            this.getPageCache().put("hasdeq", hasDsqFlag);
        }
    }

    private List<Integer> getMoveRow(int row, String actionType) {
        ArrayList<Integer> rowList = new ArrayList<Integer>(2);
        if (!CHANGEDATA.equals(actionType)) {
            int rows = this.getModel().getEntryRowCount("reportnamedefined");
            for (int currow = 0; currow < rows; ++currow) {
                rowList.add(currow);
            }
        } else {
            rowList.add(row);
        }
        return rowList;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    private int getCurrMaxSequence(long modelId) {
        QFilter model = new QFilter(MODEL, "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{model};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_templateentity", (String)SEQUENCE, (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString(SEQUENCE);
            return (strSeq.trim().isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getDMModelId());
        Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIMF7MAP));
        if (f7DimMap.containsKey(actionId)) {
            DimMemberInfo dimMemberInfo = modelStrategyEx.getDimensionF7().singleClosedCallBack(closedCallBackEvent.getReturnData());
            if (dimMemberInfo != null) {
                this.getModel().setValue(actionId, (Object)dimMemberInfo.getId());
                this.getView().updateView(actionId);
            }
        } else if ("fidm_tmplcatalogselect".equals(actionId)) {
            Map result = (Map)closedCallBackEvent.getReturnData();
            if (result == null) {
                return;
            }
            long catalogId = Long.parseLong(result.get("id").toString());
            if (catalogId == 0L) {
                this.getModel().setValue(TEMPLATE_CATALOG, null);
                return;
            }
            this.getModel().setValue(TEMPLATE_CATALOG, (Object)catalogId);
        } else if ("value_type_edit".equals(actionId)) {
            EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl("reportnamedefined");
            int row = reportNameEntry.getSelectRows()[0];
            if (closedCallBackEvent.getReturnData() != null) {
                String valueType = String.valueOf(closedCallBackEvent.getReturnData());
                this.getModel().setValue(VALUETYPE, (Object)valueType, row);
            }
        }
    }

    private void setPanelContent(List<String> paramDim) {
        this.getControl(DEFDIMPANEL).setDroppable(true);
        this.getControl(PARAMPANEL).setDroppable(true);
        Area defDimPanel = new Area(DEFDIMPANEL);
        Area paramPanel = new Area(PARAMPANEL);
        Map dim2NameAndModel = (Map)this.deSerializedBytes(this.getPageCache().get(DIM2NAMEANDMODEL));
        HashMap<String, Object> paramDimMap = new HashMap<String, Object>(paramDim.size());
        for (Map.Entry entry : dim2NameAndModel.entrySet()) {
            String dimNumber = (String)entry.getKey();
            Pair pair = (Pair)entry.getValue();
            BaseEditElement baseEdit = new BaseEditElement((String)pair.p1, dimNumber, (String)pair.p2);
            ElementHelper.buildF7Style((Element)baseEdit);
            baseEdit.setWidth(new LocaleString("190px"));
            baseEdit.setMustInput(false);
            if (paramDim.contains(dimNumber)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{dimNumber});
                paramPanel.addElement((Element)baseEdit);
                paramDimMap.put((String)pair.p2 + "/" + dimNumber, pair.p1);
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{dimNumber});
            defDimPanel.addElement((Element)baseEdit);
        }
        Page page = new Page();
        page.addArea(defDimPanel);
        page.addArea(paramPanel);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        List allowableDrag = (List)this.deSerializedBytes(this.getPageCache().get(ALLOWABLEDRAG));
        for (String dim : allowableDrag) {
            this.getControl(dim).setDraggable(true);
            this.getControl(dim).setDroppable(true);
        }
        this.getPageCache().put(PARAMDIM, this.toByteSerialized(paramDim));
        this.getPageCache().put(PARAMDIMMAP, this.toByteSerialized(paramDimMap));
    }

    public void onGetControl(OnGetControlArgs e) {
        Element c;
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(e.getKey())) != null) {
            Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIMF7MAP));
            Long dimId = (Long)f7DimMap.get(e.getKey());
            Long modelId = LongUtil.toLong((Object)this.getPageCache().get(REALMODELID));
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
            DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(false), (Long)dimId);
            BasedataEdit f7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, e.getKey(), this.getClass().getName(), false, "");
            e.setControl((Control)f7);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (TEMPLATE_CATALOG.equals(dimKey)) {
            beforeF7SelectEvent.setCancel(true);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fidm_tmplcatalogselect");
            showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u7c7b", (String)"DiscTemplateEditPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("modelId", (Object)this.getDMModelId());
            DynamicObject catalog = (DynamicObject)this.getModel().getValue(TEMPLATE_CATALOG);
            if (catalog != null) {
                showParameter.setCustomParam("focusnodeid", (Object)catalog.getString("id"));
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "fidm_tmplcatalogselect");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIMF7MAP));
            Long dimId = (Long)f7DimMap.get(dimKey);
            Long modelid = LongUtil.toLong((Object)this.getPageCache().get(REALMODELID));
            QFilter qFilter = new QFilter(MODEL, "=", (Object)modelid);
            qFilter.and("dimension", "=", (Object)dimId);
            ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
            filterList.add(qFilter);
            beforeF7SelectEvent.setCustomQFilters(filterList);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            List paramDim = (List)this.deSerializedBytes(this.getPageCache().get(PARAMDIM));
            List allowableDrag = (List)this.deSerializedBytes(this.getPageCache().get(ALLOWABLEDRAG));
            if (allowableDrag.contains(source) && (PARAMPANEL.equals(target) && !paramDim.contains(source) || DEFDIMPANEL.equals(target) && paramDim.contains(source))) {
                if (PARAMPANEL.equals(target)) {
                    paramDim.add(source);
                } else {
                    paramDim.remove(source);
                }
                this.setPanelContent(paramDim);
                String hasDsq = this.getPageCache().get("hasdeq");
                if ("1".equals(hasDsq)) {
                    this.initDimCombolEdit(true);
                } else if ("0".equals(hasDsq)) {
                    this.initDimCombolEdit(false);
                }
                this.repairData();
                this.getModel().setValue(source, null);
                this.getModel().setDataChanged(true);
            }
        }
    }

    private void repairData() {
        Map dim2NameAndModelMembers = (Map)this.deSerializedBytes(this.getPageCache().get(DIM2NAMEANDMODELMEMBER));
        for (Map.Entry item : dim2NameAndModelMembers.entrySet()) {
            DynamicObject data = (DynamicObject)this.getModel().getValue((String)item.getKey());
            Map redis = (Map)item.getValue();
            if (data != null || redis == null) continue;
            this.getModel().setValue((String)item.getKey(), (Object)LongUtil.toLong(redis.get("id")));
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey().toLowerCase(Locale.ENGLISH);
        if (VALUETYPE.equals(key)) {
            EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl("reportnamedefined");
            int row = reportNameEntry.getSelectRows()[0];
            String nameField = String.valueOf(this.getModel().getValue("fieldname", row));
            if (StringUtils.isEmpty((String)nameField)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b57\u6bb5\u540d\u79f0\u3002", (String)"DiscTemplateEditPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            String nameType = nameField.substring(0, 3);
            this.openCombolEdit(nameType);
        } else if ("btnnext".equals(key)) {
            this.uploadFileNext();
        }
    }

    private void uploadFileNext() {
        String name;
        Control attachmentControl = this.getView().getControl("attachmentpanelap");
        AttachmentPanel panel = (AttachmentPanel)attachmentControl;
        List attachmentData = panel.getAttachmentData();
        ArrayList<TemplateUploadFile> templateUploadFiles = new ArrayList<TemplateUploadFile>(100);
        for (Map file : attachmentData) {
            TemplateUploadFile templateUploadFile = new TemplateUploadFile();
            templateUploadFile.setUrl((String)file.get("url"));
            templateUploadFile.setTempFile(true);
            templateUploadFile.setFileName((String)file.get("name"));
            templateUploadFile.setFileType(DisclosureFileHelper.getFileType((String)templateUploadFile.getFileName()));
            templateUploadFiles.add(templateUploadFile);
        }
        List zipFileItemList = DisclosureTemplateImportService.getWordFile(templateUploadFiles);
        if (zipFileItemList == null || zipFileItemList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6709\u6548\u7684\u6587\u4ef6\u3002", (String)"DiscTemplateListPlugin_35", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (templateUploadFiles.size() == 1 && StringUtils.isNotEmpty((String)(name = DisclosureFileHelper.getFileNameNotFileType((String)((TemplateUploadFile)templateUploadFiles.get(0)).getFileName())))) {
            this.getView().getModel().setValue("name", (Object)name);
        }
        if (zipFileItemList.size() > 1) {
            String templateNumebr = DisclosureTemplateImportService.getNewTemplateNumber((Long)this.getDMModelId(), (int)1);
            String templateName = DisclosureFileHelper.getFileNameNotFileType((String)((TemplateUploadFile)templateUploadFiles.get(0)).getFileName());
            if (StringUtils.isEmpty((String)templateName)) {
                templateName = templateNumebr;
            }
            this.getView().getModel().setValue("name", (Object)templateName);
            this.getView().getModel().setValue("number", (Object)templateNumebr);
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"baseinfo"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"params"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"reportname"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadtemplate"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnext"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"save"});
        this.getPageCache().put("zipFileItemList", JSON.toJSONString((Object)zipFileItemList));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("addnew".equals(itemKey)) {
            this.addNewEntryData();
        } else if ("delete".equals(itemKey)) {
            this.deleteEntryRow();
        } else if ("moveup".equals(itemKey)) {
            this.entryRowMoveUp();
        } else if ("movedown".equals(itemKey)) {
            this.entryRowMovedown();
        }
    }

    private void addNewEntryData() {
        this.getModel().createNewEntryRow("reportnamedefined");
    }

    private void deleteEntryRow() {
        EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl("reportnamedefined");
        if (reportNameEntry.getSelectRows().length != 0) {
            int row = reportNameEntry.getSelectRows()[0];
            this.getModel().deleteEntryRow("reportnamedefined", row);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateEditPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryRowMoveUp() {
        EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl("reportnamedefined");
        if (reportNameEntry.getSelectRows().length != 0) {
            int row = reportNameEntry.getSelectRows()[0];
            if (row != 0) {
                this.getModel().moveEntryRowUp("reportnamedefined", row);
                this.getView().updateView("reportnamedefined");
                reportNameEntry.selectRows(row - 1);
                this.changeNameRule("fieldname", MOVEROWUP);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"DiscTemplateEditPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateEditPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void entryRowMovedown() {
        EntryGrid reportNameEntry = (EntryGrid)this.getView().getControl("reportnamedefined");
        if (reportNameEntry.getSelectRows().length != 0) {
            int row = reportNameEntry.getSelectRows()[0];
            int rowCount = this.getModel().getEntryRowCount("reportnamedefined");
            if (rowCount - 1 > row) {
                this.getModel().moveEntryRowDown("reportnamedefined", row);
                this.getView().updateView("reportnamedefined");
                reportNameEntry.selectRows(row + 1);
                this.changeNameRule("fieldname", MOVEROWDOWN);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"DiscTemplateEditPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateEditPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void openCombolEdit(String nameType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fidm_comboitem");
        showParameter.setCustomParam("nametype", (Object)nameType);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "value_type_edit");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private void writeOpLog(OperationResult result) {
        try {
            String templateNumber;
            Long templateId;
            OperationName operationName = OperationName.CREATE;
            if (this.getIsUploadTemplateFileModle()) {
                operationName = OperationName.UPLOAD;
            }
            if (LongUtil.isvalidLong((Object)(templateId = (Long)this.getFormCustomParam("templateId")))) {
                operationName = OperationName.EDIT;
            }
            long modelId = this.getDMModelId();
            String string = templateNumber = this.getModel().getValue("number") != null ? this.getModel().getValue("number").toString() : "";
            if ("fidm".equalsIgnoreCase(this.getBizAppId())) {
                super.writeOpLog(OperationCategory.TEMPLATE, operationName, result, "fidm_template", modelId, templateNumber);
            } else {
                super.writeOpLog(OperationCategory.ANALYSIS_DESIGN, operationName, result, "far_analysisdesign", modelId, templateNumber);
            }
        }
        catch (Exception ex) {
            log.error("dm log erorr", (Throwable)ex);
        }
    }
}

