/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.template;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.config.DMConfigServiceHelper;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.enums.DisclosureCopyEnum;
import kd.epm.far.business.common.other.GeneralCopyHepler;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureTreeHelper;
import kd.epm.far.business.fidm.base.dto.DisclosureTreeDto;
import kd.epm.far.business.fidm.design.DisclosurePageJumpHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewSelectHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassTemplateHelper;
import kd.epm.far.business.fidm.report.dto.GenerateFormInput;
import kd.epm.far.business.fidm.report.dto.GenerateFormResult;
import kd.epm.far.business.fidm.report.dto.GenerateResult;
import kd.epm.far.business.fidm.task.DisclosureTaskHepler;
import kd.epm.far.business.fidm.task.dto.GenerateTaskInput;
import kd.epm.far.business.fidm.task.dto.GenerateTaskResult;
import kd.epm.far.business.fidm.task.dto.PreviewTaskInput;
import kd.epm.far.business.fidm.task.dto.PreviewTaskResult;
import kd.epm.far.business.fidm.template.DisclosureTemplateCopyHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.template.TemplateCatalogHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.AppUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.disclosure.template.AbstractDiscTemplateTreePlugin;

public class DiscTemplateListPlugin
extends AbstractDiscTemplateTreePlugin {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String TREE_CHECK_BOX = "treecheckbox";
    private static final String TEMPLATE_CATALOG = "templatecatalog";
    private static final String CTL_MODEL = "modelbd";
    private static final String CALLBACKID_DEL_CONFIRM = "callbackid_del_confirm";
    private static final String CALLBACKID_COPYTEMPALTE_COMFIRM = "copyTempalte_comfirm";
    private Map<Long, String> realWordTypesMap = new HashMap<Long, String>(1);

    @Override
    public void initialize() {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setBillFormId(this.getBizEntityNumber());
        billList.addHyperClickListener(this::hyperLinkClick);
    }

    @Override
    public void registerListener(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.afterCreateNewData(e);
        this.setBtnVisable();
        Long dmModelId = this.getDMModelId();
        this.addCatalogRoot(dmModelId);
        this.getModel().setValue(CTL_MODEL, (Object)dmModelId);
        this.getPageCache().put("KEY_MODEL_ID", dmModelId.toString());
        this.refreshTreeAndList(null);
        DMConfigServiceHelper.repair();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        String key = e.getProperty().getName();
        if (key.equals(TREE_CHECK_BOX)) {
            this.refreshBillList();
        } else if (key.equals(CTL_MODEL)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
                return;
            }
            this.getPageCache().put("KEY_MODEL_ID", this.getDMModelId().toString());
            this.addCatalogRoot(this.getDMModelId());
            this.refreshTreeAndList(null);
        }
    }

    private void setBtnVisable() {
        if (AppUtils.isFidmReport((String)this.getBizAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_publish"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_generatereport"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_publish"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_generatereport"});
        }
    }

    private void addCatalogRoot(Long dmModelId) {
        TemplateCatalogHelper.addCatalogRoot((Long)dmModelId, (DiscTemplateCatalogTypeEnum)DiscTemplateCatalogTypeEnum.TMPL_CATALOG);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        String key = evt.getItemKey();
        String catelogId = this.getFocusCataLog();
        switch (key) {
            case "bar_add": {
                if (catelogId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u5206\u7c7b\u540e\u518d\u64cd\u4f5c\u3002", (String)"DiscTemplateListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("modelId", Long.valueOf(this.getPageCache().get("KEY_MODEL_ID")));
                params.put("templateCatalogId", Long.valueOf(catelogId));
                String title = ResManager.loadKDString((String)"\u65b0\u589e\u6a21\u677f", (String)"DiscTemplateListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]);
                if (!AppUtils.isFidmReport((String)this.getBizAppId())) {
                    title = ResManager.loadKDString((String)"\u65b0\u589e\u770b\u677f", (String)"DiscTemplateListPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]);
                }
                this.openFormPage("fidm_template", title, params);
                break;
            }
            case "bar_uploadtemplate": {
                this.checkPerm("bar_add");
                HashMap<String, Object> templateParams = new HashMap<String, Object>();
                templateParams.put("modelId", Long.valueOf(this.getPageCache().get("KEY_MODEL_ID")));
                templateParams.put("templateCatalogId", Long.valueOf(catelogId));
                templateParams.put("isUploadTemplateFile", "1");
                String templateTitle = ResManager.loadKDString((String)"\u65b0\u589e\u6a21\u677f", (String)"DiscTemplateListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]);
                if (!AppUtils.isFidmReport((String)this.getBizAppId())) {
                    templateTitle = ResManager.loadKDString((String)"\u65b0\u589e\u770b\u677f", (String)"DiscTemplateListPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]);
                }
                this.openFormPage("fidm_template", templateTitle, templateParams);
                break;
            }
            case "bar_delete": {
                this.actionDelete();
                break;
            }
            case "bar_copy": {
                this.copyTempalte();
                break;
            }
            case "bar_enable": {
                this.setStatus(true);
                break;
            }
            case "bar_disable": {
                this.setStatus(false);
                break;
            }
            case "bar_preview": {
                Object[] selectedIds = this.getSelectedIds();
                if (selectedIds == null || selectedIds.length == 0) {
                    return;
                }
                if (selectedIds.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateListPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                String previewMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u5165\u6a21\u677f\u7f16\u8f91\u9875\u9762\uff0c\u65b0\u589e\u7ae0\u8282\u540e\u518d\u8fdb\u884c\u9884\u89c8\u3002", (String)"DiscTemplateListPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]);
                if (!this.checkHaveChapterIds(previewMsg)) {
                    return;
                }
                if (selectedIds == null || selectedIds.length <= 0) break;
                DisclosurePreviewSelectHelper.openByTemplate((IFormPlugin)this, (IFormView)this.getView(), (Long)this.getDMModelId(), (Long)LongUtil.toLong((Object)selectedIds[0]));
                break;
            }
            case "bar_generatereport": {
                this.generatereport();
                break;
            }
            case "bar_refresh": {
                this.refreshTreeAndList(this.getFocusCataLog());
                break;
            }
            case "bar_baseinfo": {
                this.modifyBaseInfo();
                break;
            }
        }
    }

    private void generatereport() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null) {
            if (selectedIds.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateListPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            Long templateId = LongUtil.toLong((Object)selectedIds[0]);
            DynamicObject tmpl = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fidm_template", (String)"status");
            if (tmpl.getBoolean("status")) {
                String generateMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u5165\u6a21\u677f\u7f16\u8f91\u9875\u9762\uff0c\u65b0\u589e\u7ae0\u8282\u540e\u518d\u751f\u6210\u62a5\u544a\u3002", (String)"DiscTemplateListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]);
                if (!this.checkHaveChapterIds(generateMsg)) {
                    return;
                }
                String formId = "fidm_report_generate";
                String generateTitle = ResManager.loadKDString((String)"\u751f\u6210\u62a5\u544a", (String)"DiscTemplateListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]);
                GenerateFormInput formInput = new GenerateFormInput();
                formInput.setDmModelId(Long.valueOf(this.getModelId()));
                formInput.setTemplateId(templateId);
                formInput.setOperType("generate");
                FormShowParameter formShowParameter = DisclosureFormHelper.createFormParam((Object)formInput);
                formShowParameter.setFormId(formId);
                formShowParameter.setParentPageId(this.getView().getPageId());
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCaption(generateTitle);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"DiscTemplateListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void modifyBaseInfo() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null && selectedIds.length > 0) {
            if (selectedIds.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateListPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            Object templateID = selectedIds[0];
            BaseShowParameter param = new BaseShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("fidm_template");
            param.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"DiscTemplateListPlugin_28", (String)"epm-far-formplugin", (Object[])new Object[0]));
            param.setPkId(templateID);
            param.setCustomParam("templateId", templateID);
            param.setStatus(OperationStatus.EDIT);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fidm_tmpl_modifyBaseInfo"));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    @Override
    protected void refreshControl() {
        String nodeId = this.getFocusCataLog();
        if (!StringUtils.isEmpty((String)nodeId) && this.isCataLogReadOnly(nodeId)) {
            this.setButtonEnable(false);
        } else {
            this.setButtonEnable(true);
        }
    }

    private boolean checkHaveChapterIds(String msg) {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null && selectedIds.length > 0) {
            if (QueryServiceHelper.exists((String)"fidm_chapter", (QFilter[])new QFilter("template", "=", selectedIds[0]).toArray())) {
                return true;
            }
            this.getView().showTipNotification(msg);
        }
        return false;
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        String nodeId = this.getFocusCataLog();
        boolean cateLogReadOnly = this.isCataLogReadOnly(nodeId);
        if (billList.getSelectedRows().size() > 0 && !cateLogReadOnly) {
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            Map tempaltePermMap = PermClassTemplateHelper.getTemplatePermMap((Long)this.getDMModelId(), (Collection)TypeUtils.convertValueToLongList((Object[])selectNodeIds));
            boolean isWrite = true;
            for (Map.Entry cateEntry : tempaltePermMap.entrySet()) {
                if (!PermClassBaseHelper.isNoPerm((String)((String)cateEntry.getValue())) && !PermClassBaseHelper.isReadPerm((String)((String)cateEntry.getValue()))) continue;
                isWrite = false;
                break;
            }
            if (isWrite) {
                this.setButtonEnable(true);
            } else {
                this.setButtonEnable(false);
            }
        } else if (billList.getSelectedRows().size() == 0 && !cateLogReadOnly) {
            this.setButtonEnable(true);
        }
    }

    private void copyTempalte() {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"DiscTemplateListPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if (tempObjs != null) {
            if (tempObjs.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"DiscTemplateListPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            String newNumber = tempObjs[0].getString("number").concat("copy");
            String newName = tempObjs[0].getString("name").concat("copy");
            QFilter qf = new QFilter("model", "=", (Object)tempObjs[0].getLong("model.id"));
            qf.and("number", "=", (Object)newNumber);
            if (newNumber.length() > 50 || newName.length() > 100) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u590d\u5236\u751f\u6210\u7684\u62a5\u544a\u6a21\u677f\u7f16\u7801\u6216\u540d\u79f0\u8d85\u8fc7\u6307\u5b9a\u957f\u5ea6\u65e0\u6cd5\u4fdd\u5b58\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DiscTemplateListPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_COPYTEMPALTE_COMFIRM, (IFormPlugin)this));
            } else if (QueryServiceHelper.exists((String)"fidm_template", (QFilter[])qf.toArray())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u590d\u5236\u751f\u6210\u7684\u62a5\u544a\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DiscTemplateListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_COPYTEMPALTE_COMFIRM, (IFormPlugin)this));
            } else {
                DisclosureTemplateCopyHelper.copyTempalte((DynamicObject)tempObjs[0], (String)newNumber, (String)newName);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"DiscTemplateListPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.refreshBillList();
            }
        }
    }

    private void actionDelete() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds == null || selectedIds.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ChapterRepositoryListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"DiscTemplateListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_DEL_CONFIRM, (IFormPlugin)this));
    }

    private void actionDeleteResult() {
        String msg = "";
        Long dmModelId = this.getDMModelId();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ArrayList<Long> deleteSuccessIds = new ArrayList<Long>(billList.getSelectedRows().size());
        for (ListSelectedRow row : billList.getSelectedRows()) {
            Long templateId = LongUtil.toLong((Object)row.getPrimaryKeyValue());
            try {
                ResultInfo resultInfo = DisclosureTemplateHelper.deleteTemplate((long)dmModelId, (long)templateId);
                if (!resultInfo.isSuccess().booleanValue()) {
                    msg = row.getName() + "\uff1a" + resultInfo.getMessage();
                    this.getView().showTipNotification(msg);
                    continue;
                }
                deleteSuccessIds.add(templateId);
                this.writeOpLog(OperationResult.SUCCESS, OperationName.DELETE, row);
            }
            catch (Exception ex) {
                this.writeOpLog(OperationResult.FAILURE, OperationName.DELETE, row);
                throw ex;
            }
        }
        if (deleteSuccessIds.size() > 0) {
            msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"ChapterRepositoryListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]), deleteSuccessIds.size());
            this.getView().showSuccessNotification(msg);
        }
        this.refreshBillList();
    }

    private void setStatus(boolean status) {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"ModuleRepositoryListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (tempObjs != null) {
            for (DynamicObject tempObj : tempObjs) {
                tempObj.set("status", (Object)(status ? "1" : "0"));
            }
            try {
                SaveServiceHelper.save((DynamicObject[])tempObjs);
            }
            catch (Exception e) {
                OperationName opName = status ? OperationName.ENABLE : OperationName.DISABLE;
                this.batchWriteOpLog(OperationResult.FAILURE, opName, selectedRows);
                throw e;
            }
            if (status) {
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.ENABLE, selectedRows);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"DiscTemplateListPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else {
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.DISABLE, selectedRows);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"DiscTemplateListPlugin_24", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList();
        }
    }

    private Object[] getSelectedIds() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"DiscTemplateListPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return null;
        }
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    private void openFormPage(String formId, String caption, Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        params.put("classname", DiscTemplateListPlugin.class.getName());
        formShowParameter.setCustomParams(params);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(caption);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "fidm_template": {
                if (returnData != null) {
                    DisclosurePageJumpHelper.showTemplateEdit((IFormView)this.getView(), (Long)this.getDMModelId(), (Long)((Long)returnData));
                }
                this.refreshBillList();
                break;
            }
            case "fidm_data_copy": {
                if (returnData == null) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"DiscTemplateListPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.refreshBillList();
                break;
            }
            case "fidm_tmpl_modifyBaseInfo": {
                if (returnData == null) break;
                this.refreshBillList();
                break;
            }
            case "fidm_report_preview": {
                if (returnData == null) break;
                PreviewTaskInput previewTaskParam = (PreviewTaskInput)this.deSerializedBytes((String)returnData);
                if (previewTaskParam == null) {
                    return;
                }
                DisclosureTaskHepler.previewDispatch((IFormPlugin)this, (IFormView)this.getView(), (PreviewTaskInput)previewTaskParam);
                break;
            }
            case "task_preview_close_back": {
                PreviewTaskResult taskResult = DisclosureTaskHepler.getPreviewCallBackData((Object)returnData);
                if (taskResult == null) {
                    return;
                }
                if (!taskResult.success.booleanValue()) {
                    this.getView().showTipNotification(taskResult.message);
                    break;
                }
                ChapterPreviewResult previewResult = taskResult.getResult();
                if (previewResult == null) {
                    return;
                }
                DisclosurePageJumpHelper.preview((IFormView)this.getView(), (Long)this.getDMModelId(), (ChapterPreviewResult)previewResult);
                break;
            }
            case "fidm_report_generate": {
                if (returnData == null) break;
                GenerateFormResult genetateFormResult = (GenerateFormResult)this.deSerializedBytes((String)returnData);
                if (genetateFormResult == null) {
                    return;
                }
                GenerateTaskInput generateTaskInput = new GenerateTaskInput();
                generateTaskInput.setGenetateFormResult(genetateFormResult);
                DisclosureTaskHepler.generateDispatch((IFormPlugin)this, (IFormView)this.getView(), (GenerateTaskInput)generateTaskInput);
                break;
            }
            case "task_general_close_back": {
                GenerateTaskResult generateTaskResult = DisclosureTaskHepler.getGeneralCallBackData((Object)returnData);
                if (generateTaskResult == null) {
                    return;
                }
                if (!generateTaskResult.getSuccess().booleanValue()) {
                    this.getView().showTipNotification(generateTaskResult.getMessage());
                    break;
                }
                List generateResults = generateTaskResult.getResult();
                if (generateTaskResult.getResult() == null || generateTaskResult.getResult().size() == 0) {
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"ReportListPlugin_28", (String)"epm-far-formplugin", (Object[])new Object[0]));
                if (generateResults.size() <= 0) break;
                GenerateResult firstResult = (GenerateResult)generateResults.get(0);
                if (!generateTaskResult.getInput().getGenetateFormResult().getGoToReportDetail().booleanValue()) break;
                DisclosurePageJumpHelper.openEditPage((IFormView)this.getView(), (Long)firstResult.getReportId(), (Long)this.getDMModelId());
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "callbackid_del_confirm": {
                if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.actionDeleteResult();
                break;
            }
            case "copyTempalte_comfirm": {
                Object[] selectedIds = this.getSelectedIds();
                if (selectedIds == null || selectedIds.length <= 0) break;
                Long oldValId = LongUtil.toLong((Object)selectedIds[0]);
                String title = ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u590d\u5236", (String)"DiscTemplateListPlugin_32", (String)"epm-far-formplugin", (Object[])new Object[0]);
                GeneralCopyHepler.openWindow((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getDMModelId(), (DisclosureCopyEnum)DisclosureCopyEnum.Template, (Long)oldValId, (String)title);
                break;
            }
            case "settingmodel": {
                ListShowParameter lShowParameter = new ListShowParameter();
                lShowParameter.setBillFormId("fidm_model");
                HashMap parameter = new HashMap();
                lShowParameter.setCustomParams(parameter);
                lShowParameter.setCustomParam("billFormId", (Object)"fidm_model");
                lShowParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
                lShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)lShowParameter);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    @Override
    protected void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addBeforePackageDataListener(this::beforePackData);
        billList.addPackageDataListener(this::packData);
        QFilter filter = new QFilter("model", "=", (Object)this.getDMModelId());
        this.getCatalogqFilter(filter);
        this.addPermClassFilter(filter);
        billList.clearSelection();
        billList.setFilterParameter(new FilterParameter(filter, "sequence asc,number asc"));
        billList.refresh();
    }

    private void setTemplateWordTypes(Map<Long, String> wordTypesMap) {
        this.getPageCache().put("TemplateWordTypes", JSON.toJSONString(wordTypesMap));
    }

    private Map<Long, String> getTemplateWordTypes() {
        if (this.realWordTypesMap != null && this.realWordTypesMap.size() > 0) {
            return this.realWordTypesMap;
        }
        Map<Long, String> wordTypesMap = new HashMap<Long, String>(1);
        String templateWordTypesStr = this.getPageCache().get("TemplateWordTypes");
        if (!StringUtils.isEmpty((String)templateWordTypesStr)) {
            wordTypesMap = (Map)JSON.parseObject((String)templateWordTypesStr, Map.class);
        }
        this.realWordTypesMap = wordTypesMap;
        return this.realWordTypesMap;
    }

    private void beforePackData(BeforePackageDataEvent e) {
        List templateIds = e.getPageData().stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        if (templateIds.size() > 0) {
            Map wordTypesMap = DisclosureTemplateHelper.getTemplateOpenWordType(templateIds);
            this.setTemplateWordTypes(wordTypesMap);
        }
    }

    private void packData(PackageDataEvent e) {
        try {
            Map<Long, String> wordTypesMap = this.getTemplateWordTypes();
            if (e.getRowData() != null) {
                String wordTypeText = wordTypesMap.get(e.getRowData().getLong("id"));
                if (wordTypeText == null) {
                    wordTypeText = "";
                }
                e.getRowData().set("creator.number", (Object)wordTypeText);
            }
        }
        catch (Exception ex) {
            log.error("fimd packData failed", (Throwable)ex);
        }
    }

    private void addPermClassFilter(QFilter qFilter) {
        List noPermIds = PermClassBaseHelper.getNoPermIds((Long)this.getDMModelId(), (String)"fidm", (String)"fidm_template");
        if (noPermIds.size() > 0) {
            qFilter.and(new QFilter("id", "not in", (Object)noPermIds));
        }
    }

    private void getCatalogqFilter(QFilter filter) {
        List<DisclosureTreeDto> treeDtos = this.getTreeList();
        String nodeId = this.getFocusCataLog();
        if (!StringUtils.isEmpty((String)nodeId)) {
            boolean isallchild = DisclosureFormHelper.getFormControlValueBool((Object)this.getModel().getValue(TREE_CHECK_BOX));
            ArrayList<String> cataLogIds = new ArrayList<String>(treeDtos.size());
            if (isallchild) {
                cataLogIds.addAll(DisclosureTreeHelper.getTreeIds(treeDtos, (String)nodeId));
            } else {
                cataLogIds.add(nodeId);
            }
            filter.and(new QFilter(TEMPLATE_CATALOG, "in", (Object)LongUtil.toLongList(cataLogIds)));
        } else {
            filter.and(new QFilter("1", "!=", (Object)1));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        if (arg.getFieldName().equals("number")) {
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)arg).getCurrentRow();
            DisclosurePageJumpHelper.showTemplateEdit((IFormView)this.getView(), (Long)this.getDMModelId(), (Long)((Long)currentRow.getPrimaryKeyValue()));
        }
    }

    @Override
    public String getModelSign() {
        return CTL_MODEL;
    }

    private void writeOpLog(OperationResult result, OperationName opName, ListSelectedRow row) {
        super.writeOpLog(OperationCategory.TEMPLATE, opName, result, "fidm_templatelist", row.getNumber(), row.getName());
    }

    private void batchWriteOpLog(OperationResult result, OperationName opName, ListSelectedRowCollection selectedRows) {
        super.batchWriteOpLogRows(OperationCategory.TEMPLATE, opName, result, "fidm_templatelist", selectedRows);
    }
}

