/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.far.business.common.enums.DisclosureCopyEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.other.GeneralCopyHepler;
import kd.epm.far.business.common.other.dto.CopyFormParam;
import kd.epm.far.business.common.other.dto.CopyFormResult;
import kd.epm.far.business.fidm.base.DisclosureConstants;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.design.DisclosurePageJumpHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.dto.DesignFormInput;
import kd.epm.far.business.fidm.task.DisclosureTaskHepler;
import kd.epm.far.business.fidm.task.dto.PreviewTaskInput;
import kd.epm.far.business.fidm.task.dto.PreviewTaskResult;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.web.WebServiceHelper;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.disclosure.base.AbstractDesignPlugin;

public class WebDesignPlugin
extends AbstractDesignPlugin {
    protected static final String CALLBACKID_SAVETEPLATE_CLOSE = "callbackid_saveteplate_close";

    @Override
    protected OpenWordEnum getWordView() {
        return OpenWordEnum.WEB;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "fidm_report_preview": {
                if (returnData == null) break;
                PreviewTaskInput previewTaskParam = (PreviewTaskInput)this.deSerializedBytes((String)returnData);
                if (previewTaskParam == null) {
                    return;
                }
                DisclosureTaskHepler.previewDispatch((IFormPlugin)this, (IFormView)this.getView(), (PreviewTaskInput)previewTaskParam);
                break;
            }
            case "task_preview_close_back": {
                PreviewTaskResult taskResult = DisclosureTaskHepler.getPreviewCallBackData((Object)returnData);
                if (taskResult == null) {
                    return;
                }
                if (!taskResult.success.booleanValue()) {
                    this.getView().showTipNotification(taskResult.message);
                    break;
                }
                ChapterPreviewResult previewResult = taskResult.getResult();
                if (previewResult == null) {
                    return;
                }
                WebServiceHelper.previewByUrl((IFormView)this.getView(), (String)this.getBizAppId(), (Long)this.getDmModelId(), (ChapterPreviewResult)previewResult);
                break;
            }
            case "fidm_data_copy": {
                if (returnData == null) break;
                CopyFormResult copyFormResult = (CopyFormResult)JSON.parseObject((String)((String)returnData), CopyFormResult.class);
                if (copyFormResult == null) {
                    return;
                }
                DisclosureTemplateHelper.updateTempateSaveWordType((Long)copyFormResult.getNewId(), (OpenWordEnum)OpenWordEnum.WEB);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"DiscTemplateListPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
                DisclosurePageJumpHelper.showTemplateEditByWeb((IFormView)this.getView(), (Long)this.getDmModelId(), (Long)copyFormResult.getNewId());
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        MessageBoxResult msResult = evt.getResult();
        switch (key) {
            case "callbackid_saveteplate_close": {
                if (msResult != MessageBoxResult.Yes) break;
                this.saveTemplate();
            }
        }
    }

    @Override
    protected void dataInit(Long chapterId) {
        JSONObject result = null;
        try {
            DesignFormInput input = this.getDesignFormInput();
            Map chapterPermMap = input == null ? new LinkedHashMap(10) : input.getChapterPermMap();
            ArrayList strTips = new ArrayList(2);
            result = WebServiceHelper.dataInit((Long)this.getDmModelId(), (Long)chapterId, (boolean)false, strTips, chapterPermMap);
            strTips.forEach(m -> this.getView().showTipNotification(m));
            this.SendToVue(result);
        }
        catch (Exception ex) {
            this.SendToVue(DisclosureDesignHelper.dataError((Throwable)ex));
        }
    }

    @Override
    protected void evSave(String eventArgs) {
        Long chaperId = DisclosureJsonHelper.getValue((JSONObject)DisclosureJsonHelper.convert((String)eventArgs), (String)"pageConfig", (String)"id", (long)0L);
        if (!LongUtil.isvalidLong((Object)chaperId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ae0\u8282\u540e\u518d\u4fdd\u5b58\u3002", (String)"AbstractDesignPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject chapter = DisclosureChapterHelper.getChapter((Long)chaperId);
        String savewordtype = chapter.getString("savewordtype");
        OpenWordEnum curOpenWordEnum = OpenWordEnum.getByType((String)savewordtype);
        if (OpenWordEnum.WEBOFFICE == curOpenWordEnum || OpenWordEnum.WPS == curOpenWordEnum) {
            String msg = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u8f91\u65b9\u5f0f\u539f\u4e3a[%1s],\u8bf7\u786e\u8ba4\u662f\u5426\u7528[%2s]\u8fdb\u884c\u53e6\u5b58\uff1f", (String)"AbstractDesignPlugin_24", (String)"epm-far-formplugin", (Object[])new Object[0]), curOpenWordEnum.getName(), OpenWordEnum.WEB.getName());
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_SAVETEPLATE_CLOSE, (IFormPlugin)this));
        } else if (WebServiceHelper.saveTemplateChapter((Long)this.getDmModelId(), (Long)chaperId, (String)eventArgs)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractDesignPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void isDocChanged() {
        JSONObject data = new JSONObject(2);
        data.fluentPut("id", (Object)this.getSelectChapterId());
        JSONObject result = DisclosureVueHelper.getPropsDataResult((DisclosureConstants.PropsDataType)DisclosureConstants.PropsDataType.DATA_DOCUMENT_CHANGED, (Object)data, (String)"");
        this.SendToVue(result);
    }

    @Override
    protected void evDocumentChanged(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        boolean isChanged = jsonObject.getBoolean("data");
        this.isDocChangedResult(isChanged);
    }

    private void saveTemplate() {
        Long templateId = this.getTemplateId();
        if (!LongUtil.isvalidLong((Object)templateId)) {
            return;
        }
        DynamicObject template = DisclosureTemplateHelper.getTemplate((Long)templateId);
        String title = ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u590d\u5236", (String)"DiscTemplateListPlugin_32", (String)"epm-far-formplugin", (Object[])new Object[0]);
        CopyFormParam formParam = new CopyFormParam();
        formParam.setDmModelId(this.getDmModelId());
        formParam.setType(DisclosureCopyEnum.Template.getType());
        formParam.setSoucreId(templateId);
        formParam.setInitNumber(template.getString("number").concat("web"));
        formParam.setInitName(template.getString("name").concat("web"));
        GeneralCopyHepler.openWindow((IFormView)this.getView(), (IFormPlugin)this, (String)title, (CopyFormParam)formParam);
    }
}

