/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.disclosure.web;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.web.WebServiceHelper;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.MainPage;

public class WebPreviewPlugin
extends AbstractBaseDMFormPlugin
implements MainPage {
    protected static final String CTL_CUSTOMCONTROLAP = "customcontrolap";

    @Override
    public void registerListener(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.registerListener(e);
        this.addClickListeners("btndownload");
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btndownload": {
                ChapterPreviewResult previewResult = this.getReportPreviewResult();
                if (previewResult.getTempFile()) {
                    ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)previewResult.getPreviewUrl());
                    break;
                }
                String docUrl = UrlService.getAttachmentFullUrl((String)previewResult.getPreviewUrl());
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)docUrl);
                break;
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        DisclosureFormHelper.resetAppId((IFormView)this.getView());
        super.afterCreateNewData(e);
        this.dataInit();
    }

    public void customEvent(CustomEventArgs evt) {
        super.customEvent(evt);
    }

    protected void SendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    private void dataInit() {
        ChapterPreviewResult previewResult = this.getReportPreviewResult();
        try {
            JSONObject result = WebServiceHelper.dataPreview((ChapterPreviewResult)previewResult);
            this.SendToVue(result);
            if (previewResult.getTips() != null && previewResult.getTips().size() > 0) {
                previewResult.getTips().forEach(m -> this.getView().showTipNotification(m));
            }
        }
        catch (Exception ex) {
            this.SendToVue(DisclosureDesignHelper.dataError((Throwable)ex));
        }
    }

    private ChapterPreviewResult getReportPreviewResult() {
        String jsonStr = (String)this.getFormCustomParam("previewResult");
        if (StringUtils.isEmpty((String)jsonStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u89c8\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c!", (String)"AbstractDesignPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ChapterPreviewResult previewResult = (ChapterPreviewResult)JSONObject.parseObject((String)jsonStr, ChapterPreviewResult.class);
        if (previewResult == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u89c8\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c!", (String)"AbstractDesignPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return previewResult;
    }

    public Long getDmModelId() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        return modelId;
    }
}

