/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.epmclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.EpmModelServiceHelper;
import kd.epm.far.business.epmclient.dto.EpmApiOutput;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.common.common.util.ThrowableHelper;
import kd.epm.far.formplugin.epmclient.WordService;
import kd.epm.far.formplugin.epmclient.dto.ApiResponseModel;

public class WordPlugin
extends AbstractBillWebApiPlugin {
    private static final String PARAM_METHOD = "method";
    private static final String PARAM_PARAM = "param";
    private static final String PARAM_IS_GZIP = "isGzip";
    private static final String PARAM_APPID = "AppId";

    public ApiResult doCustomService(Map<String, Object> params) {
        Object backData;
        ApiResult result = new ApiResult();
        ApiResponseModel response = new ApiResponseModel();
        try {
            this.checkApp(params);
            this.checkLicense(params);
            this.checkModel(params);
            backData = this.invoke(params);
            backData = this.compress(params, backData);
        }
        catch (KDBizException e) {
            response.setSuccess(false);
            backData = e.getMessage();
        }
        catch (Exception e) {
            response.setSuccess(false);
            backData = "errorMessage:" + ThrowableHelper.toString((Exception)e);
        }
        response.setBackData(backData);
        result.setData((Object)response);
        return result;
    }

    private void checkApp(Map<String, Object> params) {
        String appId = StringUtils.getStringValue((Object)params.get(PARAM_APPID));
        if (!ApplicationTypeEnum.FIDM.getOIndex().equals(appId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u62ab\u9732\u7ba1\u7406\u5e94\u7528\u4e0d\u652f\u6301\u8c03\u7528\u63a5\u53e3\u3002", (String)"WordPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkLicense(Map<String, Object> params) {
        if ("checkLicense".equalsIgnoreCase(StringUtils.getStringValue((Object)params.get(PARAM_METHOD)))) {
            return;
        }
        WordService service = new WordService();
        String appId = StringUtils.getStringValue((Object)params.get(PARAM_APPID));
        LicenseCheckResult checkResult = service.checkLicense(appId);
        Boolean result = checkResult.getHasLicense();
        if (Boolean.FALSE.equals(result)) {
            throw new KDBizException(checkResult.getMsg());
        }
    }

    private void checkModel(Map<String, Object> params) {
        Object param = params.get(PARAM_PARAM);
        if (null == param) {
            return;
        }
        String methodName = StringUtils.getStringValue((Object)params.get(PARAM_METHOD));
        if (Arrays.asList("getModels", "getCharts", "getGlobalLongId", "checkLicense").contains(methodName)) {
            return;
        }
        long modelId = 0L;
        if ("getScenePeriodMap".equals(methodName) || "getUserInfo".equals(methodName)) {
            modelId = LongUtil.toLong((Object)param);
        } else {
            Map map = (Map)param;
            if (map.containsKey("ModelId")) {
                modelId = LongUtil.toLong(map.get("ModelId"));
            }
        }
        if (modelId > 0L) {
            ResultInfo resultInfo = new ModelStrategyEx(Long.valueOf(modelId)).getModel().checkModel();
            if (Boolean.FALSE.equals(resultInfo.isSuccess())) {
                throw new KDBizException(resultInfo.getMessage());
            }
            if (!EpmModelServiceHelper.hasPerm((long)modelId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u8be5\u4f53\u7cfb\u6743\u9650\u3002", (String)"WordPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Object compress(Map<String, Object> params, Object backData) {
        Boolean isGzip;
        if (params.containsKey(PARAM_IS_GZIP) && null != backData && Boolean.TRUE.equals(isGzip = (Boolean)params.get(PARAM_IS_GZIP))) {
            String jsonData = JSON.toJSONStringWithDateFormat((Object)backData, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            backData = ObjectSerialUtil.compress4GZip((String)jsonData);
        }
        return backData;
    }

    private Object invoke(Map<String, Object> params) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> clazz = Class.forName("kd.epm.far.formplugin.epmclient.WordService");
        Object instanceObj = clazz.newInstance();
        for (Method m : clazz.getMethods()) {
            EpmApiOutput output = this.invokeService(params, instanceObj, m);
            if (!output.isSuccess()) continue;
            return output.getData();
        }
        return null;
    }

    private EpmApiOutput invokeService(Map<String, Object> params, Object instanceObj, Method method) throws IllegalAccessException, InvocationTargetException {
        EpmApiOutput output = new EpmApiOutput();
        try {
            String methodName = StringUtils.getStringValue((Object)params.get(PARAM_METHOD));
            if (method.getName().equals(methodName)) {
                int paramCount;
                Object param = params.get(PARAM_PARAM);
                int count = method.getParameterCount();
                if (count == (paramCount = param != null ? 1 : 0)) {
                    if (count == 0) {
                        output.setData(method.invoke(instanceObj, new Object[0]));
                    } else {
                        output.setData(method.invoke(instanceObj, param));
                    }
                    output.setSuccess(true);
                    return output;
                }
            }
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException().toString().contains("KDBizException")) {
                throw new KDBizException(e.getTargetException().getMessage());
            }
            throw e;
        }
        return output;
    }
}

