/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.epmclient;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMDimensionHelper;
import kd.epm.far.business.bcm.BCMMemberHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.CslSchemeServiceHelper;
import kd.epm.far.business.bcm.dto.BCMPerm;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.bcm.dto.CslScheme;
import kd.epm.far.business.bcm.dto.DimMember;
import kd.epm.far.business.bcm.dto.DimProperty;
import kd.epm.far.business.bcm.dto.Dimension;
import kd.epm.far.business.bcm.dto.EnumValue;
import kd.epm.far.business.bcm.dto.MemberRange;
import kd.epm.far.business.bcm.dto.MemberRangeInput;
import kd.epm.far.business.bcm.dto.OrgBizChangeRecord;
import kd.epm.far.business.bcm.dto.OrgNameChangeRecord;
import kd.epm.far.business.bcm.dto.PeriodMemberEx;
import kd.epm.far.business.common.dataset.dto.DataSet;
import kd.epm.far.business.common.dataset.dto.DataSetMultiValue;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.ChapterCommitStatusEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.module.dto.Module;
import kd.epm.far.business.common.module.dto.ModuleCatalog;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.dto.FunctionPermItem;
import kd.epm.far.business.common.perm.dto.PermissionClass;
import kd.epm.far.business.common.user.UserHelper;
import kd.epm.far.business.common.user.dto.UserInfo;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.business.common.variable.dto.Variable;
import kd.epm.far.business.common.variable.dto.VariableEnum;
import kd.epm.far.business.epmclient.EpmChapterServiceHelper;
import kd.epm.far.business.epmclient.EpmClientLogHelper;
import kd.epm.far.business.epmclient.EpmDataSetServiceHelper;
import kd.epm.far.business.epmclient.EpmModelServiceHelper;
import kd.epm.far.business.epmclient.EpmModuleServiceHelper;
import kd.epm.far.business.epmclient.EpmReportServiceHelper;
import kd.epm.far.business.epmclient.EpmTemplateServiceHelper;
import kd.epm.far.business.epmclient.VersionHelper;
import kd.epm.far.business.epmclient.dto.EpmApiOutput;
import kd.epm.far.business.epmclient.dto.EpmClientVersion;
import kd.epm.far.business.epmclient.dto.Model;
import kd.epm.far.business.epmclient.dto.Report;
import kd.epm.far.business.epmclient.dto.ReportSimple;
import kd.epm.far.business.epmclient.util.ConvertUtil;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.business.fidm.chapter.ChapterCatalogHelper;
import kd.epm.far.business.fidm.chapter.ChapterRepositoryHelper;
import kd.epm.far.business.fidm.chapter.ChapterServiceHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.chapter.LockChapterHelper;
import kd.epm.far.business.fidm.chapter.dto.Chapter;
import kd.epm.far.business.fidm.chapter.dto.ChapterCatalog;
import kd.epm.far.business.fidm.chapter.dto.ChapterSaveInput;
import kd.epm.far.business.fidm.chapter.dto.ChapterSimple;
import kd.epm.far.business.fidm.module.calculate.VarHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.report.ReportFlowStatusHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.template.TemplateCatalogHelper;
import kd.epm.far.business.fidm.template.dto.TempCatalog;
import kd.epm.far.business.fidm.template.dto.Template;
import kd.epm.far.common.common.enums.PermEnum;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;

public class WordService {
    public Map<String, String> getEpmServerVersion() {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("EpmServerVersion", "1.5.2");
        map.put("EpmClientVersion", "2.2.0");
        map.put("EpmApiVersionDate", "2023-11-24");
        return map;
    }

    public LicenseCheckResult checkLicense(String appId) {
        Long groupId = 401L;
        String epmAppId = "2/FPWJAAAGX=";
        String fidmAppId = "2IFNVZ0SS0W4";
        LicenseCheckResult result = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.get().getCurrUserId(), (Long)groupId);
        if (Boolean.TRUE.equals(result.getHasLicense()) && Boolean.TRUE.equals((result = LicenseServiceHelper.checkLicenseModules((String)epmAppId)).getHasLicense())) {
            result = LicenseServiceHelper.checkLicenseModules((String)fidmAppId);
        }
        return result;
    }

    public List<Model> getModels(Map<String, Object> param) {
        String type = StringUtils.getStringValue((Object)param.get("Type"));
        return EpmModelServiceHelper.getModels((String)type);
    }

    public long getGlobalLongId(Map<String, Object> param) {
        return GlobalIdUtil.genGlobalLongId();
    }

    public UserInfo getUserInfo(long modelId) {
        return UserHelper.getUserInfo();
    }

    public String getVersion() {
        return VersionHelper.getVersion();
    }

    public EpmClientVersion getEpmClientPackageInfoByVersion(Map<String, Object> param) {
        String version = StringUtils.getStringValue((Object)param.get("version"));
        boolean isLatest = (Boolean)param.get("isLatest");
        return VersionHelper.getEpmClientPackageInfoByVersion((String)version, (boolean)isLatest);
    }

    public byte[] downloadFile(Map<String, Object> param) {
        String fileUrl = StringUtils.getStringValue((Object)param.get("remoteFilePath"));
        return VersionHelper.getFileBytes((String)fileUrl);
    }

    public List<PermissionClass> getPermissionClasses(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        String number = StringUtils.getStringValue((Object)param.get("Number"));
        List ids = (List)param.get("Ids");
        return PermissionHelper.getPermissionClasses((long)modelId, (String)number, (List)ids);
    }

    public List<FunctionPermItem> getFunctionNoPermissions(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        return PermissionHelper.getFunctionNoPermissions((long)modelId);
    }

    public List<Dimension> getDimensionByModelId(Map<String, Object> param) {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<Dimension>(0);
        }
        return BCMDimensionHelper.getDimensions((long)dmModel.getModelId());
    }

    public List<CslScheme> getCslSchemeByModelId(Map<String, Object> param) throws ParseException {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date modifyTime = format.parse(param.get("modifyTime").toString());
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<CslScheme>(0);
        }
        return CslSchemeServiceHelper.getCslSchemes((long)dmModel.getModelId(), (Date)modifyTime);
    }

    public List<DimMember> getMemberByModelId(Map<String, Object> param) throws ParseException {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        long dimensionId = LongUtil.toLong((Object)param.get("dimensionId"));
        Date modifyTime = null;
        if (param.containsKey("modifyTime")) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            modifyTime = format.parse(param.get("modifyTime").toString());
        }
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<DimMember>(0);
        }
        return BCMMemberHelper.getDimMembers((long)dmModel.getModelId(), (long)dimensionId, (Date)modifyTime);
    }

    public List<EnumValue> getEnumValueByModelId(Map<String, Object> param) {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        long dimensionId = LongUtil.toLong((Object)param.get("dimensionId"));
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<EnumValue>(0);
        }
        return BCMMemberHelper.getEnumValues((long)dmModel.getModelId(), (long)dimensionId);
    }

    public Map<Long, List<Long>> getDeleteMemberByModelId(Map<String, Object> param) throws ParseException {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        long dimensionId = LongUtil.toLong((Object)param.get("dimensionId"));
        Date modifyTime = null;
        if (param.containsKey("modifyTime")) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            modifyTime = format.parse(param.get("modifyTime").toString());
        }
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new HashMap<Long, List<Long>>(0);
        }
        return BCMMemberHelper.getDeleteMembers((long)dmModel.getModelId(), (long)dimensionId, (Date)modifyTime);
    }

    public Map<String, List<String>> getScenePeriodMap(long fidmModelId) {
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new HashMap<String, List<String>>(0);
        }
        return BCMMemberHelper.getScenarioPeriods((long)dmModel.getModelId());
    }

    public List<PeriodMemberEx> downloadPeriodMemberEx(Map<String, Object> param) throws ParseException {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        Date modifyTime = null;
        if (param.containsKey("modifyTime")) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            modifyTime = format.parse(param.get("modifyTime").toString());
        }
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<PeriodMemberEx>(0);
        }
        return BCMMemberHelper.getPeriodMemberEx((long)dmModel.getModelId(), (Date)modifyTime);
    }

    public List<OrgBizChangeRecord> downloadEntityBizChangeRecord(Map<String, Object> param) {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<OrgBizChangeRecord>(0);
        }
        return BCMMemberHelper.getEntityBizChangeRecord((long)dmModel.getModelId());
    }

    public List<OrgNameChangeRecord> downloadEntityizNameChangeRecord(Map<String, Object> param) {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<OrgNameChangeRecord>(0);
        }
        return BCMMemberHelper.getEntityNameChangeRecord((long)dmModel.getModelId());
    }

    public List<DimProperty> getPropertyByModelId(Map<String, Object> param) {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        long dimensionId = LongUtil.toLong((Object)param.get("dimensionId"));
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<DimProperty>(0);
        }
        return BCMMemberHelper.getProperties((long)dmModel.getModelId(), (long)dimensionId);
    }

    public List<Long> getMemberIdByRange(Map<String, Object> param) {
        long fidmModelId = LongUtil.toLong((Object)param.get("ModelId"));
        long dimensionId = LongUtil.toLong((Object)param.get("DimensionId"));
        long schemeId = LongUtil.toLong((Object)param.get("SchemeId"));
        boolean isProperty = (Boolean)param.get("IsProperty");
        List members = (List)param.get("Members");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(Long.valueOf(fidmModelId));
        ModelInfo dmModel = modelStrategyEx.getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new ArrayList<Long>(0);
        }
        ArrayList<String> dimIds = new ArrayList<String>(1);
        dimIds.add(StringUtils.getStringValue((Object)dimensionId));
        DimensionInfo dimensionInfo = (DimensionInfo)modelStrategyEx.getDim().getDimDataByIds(dimIds).get(0);
        ArrayList<MemberRange> memberList = new ArrayList<MemberRange>(members.size());
        for (Map member : members) {
            MemberRange memberRange = new MemberRange();
            memberRange.setId(LongUtil.toLong(member.get("MemberId")));
            memberRange.setRange(Integer.parseInt(StringUtils.getStringValue(member.get("Range"))));
            memberList.add(memberRange);
        }
        MemberRangeInput memberRangeInput = new MemberRangeInput();
        memberRangeInput.setModelId(dmModel.getModelId());
        memberRangeInput.setEntityName(dimensionInfo.getEntityName());
        memberRangeInput.setMembers(memberList);
        memberRangeInput.setProperty(isProperty);
        memberRangeInput.setSchemeId(Long.valueOf(schemeId));
        List memberRangeResults = BCMMsServiceHelper.batchGetMembersByIds((MemberRangeInput)memberRangeInput);
        if (CollectionUtils.isEmpty((Collection)memberRangeResults)) {
            return Collections.emptyList();
        }
        return memberRangeResults.stream().map(t -> LongUtil.toLong((Object)t.getId())).collect(Collectors.toList());
    }

    public List<Variable> getVariables(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        ArrayList<DmVariableTypeEnum> types = null;
        if (param.containsKey("Types")) {
            types = new ArrayList<DmVariableTypeEnum>(6);
            for (String type : (List)param.get("Types")) {
                types.add(DmVariableTypeEnum.getByIndex((String)type));
            }
        }
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_disc_variable_list", (String)"47150e89000000ac")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5168\u5c40\u53d8\u91cf\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"WordService_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return VariableService.getVariables((long)modelId, (long)chapterId, (String)name, types);
    }

    public EpmApiOutput deleteVariable(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        List variableIds = null;
        if (param.containsKey("VariableIds")) {
            variableIds = (List)param.get("VariableIds");
        }
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_disc_variable_list", (String)"4715e1f1000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5168\u5c40\u53d8\u91cf\u7684\u5220\u9664\u6743\u9650\u3002", (String)"WordService_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        List variables = VariableService.getVariables((long)modelId, (List)variableIds);
        ResultInfo result = VariableService.deleteVariable((long)modelId, (List)variableIds);
        EpmClientLogHelper.writeVars((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.DELETE, (Long)modelId, (List)variables);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput saveVariable(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        Variable variable = new Variable();
        variable.setId(LongUtil.toLong((Object)param.get("VariableId")).longValue());
        variable.setNumber(StringUtils.getStringValue((Object)param.get("Number")));
        variable.setName(StringUtils.getStringValue((Object)param.get("Name")));
        variable.setDescribe(StringUtils.getStringValue((Object)param.get("Describe")));
        variable.setPermClassId(LongUtil.toLong((Object)param.get("PermClassId")).longValue());
        variable.setType(StringUtils.getStringValue((Object)param.get("Type")));
        variable.setDefaultValue(StringUtils.getStringValue((Object)param.get("DefaultValue")));
        variable.setChapterId(LongUtil.toLong((Object)param.get("ChapterId")).longValue());
        variable.setDimId(LongUtil.toLong((Object)param.get("DimId")).longValue());
        if (param.containsKey("Enums")) {
            List enums = (List)param.get("Enums");
            for (Map e : enums) {
                VariableEnum varEnum = new VariableEnum();
                varEnum.setNumber(StringUtils.getStringValue(e.get("Number")));
                varEnum.setName(StringUtils.getStringValue(e.get("Name")));
                varEnum.setIsDefault(((Boolean)e.get("IsDefault")).booleanValue());
                varEnum.setDseq(Integer.parseInt(StringUtils.getStringValue(e.get("Dseq"))));
                variable.addEnums(varEnum);
            }
        }
        if (variable.getId() == 0L && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_disc_variable_list", (String)"47156aff000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5168\u5c40\u53d8\u91cf\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"WordService_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (variable.getId() > 0L && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_disc_variable_list", (String)"4715a0df000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5168\u5c40\u53d8\u91cf\u7684\u4fee\u6539\u6743\u9650\u3002", (String)"WordService_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = VariableService.saveVariable((long)modelId, (Variable)variable);
        EpmClientLogHelper.writeVars((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(LongUtil.toLong((Object)param.get("VariableId")) == 0L ? OperationName.CREATE : OperationName.MODIFY), (Long)modelId, Collections.singletonList(variable));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public List<DataSet> getDataSets(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        ArrayList<DataSetTypeEnum> types = null;
        if (param.containsKey("Types")) {
            types = new ArrayList<DataSetTypeEnum>(6);
            for (String type : (List)param.get("Types")) {
                types.add(DataSetTypeEnum.getEnumByType((String)type));
            }
        }
        List statuses = null;
        if (param.containsKey("Statuses")) {
            statuses = (List)param.get("Statuses");
        }
        List dataSrcTypes = null;
        if (param.containsKey("DataSrcTypes")) {
            dataSrcTypes = (List)param.get("DataSrcTypes");
        }
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_dataset_list", (String)"47150e89000000ac")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u96c6\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"WordService_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return DatasetServiceHelper.getDataSets((long)modelId, (long)chapterId, (String)name, types, (List)statuses, (List)dataSrcTypes);
    }

    public DataSet getDataSet(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long dataSetId = LongUtil.toLong((Object)param.get("DataSetId"));
        return DatasetServiceHelper.getDataSet((long)modelId, (long)dataSetId);
    }

    public EpmApiOutput setDataSetStatus(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        List dataSetIds = (List)param.get("DataSetIds");
        boolean enable = Boolean.parseBoolean(StringUtils.getStringValue((Object)param.get("Status")));
        if (enable && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_dataset_list", (String)"4730fc5d000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u96c6\u7684\u542f\u7528\u6743\u9650\u3002", (String)"WordService_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!enable && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_dataset_list", (String)"47160c2b000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u96c6\u7684\u7981\u7528\u6743\u9650\u3002", (String)"WordService_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = DatasetServiceHelper.setDataSetStatus((long)modelId, (List)dataSetIds, (boolean)enable);
        EpmClientLogHelper.writeDataSetsById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(enable ? OperationName.ENABLE : OperationName.DISABLE), (Long)modelId, (List)dataSetIds);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput deleteDataSet(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long dataSetId = LongUtil.toLong((Object)param.get("DataSetId"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_dataset_list", (String)"4715e1f1000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u96c6\u7684\u5220\u9664\u6743\u9650\u3002", (String)"WordService_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("discmodel", "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)dataSetId));
        DynamicObject dataSet = QueryServiceHelper.queryOne((String)"fidm_dataset", (String)"id,name,number,status", (QFilter[])qFilters.toArray(new QFilter[0]));
        String msg = DatasetServiceHelper.checkDelete((long)modelId, (DynamicObject)dataSet);
        if (StringUtils.isNotEmpty((String)msg)) {
            return new EpmApiOutput(false, msg);
        }
        HashSet<Long> ids = new HashSet<Long>(1);
        ids.add(dataSetId);
        boolean success = DatasetServiceHelper.deleteDataSet(ids);
        DataSet delSet = new DataSet();
        delSet.setName(dataSet.getString("name"));
        delSet.setNumber(dataSet.getString("number"));
        EpmClientLogHelper.writeDataSets((OperationResult)(success ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.DELETE, (Long)modelId, Collections.singletonList(delSet));
        return new EpmApiOutput((Object)dataSetId);
    }

    public EpmApiOutput getDataSetPreviewVarDim(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        long dataSetId = LongUtil.toLong((Object)param.get("DataSetId"));
        long dataSetFormulaId = LongUtil.toLong((Object)param.get("DataSetFormulaId"));
        return EpmDataSetServiceHelper.getColumnAndFilter((long)modelId, (long)chapterId, (long)dataSetId, (long)dataSetFormulaId);
    }

    public EpmApiOutput getDataSetPreviewData(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        long dataSetId = LongUtil.toLong((Object)param.get("DataSetId"));
        long dataSetFormulaId = LongUtil.toLong((Object)param.get("DataSetFormulaId"));
        List dimMembers = (List)param.get("DimMembers");
        Map varParams = (Map)param.get("VarParams");
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_dataset_list", (String)"1C8UBNOYX9F0")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u96c6\u7684\u9884\u89c8\u6743\u9650\u3002", (String)"WordService_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return EpmDataSetServiceHelper.getPreviewData((long)modelId, (long)chapterId, (long)dataSetId, (long)dataSetFormulaId, (List)dimMembers, (Map)varParams);
    }

    public List<DataSetMultiValue> getDataSetMultiValue(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long dataSetId = LongUtil.toLong((Object)param.get("DataSetId"));
        return DatasetServiceHelper.getDataSetMultiValue((long)modelId, (long)dataSetId);
    }

    public List<ModuleCatalog> getModuleCatalogs(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        return ModuleServiceHelper.getCatalogs((long)modelId);
    }

    public List<Module> getModules(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        return ModuleServiceHelper.getModulesForRepository((long)modelId);
    }

    public List<Module> getModulesForChapter(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        return ModuleServiceHelper.getModulesForChapter((long)modelId, (long)chapterId);
    }

    public Module getModule(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long moduleId = LongUtil.toLong((Object)param.get("ModuleId"));
        Map dimMembers = (Map)param.get("DimMembers");
        return ModuleServiceHelper.getModule((long)modelId, (long)moduleId, (Map)dimMembers);
    }

    public EpmApiOutput setModuleStatus(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long moduleId = LongUtil.toLong((Object)param.get("ModuleId"));
        boolean enable = Boolean.parseBoolean(StringUtils.getStringValue((Object)param.get("Status")));
        if (enable && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_modulerepositorylist", (String)"4730fc5d000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u4ef6\u5e93\u7684\u542f\u7528\u6743\u9650\u3002", (String)"WordService_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!enable && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_modulerepositorylist", (String)"47160c2b000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u4ef6\u5e93\u7684\u7981\u7528\u6743\u9650\u3002", (String)"WordService_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = ModuleServiceHelper.setModuleStatus((long)modelId, (long)moduleId, (boolean)enable);
        EpmClientLogHelper.writeModulesById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(enable ? OperationName.ENABLE : OperationName.DISABLE), (Long)modelId, Collections.singletonList(moduleId));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput deleteModule(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long moduleId = LongUtil.toLong((Object)param.get("ModuleId"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_modulerepositorylist", (String)"4715e1f1000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u4ef6\u5e93\u7684\u5220\u9664\u6743\u9650\u3002", (String)"WordService_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)moduleId));
        DynamicObject moduleData = QueryServiceHelper.queryOne((String)"fidm_modulerepository", (String)"id,number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (null == moduleData) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u7ec4\u4ef6\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WordService_57", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = ModuleServiceHelper.deleteModule((long)modelId, (long)moduleId);
        Module module = new Module();
        module.setName(moduleData.getString("name"));
        module.setNumber(moduleData.getString("number"));
        module.setId(modelId);
        EpmClientLogHelper.writeModules((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.DELETE, (Long)modelId, Collections.singletonList(module));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput saveAsModule(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        String number = StringUtils.getStringValue((Object)param.get("Number"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        String description = StringUtils.getStringValue((Object)param.get("Description"));
        String moduleJson = StringUtils.getStringValue((Object)param.get("ModuleJson"));
        String chartTemplateData = StringUtils.getStringValue((Object)param.get("ChartTemplateData"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        long permClassId = LongUtil.toLong((Object)param.get("PermClassId"));
        EpmApiOutput result = EpmModuleServiceHelper.saveAsModule((long)modelId, (String)number, (String)name, (long)catalogId, (long)permClassId, (String)description, (String)moduleJson, (String)chartTemplateData);
        Module module = new Module();
        module.setName(name);
        module.setNumber(number);
        EpmClientLogHelper.writeModules((OperationResult)(result.isSuccess() ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.SAVE_AS, (Long)modelId, Collections.singletonList(module));
        return result;
    }

    public EpmApiOutput getReportSectionData(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long moduleId = LongUtil.toLong((Object)param.get("ModuleId"));
        Map dimMembers = (Map)param.get("DimMembers");
        String properties = StringUtils.getStringValue((Object)param.get("Properties"));
        return EpmModuleServiceHelper.getReportSectionData((long)modelId, (long)moduleId, (Map)dimMembers, (String)properties);
    }

    public List<ChapterCatalog> getChapterCatalogs(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        boolean onlyWritePermission = false;
        if (param.containsKey("OnlyWritePermission")) {
            onlyWritePermission = Boolean.parseBoolean(param.get("OnlyWritePermission").toString());
        }
        return ChapterCatalogHelper.getChapterCatalogs((long)modelId, (boolean)onlyWritePermission);
    }

    public EpmApiOutput saveChapterCatalog(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        ChapterCatalog catalog = new ChapterCatalog();
        catalog.setId(catalogId);
        catalog.setNumber(StringUtils.getStringValue((Object)param.get("Number")));
        catalog.setName(StringUtils.getStringValue((Object)param.get("Name")));
        catalog.setPermClassId(LongUtil.toLong((Object)param.get("PermClassId")).longValue());
        catalog.setParentId(LongUtil.toLong((Object)param.get("ParentId")).longValue());
        catalog.setDescription(StringUtils.getStringValue((Object)param.get("Description")));
        ResultInfo result = ChapterCatalogHelper.saveChapterCatalog((long)modelId, (ChapterCatalog)catalog);
        EpmClientLogHelper.writeChapterCatalogs((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(catalogId == 0L ? OperationName.CATALOG_CREATE : OperationName.CATALOG_EDIT), (Long)modelId, Collections.singletonList(catalog));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput deleteChapterCatalog(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        QFilter filter = new QFilter("id", "in", (Object)catalogId).and("model", "=", (Object)modelId);
        DynamicObject catalogData = QueryServiceHelper.queryOne((String)"fidm_chaptergroup", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        if (null == catalogData) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u5206\u7c7b\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WordService_56", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterCatalogHelper.deleteChapterCatalog((long)modelId, (long)catalogId);
        ChapterCatalog catalog = new ChapterCatalog();
        catalog.setName(catalogData.getString("name"));
        catalog.setNumber(catalogData.getString("number"));
        catalog.setId(catalogId);
        EpmClientLogHelper.writeChapterCatalogs((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.CATALOG_DELETE, (Long)modelId, Collections.singletonList(catalog));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput moveChapterCatalog(Map<String, Object> param) {
        int type;
        long catalogId;
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        ResultInfo result = ChapterCatalogHelper.moveChapterCatalog((long)modelId, (long)(catalogId = LongUtil.toLong((Object)param.get("CatalogId")).longValue()), (int)(type = Integer.parseInt(StringUtils.getStringValue((Object)param.get("MoveToType")))));
        EpmClientLogHelper.writeChapterCatalogsById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(type == 1 ? OperationName.CATALOG_MOVE_UP : OperationName.CATALOG_MOVE_DOWN), (Long)modelId, Collections.singletonList(catalogId));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public List<ChapterSimple> getRepositoryChapters(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        return ChapterRepositoryHelper.getChapters((long)modelId);
    }

    public Chapter getRepositoryChapter(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        Map dimMembers = (Map)param.get("DimMembers");
        return ChapterRepositoryHelper.getChapter((long)modelId, (long)chapterId, (Map)dimMembers);
    }

    public EpmApiOutput saveRepositoryChapter(Map<String, Object> param) {
        Long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        Long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        ChapterSaveInput input = new ChapterSaveInput();
        input.setDmModelId(modelId);
        input.setChapterId(chapterId);
        input.setOldChapterId(LongUtil.toLong((Object)param.get("OldChapterId")));
        input.setCatalogId(LongUtil.toLong((Object)param.get("CatalogId")));
        input.setDescription((Object)StringUtils.getStringValue((Object)param.get("Description")));
        input.setNumber(StringUtils.getStringValue((Object)param.get("Number")));
        input.setName((Object)StringUtils.getStringValue((Object)param.get("Name")));
        input.setPermClassId(LongUtil.toLong((Object)param.get("PermClassId")));
        input.setSaveWordType(OpenWordEnum.EPMCLIENT);
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_chapterepositorylist", (String)"0=KX5+QVF5+R")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ae0\u8282\u5e93\u7684\u4fdd\u5b58\u6743\u9650\u3002", (String)"WordService_44", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo resultInfo = ChapterRepositoryHelper.save((ChapterSaveInput)input);
        EpmClientLogHelper.writeRepositoryChaptersById((OperationResult)(resultInfo.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(chapterId == 0L ? OperationName.CREATE : OperationName.EDIT), (Long)modelId, Collections.singletonList(chapterId));
        return ConvertUtil.toApiOutput((ResultInfo)resultInfo);
    }

    public EpmApiOutput deleteRepositoryChapter(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_chapterepositorylist", (String)"4715e1f1000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ae0\u8282\u5e93\u7684\u5220\u9664\u6743\u9650\u3002", (String)"WordService_45", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("id", "in", (Object)chapterId).and("model", "=", (Object)modelId);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fidm_chapter", (String)"number,name,id", (QFilter[])new QFilter[]{filter});
        if (dyns.size() == 0) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u7ae0\u8282\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WordService_55", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterRepositoryHelper.deleteChapter((long)modelId, (long)chapterId);
        Chapter chapter = new Chapter();
        chapter.setNumber(((DynamicObject)dyns.get(0)).getString("number"));
        chapter.setName(((DynamicObject)dyns.get(0)).getString("name"));
        chapter.setId(chapterId);
        EpmClientLogHelper.writeRepositoryChapters((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.DELETE, (Long)modelId, Collections.singletonList(chapter));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput setRepositoryChapterEnable(Map<String, Object> param) {
        ResultInfo result;
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        boolean enable = "1".equals(StringUtils.getStringValue((Object)param.get("Status")));
        if (enable) {
            if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_chapterepositorylist", (String)"4730fc5d000000ac")) {
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ae0\u8282\u5e93\u7684\u542f\u7528\u6743\u9650\u3002", (String)"WordService_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_chapterepositorylist", (String)"47160c2b000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ae0\u8282\u5e93\u7684\u7981\u7528\u6743\u9650\u3002", (String)"WordService_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        EpmClientLogHelper.writeRepositoryChaptersById((OperationResult)((result = ChapterRepositoryHelper.setEnableStatus((long)modelId, (long)chapterId, (boolean)enable)).isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(enable ? OperationName.ENABLE : OperationName.DISABLE), (Long)modelId, Collections.singletonList(chapterId));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput getChapterPreviewVarDim(Map<String, Object> param) {
        try {
            long modelId = LongUtil.toLong((Object)param.get("ModelId"));
            long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
            List filterDims = DisclosureChapterHelper.getPreviewVars((Long)modelId, (Long)chapterId);
            HashMap preViewDims = new HashMap(filterDims.size());
            for (DimensionInfo dim : filterDims) {
                HashMap<String, String> members = new HashMap<String, String>(2);
                members.put("memberId", dim.getMembers().isEmpty() ? "" : ((DimMemberInfo)dim.getMembers().get(0)).getId().toString());
                members.put("readOnly", "0");
                preViewDims.put(dim.getId().toString(), members);
            }
            return new EpmApiOutput(preViewDims);
        }
        catch (KDBizException e) {
            return new EpmApiOutput(false, e.getMessage());
        }
    }

    public List<TempCatalog> getTemplateCatalogs(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        List catalogIds = null;
        if (param.containsKey("CatalogIds")) {
            catalogIds = (List)param.get("CatalogIds");
        }
        boolean onlyWritePermission = false;
        if (param.containsKey("OnlyWritePermission")) {
            onlyWritePermission = Boolean.parseBoolean(param.get("OnlyWritePermission").toString());
        }
        return TemplateCatalogHelper.getCatalogs((long)modelId, (List)catalogIds, (boolean)onlyWritePermission);
    }

    public TempCatalog getTemplateCatalog(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        ArrayList<Long> catalogIds = new ArrayList<Long>(1);
        catalogIds.add(catalogId);
        List catalogs = TemplateCatalogHelper.getCatalogs((long)modelId, catalogIds, (boolean)false);
        return catalogs.isEmpty() ? null : (TempCatalog)catalogs.get(0);
    }

    public EpmApiOutput saveTemplateCatalog(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        long permClassId = LongUtil.toLong((Object)param.get("PermClassId"));
        String description = StringUtils.getStringValue((Object)param.get("Description"));
        if (catalogId == 0L) {
            if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_templatelist", (String)"3M0ELI1UPWOB")) {
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u5217\u8868\u7684\u5206\u7c7b\u65b0\u589e\u6743\u9650\u3002", (String)"WordService_48", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            String number = StringUtils.getStringValue((Object)param.get("Number"));
            long parentId = LongUtil.toLong((Object)param.get("ParentId"));
            ResultInfo result = TemplateCatalogHelper.addCatalog((long)modelId, (String)number, (String)name, (long)parentId, (long)permClassId, (String)description);
            TempCatalog catalog = new TempCatalog();
            catalog.setName(name);
            catalog.setNumber(number);
            ArrayList<TempCatalog> catalogs = new ArrayList<TempCatalog>(1);
            catalogs.add(catalog);
            EpmClientLogHelper.writeTemplateCatlogs((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.CREATE, (Long)modelId, catalogs);
            return ConvertUtil.toApiOutput((ResultInfo)result);
        }
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_templatelist", (String)"3M0ENNT7J+93")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u5217\u8868\u7684\u5206\u7c7b\u4fee\u6539\u6743\u9650\u3002", (String)"WordService_49", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = TemplateCatalogHelper.updateCatalog((long)modelId, (long)catalogId, (String)name, (long)permClassId, (String)description);
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(catalogId);
        EpmClientLogHelper.writeTemplateCatlogsById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.EDIT, (Long)modelId, ids);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput deleteTemplateCatalog(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_templatelist", (String)"3M0EPBLB+D/Z")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u5217\u8868\u7684\u5206\u7c7b\u5220\u9664\u6743\u9650\u3002", (String)"WordService_50", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(catalogId);
        List catalogs = TemplateCatalogHelper.getCatalogs((long)modelId, ids, (boolean)false);
        ResultInfo result = TemplateCatalogHelper.deleteCatalog((long)modelId, (long)catalogId);
        EpmClientLogHelper.writeTemplateCatlogs((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.DELETE, (Long)modelId, (List)catalogs);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput moveTemplateCatalog(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        int type = Integer.parseInt(StringUtils.getStringValue((Object)param.get("MoveToType")));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_templatelist", (String)"3M0EQH+F0XQ5")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u5217\u8868\u7684\u5206\u7c7b\u79fb\u52a8\u6743\u9650\u3002", (String)"WordService_51", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = TemplateCatalogHelper.moveCatalog((long)modelId, (long)catalogId, (int)type);
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(catalogId);
        EpmClientLogHelper.writeTemplateCatlogsById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(type == 1 ? OperationName.CATALOG_MOVE_UP : OperationName.CATALOG_MOVE_DOWN), (Long)modelId, ids);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public List<Template> getTemplates(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        List templateIds = null;
        if (param.containsKey("TemplateIds")) {
            templateIds = (List)param.get("TemplateIds");
        }
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        return EpmTemplateServiceHelper.getTemplates((long)modelId, (List)templateIds, (long)catalogId);
    }

    public Template getTemplate(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        ArrayList<Long> templateIds = new ArrayList<Long>(1);
        templateIds.add(templateId);
        List templates = EpmTemplateServiceHelper.getTemplates((long)modelId, templateIds, (long)0L);
        return templates.isEmpty() ? null : (Template)templates.get(0);
    }

    public EpmApiOutput setTemplateStatus(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        boolean enable = Boolean.parseBoolean(StringUtils.getStringValue((Object)param.get("Status")));
        if (enable && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_template", (String)"4730fc5d000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u7684\u542f\u7528\u6743\u9650\u3002", (String)"WordService_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!enable && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_template", (String)"47160c2b000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u7684\u7981\u7528\u6743\u9650\u3002", (String)"WordService_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = DisclosureTemplateHelper.setTemplateStatus((long)modelId, (long)templateId, (boolean)enable);
        ArrayList<Long> Ids = new ArrayList<Long>(1);
        Ids.add(templateId);
        EpmClientLogHelper.writeTemplatesById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(enable ? OperationName.ENABLE : OperationName.DISABLE), (Long)modelId, Ids);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput deleteTemplate(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_template", (String)"4715e1f1000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u7684\u5220\u9664\u6743\u9650\u3002", (String)"WordService_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        DynamicObject dytemp = DisclosureTemplateHelper.getTemplate((Long)templateId);
        if (null == dytemp) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WordService_54", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = DisclosureTemplateHelper.deleteTemplate((long)modelId, (long)templateId);
        Template delTemp = new Template();
        delTemp.setNumber(dytemp.getString("number"));
        delTemp.setName(dytemp.getString("name"));
        ArrayList<Template> delTemps = new ArrayList<Template>(1);
        delTemps.add(delTemp);
        EpmClientLogHelper.writeTemplates((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.DELETE, (Long)modelId, delTemps);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput saveTemplate(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        String number = StringUtils.getStringValue((Object)param.get("Number"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        String description = StringUtils.getStringValue((Object)param.get("Description"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        long permClassId = LongUtil.toLong((Object)param.get("PermClassId"));
        boolean isAutoNumberName = param.containsKey("IsAutoNumberName") && Boolean.parseBoolean(param.get("IsAutoNumberName").toString());
        List defmembentry = new ArrayList(6);
        List parammembentry = new ArrayList(6);
        if (param.containsKey("TemplateDimensions")) {
            defmembentry = (List)param.get("TemplateDimensions");
        }
        if (param.containsKey("TemplateParamDimensions")) {
            parammembentry = (List)param.get("TemplateParamDimensions");
        }
        if (templateId <= 0L) {
            if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_template", (String)"47156aff000000ac")) {
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"WordService_19", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_template", (String)"1=DS4UJ=H4CX") && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_webdesign", (String)"1=DS4UJ=H4CX")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u7684\u57fa\u672c\u4fe1\u606f-\u7f16\u8f91\u6743\u9650\uff0c\u4e5f\u6ca1\u6709\u62a5\u544a\u8bbe\u8ba1\u7684\u57fa\u672c\u4fe1\u606f-\u7f16\u8f91\u6743\u9650\u3002", (String)"WordService_20", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = DisclosureTemplateHelper.saveTemplate((long)modelId, (long)templateId, (String)number, (String)name, (long)catalogId, (long)permClassId, (String)description, defmembentry, parammembentry, (boolean)isAutoNumberName);
        Template saveTemp = new Template();
        saveTemp.setName(name);
        saveTemp.setNumber(number);
        ArrayList<Template> saveTemps = new ArrayList<Template>(1);
        saveTemps.add(saveTemp);
        EpmClientLogHelper.writeTemplates((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(templateId <= 0L ? OperationName.CREATE : OperationName.EDIT), (Long)modelId, saveTemps);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput copyTemplate(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_template", (String)"4730fc9f000020ae")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u6a21\u677f\u5217\u8868\u7684\u590d\u5236\u6743\u9650\u3002", (String)"WordService_52", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        EpmApiOutput result = EpmTemplateServiceHelper.copyTemplate((long)modelId, (long)templateId);
        ArrayList<Long> Ids = new ArrayList<Long>(1);
        Ids.add(templateId);
        EpmClientLogHelper.writeTemplatesById((OperationResult)(result.isSuccess() ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.COPY, (Long)modelId, Ids);
        return result;
    }

    public List<ReportSimple> getReports(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        String flowStatus = StringUtils.getStringValue((Object)param.get("FlowStatus"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"47150e89000000ac")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"WordService_21", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return EpmReportServiceHelper.getReports((long)modelId, (long)templateId, (String)name, (String)flowStatus, param);
    }

    public Report getReport(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        return EpmReportServiceHelper.getReport((long)modelId, (long)reportId);
    }

    public EpmApiOutput createReport(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        boolean templateGenerate = PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_templatelist", (String)"2N37YASZMO0K");
        boolean generate = PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"2N37YASZMO0K");
        boolean batchGenerate = PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"2N39FB04/VF3");
        if (!(templateGenerate || generate || batchGenerate)) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u751f\u6210\u62a5\u544a\u7684\u6743\u9650\u3002", (String)"WordService_22", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return EpmReportServiceHelper.createReport((long)modelId, param);
    }

    public EpmApiOutput saveReport(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        long permClassId = LongUtil.toLong((Object)param.get("PermClassId"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"2R3S=C4SM5IS")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u67e5\u770b\u62a5\u544a-\u57fa\u672c\u4fe1\u606f\u6743\u9650\u3002", (String)"WordService_53", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = DisclosureReportHelper.saveReport((long)modelId, (long)reportId, (String)name, (long)permClassId);
        EpmClientLogHelper.writeReportsById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.EDIT_BASEINFO, (Long)modelId, Collections.singletonList(reportId));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput deleteReport(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"4715e1f1000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u5220\u9664\u6743\u9650\u3002", (String)"WordService_24", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        DynamicObject reportDyn = DisclosureReportHelper.getReport((Long)reportId);
        if (null == reportDyn) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u62a5\u544a\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WordService_58", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = DisclosureReportHelper.deleteReport((long)modelId, (long)reportId);
        Report rpt = new Report();
        rpt.setName(reportDyn.getString("name"));
        EpmClientLogHelper.writeReports((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.DELETE, (Long)modelId, Collections.singletonList(rpt));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput setReportFlowStatus(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        String operateType = StringUtils.getStringValue((Object)param.get("OperateType"));
        String remark = StringUtils.getStringValue((Object)param.get("Remark"));
        switch (operateType) {
            case "A": {
                if (PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"804f6478000000ac")) break;
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u63d0\u4ea4\u6743\u9650\u3002", (String)"WordService_25", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            case "B": {
                if (PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"4730fc9f000000ae")) break;
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u6253\u56de\u6743\u9650\u3002", (String)"WordService_26", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            case "C": {
                if (PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"47162f66000000ac")) break;
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u5ba1\u6838\u6743\u9650\u3002", (String)"WordService_27", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            case "D": {
                if (PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"47165e8e000000ac")) break;
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u53cd\u5ba1\u6838\u6743\u9650\u3002", (String)"WordService_28", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            case "E": {
                if (PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"/=N=NAA4+3V2")) break;
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u5f52\u6863\u6743\u9650\u3002", (String)"WordService_29", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            case "F": {
                if (PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"/=N=Y++CAOOZ")) break;
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u53cd\u5f52\u6863\u6743\u9650\u3002", (String)"WordService_30", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        ResultInfo result = DisclosureReportHelper.setReportFlowStatus((long)modelId, (long)reportId, (String)operateType, (String)remark);
        OperationName operName = ReportFlowStatusHelper.getOperationName((String)operateType);
        EpmClientLogHelper.writeReportOper((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (Long)modelId, (long)reportId, (OperationName)operName);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public List<ChapterSimple> getChapters(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        List reportIds = new ArrayList(6);
        if (param.containsKey("ReportIds")) {
            reportIds = (List)param.get("ReportIds");
        }
        List templateIds = new ArrayList(6);
        if (param.containsKey("TemplateIds")) {
            templateIds = (List)param.get("TemplateIds");
        }
        boolean checkPermission = false;
        if (param.containsKey("CheckPermission")) {
            checkPermission = (Boolean)param.get("CheckPermission");
        }
        if (!reportIds.isEmpty()) {
            return ChapterServiceHelper.getChaptersByReport((long)modelId, reportIds);
        }
        if (!templateIds.isEmpty()) {
            return ChapterServiceHelper.getChaptersByTemplate((long)modelId, templateIds, (boolean)checkPermission);
        }
        return new ArrayList<ChapterSimple>(0);
    }

    public Chapter getChapter(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        Map dimMembers = (Map)param.get("DimMembers");
        return ChapterServiceHelper.getChapter((long)modelId, (long)chapterId, (long)reportId, (Map)dimMembers);
    }

    public EpmApiOutput saveChapterDocument(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        String modules = StringUtils.getStringValue((Object)param.get("Modules"));
        String docBytes = StringUtils.getStringValue((Object)param.get("DocBytes"));
        if (reportId > 0L && StringUtils.isNotEmpty((String)docBytes) && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"2R609B5J9YU/")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u7f16\u8f91-\u4fdd\u5b58\u6743\u9650\u3002", (String)"WordService_32", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.saveChapterDocument((long)modelId, (long)templateId, (long)reportId, (long)chapterId, (String)modules, (String)docBytes);
        EpmClientLogHelper.writeChaptersById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.SAVE, (templateId <= 0L ? 1 : 0) != 0, (Long)modelId, Collections.singletonList(chapterId), (long)(templateId <= 0L ? reportId : templateId));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput saveChapterInfo(Map<String, Object> param) {
        boolean isAutoNumberName;
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        long permClassId = LongUtil.toLong((Object)param.get("PermClassId"));
        String number = StringUtils.getStringValue((Object)param.get("Number"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        String description = StringUtils.getStringValue((Object)param.get("Description"));
        boolean bl = isAutoNumberName = param.containsKey("IsAutoNumberName") && Boolean.parseBoolean(param.get("IsAutoNumberName").toString());
        if (reportId == 0L) {
            if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_webdesign", (String)"0=KX5+QVF5+R")) {
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u8bbe\u8ba1\u7684\u4fdd\u5b58\u6743\u9650\u3002", (String)"WordService_33", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"0AQ3YJ2LET+U")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u7f16\u8f91\u6743\u9650\u3002", (String)"WordService_31", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.saveChapterInfo((long)modelId, (long)templateId, (long)reportId, (long)chapterId, (String)number, (String)name, (long)permClassId, (String)description, (boolean)isAutoNumberName);
        ArrayList<Chapter> chapters = new ArrayList<Chapter>(1);
        Chapter chapter = new Chapter();
        chapter.setName(name);
        chapter.setNumber(number);
        chapter.setTemplateId(templateId);
        chapter.setReportId(reportId);
        chapters.add(chapter);
        EpmClientLogHelper.writeChapters((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(chapterId == 0L ? OperationName.CREATE : OperationName.EDIT), (reportId != 0L ? 1 : 0) != 0, (Long)modelId, chapters);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput setChapterCheck(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        boolean isCheck = (Boolean)param.get("IsCheck");
        if (isCheck && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"2N6Q4FDWO2UB")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u7f16\u8f91-\u7f6e\u4e3a\u5b9a\u7a3f\u6743\u9650\u3002", (String)"WordService_34", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!isCheck && !PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_myreportlist", (String)"2N6Q7NTRD19R")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u5217\u8868\u7684\u7f16\u8f91-\u7f6e\u4e3a\u8349\u7a3f\u6743\u9650\u3002", (String)"WordService_35", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.setChapterCheck((long)modelId, (long)reportId, (long)chapterId, (boolean)isCheck);
        EpmClientLogHelper.writeChaptersById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(isCheck ? OperationName.COMMIT : OperationName.BACKED), (boolean)true, (Long)modelId, Collections.singletonList(chapterId), (long)reportId);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput moveChapter(Map<String, Object> param) {
        int type;
        long chapterId;
        long templateId;
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        ResultInfo result = ChapterServiceHelper.moveChapter((long)modelId, (long)(templateId = LongUtil.toLong((Object)param.get("TemplateId")).longValue()), (long)(chapterId = LongUtil.toLong((Object)param.get("ChapterId")).longValue()), (int)(type = Integer.parseInt(StringUtils.getStringValue((Object)param.get("MoveToType")))));
        EpmClientLogHelper.writeChaptersById((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(type == 1 ? OperationName.CATALOG_MOVE_UP : OperationName.CATALOG_MOVE_DOWN), (boolean)false, (Long)modelId, Collections.singletonList(chapterId), (long)templateId);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput deleteChapter(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        QFilter filter = new QFilter("id", "in", (Object)chapterId).and("model", "=", (Object)modelId);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fidm_chapter", (String)"number,name,id", (QFilter[])new QFilter[]{filter});
        if (dyns.size() == 0) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u7ae0\u8282\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WordService_55", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ResultInfo result = ChapterServiceHelper.deleteChapter((long)modelId, (long)templateId, (long)chapterId);
        Chapter chapter = new Chapter();
        chapter.setName(((DynamicObject)dyns.get(0)).getString("name"));
        chapter.setNumber(((DynamicObject)dyns.get(0)).getString("number"));
        chapter.setTemplateId(templateId);
        EpmClientLogHelper.writeChapters((OperationResult)(result.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.DELETE, (boolean)false, (Long)modelId, Collections.singletonList(chapter));
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput setChapterCommitStatus(Map<String, Object> param) {
        ResultInfo result;
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        String status = StringUtils.getStringValue((Object)param.get("Status"));
        if (ChapterCommitStatusEnum.COMMIT.getType().equals(status)) {
            if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_webdesign", (String)"804f6478000000ac")) {
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u8bbe\u8ba1\u7684\u63d0\u4ea4\u6743\u9650\u3002", (String)"WordService_36", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_webdesign", (String)"4730fc9f000000ae")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u8bbe\u8ba1\u7684\u6253\u56de\u6743\u9650\u3002", (String)"WordService_37", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        EpmClientLogHelper.writeChaptersById((OperationResult)((result = ChapterServiceHelper.setCommitStatus((long)modelId, (long)templateId, (long)chapterId, (String)status)).isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)(ChapterCommitStatusEnum.COMMIT.getType().equals(status) ? OperationName.COMMIT : OperationName.BACKED), (boolean)false, (Long)modelId, Collections.singletonList(chapterId), (long)templateId);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput setChapterEnableStatus(Map<String, Object> param) {
        ResultInfo result;
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        String status = StringUtils.getStringValue((Object)param.get("Status"));
        if ("1".equals(status)) {
            if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_webdesign", (String)"4730fc5d000000ac")) {
                return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u8bbe\u8ba1\u7684\u542f\u7528\u6743\u9650\u3002", (String)"WordService_38", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else if (!PermissionHelper.checkFunctionPermission((long)modelId, (String)"fidm_webdesign", (String)"47160c2b000000ac")) {
            return new EpmApiOutput(false, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62a5\u544a\u8bbe\u8ba1\u7684\u7981\u7528\u6743\u9650\u3002", (String)"WordService_39", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        EpmClientLogHelper.writeChaptersById((OperationResult)((result = ChapterServiceHelper.setEnableStatus((long)modelId, (long)templateId, (long)chapterId, (String)status)).isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)("1".equals(status) ? OperationName.ENABLE : OperationName.DISABLE), (boolean)false, (Long)modelId, Collections.singletonList(chapterId), (long)templateId);
        return ConvertUtil.toApiOutput((ResultInfo)result);
    }

    public EpmApiOutput saveNewChapter(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long templateId = LongUtil.toLong((Object)param.get("TemplateId"));
        long oldChapterId = LongUtil.toLong((Object)param.get("OldChapterId"));
        long catalogId = LongUtil.toLong((Object)param.get("CatalogId"));
        long permClassId = LongUtil.toLong((Object)param.get("PermClassId"));
        String operateType = StringUtils.getStringValue((Object)param.get("OperateType"));
        String number = StringUtils.getStringValue((Object)param.get("Number"));
        String name = StringUtils.getStringValue((Object)param.get("Name"));
        String description = StringUtils.getStringValue((Object)param.get("Description"));
        Chapter chapter = new Chapter();
        chapter.setName(name);
        chapter.setNumber(number);
        chapter.setTemplateId(templateId);
        switch (operateType) {
            case "1": {
                EpmApiOutput copyResult = EpmChapterServiceHelper.copyChapter((long)modelId, (long)templateId, (long)oldChapterId);
                EpmClientLogHelper.writeChapters((OperationResult)(copyResult.isSuccess() ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.COPY, (boolean)false, (Long)modelId, Collections.singletonList(chapter));
                return copyResult;
            }
            case "2": {
                EpmApiOutput saveToResResult = EpmChapterServiceHelper.saveChapterByRepository((long)modelId, (long)templateId, (long)oldChapterId, (String)number, (String)name, (long)permClassId, (String)description);
                EpmClientLogHelper.writeRepositoryChapters((OperationResult)(saveToResResult.isSuccess() ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.CREATE, (Long)modelId, Collections.singletonList(chapter));
                return saveToResResult;
            }
            case "3": {
                ChapterSaveInput input = new ChapterSaveInput();
                input.setDmModelId(Long.valueOf(modelId));
                input.setChapterId(Long.valueOf(oldChapterId));
                input.setOldChapterId(Long.valueOf(oldChapterId));
                input.setNumber(number);
                input.setName((Object)name);
                input.setCatalogId(Long.valueOf(catalogId));
                input.setPermClassId(Long.valueOf(permClassId));
                input.setDescription((Object)description);
                ResultInfo resultInfo = ChapterRepositoryHelper.saveAsRepositoryByEPM((ChapterSaveInput)input);
                EpmClientLogHelper.writeChaptersById((OperationResult)(resultInfo.isSuccess() != false ? OperationResult.SUCCESS : OperationResult.FAILURE), (OperationName)OperationName.SAVE_AS, (boolean)false, (Long)modelId, Collections.singletonList(oldChapterId), (long)0L);
                return ConvertUtil.toApiOutput((ResultInfo)resultInfo);
            }
        }
        return new EpmApiOutput(false, "OperateType not exists.");
    }

    public EpmApiOutput getChapterLock(Map<String, Object> param) {
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        boolean isPageLock = (Boolean)param.get("IsLocked");
        ArrayList tips = new ArrayList(2);
        String entityKey = reportId > 0L ? "fidm_webreport_edit" : "fidm_webdesign";
        int result = LockChapterHelper.lockChapter((String)entityKey, (String)StringUtils.getStringValue((Object)chapterId), (boolean)isPageLock, tips);
        if (result == 1) {
            return new EpmApiOutput(true, "");
        }
        if (tips.isEmpty()) {
            return new EpmApiOutput(false, "");
        }
        return new EpmApiOutput(false, (String)tips.get(0));
    }

    public EpmApiOutput releaseChapterLock(Map<String, Object> param) {
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        long chapterId = LongUtil.toLong((Object)param.get("ChapterId"));
        boolean isPageLock = (Boolean)param.get("IsLocked");
        String entityKey = reportId > 0L ? "fidm_webreport_edit" : "fidm_webdesign";
        LockChapterHelper.releaseChapter((String)entityKey, (String)StringUtils.getStringValue((Object)chapterId), (boolean)isPageLock);
        return new EpmApiOutput(true, "");
    }

    public EpmApiOutput batchReleaseChapterLocks(Map<String, Object> param) {
        Map templateChapterIds = (Map)param.get("TemplateChapterIds");
        Map reportChapterIds = (Map)param.get("ReportChapterIds");
        if (templateChapterIds != null && !templateChapterIds.isEmpty()) {
            for (Map.Entry entry : templateChapterIds.entrySet()) {
                LockChapterHelper.releaseChapter((String)"fidm_webdesign", (String)((String)entry.getKey()), (boolean)((Boolean)entry.getValue()));
            }
        }
        if (reportChapterIds != null && !reportChapterIds.isEmpty()) {
            for (Map.Entry entry : reportChapterIds.entrySet()) {
                LockChapterHelper.releaseChapter((String)"fidm_webreport_edit", (String)StringUtils.getStringValue(entry.getKey()), (boolean)((Boolean)entry.getValue()));
            }
        }
        return new EpmApiOutput(true, "");
    }

    public Map<String, Map<Integer, Set<Long>>> getDimMemberRights(Map<String, Object> param) {
        long fidmModelId = LongUtil.toLong((Object)param.get("modelId"));
        ModelInfo dmModel = new ModelStrategyEx(Long.valueOf(fidmModelId)).getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(dmModel.getModelType())) {
            return new HashMap<String, Map<Integer, Set<Long>>>(0);
        }
        HashMap<String, Map<Integer, Set<Long>>> result = new HashMap<String, Map<Integer, Set<Long>>>(6);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model_id", "=", (Object)dmModel.getModelId()));
        if (param.containsKey("dimensionNumber")) {
            qFilters.add(new QFilter("number", "=", param.get("dimensionNumber")));
        }
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number", (QFilter[])qFilters.toArray(new QFilter[0]));
        for (DynamicObject dim : dims) {
            HashMap<Integer, Set> memberPerms = new HashMap<Integer, Set>(2);
            BcmPermService bcmPermService = new BcmPermService(dmModel.getModelId(), Long.valueOf(dim.getLong("id")));
            BCMPerm perm = bcmPermService.getPerm();
            if (Objects.equals(PermEnum.NOPERM.getValue(), perm.getDefaultPerm())) {
                memberPerms.put(PermEnum.READONLY.getValue(), perm.getReadPermSets());
                memberPerms.put(PermEnum.READWRITE.getValue(), perm.getWritePermSets());
            } else {
                memberPerms.put(PermEnum.READONLY.getValue(), perm.getReadPermSets());
                memberPerms.put(PermEnum.NOPERM.getValue(), perm.getNoPermSets());
            }
            result.put(dim.getString("number"), memberPerms);
        }
        return result;
    }

    public EpmApiOutput calculateExcelFormula(Map<String, Object> param) {
        EpmApiOutput result = new EpmApiOutput();
        try {
            String formula = StringUtils.getStringValue((Object)param.get("Formula"));
            Object value = param.get("Value");
            result.setData((Object)VarHelper.calculate((String)formula, (Object)value, (boolean)true));
            result.setSuccess(true);
        }
        catch (KDBizException ex) {
            result.setMessage(ex.getMessage());
        }
        return result;
    }

    public EpmApiOutput hasWritePermission(Map<String, Object> param) {
        long modelId = LongUtil.toLong((Object)param.get("ModelId"));
        long id = LongUtil.toLong((Object)param.get("Id"));
        int type = Integer.parseInt(param.get("Type").toString());
        long reportId = LongUtil.toLong((Object)param.get("ReportId"));
        EpmApiOutput output = new EpmApiOutput();
        switch (type) {
            case 1: {
                output.setSuccess(TemplateCatalogHelper.hasWritePermission((long)modelId, (long)id));
                break;
            }
            case 2: {
                output.setSuccess(DisclosureTemplateHelper.hasWritePermission((long)modelId, (long)id));
                break;
            }
            case 3: {
                output.setSuccess(DisclosureReportHelper.hasWritePermission((long)modelId, (long)id));
                break;
            }
            case 4: {
                output.setSuccess(ChapterServiceHelper.hasWritePermissionForTempalte((long)modelId, (long)id));
                break;
            }
            case 5: {
                output.setSuccess(ChapterServiceHelper.hasWritePermissionForReport((long)modelId, (long)id, (long)reportId));
                break;
            }
            case 6: {
                output.setSuccess(ChapterCatalogHelper.hasWritePermission((long)modelId, (long)id));
                break;
            }
            case 7: {
                output.setSuccess(ChapterRepositoryHelper.hasWritePermission((long)modelId, (long)id, (long)0L));
                break;
            }
            case 8: {
                output.setSuccess(PermissionHelper.hasWritePerm((long)modelId, (String)"fidm_modulerepository", (long)id));
                break;
            }
        }
        return output;
    }
}

