/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.business.far.enums.DynamicControlSourceEnum;
import kd.epm.far.business.far.enums.MoudleLinkageEnum;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisSingleF7ServiceHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisExceptionHelper;

public class AbstractAnalysisPlugin
extends AbstractBaseDMFormPlugin
implements BeforeF7SelectListener,
UploadListener {
    protected static final String KEY_TEMPLATEDIMMAP = "KEY_TEMPLATEDIMMAP";
    protected static final String KEY_DIMF7MAP = "KEY_DIMF7MAP";
    protected static final String CTL_CUSTOMCONTROLAP = "customcontrolap";
    protected static final String CLOSEDCALLBACK_FILTER_VALUE = "singlememberf7";
    protected static final String CLOSEDCALLBACK_MULTI_FILTER_VALUE = "multimemberf7";
    protected static final String CALLBACKIMAGECLOSE = "imageclosecallback";
    protected static final String KEY_CUSTOM_OPERATION = "KEY_CUSTOM_OPERATION";
    private static final String EVENT_NAME = "eventName";
    private static final String CALL_BACK_SET_MAPPING = "setMapping";
    private static final String CALL_BACK_DATA_JOINT_SEARCH = "CALL_BACK_DATA_JOINT_SEARCH";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.resetAppId();
        if (Objects.nonNull(this.getDmModelId())) {
            this.initDimF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (Objects.nonNull(returnData)) {
            switch (actionId) {
                case "far_analysis_preview": {
                    this.previewCallBack(returnData);
                    break;
                }
                case "far_preview_config": {
                    Map returnInfo = (Map)ObjectSerialUtil.deSerializedBytes((String)String.valueOf(returnData));
                    String previewSource = (String)returnInfo.get("previewsource");
                    String previewResult = (String)returnInfo.get("previewresult");
                    if (DynamicControlSourceEnum.ICONPARAMETERS.getSourceName().equals(previewSource)) {
                        this.eventIndividualizedResult(previewResult);
                        break;
                    }
                    this.previewWithNoDeSerialized(previewResult, false);
                    break;
                }
                case "far_module_reportity_bak": {
                    this.moduleSaveCallBack();
                    break;
                }
                case "singlememberf7": 
                case "multimemberf7": {
                    this.dimMemberReturn(returnData);
                    break;
                }
                case "imageclosecallback": {
                    this.selectImageReturn(returnData);
                    break;
                }
                case "setMapping": {
                    JSONObject jsonObject = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_SAVE_MAP_MAPPING);
                    Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_SAVE_MAP_MAPPING, returnData, jsonObject.getString("id"));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractAnalysisPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    this.SendToVue(result);
                    break;
                }
                case "CALL_BACK_DATA_JOINT_SEARCH": {
                    Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_JOINT_SEARCH_CALLBACK, "", AnalysisDesignConstants.CallBackType.EVENT_DATA_JOINT_SEARCH.toString());
                    this.SendToVue(result);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        super.beforeF7Select(evt);
        switch (key = evt.getProperty().getName()) {
            case "singlememberf7": {
                Map f7DimMap;
                String dimKey;
                JSONObject jsonObject;
                AnalysisDesignConstants.CallBackType cB = AnalysisDesignConstants.CallBackType.EVENT_DIM_F7;
                if (!StringUtils.equals((CharSequence)this.getCustomF7KeyOperation(), (CharSequence)cB.toString())) {
                    cB = AnalysisDesignConstants.CallBackType.EVENT_DIM_PARAM_F7;
                }
                if (!Objects.nonNull(jsonObject = this.getCallBackType(cB)) || StringUtils.isEmpty((CharSequence)(dimKey = jsonObject.getJSONObject("dim").getString("number").toLowerCase())) || !Objects.nonNull((f7DimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_DIMF7MAP), Map.class)).get(dimKey))) break;
                Map templateDimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TEMPLATEDIMMAP), Map.class);
                Object scenario = f7DimMap.containsKey("scenario") ? f7DimMap.get("scenario") : null;
                AnalysisSingleF7ServiceHelper.beforeF7Select(evt, this.getSourceModelId(), templateDimMap, f7DimMap, scenario, dimKey);
            }
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        if (StringUtils.isEmpty((CharSequence)eventName)) {
            AbstractBaseFormPlugin.log.info("eventName is empty");
            return;
        }
        String eventArgs = evt.getEventArgs();
        try {
            AnalysisDesignConstants.CallBackType callBackType = AnalysisDesignConstants.CallBackType.valueOf(eventName);
            this.putCallBackType(callBackType, eventArgs);
            this.setCustomF7KeyOperation(eventName);
        }
        catch (Exception ex) {
            AbstractBaseFormPlugin.log.error((Throwable)ex);
            return;
        }
        if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_GETITEMID.toString())) {
            this.evGetItemId(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_COPY.toString())) {
            this.evCopy(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DS_F7.toString())) {
            this.evDSF7(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_SAVE.toString())) {
            this.evSave(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_VAR_ADD.toString())) {
            this.evVarAdd(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_VAR_DELETE.toString())) {
            this.evVarDelete(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_VAR_EDIT.toString())) {
            this.evVarEdit(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DS_ADD.toString())) {
            this.evDSAdd(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DS_DELETE.toString())) {
            this.evDSDelete(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DS_EDIT.toString())) {
            this.evDSEdit(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DS_FILTER.toString())) {
            this.evDSFilter(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_PREVIEW.toString())) {
            this.evPreview(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_INDIVIDUALIZED_SETTING.toString())) {
            this.evIndividualizedPreview(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_PREVIEW2.toString())) {
            this.evPreview2(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DIMPARAM_PREVIEW.toString())) {
            this.previewWithNoDeSerialized(eventArgs, false);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_MODULE_SAVE.toString())) {
            this.evSaveModule(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_MODULE_ADDITEM.toString())) {
            this.evModuleAddItem(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_SELECTIMAGE.toString())) {
            this.evSelectImage(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DIM_F7.toString())) {
            this.evDimF7(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DIM_PARAM_F7.toString())) {
            this.evDimF7(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.DATA_THEME_PAGE_REFRESH.toString())) {
            this.evRefreshThemePreview(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_THEME_SAVE.toString())) {
            this.evThemeSave(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_THEMATICANALYSIS.toString())) {
            this.evThematicAnalysis(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_ITEM_REFRESH.toString())) {
            this.evItemRefresh(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DATASET_VIEW.toString())) {
            this.evDatasetView(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DATASET_FORMULA.toString())) {
            this.evDatasetFormula(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_ITEM_LINKAGE.toString())) {
            this.evItemlinkage(eventArgs, eventName);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DRILL.toString())) {
            this.evItemNewDrilling(eventArgs, eventName);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DATA_JOINT_SEARCH.toString())) {
            this.evDataJointSearch(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_SAVE_MAP_MAPPING.toString())) {
            this.evOpenMappingPage(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DATAPOINT_FORMULA.toString())) {
            this.evDataPointFormula(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_ITEMS_REFRESH.toString())) {
            this.evItemsRefresh(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DOSEARCH.toString())) {
            this.doSearch(eventArgs);
        }
    }

    private void evOpenMappingPage(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        if (StringUtils.isBlank((Object)jsonObject.get((Object)"dimNumber"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f4d\u7f6e\u3002", (String)"AbstractAnalysisPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("far_map_mapping");
        fsp.setCustomParam("modelId", (Object)this.getDmModelId());
        fsp.setCustomParam("address", jsonObject.get((Object)"address"));
        fsp.setCustomParam("dimNumber", jsonObject.get((Object)"dimNumber"));
        fsp.setCustomParam("mapping", jsonObject.get((Object)"mapping"));
        fsp.setCustomParam("datasetId", jsonObject.get((Object)"datasetId"));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_SET_MAPPING));
        this.getView().showForm(fsp);
    }

    protected void evDataPointFormula(String eventArgs) {
    }

    private void evCopy(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray itemList = (JSONArray)jsonObject.get((Object)"itemList");
        HashMap idMap = Maps.newHashMapWithExpectedSize((int)itemList.size());
        itemList.forEach(item -> {
            JSONObject itemObj = (JSONObject)item;
            String id = String.valueOf(ID.genLongId());
            idMap.put(itemObj.get((Object)"id").toString(), id);
            itemObj.put("id", (Object)id);
            itemObj.put("name", (Object)(itemObj.get((Object)"name").toString() + "_copy"));
        });
        itemList.forEach(item -> {
            Object lineList;
            JSONObject itemObj = (JSONObject)item;
            if (LongUtil.isvalidLong((Object)itemObj.get((Object)"pid"))) {
                itemObj.put("pid", (Object)idMap.getOrDefault(itemObj.get((Object)"pid").toString(), itemObj.get((Object)"pid").toString()));
            }
            if ((lineList = AnalysisCommonOperateHelper.changeFieldByPath(itemObj, "c.lineList", "", true)) != null) {
                AnalysisCommonOperateHelper.copyDupontLine(lineList, idMap);
            }
        });
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_COPY_RESULT, itemList, null);
        this.SendToVue(result);
    }

    protected void evGetItemId(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String itemId = String.valueOf(ID.genLongId());
        JSONObject data = new JSONObject(2);
        data.fluentPut("type", (Object)jsonObject.getString("type"));
        data.fluentPut("itemId", (Object)itemId);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_GETITEMID_RESULT, data, jsonObject.getString("primaryKey"));
        this.SendToVue(result);
    }

    protected void evDSF7(String eventArgs) {
    }

    protected void evSave(String eventArgs) {
    }

    protected void evVarAdd(String eventArgs) {
    }

    protected void evVarDelete(String eventArgs) {
    }

    protected void evVarEdit(String eventArgs) {
    }

    protected void evDSAdd(String eventArgs) {
    }

    protected void evDSDelete(String eventArgs) {
    }

    protected void evDSEdit(String eventArgs) {
    }

    protected void evDSFilter(String eventArgs) {
    }

    protected void evPreview(String eventArgs) {
        this.previewDesign(this.getDmModelId(), eventArgs);
    }

    private void previewDesign(Long dmModelId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject queryConfig = jsonObject.getJSONObject("queryConfig");
        JSONArray dimList = queryConfig.getJSONArray("dimList");
        if (Objects.nonNull(dimList) && dimList.size() == 0) {
            this.previewWithNoDeSerialized(eventArgs, false);
        } else {
            String previewResult = AnalysisServiceHelper.getPreviwResult(jsonObject, true, eventArgs);
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)previewResult)) {
                this.previewCallBack(ObjectSerialUtil.toByteSerialized((Object)previewResult));
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("modelId", dmModelId);
                params.put("previewData", eventArgs);
                params.put("previewsource", DynamicControlSourceEnum.DESIGNANALYSIS.getSourceName());
                params.put("chapterId", jsonObject.get((Object)"chapterId"));
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("far_preview_config");
                formShowParameter.setCustomParams(params);
                formShowParameter.setParentPageId(this.getView().getPageId());
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "far_preview_config");
                formShowParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    protected void evPreview2(String eventArgs) {
        String previewResult = AnalysisServiceHelper.preview(this, this.getDmModelId(), this.getView().getPageId(), eventArgs, false);
        if (!StringUtils.isEmpty((CharSequence)previewResult)) {
            this.previewCallBack(ObjectSerialUtil.toByteSerialized((Object)previewResult));
        }
    }

    protected void doSearch(String eventArgs) {
        String previewResult = AnalysisServiceHelper.doSearch(eventArgs);
        JSONObject jsonObject = Objects.nonNull(eventArgs) ? JSONObject.parseObject((String)eventArgs) : new JSONObject();
        String compType = jsonObject.getString("compType");
        try {
            if ("emptydimmember".equals(previewResult)) {
                if (Objects.equals("Design", compType)) {
                    this.previewWithNoDeSerialized(eventArgs, false);
                } else {
                    this.evRefreshThemePreview(eventArgs);
                }
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)previewResult)) {
                if (Objects.equals("Design", compType)) {
                    this.previewCallBack(ObjectSerialUtil.toByteSerialized((Object)previewResult));
                } else {
                    this.evRefreshThemePreview(eventArgs);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u5f02\u5e38\u3002", (String)"AnalysisCalcHelper_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    protected void evIndividualizedPreview(String eventArgs) {
        String previewResult;
        Long dmModelId = this.getDMModelId();
        Long convertModelId = AnalysisServiceHelper.convertModelId(eventArgs);
        if (convertModelId != 0L) {
            dmModelId = convertModelId;
        }
        if (!StringUtils.isEmpty((CharSequence)(previewResult = AnalysisServiceHelper.openPreviewParamView(this, dmModelId, this.getView().getPageId(), eventArgs, DynamicControlSourceEnum.ICONPARAMETERS.getSourceName())))) {
            this.previewCallBack(ObjectSerialUtil.toByteSerialized((Object)previewResult));
        }
    }

    protected void evRefreshThemePreview(String eventArgs) {
        if (Objects.nonNull(eventArgs)) {
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            JSONArray itemList = jsonObject.getJSONArray("itemList");
            if (Objects.isNull(itemList)) {
                itemList = new JSONArray();
                JSONObject item = jsonObject.getJSONObject("item");
                if (Objects.nonNull(item)) {
                    itemList.add((Object)item);
                }
            }
            Object result = AnalysisDesignHelper.themePageRefreshPreviewResult(false, jsonObject.getJSONArray("itemList"), jsonObject.getJSONObject("pageConfig"), jsonObject.getJSONObject("queryConfig"), jsonObject.getJSONObject("i18n"));
            this.SendToVue(result);
        }
    }

    protected void evSaveModule(String eventArgs) {
    }

    protected void evSelectImage(String eventArgs) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("pkId", JSON.parseObject((String)eventArgs).get((Object)"itemId"));
        params.put("formId", this.getView().getFormShowParameter().getFormId());
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("far_analysisupploadimage");
        param.setStatus(OperationStatus.ADDNEW);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKIMAGECLOSE));
        param.setCustomParams(params);
        this.getView().showForm(param);
    }

    protected void evModuleAddItem(String eventArgs) {
    }

    protected void evDimF7(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject dimJsonObject = jsonObject.getJSONObject("dim");
        JSONArray dimListObject = jsonObject.getJSONArray("dimList");
        Long dimensionId = dimJsonObject.getLong("id");
        Long dimId = dimJsonObject.getLong("dimid");
        String datasetId = jsonObject.getString("datasetId");
        if (Objects.nonNull(dimId)) {
            dimensionId = dimId;
        }
        if (Objects.isNull(this.getPageCache().get(KEY_TEMPLATEDIMMAP))) {
            this.initDimF7();
        }
        Map templateDimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TEMPLATEDIMMAP), Map.class);
        LinkedHashMap<String, Long> dimF7Map = new LinkedHashMap<String, Long>(templateDimMap.size());
        if (Objects.nonNull(dimListObject) && dimListObject.size() > 0) {
            for (Object dimObject : dimListObject) {
                JSONObject dim = (JSONObject)dimObject;
                dimF7Map.put(dim.getString("number").toLowerCase(), dim.getLong("id"));
            }
        } else {
            dimF7Map.put(dimJsonObject.getString("number").toLowerCase(), dimJsonObject.getLong("id"));
        }
        this.getPageCache().put(KEY_DIMF7MAP, SerializationUtils.toJsonString(dimF7Map));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getSourceModelId());
        DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(false), (Long)dimensionId);
        String isDim = dimJsonObject.getString("isDim");
        if (Objects.equals(isDim, "1")) {
            modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, CLOSEDCALLBACK_FILTER_VALUE, this.getClass().getName(), true, datasetId);
        } else if (Objects.equals(isDim, "2")) {
            boolean isEb = DisModelTypeEnum.EB.getType().equals(modelStrategyEx.getModel().getModelInfo().getModelType());
            JSONArray members = dimJsonObject.getJSONArray("members");
            DynamicObject dataSet = DatasetDataReader.getDataSet((Long)LongUtil.toLong((Object)datasetId));
            String ebDatset = null;
            if (!Objects.equals(DataSetTypeEnum.MULTIPLE_VALUED.getType(), dataSet.getString("type"))) {
                DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)LongUtil.toLong((Object)datasetId));
                ebDatset = singleDS.getString("ebdataset");
            } else {
                ebDatset = isEb ? "default" : null;
            }
            modelStrategyEx.getDimensionF7().openComMultiF7WithClick(this.getView(), members, dimensionInfo, ebDatset, (BeforeF7SelectListener)this, CLOSEDCALLBACK_MULTI_FILTER_VALUE, this.getPluginName());
        }
    }

    protected void evThemeSave(String eventArgs) {
    }

    protected void evThematicAnalysis(String eventArgs) {
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String myAnaNumber = jsonObject.getString("number");
        if (StringUtils.isEmpty((CharSequence)myAnaNumber)) {
            return;
        }
        QFilter mqFilter = new QFilter("model", "=", (Object)this.getDmModelId());
        QFilter nqFilter = new QFilter("number", "=", (Object)myAnaNumber);
        DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((String)"far_themeanalysis", (String)"id, name, number", (QFilter[])new QFilter[]{mqFilter, nqFilter});
        if (Objects.isNull(templateDy)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u7684\u4e3b\u9898\u5206\u6790\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u94fe\u63a5\u662f\u5426\u6b63\u786e\u3002", (String)"AbstractAnalysisPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        long myAnalysisId = templateDy.getLong("id");
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = String.valueOf(myAnalysisId) + "far_themeanalysisview";
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
        customParams.put("themeAnalysisId", myAnalysisId);
        customParams.put("number", templateDy.getString("number"));
        customParams.put("fileName", templateDy.getString("name"));
        customParams.put("appId", this.getBizAppId());
        customParams.put("dmmodelid", this.getDMModelId());
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("far_themeanalysisview");
        formShowParameter.setCustomParams((Map)customParams);
        formShowParameter.setCaption(templateDy.getString("name"));
        formShowParameter.setPageId(pageId);
        String openStyle = jsonObject.getString("openStyle");
        if (StringUtils.equals((CharSequence)openStyle, (CharSequence)"newWindows")) {
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("800px");
            inlineStyleCss.setWidth("1100px");
            customParams.put("newWindows", "1");
            formShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else if (mainPageView.getView(pageId) == null) {
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parentView.showForm(formShowParameter);
            this.getView().sendFormAction(parentView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    protected void evItemlinkage(String eventArgs, String eventName) {
        String rotateSeriesNumber;
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        JSONObject eventArgsObj = JSON.parseObject((String)eventArgs);
        JSONObject item = eventArgsObj.getJSONObject("item");
        JSONObject request = item.getJSONObject("dataset").getJSONObject("request");
        String oldLegendNumber = request.getString("legendNumber");
        JSONArray drillingPath = this.getDrillingPath(item);
        if (Objects.isNull(drillingPath)) {
            drillingPath = new JSONArray();
        }
        boolean changeLegendNumber = false;
        if (Objects.nonNull(drillingPath) && drillingPath.size() > 0 && StringUtils.isNotEmpty((CharSequence)(rotateSeriesNumber = this.getRotateSeriesNumber(drillingPath)))) {
            changeLegendNumber = true;
            request.put("legendNumber", (Object)rotateSeriesNumber);
            eventArgs = JSONObject.toJSONString((Object)eventArgsObj);
        }
        Map<String, String> availableDimsForDrilling = this.getAvailableDims(drillingPath);
        Map availableDimsForLinkage = (Map)eventArgsObj.getJSONObject("item").getJSONObject("c").getJSONObject("config").getJSONObject("compLinkage").getObject("dimMap", Map.class);
        JSONObject data = new JSONObject(2);
        JSONObject itemResult = AnalysisServiceHelper.moduleCalcute(this.getDmModelId(), eventArgs, new AnalysisDataHandler(MoudleLinkageEnum.LINKAGE, availableDimsForLinkage, availableDimsForDrilling));
        data.fluentPut("item", (Object)itemResult);
        JSONObject requestResult = itemResult.getJSONObject("dataset").getJSONObject("request");
        if (Objects.nonNull(requestResult) && changeLegendNumber) {
            requestResult.put("legendNumber", (Object)oldLegendNumber);
        }
        Object propsDataResult = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ITEM_REFRESH_RESULT, data, itemResult.getString("id"));
        JSONObject result = (JSONObject)JSON.toJSON((Object)propsDataResult);
        result.put(EVENT_NAME, (Object)eventName);
        this.SendToVue(result);
    }

    protected void evItemNewDrilling(String eventArgs, String eventName) {
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject item = jsonObject.getJSONObject("item");
        JSONObject dataset = item.getJSONObject("dataset");
        JSONObject request = dataset.getJSONObject("request");
        String oldLegendNumber = request.getString("legendNumber");
        JSONArray drillingPath = this.getDrillingPath(item);
        if (Objects.isNull(drillingPath)) {
            drillingPath = new JSONArray();
        }
        JSONObject data = new JSONObject(2);
        if (drillingPath.size() > 0) {
            String rotateSeriesNumber;
            JSONObject pathItemObj = drillingPath.getJSONObject(drillingPath.size() - 1);
            String drillType = pathItemObj.getString("type");
            String dimNumber = pathItemObj.getString("dimNumber");
            String seriesNumber = pathItemObj.getString("seriesNumber");
            if (StringUtils.equals((CharSequence)drillType, (CharSequence)"next_direct") && StringUtils.isNotEmpty((CharSequence)dimNumber) && StringUtils.isNotEmpty((CharSequence)seriesNumber)) {
                String dataSrcType = dataset.getString("dataSrcType");
                long dataSrcId = DataSrcTypeEnum.CURRENT_MODEL.getFormId().equals(dataSrcType) ? this.getDmModelId() : DatasetServiceHelper.getDataSrcIdByDatasetOfSingleDS((long)dataset.getLong("id"));
                BCMMemberTreeNode memberByNumber = BCMMemberReader.findMemberByNumber((String)BCMMemberReader.findModelNumberById((Object)dataSrcId), (String)dimNumber, (String)seriesNumber);
                if (memberByNumber != null && memberByNumber.isLeaf()) {
                    drillingPath.remove(drillingPath.size() - 1);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(rotateSeriesNumber = this.getRotateSeriesNumber(drillingPath)))) {
                request.put("legendNumber", (Object)rotateSeriesNumber);
            }
            eventArgs = JSONObject.toJSONString((Object)jsonObject);
            Map<String, String> availableDims = this.getAvailableDims(drillingPath);
            JSONObject itemResult = AnalysisServiceHelper.moduleCalcute(this.getDmModelId(), eventArgs, new AnalysisDataHandler(MoudleLinkageEnum.DRILLING, availableDims));
            data.fluentPut("item", (Object)itemResult);
            JSONObject requestResult = itemResult.getJSONObject("dataset").getJSONObject("request");
            if (Objects.nonNull(requestResult)) {
                requestResult.put("legendNumber", (Object)oldLegendNumber);
            }
            Object propsDataResult = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ITEM_REFRESH_RESULT, data, jsonObject.getString("primaryKey"));
            JSONObject result = (JSONObject)JSON.toJSON((Object)propsDataResult);
            result.put(EVENT_NAME, (Object)eventName);
            this.SendToVue(result);
        }
    }

    private JSONArray getDrillingPath(JSONObject item) {
        JSONArray jsonArray = new JSONArray();
        try {
            jsonArray = item.getJSONObject("c").getJSONObject("config").getJSONObject("dataDrillingDown").getJSONArray("path");
        }
        catch (Exception e) {
            jsonArray = new JSONArray();
        }
        return jsonArray;
    }

    private String getRotateSeriesNumber(JSONArray pathArray) {
        String seriesNumber = "";
        for (int i = pathArray.size() - 1; i >= 0; --i) {
            JSONObject pathItemObj = (JSONObject)pathArray.get(i);
            String drillType = pathItemObj.getString("type");
            if (!StringUtils.equals((CharSequence)drillType, (CharSequence)"next_rotate")) continue;
            seriesNumber = pathItemObj.getString("dimNumber");
            break;
        }
        return seriesNumber;
    }

    private Map<String, String> getAvailableDims(JSONArray pathArray) {
        HashMap availableDims = Maps.newHashMapWithExpectedSize((int)pathArray.size());
        for (int i = pathArray.size() - 1; i >= 0; --i) {
            String dimNumber;
            JSONObject pathItemObj = (JSONObject)pathArray.get(i);
            String drillType = pathItemObj.getString("type");
            if (!StringUtils.equals((CharSequence)drillType, (CharSequence)"next_direct") || !Objects.nonNull(dimNumber = pathItemObj.getString("dimNumber")) || availableDims.containsKey(dimNumber)) continue;
            availableDims.put(dimNumber, pathItemObj.getString("seriesNumber"));
        }
        return availableDims;
    }

    protected void evDataJointSearch(String eventArgs) {
        long datasetId;
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        JSONObject eventJson = JSON.parseObject((String)eventArgs);
        JSONObject item = eventJson.getJSONObject("item");
        try {
            datasetId = item.getJSONObject("dataset").getLong("id");
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u53d6\u6570id\u5f02\u5e38\u3002", (String)"AbstractAnalysisPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        DatasetServiceHelper.openPreviewPageWithoutPopup((IFormView)this.getView(), (IFormPlugin)this, (long)this.getModelId(), (long)datasetId, (JSONObject)eventJson);
    }

    protected void evItemRefreshAndSave(String eventArgs) {
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject itemResult = AnalysisServiceHelper.moduleCalcute(this.getDmModelId(), eventArgs, null);
        JSONObject data = new JSONObject(2);
        data.fluentPut("item", (Object)itemResult);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ITEM_REFRESH_RESULT, data, jsonObject.getString("primaryKey"));
        this.SendToVue(result);
    }

    protected void evItemRefresh(String eventArgs) {
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject itemResult = AnalysisServiceHelper.moduleCalcute(this.getDmModelId(), eventArgs, null);
        JSONObject data = new JSONObject(2);
        data.fluentPut("item", (Object)itemResult);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ITEM_REFRESH_RESULT, data, jsonObject.getString("primaryKey"));
        this.SendToVue(result);
    }

    protected void evDatasetView(String eventArgs) {
    }

    protected void evDatasetFormula(String eventArgs) {
    }

    protected void SendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    protected void putCallBackType(AnalysisDesignConstants.CallBackType callBackType, String value) {
        this.getPageCache().put("KEY_" + callBackType.toString(), value);
    }

    protected JSONObject getCallBackType(AnalysisDesignConstants.CallBackType callBackType) {
        String data = this.getPageCache().get("KEY_" + callBackType.toString());
        if (!StringUtils.isEmpty((CharSequence)data)) {
            return JSON.parseObject((String)data);
        }
        return null;
    }

    protected String getCallBackPrimaryKey(AnalysisDesignConstants.CallBackType callBackType) {
        String result = "";
        JSONObject jsonObject = this.getCallBackType(callBackType);
        if (Objects.nonNull(jsonObject) && StringUtils.isEmpty((CharSequence)(result = jsonObject.getString("primaryKey")))) {
            result = "";
        }
        return result;
    }

    protected Long getDmModelId() {
        return this.getDMModelId();
    }

    protected void initDimF7() {
        if (this.getDmModelId() <= 0L) {
            return;
        }
        Map<String, Set<Long>> templateDimMap = AnalysisSingleF7ServiceHelper.getDimDataMap(this.getDmModelId(), this.getSourceModelId(), null);
        LinkedHashMap<String, Long> dimF7Map = new LinkedHashMap<String, Long>(templateDimMap.size());
        for (Map.Entry<String, Set<Long>> entry : templateDimMap.entrySet()) {
            String dimKey = entry.getKey();
            String[] splitDimKey = dimKey.split("/");
            Long dimensionId = LongUtil.toLong((Object)splitDimKey[0]);
            String dimNumber = splitDimKey[1];
            dimF7Map.put(dimNumber.toLowerCase(), dimensionId);
        }
        this.getPageCache().put(KEY_DIMF7MAP, SerializationUtils.toJsonString(dimF7Map));
        this.getPageCache().put(KEY_TEMPLATEDIMMAP, SerializationUtils.toJsonString(templateDimMap));
    }

    protected boolean previewCallBack(Object returnData) {
        return this.previewCallBack(returnData, false);
    }

    protected boolean previewCallBack(Object returnData, boolean isDesignMode) {
        if (Objects.isNull(returnData)) {
            return false;
        }
        String eventArgs = (String)this.deSerializedBytes((String)returnData);
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        Object result = AnalysisDesignHelper.dataPreviewResult(isDesignMode, jsonObject.getJSONArray("itemList"), jsonObject.getJSONObject("pageConfig"), jsonObject.getJSONObject("queryConfig"), jsonObject.getJSONObject("i18n"), jsonObject.getLong("chapterId"));
        this.SendToVue(result);
        return true;
    }

    protected void moduleSaveCallBack() {
        List moduleList = ModuleServiceHelper.getModuleList((Long)this.getDmModelId());
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_MODULE_REFRESH, moduleList, this.getCallBackPrimaryKey(AnalysisDesignConstants.CallBackType.EVENT_MODULE_SAVE));
        this.SendToVue(result);
    }

    protected void previewWithNoDeSerialized(String eventArgs, boolean isDesignMode) {
        if (Objects.nonNull(eventArgs)) {
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            JSONArray itemList = jsonObject.getJSONArray("itemList");
            if (Objects.isNull(itemList)) {
                itemList = new JSONArray();
                JSONObject item = jsonObject.getJSONObject("item");
                if (Objects.nonNull(item)) {
                    itemList.add((Object)item);
                }
            }
            Object result = AnalysisDesignHelper.dataPreviewResult(isDesignMode, itemList, jsonObject.getJSONObject("pageConfig"), jsonObject.getJSONObject("queryConfig"), jsonObject.getJSONObject("i18n"), jsonObject.getLong("chapterId"));
            this.SendToVue(result);
        }
    }

    protected void eventIndividualizedResult(String previewData) {
        if (Objects.isNull(previewData)) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)previewData);
        JSONObject data = new JSONObject(2);
        JSONObject item = jsonObject.getJSONObject("item");
        data.fluentPut("item", (Object)item);
        Object result = AnalysisDesignHelper.paramPreviewResult(false, data, jsonObject.getJSONObject("pageConfig"), jsonObject.getJSONObject("queryConfig"), jsonObject.getJSONObject("i18n"), jsonObject.getString("primaryKey"));
        this.SendToVue(result);
    }

    protected boolean dimMemberReturn(Object returnData) {
        if (Objects.isNull(returnData)) {
            return false;
        }
        if (returnData instanceof DynamicObject) {
            return this.singleSelectReturn((DynamicObject)returnData);
        }
        if (returnData instanceof Collection) {
            return this.multiSelectReturn((Collection)returnData);
        }
        return false;
    }

    protected boolean multiSelectReturn(Collection returnData) {
        JSONObject jsonObject;
        AnalysisDesignConstants.CallBackType cB = AnalysisDesignConstants.CallBackType.EVENT_DIM_F7;
        AnalysisDesignConstants.PropsDataType cR = AnalysisDesignConstants.PropsDataType.DATA_DIM_F7_RESULT;
        if (!StringUtils.equals((CharSequence)this.getCustomF7KeyOperation(), (CharSequence)cB.toString())) {
            cB = AnalysisDesignConstants.CallBackType.EVENT_DIM_PARAM_F7;
            cR = AnalysisDesignConstants.PropsDataType.EVENT_DIM_PARAM_F7_RESULT;
        }
        if (Objects.isNull(jsonObject = this.getCallBackType(cB))) {
            return false;
        }
        String dimKey = jsonObject.getJSONObject("dim").getString("number");
        JSONArray members = new JSONArray(returnData.size());
        for (Object member : returnData) {
            HashMap<String, String> memberMap;
            if (member instanceof ListSelectedRow) {
                ListSelectedRow memberRow = (ListSelectedRow)member;
                memberMap = new HashMap<String, String>(3);
                memberMap.put("id", String.valueOf(memberRow.getPrimaryKeyValue()));
                memberMap.put("number", memberRow.getNumber());
                memberMap.put("name", memberRow.getName());
                members.add(memberMap);
                continue;
            }
            if (!(member instanceof DynamicObject)) continue;
            DynamicObject memberDy = (DynamicObject)member;
            memberMap = new HashMap(3);
            memberMap.put("id", memberDy.getString(4));
            memberMap.put("number", memberDy.getString(2));
            memberMap.put("name", memberDy.getString(3));
            members.add(memberMap);
        }
        JSONObject data = new JSONObject(2);
        data.fluentPut("dimNumber", (Object)dimKey);
        data.fluentPut("members", (Object)members);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)cR, data, jsonObject.getString("primaryKey"));
        this.SendToVue(result);
        return true;
    }

    protected boolean singleSelectReturn(DynamicObject returnData) {
        JSONObject jsonObject;
        AnalysisDesignConstants.CallBackType cB = AnalysisDesignConstants.CallBackType.EVENT_DIM_F7;
        AnalysisDesignConstants.PropsDataType cR = AnalysisDesignConstants.PropsDataType.DATA_DIM_F7_RESULT;
        if (!StringUtils.equals((CharSequence)this.getCustomF7KeyOperation(), (CharSequence)cB.toString())) {
            cB = AnalysisDesignConstants.CallBackType.EVENT_DIM_PARAM_F7;
            cR = AnalysisDesignConstants.PropsDataType.EVENT_DIM_PARAM_F7_RESULT;
        }
        if (Objects.nonNull(jsonObject = this.getCallBackType(cB))) {
            String dimKey = jsonObject.getJSONObject("dim").getString("number");
            HashMap<String, String> memberMap = new HashMap<String, String>(3);
            memberMap.put("id", returnData.getString("id"));
            memberMap.put("name", returnData.getString("name"));
            if (jsonObject.getString("primaryKey").startsWith("variable") || jsonObject.getString("primaryKey").startsWith("dimvarparamf7") || jsonObject.getString("primaryKey").equals("queryComp") && Objects.isNull(jsonObject.getJSONObject("dim").getString("isDim"))) {
                JSONObject dimObject = jsonObject.getJSONObject("dim");
                String dimShortNum = dimObject.getString("shortNumber");
                if (Objects.isNull(dimShortNum)) {
                    dimShortNum = dimObject.getString("dimShortNumber");
                }
                memberMap.put("number", dimShortNum + "." + returnData.getString("number"));
            } else {
                memberMap.put("number", returnData.getString("number"));
            }
            JSONObject data = new JSONObject(2);
            data.fluentPut("dimNumber", (Object)dimKey);
            data.fluentPut("member", memberMap);
            Object result = AnalysisDesignHelper.getPropsDataResult((Object)cR, data, jsonObject.getString("primaryKey"));
            this.SendToVue(result);
            return true;
        }
        return false;
    }

    private String getCustomF7KeyOperation() {
        return this.getView().getPageCache().get(KEY_CUSTOM_OPERATION);
    }

    private void setCustomF7KeyOperation(String customKey) {
        this.getView().getPageCache().put(KEY_CUSTOM_OPERATION, customKey);
    }

    protected boolean selectImageReturn(Object returnData) {
        if (Objects.isNull(returnData)) {
            return false;
        }
        Map uploaDataMap = (Map)this.deSerializedBytes((String)returnData);
        if (uploaDataMap.isEmpty()) {
            return false;
        }
        JSONObject jsonObject = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_SELECTIMAGE);
        if (Objects.nonNull(jsonObject)) {
            JSONObject data = new JSONObject(2);
            data.fluentPut("url", uploaDataMap.get("url"));
            data.fluentPut("itemId", (Object)jsonObject.getString("itemId"));
            Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_SELECTIMAGE_RESULT, data, this.getCallBackPrimaryKey(AnalysisDesignConstants.CallBackType.EVENT_SELECTIMAGE));
            this.SendToVue(result);
        }
        return false;
    }

    protected void evItemsRefresh(String eventArgs) {
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        JSONArray itemList = new JSONArray();
        JSONObject eventArgsObj = JSON.parseObject((String)eventArgs);
        String primaryKey = eventArgsObj.getString("primaryKey");
        JSONArray itemArr = eventArgsObj.getJSONArray("item");
        for (Object o : itemArr) {
            eventArgsObj.put("item", o);
            String eventArgsStr = JSON.toJSONString((Object)eventArgsObj);
            JSONObject itemResult = AnalysisServiceHelper.moduleCalcute(this.getDmModelId(), eventArgsStr, null);
            itemList.add((Object)itemResult);
        }
        JSONObject data = new JSONObject(2);
        data.fluentPut("item", (Object)itemList);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ITEM_REFRESH_RESULT, data, primaryKey);
        this.SendToVue(result);
    }

    protected void resetAppId() {
        this.getView().getFormShowParameter().setAppId((String)this.getView().getFormShowParameter().getCustomParam("appId"));
    }

    protected void dataError(Throwable ex) {
        String title = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25", (String)"AbstractAnalysisPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]);
        AbstractBaseFormPlugin.log.error(title, ex);
        String errorMsg = AnalysisExceptionHelper.buildExceptionMsg(title, ex, 30);
        this.dataError(errorMsg);
    }

    protected void dataError(String errorMsg) {
        HashMap data = new HashMap(2);
        HashMap<String, String> error = new HashMap<String, String>(2);
        error.put("msg", errorMsg);
        data.put("error", error);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ERROR, data, "");
        this.SendToVue(result);
    }
}

