/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.perm.permclass.PermClassCache;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.AppUtils;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;

public class AbstractDesignTreePlugin
extends AbstractBaseDMListPlugin {
    public static final String TEMPLATECATALOG = "templatecatalog";
    protected static final String MODEL = "model";
    protected static final String FI_BCM_FORMPLUGIN = "epm-far-formplugin";
    protected static final String READONLYLIST = "readonlylist";
    protected static final String NODEPERM = "nodeperm";
    protected static final String ISTEMPLATEONLYREAD = "template";
    protected Set<String> permControlButton = new HashSet<String>(Arrays.asList("btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down"));

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refrushTree();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addListeners();
    }

    protected void addListeners() {
        this.addClickListeners("btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down");
        TreeView tview = (TreeView)this.getControl(TEMPLATECATALOG);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                AbstractDesignTreePlugin.this.getPageCache().put("focusnodeid", evt.getNodeId().toString());
                AbstractDesignTreePlugin.this.getPageCache().put("parent", evt.getParentNodeId().toString());
                if (AbstractDesignTreePlugin.this.isNodeReadOnly(evt.getNodeId().toString())) {
                    AbstractDesignTreePlugin.this.getPageCache().put(AbstractDesignTreePlugin.NODEPERM, "2");
                    AbstractDesignTreePlugin.this.getPageCache().put(AbstractDesignTreePlugin.ISTEMPLATEONLYREAD, "true");
                    AbstractDesignTreePlugin.this.setButtonEnable(Boolean.FALSE, Boolean.TRUE);
                } else {
                    AbstractDesignTreePlugin.this.getPageCache().put(AbstractDesignTreePlugin.NODEPERM, "3");
                    AbstractDesignTreePlugin.this.getPageCache().put(AbstractDesignTreePlugin.ISTEMPLATEONLYREAD, "false");
                    AbstractDesignTreePlugin.this.setButtonEnable(Boolean.TRUE, Boolean.TRUE);
                }
                AbstractDesignTreePlugin.this.refrushBillList();
            }
        });
    }

    protected void refrushBillList() {
    }

    protected void setButtonEnable(Boolean status, Boolean isTreeNode) {
        if (isTreeNode.booleanValue()) {
            this.getView().setEnable(status, new String[]{"bar_add", "bar_copy", "bar_delete", "bar_enable", "bar_disable"});
        } else {
            this.getView().setEnable(status, new String[]{"bar_copy", "bar_delete", "bar_enable", "bar_disable"});
        }
    }

    protected void initTree() {
        TreeNode templatecatalog = new TreeNode();
        String nodeid = this.getPageCache().get("focusnodeid");
        String algoKey = this.getClass().getName();
        String modelID = this.getPageCache().get("dmmodelid");
        String entityName = this.getTemplateCataLogEntryEntity();
        String selectFields = this.getSelectFields();
        QFilter fmodelid = new QFilter(MODEL, "=", (Object)this.getDMModelId());
        QFilter ftype = this.getCatalogtypeQFilter();
        QFilter[] filters = new QFilter[]{fmodelid, ftype};
        String orderBys = "sequence";
        String headid = "";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        PermClassCache.cachePermission((IPageCache)this.getPageCache(), (String)entityName, (String)modelID);
        List<Long> noPerms = this.getNoPermIds(entityName, this.getDMModelId(), RequestContext.get().getUserId());
        ArrayList treeList = new ArrayList(16);
        this.getPageCache().remove("focusnodeid");
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                if (noPerms.contains(task.getLong("id"))) continue;
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", (String)task.get("number"));
                memberMap.put("name", (String)task.get("name"));
                memberMap.put("parentid", task.get("parent").toString());
                treeList.add(memberMap);
                if (!"0".equals(task.get("parent").toString())) continue;
                headid = task.get("id").toString();
                templatecatalog.setId(headid);
                this.getPageCache().put("focusnodeid", headid);
                this.getPageCache().put("headnodeid", headid);
            }
        }
        templatecatalog.setParentid("");
        templatecatalog.setText(this.getRootName());
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNode((TreeNode)templatecatalog, treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)templatecatalog);
        if (StringUtils.isEmpty((String)templatecatalog.getId())) {
            return;
        }
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        tree.addNode(templatecatalog);
        TreeNode fo = this.findFocusNodeById(nodeid, templatecatalog);
        if (fo == null) {
            fo = templatecatalog;
        } else {
            this.getPageCache().put("focusnodeid", fo.getId());
        }
        tree.focusNode(fo);
    }

    protected String getRootName() {
        return DiscTemplateCatalogTypeEnum.getCatalogByAppId((String)this.getBizAppId()).getName();
    }

    protected QFilter getCatalogtypeQFilter() {
        return DiscTemplateCatalogTypeEnum.getCatalogTypeQfByAppId((String)this.getBizAppId());
    }

    protected String getSelectFields() {
        return "id,name,number,parent,catalogtype";
    }

    private List<Long> getNoPermIds(String entityName, Long modelId, String userId) {
        ArrayList<Long> noPerms = new ArrayList<Long>();
        if (this.isFIDM()) {
            noPerms.addAll(PermClassEntityHelper.getDiscPermissionMap((String)entityName, (Long)modelId, (Long)LongUtil.toLong((Object)userId), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"1"));
        } else {
            noPerms.addAll(PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)DataTypeEnum.NO.getIndex()));
        }
        return noPerms;
    }

    private List<Long> getReadOnlyCataLogIds(String entityName, Long modelId, String userId) {
        ArrayList<Long> readOnlyPerms = new ArrayList<Long>();
        readOnlyPerms.addAll(PermClassEntityHelper.getDiscPermissionMap((String)entityName, (Long)modelId, (Long)LongUtil.toLong((Object)userId), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"2"));
        return readOnlyPerms;
    }

    private TreeNode findFocusNodeById(String id, TreeNode tree) {
        if (StringUtils.isEmpty((String)id) || tree == null) {
            return null;
        }
        if (id.equals(tree.getId())) {
            return tree;
        }
        if (tree.getChildren() != null) {
            for (TreeNode c : tree.getChildren()) {
                TreeNode fc = this.findFocusNodeById(id, c);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    protected List<String> queryAllChildNodeList(String nodeid, List<Map<String, String>> treeList, List<String> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get("parentid").equals(nodeid)) continue;
            allnodelist.add(m.get("id"));
            this.queryAllChildNodeList(m.get("id"), treeList, allnodelist);
        }
        return allnodelist;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (!this.validator()) {
            return;
        }
        String nodeId = this.getPageCache().get("focusnodeid");
        if (StringUtils.isEmpty((String)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6a21\u677f\u5206\u7c7b\u6811\u8282\u70b9\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractTemplateTreePlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.permControlButton.contains(c.getKey().toLowerCase(Locale.ENGLISH)) && this.isNodeReadOnly(nodeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"DiscTemplateListPlugin_18", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addnew": {
                this.newTemplateCatalog(nodeId, true);
                break;
            }
            case "btn_delete": {
                if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"AbstractTemplateTreePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (AppUtils.isFidmReport((String)this.getBizAppId())) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u5220\u6a21\u677f\u5206\u7c7b\u4e0b\u7684\u6a21\u677f\u5c06\u4f1a\u88ab\u79fb\u52a8\u5230\u5176\u76f4\u63a5\u4e0a\u7ea7\u6a21\u677f\u5206\u7c7b\u4e0a\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AbstractTemplateTreePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletecatalog_comfirm", (IFormPlugin)this));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u5220\u7ee9\u6548\u5206\u6790\u5206\u7c7b\u4e0b\u7684\u5206\u6790\u8bbe\u8ba1\u5c06\u4f1a\u88ab\u79fb\u52a8\u5230\u5176\u76f4\u63a5\u4e0a\u7ea7\u7ee9\u6548\u5206\u6790\u5206\u7c7b\u4e0a\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AbstractTemplateTreePlugin_17", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletecatalog_comfirm", (IFormPlugin)this));
                break;
            }
            case "btn_modify": {
                if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u7f16\u8f91\u3002", (String)"AbstractTemplateTreePlugin_20", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.newTemplateCatalog(nodeId, false);
                break;
            }
            case "btn_up": 
            case "btn_down": {
                if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u79fb\u52a8\u3002", (String)"AbstractTemplateTreePlugin_21", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.downAndUpMember(c.getKey().toLowerCase(Locale.ENGLISH));
                break;
            }
        }
    }

    protected boolean isNodeReadOnly(String nodeId) {
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
        Iterator iterator = treeList.iterator();
        String parentNodeId = "";
        HashMap<String, String> node = new HashMap<String, String>(4);
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            if (!((String)next.get("id")).equals(nodeId)) continue;
            parentNodeId = (String)next.get("parentid");
            node.putAll(next);
            break;
        }
        ArrayList<Long> readOnlyIds = new ArrayList<Long>(16);
        if (this.getPageCache().get(READONLYLIST) == null) {
            readOnlyIds.addAll(this.getReadOnlyCataLogIds(this.getTemplateCataLogEntryEntity(), this.getDMModelId(), String.valueOf(this.getUserId())));
            this.getPageCache().put(READONLYLIST, SerializationUtils.toJsonString(readOnlyIds));
        } else {
            readOnlyIds.addAll((Collection)SerializationUtils.fromJsonString((String)this.getPageCache().get(READONLYLIST), List.class));
        }
        if (readOnlyIds.contains(LongUtil.toLong((Object)nodeId))) {
            return true;
        }
        return this.hasOnlyReadParentNode(treeList, node, readOnlyIds);
    }

    private boolean hasOnlyReadParentNode(List<Map<String, String>> treeList, Map<String, String> node, List<Long> readOnlyIds) {
        for (Map<String, String> next : treeList) {
            String parentNodeId = node.get("parentid");
            String nextId = next.get("id");
            if (!Objects.nonNull(parentNodeId) || !Objects.nonNull(nextId) || !parentNodeId.equals(nextId)) continue;
            if (readOnlyIds.contains(LongUtil.toLong((Object)nextId))) {
                return true;
            }
            return this.hasOnlyReadParentNode(treeList, next, readOnlyIds);
        }
        return false;
    }

    protected void downAndUpMember(String key) {
        TreeView treeView = (TreeView)this.getView().getControl(TEMPLATECATALOG);
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodeIds = treeState.getSelectedNodeId();
        if (selectNodeIds == null || selectNodeIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u5206\u7c7b\u3002", (String)"AbstractTemplateTreePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String selectedNodeId = (String)selectNodeIds.get(selectNodeIds.size() - 1);
        try {
            if ("btn_up".equals(key)) {
                this.checkCatalogSeq(selectedNodeId);
                this.moveCatelogUp(selectedNodeId, this.getTemplateCataLogEntryEntity());
            } else if ("btn_down".equals(key)) {
                this.checkCatalogSeq(selectedNodeId);
                this.moveCatalogDown(selectedNodeId, this.getTemplateCataLogEntryEntity());
            }
        }
        catch (Exception e) {
            DynamicObject dyTree = BusinessDataReader.loadSingle((Object)Long.parseLong(selectedNodeId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getTemplateCataLogEntryEntity()));
            OperationName operationName = "btn_up".equals(key) ? OperationName.CATALOG_MOVE_UP : OperationName.CATALOG_MOVE_DOWN;
            this.writeOpLog(OperationResult.FAILURE, operationName, dyTree);
            throw e;
        }
    }

    protected void checkCatalogSeq(String selectNodeId) {
        String parentId = this.queryParentId(selectNodeId, this.getTemplateCataLogEntryEntity());
        this.dealChildSeq(parentId);
    }

    protected void moveCatelogUp(String id, String formId) {
        DynamicObject dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        if (seq == 1) {
            if (AppUtils.isFidmReport((String)this.getBizAppId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ee9\u6548\u5206\u6790\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else {
            QFilter qf1 = new QFilter("sequence", "<", (Object)dyTree.getInt("sequence"));
            String parentId = this.queryParentId(id, formId);
            QFilter filter = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
            QFilter[] filters = new QFilter[]{qf1, filter};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence desc", (int)1);
            if (seq != 0) {
                if (dcs != null && dcs.size() > 0) {
                    DynamicObject dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                    int seq2 = dyTree2.getInt("sequence");
                    dyTree2.set("sequence", (Object)seq);
                    dyTree.set("sequence", (Object)seq2);
                    SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                    ((TreeView)this.getControl(TEMPLATECATALOG)).deleteAllNodes();
                    this.initTree();
                    TreeNode node = new TreeNode(parentId, id, dyTree.getString("name"));
                    ((TreeView)this.getControl(TEMPLATECATALOG)).focusNode(node);
                    this.writeOpLog(OperationResult.SUCCESS, OperationName.CATALOG_MOVE_UP, dyTree);
                } else if (AppUtils.isFidmReport((String)this.getBizAppId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ee9\u6548\u5206\u6790\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateTreePlugin_15", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
        }
    }

    protected String queryParentId(String id, String entityId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)id))};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityId, (String)"parent", (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getString("parent");
        }
        return "";
    }

    protected void dealChildSeq(String parentId) {
        QFilter parent = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.getTemplateCataLogEntryEntity(), (String)"id,sequence", (QFilter[])filters, (String)"longnumber");
        if (dcs != null && dcs.size() > 0) {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(16);
            ArrayList<Long> arrayList = new ArrayList<Long>(16);
            for (DynamicObject dy : dcs) {
                Long id = dy.getLong("id");
                arrayList.add(id);
                map.put(id, dy.getInt("sequence"));
            }
            if (map.values().contains(0)) {
                DynamicObject dyCatelog = BusinessDataServiceHelper.newDynamicObject((String)this.getTemplateCataLogEntryEntity());
                Object[] dyDealSeq = (DynamicObject[])BusinessDataReader.load((Object[])arrayList.toArray(), (IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyCatelog.getDynamicObjectType().getName()));
                for (int i = 0; i < dyDealSeq.length; ++i) {
                    dyDealSeq[i].set("sequence", (Object)(i + 1));
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyCatelog.getDynamicObjectType().getName()), (Object[])dyDealSeq);
            }
        }
    }

    protected int getDSeq(long id, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"sequence", (QFilter[])filters, (String)"sequence");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getInt("sequence");
        }
        return 1;
    }

    protected void moveCatalogDown(String id, String formId) {
        DynamicObject dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        QFilter qf1 = new QFilter("sequence", ">", (Object)dyTree.getInt("sequence"));
        String parentId = this.queryParentId(id, formId);
        QFilter filter = new QFilter("parent", "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{qf1, filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence asc", (int)1);
        if (seq != 0) {
            if (dcs != null && dcs.size() > 0) {
                DynamicObject dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                int seq2 = dyTree2.getInt("sequence");
                dyTree2.set("sequence", (Object)seq);
                dyTree.set("sequence", (Object)seq2);
                SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                ((TreeView)this.getControl(TEMPLATECATALOG)).deleteAllNodes();
                this.initTree();
                TreeNode node = new TreeNode(parentId, id, dyTree.getString("name"));
                ((TreeView)this.getControl(TEMPLATECATALOG)).focusNode(node);
                this.writeOpLog(OperationResult.SUCCESS, OperationName.CATALOG_MOVE_DOWN, dyTree);
            } else if (AppUtils.isFidmReport((String)this.getBizAppId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u76ee\u5f55\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbstractTemplateTreePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ee9\u6548\u5206\u6790\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbstractTemplateTreePlugin_16", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    protected void newTemplateCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, this.getPageCache().get("dmmodelid"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "fidm_tmplcatalog");
        long id = Long.parseLong(nodeId);
        if (isAddNew) {
            params.put("parent", id);
            params.put("catcalogType", this.getCatalogType());
            params.put("type", "add");
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, 0L);
        } else {
            params.put("catcalogType", this.getCatalogType());
            params.put("parent", this.getPageCache().get("parent"));
            params.put("type", "edit");
            this.showForm(this.getTemplateCataLogEntryEntity(), params, closeCallBack, ShowType.Modal, id);
        }
    }

    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        params.put("entity", this.getTemplateCataLogEntryEntity());
        if (DiscTemplateCatalogTypeEnum.FAR_CATALOG.getType().equals(params.get("catcalogType"))) {
            param.setCaption(ResManager.loadKDString((String)"\u5206\u6790\u770b\u677f\u5206\u7c7b", (String)"DiscTemplateListPlugin_26", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    protected DynamicObject[] getSelectedTempDynaObjs(String noSelectedMsg) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList.getSelectedRows().size() == 0) {
            if (StringUtils.isNotEmpty((String)noSelectedMsg)) {
                this.getView().showTipNotification(noSelectedMsg);
            }
            return null;
        }
        return BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("deletecatalog_comfirm") && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            ArrayList dynList = Lists.newArrayListWithCapacity((int)5);
            try {
                PlatUtil.executeWithTXNew(tx -> {
                    DynamicObject[] oo;
                    TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
                    Map map = tree.getTreeState().getFocusNode();
                    String nodeId = (String)map.get("id");
                    String parentId = (String)map.get("parentid");
                    List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                    ArrayList<String> list = new ArrayList<String>(16);
                    this.queryAllChildNodeList(nodeId, treeList, list);
                    list.add(nodeId);
                    List longList = LongUtil.toLongList(list);
                    dynList.addAll(this.getTemplateCatalogByIds(longList, "fidm_tmplcatalog"));
                    for (DynamicObject dd : oo = (DynamicObject[])this.queryTemplateByCatalogIds(longList)) {
                        dd.set(TEMPLATECATALOG, (Object)parentId);
                    }
                    SaveServiceHelper.save((DynamicObject[])oo);
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.getTemplateCataLogEntryEntity()), (Object[])list.toArray());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractTemplateTreePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                });
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.CATALOG_DELETE, dynList);
            }
            catch (Exception e) {
                this.batchWriteOpLog(OperationResult.FAILURE, OperationName.CATALOG_DELETE, dynList);
                throw e;
            }
            this.refrushTree();
            this.refrushBillList();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("fidm_tmplcatalog".equals(actionId)) {
            ArrayList ids;
            ArrayList arrayList = ids = closedCallBackEvent.getReturnData() == null ? null : (ArrayList)closedCallBackEvent.getReturnData();
            if (ids != null && ids.size() > 0) {
                this.refrushTree();
                String nodeid = ((Long)ids.get(0)).toString();
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                for (Map m : treeList) {
                    if (!nodeid.equals(m.get("id"))) continue;
                    TreeNode node = new TreeNode((String)m.get("parentid"), (String)m.get("id"), (String)m.get("name"));
                    ((TreeView)this.getControl(TEMPLATECATALOG)).focusNode(node);
                    this.getPageCache().put("focusnodeid", nodeid);
                    this.getPageCache().put("parent", (String)m.get("parentid"));
                }
                this.refrushBillList();
            }
        }
    }

    private Object[] queryTemplateByCatalogIds(List<Long> pks) {
        QFilter filter1 = new QFilter(TEMPLATECATALOG, "in", pks);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getEntryEntity(), (String)"id", (QFilter[])new QFilter[]{filter1});
        ArrayList<Long> ids = new ArrayList<Long>(dcs.size());
        for (DynamicObject dd : dcs) {
            ids.add(dd.getLong("id"));
        }
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntryEntity()));
    }

    @Override
    public String getBizEntityNumber() {
        return "fidm_template";
    }

    protected String getEntryEntity() {
        return "fidm_template";
    }

    protected String getCatalogType() {
        return DiscTemplateCatalogTypeEnum.getCatalogByAppId((String)this.getBizAppId()).getType();
    }

    protected String getTemplateCataLogEntryEntity() {
        return "fidm_tmplcatalog";
    }

    public void refrushTree() {
        TreeView Tree = (TreeView)this.getControl(TEMPLATECATALOG);
        Tree.deleteAllNodes();
        this.initTree();
    }

    private void writeOpLog(OperationResult result, OperationName opName, DynamicObject template) {
        String templateNumber = template != null ? template.getString("number") : "";
        OperationCategory operationCategory = OperationCategory.ANALYSIS_DESIGN;
        String formId = "far_analysisdesign";
        if (this.getBizAppId().equalsIgnoreCase("fidm")) {
            operationCategory = OperationCategory.TEMPLATE;
            formId = "fidm_templatelist";
        }
        super.writeOpLog(operationCategory, opName, result, formId, templateNumber);
    }

    private void batchWriteOpLog(OperationResult result, OperationName opName, List<DynamicObject> dynList) {
        OperationCategory operationCategory = OperationCategory.ANALYSIS_DESIGN;
        String formId = "far_analysisdesign";
        if (this.getBizAppId().equalsIgnoreCase("fidm")) {
            operationCategory = OperationCategory.TEMPLATE;
            formId = "fidm_templatelist";
        }
        super.batchWriteOpLog(operationCategory, opName, result, formId, dynList, new String[0]);
    }
}

