/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.FarDataSet;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.far.calculate.CalculateHelper;
import kd.epm.far.business.far.calculate.ICalculate;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.common.common.json.JacksonUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisSingleF7ServiceHelper;
import kd.epm.far.formplugin.faranalysis.domain.DrillingData;

public class AnalysisCalcHelper {
    private static final Log log = LogFactory.getLog(AnalysisDesignHelper.class);

    public static Map<String, Object> getPreviewDataSetInfo(Long dmModelId, JSONObject jsonObject, AnalysisDataHandler anaLysisDataHandler) {
        Object sourceData;
        Map<String, Object> returnData = new HashMap<String, Object>();
        JSONObject itemObject = jsonObject.getJSONObject("item");
        JSONObject datasetObject = itemObject.getJSONObject("dataset");
        if (Objects.isNull(datasetObject.get((Object)"id")) || StringUtils.isEmpty((CharSequence)datasetObject.getString("id"))) {
            return returnData;
        }
        Long datasetId = LongUtil.toLong((Object)datasetObject.get((Object)"id"));
        HashMap changeMap = Maps.newHashMap();
        try {
            Map<String, String> needFillProperty = AnalysisCalcHelper.buildPropertyMap(datasetObject, changeMap);
            sourceData = new FarDataSet(datasetId, jsonObject).getResult(anaLysisDataHandler, needFillProperty);
            if (sourceData instanceof RuntimeException) {
                AnalysisCalcHelper.returnDataError(returnData, (RuntimeException)sourceData);
                return returnData;
            }
        }
        catch (Exception e1) {
            AnalysisCalcHelper.returnDataError(returnData, e1);
            return returnData;
        }
        String dataSecType = datasetObject.getString("dataSrcType");
        DynamicObject dataset = DatasetServiceHelper.getDataSetById((Long)datasetId);
        String datasetType = dataset.getString("type");
        if (dataSecType != null && "isc_metadata_schema".equals(dataSecType)) {
            Set moneyKeySet = DatasetUtil.getMetadataMoneyKey((Long)datasetId);
            List<DatasetFilterItem> datesetFilterItems = AnalysisCalcHelper.getDatasetFilterItems(datasetObject.getJSONArray("datesetFilterItems"));
            String moduleType = ModuleEnum.getModuleByNumber((String)itemObject.get((Object)"type").toString()).getType();
            ICalculate calculateService = CalculateHelper.calInstance((String)moduleType, (String)datasetType, (Object)sourceData, (JSONObject)itemObject, datesetFilterItems, (Set)moneyKeySet, (Boolean)true);
            try {
                returnData = calculateService.calculate();
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
                AnalysisCalcHelper.returnDataError(returnData, exception);
            }
        } else {
            Set moneyKeySet = null;
            if (Objects.equals("2", datasetType)) {
                moneyKeySet = DatasetFilterHelper.getMoneyKeySet((Long)dmModelId, (Long)datasetId);
            }
            JSONObject requestJson = datasetObject.getJSONObject("request");
            try {
                String moduleType = ModuleEnum.getModuleByNumber((String)itemObject.get((Object)"type").toString()).getType();
                AnalysisCalcHelper.specialFilter(dmModelId, moduleType, requestJson);
                List<DatasetFilterItem> datesetFilterItems = AnalysisCalcHelper.getDatasetFilterItems(datasetObject.getJSONArray("datesetFilterItems"));
                ICalculate calculateService = CalculateHelper.calInstance((String)moduleType, (String)datasetType, (Object)sourceData, (JSONObject)itemObject, datesetFilterItems, (Set)moneyKeySet, (Boolean)true);
                returnData = calculateService.calculate();
                AnalysisCalcHelper.fillStyle(moduleType, itemObject, sourceData, datasetId, returnData);
            }
            catch (Exception e2) {
                String title = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7ec4\u4ef6\u8bbe\u7f6e\u4fe1\u606f\u6216\u5f02\u5e38\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"AnalysisCalcHelper_12", (String)"epm-far-formplugin", (Object[])new Object[0]);
                String errorMsg = e2 instanceof KDBizException ? e2.getMessage() : title;
                log.error(title, (Throwable)e2);
                returnData.put("errorMsg", errorMsg);
            }
            AnalysisCalcHelper.buildDrillingDims(itemObject, datasetObject, sourceData);
            AnalysisCalcHelper.buildLinkageDims(itemObject, datasetObject, sourceData);
            if (!changeMap.isEmpty()) {
                changeMap.entrySet().forEach(e -> requestJson.put((String)e.getKey(), e.getValue()));
            }
        }
        return returnData;
    }

    private static Map<String, String> buildPropertyMap(JSONObject datasetObject, Map<String, String> changeMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        JSONObject request = datasetObject.getJSONObject("request");
        AnalysisCalcHelper.buildProperty("yAxisNumber", map, request, changeMap);
        AnalysisCalcHelper.buildProperty("xAxisNumber", map, request, changeMap);
        AnalysisCalcHelper.buildProperty("legendNumber", map, request, changeMap);
        AnalysisCalcHelper.buildProperty("legendDetailNumber", map, request, changeMap);
        return map;
    }

    private static void buildProperty(String key, Map<String, String> map, JSONObject request, Map<String, String> changeMap) {
        String number = request.getString(key);
        if (Objects.isNull(number) || StringUtils.isBlank((CharSequence)number.toString())) {
            return;
        }
        String column = number.toString();
        if ("FMONEY".equalsIgnoreCase(column)) {
            return;
        }
        if (column.contains("-")) {
            String[] split = column.split("-");
            map.put(split[0], column);
            request.put(key, (Object)split[0]);
            changeMap.put(key, column);
        }
    }

    private static void buildDrillingDims(JSONObject itemObject, JSONObject datasetObject, Object sourceData) {
        DrillingData drillingData = new DrillingData();
        try {
            if (itemObject.getString("type") != null && itemObject.getString("type").toLowerCase().contains("chart")) {
                HashSet<Object> dimNumbers = null;
                JSONObject request = datasetObject.getJSONObject("request");
                if (request != null) {
                    String legendNumber = Objects.isNull(request.getString("legendNumber")) ? "" : request.getString("legendNumber");
                    String yAxisNumber = Objects.isNull(request.getString("yAxisNumber")) || request.getString("yAxisNumber").toLowerCase().contains("money") ? "" : request.getString("yAxisNumber");
                    String xAxisNumber = Objects.isNull(request.getString("xAxisNumber")) || request.getString("xAxisNumber").toLowerCase().contains("money") ? "" : request.getString("xAxisNumber");
                    dimNumbers = new HashSet<String>(Arrays.asList(legendNumber, yAxisNumber, xAxisNumber));
                }
                drillingData.setDataDrillingInfo(sourceData, (Set<String>)(Objects.nonNull(dimNumbers) ? dimNumbers : new HashSet(3)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        itemObject.put("drillingdim", drillingData.getDataDrillingInfo());
    }

    private static void buildLinkageDims(JSONObject itemObject, JSONObject datasetObject, Object sourceData) {
        DrillingData drillingData = new DrillingData();
        try {
            if (itemObject.getString("type") != null && itemObject.getString("type").toLowerCase().contains("chart")) {
                HashSet<Object> dimNumbers = null;
                JSONObject request = datasetObject.getJSONObject("request");
                if (request != null) {
                    String legendNumber = Objects.isNull(request.getString("legendNumber")) ? "" : request.getString("legendNumber");
                    String legendDetailNumber = Objects.isNull(request.getString("legendDetailNumber")) ? "" : request.getString("legendDetailNumber");
                    String yAxisNumber = Objects.isNull(request.getString("yAxisNumber")) || request.getString("yAxisNumber").toLowerCase().contains("money") ? "" : request.getString("yAxisNumber");
                    String xAxisNumber = Objects.isNull(request.getString("xAxisNumber")) || request.getString("xAxisNumber").toLowerCase().contains("money") ? "" : request.getString("xAxisNumber");
                    dimNumbers = new HashSet<String>(Arrays.asList(legendNumber, legendDetailNumber, yAxisNumber, xAxisNumber));
                    JSONObject dataDrillingDown = itemObject.getJSONObject("c").getJSONObject("config").getJSONObject("dataDrillingDown");
                    if (!dataDrillingDown.isEmpty() && Objects.nonNull(dataDrillingDown.getJSONArray("path"))) {
                        JSONArray path = dataDrillingDown.getJSONArray("path");
                        for (int i = 0; i < path.size(); ++i) {
                            JSONObject node = path.getJSONObject(i);
                            dimNumbers.add(node.getString("dimNumber"));
                        }
                    }
                }
                drillingData.setDataDrillingInfo(sourceData, (Set<String>)(Objects.nonNull(dimNumbers) ? dimNumbers : new HashSet(3)));
            }
        }
        catch (Exception e) {
            log.error("Exception occurred:", (Throwable)e);
        }
        itemObject.put("linkageDims", drillingData.getDataDrillingInfo());
    }

    private static void fillStyle(String moduleType, JSONObject itemObject, Object sourceData, Long datasetId, Object data) {
        if (!Objects.equals(moduleType, ModuleEnum.Analysis_DASHBOARD.getType())) {
            return;
        }
        Object retrnData = ((Map)data).get("data");
        if (Objects.isNull(retrnData)) {
            return;
        }
        JSONObject jsonObject = itemObject.getJSONObject("c").getJSONObject("config").getJSONObject("dashboard");
        JSONArray datasetTypes = jsonObject.getJSONArray("datasetTypes");
        Object targetValueCountObj = jsonObject.get((Object)"targetValueCount");
        JSONArray aimValues = jsonObject.getJSONArray("aimValues");
        if (Objects.isNull(targetValueCountObj)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u533a\u95f4\u503c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisCalcHelper_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        int targetValueCount = Math.abs(new BigDecimal(targetValueCountObj.toString()).intValue());
        if (Objects.isNull(datasetTypes) || datasetTypes.stream().noneMatch(t -> Objects.equals("dynamic", t))) {
            AnalysisCalcHelper.checkValue(jsonObject.get((Object)"min"), jsonObject.get((Object)"max"), aimValues, data, targetValueCount);
            return;
        }
        QFilter qFilter = new QFilter("dataset", "=", (Object)datasetId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fidm_dataset_multivalue", (String)"id,number", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return;
        }
        Map<Long, String> numbermap = query.stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t.getString("number")));
        JSONArray datasetIds = jsonObject.getJSONArray("datasetFormula");
        for (int i = 0; i < targetValueCount + 2; ++i) {
            HashMap mapData;
            Object obj;
            Long datasetMultiId;
            String datasetMultiNumber;
            Object o;
            if (Objects.equals("", datasetTypes.get(i)) || !LongUtil.isvalidLong((Object)(o = ((JSONObject)datasetIds.get(i)).get((Object)"id"))) || StringUtils.isEmpty((CharSequence)(datasetMultiNumber = numbermap.get(datasetMultiId = LongUtil.toLong((Object)o)))) || Objects.isNull(obj = (mapData = (HashMap)sourceData).get(datasetMultiNumber))) continue;
            if (i == 0) {
                jsonObject.put("min", (Object)new BigDecimal(obj.toString()));
                continue;
            }
            if (i == 1) {
                jsonObject.put("max", (Object)new BigDecimal(obj.toString()));
                continue;
            }
            aimValues.set(i - 2, (Object)new BigDecimal(obj.toString()));
        }
        AnalysisCalcHelper.checkValue(jsonObject.get((Object)"min"), jsonObject.get((Object)"max"), aimValues, data, targetValueCount);
    }

    private static void checkValue(Object min, Object max, JSONArray aimValues, Object data, int targetValueCount) {
        if (Objects.isNull(min)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u5c0f\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisCalcHelper_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(max)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u5927\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisCalcHelper_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        BigDecimal minValue = new BigDecimal(min.toString());
        BigDecimal maxValue = new BigDecimal(max.toString());
        Object listData = ((Map)data).get("data");
        String value = ((List)listData).get(0).toString();
        BigDecimal dataValue = new BigDecimal(value);
        if (minValue.compareTo(maxValue) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u533a\u95f4\u503c\u8303\u56f4\u5b9a\u4e49\u9519\u8bef,\u6700\u5c0f\u503c\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u503c\u3002", (String)"AnalysisCalcHelper_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (dataValue.compareTo(minValue) < 0 || dataValue.compareTo(maxValue) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u503c\u8d85\u51fa\u8303\u56f4\u3002", (String)"AnalysisCalcHelper_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        BigDecimal last = minValue.subtract(new BigDecimal("1"));
        for (int i = 0; i < targetValueCount; ++i) {
            Object aimValue = aimValues.get(i);
            if (Objects.isNull(aimValue)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u533a\u95f4\u503c%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisCalcHelper_9", (String)"epm-far-formplugin", (Object[])new Object[0]), i + 1));
            }
            BigDecimal cur = new BigDecimal(aimValue.toString());
            if (cur.compareTo(minValue) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u533a\u95f4\u503c%s\u4e0d\u80fd\u5c0f\u4e8e\u6700\u5c0f\u503c\u3002", (String)"AnalysisCalcHelper_4", (String)"epm-far-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (cur.compareTo(maxValue) > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u533a\u95f4\u503c%s\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u503c\u3002", (String)"AnalysisCalcHelper_5", (String)"epm-far-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (cur.compareTo(last) <= 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u533a\u95f4\u503c%s\u987a\u5e8f\u5b9a\u4e49\u9519\u8bef,\u540e\u7eed\u533a\u95f4\u503c\u4e0d\u80fd\u5c0f\u4e8e\u524d\u5e8f\u533a\u95f4\u503c\u3002", (String)"AnalysisCalcHelper_6", (String)"epm-far-formplugin", (Object[])new Object[0]), i + 1));
            }
            last = cur;
        }
    }

    private static void returnDataError(Map<String, Object> returnData, Exception e) {
        String excepMsg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6570\u636e\u96c6\u53d6\u6570\u5f02\u5e38", (String)"AnalysisCalcHelper_11", (String)"epm-far-formplugin", (Object[])new Object[0]);
        log.error(excepMsg, (Throwable)e);
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(excepMsg).append(":").append(e.getMessage());
        returnData.put("errorMsg", errorMsg.toString());
    }

    private static void specialFilter(long dmModelId, String moduleType, JSONObject requestJson) {
        if (ModuleEnum.Analysis_CHART_CHINAMAP.getType().equals(moduleType)) {
            String map = requestJson.getString("map");
            String xAxisNumber = requestJson.getString("xAxisNumber");
            if (StringUtils.isEmpty((CharSequence)map) || StringUtils.isEmpty((CharSequence)xAxisNumber)) {
                return;
            }
            ModelInfo dmmodel = new ModelStrategyEx(Long.valueOf(dmModelId)).getModel().getModelInfo();
            if (Objects.isNull(dmmodel)) {
                return;
            }
            long modelId = dmmodel.getModelId();
            List<Map<String, Object>> dimList = AnalysisSingleF7ServiceHelper.getDimList(dmModelId, modelId);
            Map findDim = dimList.stream().filter(x -> Objects.equals(x.get("number").toString(), xAxisNumber)).findAny().orElse(null);
            if (Objects.isNull(findDim)) {
                return;
            }
            String entityName = findDim.get("entityName").toString();
            DynamicObject mapMember = QueryServiceHelper.queryOne((String)entityName, (String)"id,name,parent", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("name", "=", (Object)map)});
            if (Objects.isNull(mapMember)) {
                return;
            }
            ArrayList<String> memeberNameList = new ArrayList<String>(10);
            QFilter dimFilter = new QFilter("model", "=", (Object)modelId);
            QFilter parentidFilter = new QFilter("parent.id", "=", (Object)mapMember.getLong("id"));
            DynamicObjectCollection members = QueryServiceHelper.query((String)entityName, (String)"name", (QFilter[])new QFilter[]{dimFilter, parentidFilter});
            for (DynamicObject item : members) {
                memeberNameList.add(item.get("name").toString().toUpperCase());
            }
            requestJson.put("memeberNameList", memeberNameList);
        }
    }

    private static List<DatasetFilterItem> getDatasetFilterItems(JSONArray filterItemsObject) {
        List<Object> datesetFilterItems = new ArrayList<DatasetFilterItem>();
        if (Objects.nonNull(filterItemsObject)) {
            datesetFilterItems = (List)JacksonUtils.fromJson((String)filterItemsObject.toJSONString(), (TypeReference)new TypeReference<List<DatasetFilterItem>>(){});
        }
        return datesetFilterItems;
    }
}

