/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.form.Style;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.business.common.control.ComboEditElement;
import kd.epm.far.business.common.control.TextEditElement;
import kd.epm.far.business.far.enums.DynamicControlSourceEnum;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;

public class AnalysisDesignHelper {
    public static Object getPropsDataResult(Object dataType) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)dataType.toString());
        dataObj.put("t", (Object)TimeServiceHelper.now());
        return dataObj;
    }

    public static Object getPropsDataResult(Object dataType, Object data, String primaryKey) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)dataType.toString());
        dataObj.put("data", data);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        dataObj.put("primaryKey", (Object)(StringUtils.isEmpty((CharSequence)primaryKey) ? "" : primaryKey));
        return dataObj;
    }

    public static Map<String, Map<String, Map<String, Object>>> getDimParamsModuleVars(JSONObject dataObj) {
        HashMap<String, Map<String, Map<String, Object>>> dimParamsModules = new HashMap<String, Map<String, Map<String, Object>>>(12);
        JSONArray allModules = dataObj.getJSONArray("itemList");
        for (Object mdObject : allModules) {
            JSONObject md = (JSONObject)mdObject;
            String type = md.getString("type");
            if (!StringUtils.equals((CharSequence)type, (CharSequence)"analysis_dimparam")) continue;
            JSONArray dims = md.getJSONArray("dims");
            String pid = md.getString("pid");
            HashMap vars = Maps.newHashMapWithExpectedSize((int)3);
            HashMap<String, JSONObject> normalVarsL = new HashMap<String, JSONObject>(12);
            HashMap<String, JSONObject> normalVarsQ = new HashMap<String, JSONObject>(12);
            HashMap<String, JSONObject> dimVars = new HashMap<String, JSONObject>(12);
            for (Object dimObject : dims) {
                JSONObject dim = (JSONObject)dimObject;
                String varType = dim.getString("vartype");
                String isDim = dim.getString("isDim");
                if (!StringUtils.isEmpty((CharSequence)isDim)) {
                    dimVars.put(dim.getString("id"), dim);
                    continue;
                }
                if (StringUtils.equals((CharSequence)varType, (CharSequence)"1")) {
                    normalVarsQ.put(dim.getString("number"), dim);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)varType, (CharSequence)"2")) continue;
                normalVarsL.put(dim.getString("number"), dim);
            }
            vars.put("dimVars", dimVars);
            vars.put("normalVarsQ", normalVarsQ);
            vars.put("normalVarsL", normalVarsL);
            dimParamsModules.put(pid, vars);
        }
        return dimParamsModules;
    }

    public static void buildPreviewPanelParams(JSONObject dataObj) {
        JSONArray allModules = dataObj.getJSONArray("itemList");
        if (Objects.isNull(allModules) || allModules.isEmpty()) {
            return;
        }
        Map<String, Map<String, Map<String, Object>>> dimParamsModuleVars = AnalysisDesignHelper.getDimParamsModuleVars(dataObj);
        for (Object mdObject : allModules) {
            Map<String, Map<String, Object>> curModuleAllVars;
            JSONObject dataset;
            JSONObject md = (JSONObject)mdObject;
            String type = md.getString("type");
            if (StringUtils.equals((CharSequence)type, (CharSequence)"analysis_dimparam") || !Objects.nonNull(dataset = md.getJSONObject("dataset"))) continue;
            AnalysisDesignHelper.clearIconParam(dataset);
            if (dimParamsModuleVars.isEmpty()) continue;
            String pid = md.getString("pid");
            if (StringUtils.equals((CharSequence)type, (CharSequence)"analysis_dupont_node")) {
                for (Object a : allModules) {
                    JSONObject joA = (JSONObject)a;
                    if (Objects.isNull(joA) || !StringUtils.equals((CharSequence)joA.getString("id"), (CharSequence)pid)) continue;
                    pid = joA.getString("pid");
                    break;
                }
            }
            if (Objects.isNull(curModuleAllVars = dimParamsModuleVars.get(pid))) continue;
            AnalysisDesignHelper.buildDimParam(dataset, curModuleAllVars);
            AnalysisDesignHelper.buildVarParam(dataset, curModuleAllVars);
        }
    }

    public static void clearIconParam(JSONObject dataset) {
        JSONArray varParams;
        JSONArray dimParams = dataset.getJSONArray("dimParams");
        if (Objects.nonNull(dimParams)) {
            for (Object dimParam : dimParams) {
                JSONObject dimVar = (JSONObject)dimParam;
                if (!Objects.isNull(dimVar.getString("isRest")) || !Objects.isNull(dimVar.getString("isFixed"))) continue;
                dimVar.remove((Object)"member");
            }
        }
        if (Objects.nonNull(varParams = dataset.getJSONArray("varParams"))) {
            for (Object varParam : varParams) {
                JSONObject var = (JSONObject)varParam;
                if (!Objects.isNull(var.getString("isRest")) || !Objects.isNull(var.getString("isFixed"))) continue;
                var.remove((Object)"modifyvalue");
                var.remove((Object)"modifyvalueid");
            }
        }
    }

    public static void buildDimParam(JSONObject dataset, Map<String, Map<String, Object>> curModuleAllVars) {
        JSONArray dimParams = dataset.getJSONArray("dimParams");
        Map<String, Object> dimVars = curModuleAllVars.get("dimVars");
        for (Object dimParam : dimParams) {
            JSONObject member;
            JSONObject dimVar = (JSONObject)dimParam;
            String dimId = dimVar.getString("id");
            JSONObject dim = (JSONObject)dimVars.get(dimId);
            if (!Objects.nonNull(dim)) continue;
            if (Objects.isNull(dimVar.getJSONObject("member")) || dimVar.getJSONObject("member").size() == 0) {
                member = dim.getJSONObject("member");
                if (!Objects.nonNull(member) || member.size() <= 0) continue;
                dimVar.put("member", (Object)member);
                dimVar.put("isRest", (Object)"YES");
                continue;
            }
            if (StringUtils.equals((CharSequence)"YES", (CharSequence)dimVar.getString("isRest"))) {
                member = dim.getJSONObject("member");
                if (!Objects.nonNull(member) || member.size() <= 0) continue;
                dimVar.put("member", (Object)member);
                dimVar.put("isRest", (Object)"YES");
                continue;
            }
            dimVar.put("isRest", (Object)"NO");
        }
    }

    public static void buildVarParam(JSONObject dataset, Map<String, Map<String, Object>> curModuleAllVars) {
        JSONArray varParams = dataset.getJSONArray("varParams");
        Map<String, Object> normalVarsQ = curModuleAllVars.get("normalVarsQ");
        Map<String, Object> normalVarsL = curModuleAllVars.get("normalVarsL");
        for (Object varParam : varParams) {
            String modifyValueId;
            String defaultvalue;
            JSONObject var = (JSONObject)varParam;
            String valuetype = var.getString("valuetype");
            String number = var.getString("number");
            JSONObject varQ = (JSONObject)normalVarsQ.get(number);
            JSONObject varL = (JSONObject)normalVarsL.get(number);
            if (Objects.nonNull(varL)) {
                defaultvalue = varL.getString("defaultvalue");
                modifyValueId = null;
                if (StringUtils.equals((CharSequence)"4", (CharSequence)valuetype)) {
                    defaultvalue = varL.getJSONObject("vardim").getJSONObject("member").getString("number");
                    modifyValueId = varL.getJSONObject("vardim").getJSONObject("member").getString("id");
                }
                if (StringUtils.isEmpty((CharSequence)var.getString("modifyvalue"))) {
                    var.put("modifyvalue", (Object)defaultvalue);
                    if (StringUtils.equals((CharSequence)"4", (CharSequence)valuetype)) {
                        var.put("modifyvalueid", (Object)modifyValueId);
                    }
                    var.put("isRest", (Object)"YES");
                    continue;
                }
                if (StringUtils.equals((CharSequence)"YES", (CharSequence)var.getString("isRest"))) {
                    var.put("modifyvalue", (Object)defaultvalue);
                    if (StringUtils.equals((CharSequence)"4", (CharSequence)valuetype)) {
                        var.put("modifyvalueid", (Object)modifyValueId);
                    }
                    var.put("isRest", (Object)"YES");
                    continue;
                }
                var.put("isRest", (Object)"NO");
                continue;
            }
            if (!Objects.nonNull(varQ)) continue;
            defaultvalue = varQ.getString("defaultvalue");
            modifyValueId = null;
            if (StringUtils.equals((CharSequence)"4", (CharSequence)valuetype)) {
                defaultvalue = varQ.getJSONObject("vardim").getJSONObject("member").getString("number");
                modifyValueId = varQ.getJSONObject("vardim").getJSONObject("member").getString("id");
            }
            if (StringUtils.isEmpty((CharSequence)var.getString("modifyvalue"))) {
                var.put("modifyvalue", (Object)defaultvalue);
                if (StringUtils.equals((CharSequence)"4", (CharSequence)valuetype)) {
                    var.put("modifyvalueid", (Object)modifyValueId);
                }
                var.put("isRest", (Object)"YES");
                continue;
            }
            if (StringUtils.equals((CharSequence)"YES", (CharSequence)var.getString("isRest"))) {
                var.put("modifyvalue", (Object)defaultvalue);
                if (StringUtils.equals((CharSequence)"4", (CharSequence)valuetype)) {
                    var.put("modifyvalueid", (Object)modifyValueId);
                }
                var.put("isRest", (Object)"YES");
                continue;
            }
            var.put("isRest", (Object)"NO");
        }
    }

    public static Object dataInit(Object itemList, Object pageConfig, Object queryConfig, Object gbVarList, Object localVarList, Object gbDatasetList, Object localDatasetList, Object dimList, Object moduleList, Object ii18n, boolean isReset, Long chapterId) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)AnalysisDesignConstants.PropsDataType.DATA_INIT.toString());
        dataObj.put("designMode", (Object)true);
        dataObj.put("i18n", ii18n);
        dataObj.put("pageConfig", pageConfig);
        dataObj.put("queryConfig", queryConfig);
        dataObj.put("gbVarList", gbVarList);
        dataObj.put("localVarList", localVarList);
        dataObj.put("gbDatasetList", gbDatasetList);
        dataObj.put("localDatasetList", localDatasetList);
        dataObj.put("dimList", dimList);
        dataObj.put("itemList", itemList);
        dataObj.put("moduleList", moduleList);
        dataObj.put("isReset", (Object)isReset);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        dataObj.put("chapterId", (Object)(Objects.isNull(chapterId) ? null : chapterId.toString()));
        return dataObj;
    }

    public static Object dataPreviewResult(boolean isDesignMode, Object itemList, Object pageConfig, Object queryConfig, Object ii18n, Long chapterId) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)AnalysisDesignConstants.PropsDataType.DATA_PREVIEW_RESULT.toString());
        dataObj.put("designMode", (Object)isDesignMode);
        dataObj.put("pageConfig", pageConfig);
        dataObj.put("queryConfig", queryConfig);
        dataObj.put("i18n", ii18n);
        dataObj.put("itemList", itemList);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        AnalysisDesignHelper.buildPreviewPanelParams(dataObj);
        return dataObj;
    }

    public static Object paramPreviewResult(boolean isDesignMode, Object data, Object pageConfig, Object queryConfig, Object ii18n, String primaryKey) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)AnalysisDesignConstants.PropsDataType.EVENT_INDIVIDUALIZED_SETTING_RWSULT.toString());
        dataObj.put("designMode", (Object)isDesignMode);
        dataObj.put("data", data);
        dataObj.put("primaryKey", (Object)(StringUtils.isEmpty((CharSequence)primaryKey) ? "" : primaryKey));
        dataObj.put("pageConfig", pageConfig);
        dataObj.put("queryConfig", queryConfig);
        dataObj.put("i18n", ii18n);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        return dataObj;
    }

    public static Object themeInitResult(boolean isDesignMode, Object pageConfig, Object ii18n, Object theme) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)AnalysisDesignConstants.PropsDataType.DATA_THEME_INIT.toString());
        dataObj.put("designMode", (Object)isDesignMode);
        dataObj.put("pageConfig", pageConfig);
        dataObj.put("i18n", ii18n);
        dataObj.put("theme", theme);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        AnalysisDesignHelper.buildThemePreviewParams(dataObj);
        return dataObj;
    }

    public static void buildThemePreviewParams(JSONObject dataObj) {
        HashMap themeN = (HashMap)dataObj.get((Object)"theme");
        ArrayList pageList = (ArrayList)themeN.get("pageList");
        for (HashMap pL : pageList) {
            JSONObject dataInit = (JSONObject)pL.get("data_init");
            if (Objects.isNull(dataInit)) {
                return;
            }
            AnalysisDesignHelper.buildPreviewPanelParams(dataInit);
        }
    }

    public static Object themePageRefreshPreviewResult(boolean isDesignMode, Object itemList, Object pageConfig, Object queryConfig, Object ii18n) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)AnalysisDesignConstants.PropsDataType.DATA_THEME_PAGE_REFRESH_RESULT.toString());
        dataObj.put("designMode", (Object)isDesignMode);
        dataObj.put("pageConfig", pageConfig);
        dataObj.put("queryConfig", queryConfig);
        dataObj.put("i18n", ii18n);
        dataObj.put("itemList", itemList);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        AnalysisDesignHelper.buildPreviewPanelParams(dataObj);
        return dataObj;
    }

    public static TextEditElement createTextEditElement(String name, String sign, Integer index, String sourceName) {
        TextEditElement textEditElement = new TextEditElement(name, sign, null);
        textEditElement.setLabelDirection("v");
        textEditElement.setFontSize(12);
        if (sourceName.equals(DynamicControlSourceEnum.DATASET.getSourceName())) {
            textEditElement.setWidth(new LocaleString("230px"));
            textEditElement.setEditStyle(2);
        } else {
            textEditElement.setWidth(new LocaleString("210px"));
            textEditElement.setEditStyle(0);
        }
        textEditElement.setFieldTextAlign("left");
        String LabelLength = (name.length() + 1) * 12 + "px";
        textEditElement.setLabelWidth(new LocaleString(LabelLength));
        Style style = AnalysisCommonOperateHelper.setCustomControlStyle(index, sourceName);
        textEditElement.setStyle(style);
        return textEditElement;
    }

    public static ComboEditElement createComboEditElement(String name, String sign, Integer index, List<String> items, String sourceName) {
        ArrayList comboItem = new ArrayList();
        items.forEach(value -> comboItem.add(new ComboItem(new LocaleString(value), value)));
        ComboEditElement comboEditElement = new ComboEditElement(sign.toLowerCase(), name, comboItem);
        comboEditElement.setMustinput(false);
        comboEditElement.setDragable(true);
        comboEditElement.setDropable(true);
        comboEditElement.setLabelWidth(new LocaleString("100px"));
        if (sourceName.equals(DynamicControlSourceEnum.DATASETDISPLAY.getSourceName())) {
            comboEditElement.setWidth(new LocaleString("120px"));
        } else if (sourceName.equals(DynamicControlSourceEnum.DATASETINFO.getSourceName())) {
            comboEditElement.setWidth(new LocaleString("80px"));
        } else {
            comboEditElement.setWidth(new LocaleString("210px"));
        }
        comboEditElement.setLabelDirection("v");
        comboEditElement.setFieldTextAlign("left");
        comboEditElement.setBasedataEditStyle(3);
        comboEditElement.setFontSize(12);
        Style style = AnalysisCommonOperateHelper.setCustomControlStyle(index, sourceName);
        comboEditElement.setStyle(style);
        return comboEditElement;
    }
}

